/* $Id: FTP.C 1.5 1999/01/09 09:10:22 rwhitby Exp $ */
/* $Source: A:/SRC/TCP/NCSATCP/APPS/FTP/RCS/FTP.C $ */

/*
 * Portions developed by The Educational Resources Center, Clarkson University.
 * Portions developed by National Center for Supercomputing Applications,
 * University of Illinois at Urbana-Champaign.
 */

#include "config.h"
#include "stdio.h"
#include <process.h>
#include "fcntl.h"
#include "nkeys.h"
#include "ctype.h"
#include "hostform.h"
#include "whatami.h"

#include "newwin.h"
#include <string.h>
#include <stdlib.h>
#include <io.h>
#define O_RAW O_BINARY
#include <sys/stat.h>

#define FASCII  0
#define FIMAGE  1

#define HFTP  21

#define FALSE	   0
#define TRUE	   1
#define SUCCESS	   2
#define ERROR	  -1
#define NONE	  -2
#define ABORT	  -3
#define INCOMPLETE -4
#define AMBIGUOUS -5
#define HAVEDATA   4

#include "windat.h"

struct twin x,*console={&x},*current = {&x};
unsigned _ovrbuffer = 2048;

int numberoflines;
extern char *env_config;
nbgets()
{


}

vprint(int d, char *s)
{
	nprintf(SCREEN,"%s",s);
}

#ifdef  FTPPW
long    ftppassword;
#endif

int 
	xp=0,					/* general pointer */
	towrite=0,				/* file transfer pointer */
	len=0,					/* file transfer length */
	ftpnum,					/* current command port */
	ftpdata=-1,				/* current data port */
	ftpfh,					/* file handle for ftp */
	ftpstate=0,				/* state for background process */
	fcnt = 0,				/* counter for ftpd */
	ftpfilemode=0,				/* file open mode for transfer */
	foundbreak=0,				/* cntrl-break pending */
	connected=0,				/* not connected */
	debug=0,				/* debug level */
	hash=0,					/* hash mark printing */
	sendport=1,				/* to send ports or not */
	verbose=1,				/* informative messages */
	bell=0,					/* sound bell */
	autologin=1,				/* login on connect */
	prompt=1,				/* check on multiple commands */
	glob=1,					/* expand wildcards */
	slashflip=1,				/* change \ to / */
	capture=0,				/* capture data or not */
	fromtty=1;				/* default input from tty */

FILE
	*fromfp=NULL;				/* file pointer for input */

        
unsigned int curftpprt = 0,			/* port to use */
			ftpport();

unsigned char destname[50],			/* who to connect to */
		s[2048],			/* temporary string */
		captlist[2001],			/* response string */
		ftpcommand[200],		/* command to execute */
		*neterrstring();

char printline[100];				/* line to display */

extern int breakstop();
static int userftpd();
char *stpblk(),*stptok();

#define BUFFERS 4096				/* size of buffer */
#define READSIZE 128				/* how much to read */

static unsigned char disaster[256];
static unsigned char xs[BUFFERS+4096];	/* buffer space for file transfer */
static unsigned char badme[256];

long
	time(),
	start=0L,				/* timing var */
	filesiz=0L;				/* length of current file for transfer */

VSwrite()		/* called from PCutil.c LoadWrite */
{
}

/************************************************************************/
/* main - main procedure.  Displays opening message, parses arguments,
/*	  initializes network, reads user commands and executes them, and
/*	  cleans up.
/************************************************************************/


main(argc,argv)
	int argc;
	char *argv[];
	{
	int i,c;
	static char Configfile[128]="lxtcp.cfg";
	static char fromfile[20]="";

	n_which();
	n_window(0,0,rows-1,cols-1);			/* vt100 size */
	n_clear();
	nputs("");
	ctrlbrk(breakstop);

        if(getenv("LXTCP.CFG"))
                strcpy(Configfile,getenv("LXTCP.CFG"));
/*
*  initialize network
*/
	destname[0] = '\0';		/* destination unknown */
	
		/* parse arguments */
        botl = rows;                      /* a cheap hack for screen */

	for (i=1; i<argc; i++) {
	    if (argv[i][0]=='-') {
		switch(tolower(argv[i][1])) {
		    case 'v':		/* display informative messages */
			verbose = TRUE;
			break;
		    case 'n':		/* do not login on connect */
			autologin = FALSE;
			break;
		    case 'i':		/* interactive prompting off */
			prompt = FALSE;
			break;
		    case 'g':		/* wildcard expansion off */
			glob = FALSE;
			break;
		    case 'd':		/* debug, optional level */
			if (sscanf(&argv[i][2],"%d",&debug)<=0)
			    debug = TRUE;
			break;
		    case 's':		/* do not change \ to / */
			slashflip = FALSE;
			break;
		    case 'e' :			/* config.tel data */
		       	 env_config = argv[++i];
		  	 break;
		    case 'h':		/* host file name */
			strcpy(Configfile,argv[++i]);
			break;
		    case 'f':		/* noninteractive, optional filename */
			fromtty = FALSE;	/* noninteractive input */
			strcpy(fromfile,&argv[i][2]);
			if (fromfile[0]) {
			   fromfp = fopen(fromfile,"r");
			   if (fromfp==NULL) {
				nprintf(SCREEN,"Could not open file: %s\n",fromfile);
				return(1);
			   }
			}
			break;
		    default:		/* unknown option */
			nprintf(SCREEN,"Unrecognized option -%c ignored\n",argv[i][1]);
			break;
		}
	    }
	    else sscanf(argv[i],"%s",destname);		/* destination host */
	}


	if (Shostfile(Configfile)<0) {		/* cannot open host file */
	    nprintf(SCREEN,"Could not find hosts file.  Exiting.\n");
	    return(1);
	}
	if (Snetinit()) {			/* cannot initialize network */
	    printerr();				/* display TCP/IP message */
	    nprintf(SCREEN,"Error initializing network\n");
	    return(1);
	}

	if (destname[0]) sprintf(ftpcommand,"open %s",destname);
		/* if destination specified, connect to it */


	do {
		if (*ftpcommand) ftppi(ftpcommand);
			/* if command available, execute it */

		if (fromtty) n_row();		/* in case screen messed up */

		putstring("ftp> ");		/* prompt */
		c = ftpgets(ftpcommand,200,1);	/* read cmd from user */

	} while (c != AF3);			/* Alt-F3 aborts */


	netclose(ftpnum);			/* close command connection */
	netshut();				/* terminate network stuff */

	return(0);
}

/************************************************************************/
/* ftpgets - read a line from the keyboard
/*	     returns ABORT if aborted, non-zero on success
/************************************************************************/

ftpgets(s,lim,echo)
	char *s;		/* where to put the line */
	int lim,echo;		/* max chars to read, echo? */
	{
	unsigned int c;
	int count,i;
	char *save, *ret;

	count = 0;		/* none read */
	save = s;		/* beginning of line */

	if (foundbreak) {
	    foundbreak = 0;
	    *s = '\0';
	    nprintf(SCREEN,"\n");
	    return(ABORT);
	}
	if (!fromtty) {
	   if (fromfp==NULL) {
		ret = fgets(s,lim,stdin);
	   }
	   else {
		ret = fgets(s,lim,fromfp);
	   }
	   if (ret==NULL) {
		nprintf(SCREEN,"EOF or error on read from file\n");
		if (connected) {
		    ftpdo("QUIT","");
		    connected = FALSE;
		}
		netshut();
		exit(1);
	   }
	   s[strlen(s)-1] = '\0';	/* remove newline */
	   if (echo && fromfp) nprintf(SCREEN,"%s\n",s);
	   return (strlen(s));
	}
	while (1) {
		if (foundbreak) {	/* abort */
		    s = save;		/* reset line */
		    *s = '\0';		/* null line */
		    nprintf(SCREEN,"\n");		/* newline */
		    foundbreak = 0;	/* break processed */
		    return(ABORT);	
		}

		c = n_chkchar();	/* char available to read? */

		if (c == 0xffff) {		/* none available */
			checkevent();		/* check event queue */
			c = 0;
		}

		switch (c) {		/* allow certain editing chars */
			case 8:		/* backspace */
			case BACKSPACE:
				if (count) {
					if (echo) {
						nputchar(8);
						nputchar(' ');
						nputchar(8);
					}
					count--;	/* one less character */
					s--;		/* move pointer backward */
				}
				break;
			case 13:		/* carriage return, = ok */
				nprintf(SCREEN,"\n");	/* newline */
				*s = '\0';	/* terminate the string */
				return(c);	/* return ok */
				break;
			case 21:		/* kill line */
				for (i=0; i < s-save; i++) {	/* length of line */
					if (echo) {		/* erase */
						nputchar(8);
						nputchar(' ');
						nputchar(8);
					}
				}
				s = save;	/* reset line */
				break;
			case 0:			/* do nothing */
				break;
			default:		/* not special char */
				if (c > 31 && c < 127) {	/* printable */
					if (echo) nputchar(c);	/* display */
					*s++ = c;	/* add to string */
					count++;	/* length of string */
				}
				else		/* acts as eol */
					return(c);	/* value of special char */

				if (count == lim) {	/* to length limit */
					*s = '\0';	/* terminate */
					return(c);	
				}
			break;
		}

	}
}


/************************************************************************/
/* dumpcon
*  take everything from a connection and send it to the screen
*  return -1 on closed connection, else 0, 1 if paused
/************************************************************************/

dumpcon(cnum)
	int cnum;
	{
	int cnt;

	if (fromtty && n_scrlck()) return(TRUE);	/* if paused, nothing to do */

	do {
		cnt = netread(cnum,s,64);		/* get some from queue */

		telnet(cnt);				/* display on screen, etc.*/

					/* demux all packets */
	} while (cnt > 0);

	return(cnt);			/* 0 normally, -1 if connection closed */
}


/************************************************************************/
/*  telnet
*   filter telnet options on incoming data
/************************************************************************/

telnet(cnt)
	int cnt;
	{
	int i;


	for (i=0; i < cnt; i++) {			/* put on screen */
		if (s[i] & 128) {			/* if over ASCII 128 */
			nprintf(SCREEN," %d ",s[i]);	/* show as number */
		}
		else
			nprintf(SCREEN,"%c",s[i]);
	}

	return(TRUE);
}


/************************************************************************/
/* ftpdo
*  Do whatever command is sent from the user interface using
*  userftpd, the background file handler
*  Returns code from ftpreplies
/************************************************************************/

ftpdo(s,ofile)
	char *s,*ofile;
	{
	int i,rcode;
	char name[50],name2[50];

	for (i=0; i<4; i++) {
		s[i] = toupper(s[i]);	/* command to upper case */
	}

	if (!strncmp(s,"STOR",4)) {	/* put file */
		getword(&s[5],name);	/* first arg - local file */
		if (!s[5]) strcpy(&s[5],name);		/* if only one argument */
	        else {
		    getword(&s[5],name2);	/* second arg - removes quotes etc. */
		    strcpy(&s[5],name2);	/* copy back into command */
		}
		if (0 > (ftpfh = open(name,O_BINARY|O_RDONLY))) {	/* open local file */
			nprintf(SCREEN," Cannot open file to transfer.\n");
			return(-1);
		}
		ftpdata = netlisten(ftpport());		/* open data connection */
		ftpstate = 20;
	}
	else if (!strncmp(s,"RETR",4)) {	/* get file */
		getword(&s[5],name);			/* remote file */
		if (s[5]) {		/* two args present */
		    getword(&s[5],name2);	/* local file */
		    ftpfh  = open(name2, O_BINARY|O_WRONLY|O_CREAT|O_TRUNC, S_IREAD|S_IWRITE);
		}
		else ftpfh  = open(name, O_BINARY|O_WRONLY|O_CREAT|O_TRUNC, S_IREAD|S_IWRITE);
		if (ftpfh<0) {
			nprintf(SCREEN,"Cannot open file to receive: %s\n",name);
			return(-1);
		}
		strcpy(&s[5],name);	/* put remote name back into command */
		ftpdata = netlisten(ftpport());		/* open data connection */
		ftpstate = 30;
	}
	else if (!strncmp(s,"LIST",4) || !strncmp(s,"NLST",4)) {
		if (capture) captlist[0] = '\0';	/* where to put incoming data */
		ftpdata = netlisten(ftpport());		/* data connection */
		ftpstate = 40;
	}
	else if (!strncmp(s,"TYPE",4)) {
		if (toupper(s[5]) == 'I')
			ftpfilemode = FIMAGE;	/* remember mode */
		else if (toupper(s[5]) == 'A')
			ftpfilemode = FASCII;
	}

	dumpcon(ftpnum);			/* clear command connection */
	netpush(ftpnum);
	netwrite(ftpnum,s,strlen(s));		/* send command */
	netwrite(ftpnum,"\r\n",2);		/* <CRLF> terminates command */
	if (!capture && ofile[0]) {		/* command redirected */
		if ((ftpstate!=20) && (ftpstate!=30)) {	/* not get or put */
		     if (0 > (ftpfh = open(ofile,O_CREAT|O_APPEND|O_WRONLY,S_IWRITE)))
			nprintf(SCREEN," Cannot open output file.\n");
		     else
		        if (ftpdata > -1) {
			    ftpstate = 30;	/* act as get, since data goes into file */
			}
			else {
			    close(ftpfh);
			    ftpfh = 0;
			}
		}
	}
	
	if (debug) {
	    nprintf(SCREEN,"---> %s\n",s);	/* show command sent */
		if (debug>=7) {
		    for (i=0; i<strlen(s); i++) {
			sprintf(&printline[4*i],"%3X ",s[i]);
		    }
		    nprintf(SCREEN,"%s\n",printline);
		}
	}

	i = ftpreplies(ftpnum,&rcode);		/* get remote response */
	if ((i==NONE) && strncmp(s,"QUIT",4)) {	/* unexpected connection drop */
	    nprintf(SCREEN,"lost connection\n");
	    connected = FALSE;
	}
	if (i==ABORT || i==NONE || i==ERROR)  {
	    ftpstate = 0;		/* if error, no transfer */
	    if (ftpdata>-1) netclose(ftpdata);
	    if (ftpfh!=0) close(ftpfh);
	    ftpdata = -1;
	    ftpfh = 0;
	}
	return(i);
}

/************************************************************************/
/*   ftpport
*   return a new port number so that we don't try to re-use ports
*   before the mandatory TCP timeout period.  (lifetime of a packet)
*   use a time-based initial port selection scheme.
/************************************************************************/

long int time();			/* global */

unsigned int ftpport()
	{
	unsigned int i,rcode;
	unsigned char hostnum[5];
	char sendline[60];		/* for port command */

	if (!sendport) {		/* default port */
	    return(HFTP-1);
	}
	if (curftpprt < 40000) {	/* restart cycle */
		i = (unsigned int)time(NULL);
		curftpprt = 40000 + (i & 0x3fff);
	}

	i = curftpprt--;	/* get port, update for next time */

	netgetip(hostnum);	/* get my ip number */
	sprintf(sendline,"PORT %d,%d,%d,%d,%d,%d\r\n",hostnum[0],hostnum[1],hostnum[2],
		hostnum[3],i/256,i&255);	/* full port number */
	if (debug>1) nprintf(SCREEN,sendline);

	netpush(ftpnum);	/* empty command connection */
	netwrite(ftpnum,sendline,strlen(sendline));	/* send PORT command */
	/* check result of command, make sure port was okay */
	/* return 0 on error */		/* ????? */
	dumpcon(ftpnum);
	ftpreplies(ftpnum,&rcode);	/* get response */
	return(i);		/* port number */

}


/************************************************************************/
/* ftpreplies
* get responses to commands to server
* return TRUE on successful completion, FALSE on transient negative
* completion, INCOMPLETE if more commands needed for operation,
* NONE on lost connection, ABORT on user abort and ERROR on failure
*
/************************************************************************/

ftpreplies(cnum,rcode)
int cnum,*rcode;
{
int cnt,ev,j=0;
	int myrc;
	int contin=0;

while (1) {
    cnt = rgetline(cnum);			/* get line form remote host */
    if (cnt==NONE) return(NONE);		/* lost connection */
    if (cnt==ABORT) {				/* user abort */
	netpush(cnum);
	netwrite(cnum,"ABOR\r\n",6);		/* send abort */
	return(ABORT);
    }
    sscanf(s,"%d",(int *) &myrc);

    if ( (!contin) && (s[3]=='-') ){
	contin=1;
	j=myrc;
    }

    if ( (contin) && (s[3]==' ') && (myrc==j) ){
	contin=0;
	myrc=j;
    }
    *rcode = myrc;

    if (((myrc/100)==2) && (! contin)) {	/* positive completion */
        dumpcon(ftpnum);			/* clear command connection */
	while (ftpdata>=0) {			/* wait till transfers complete */
	    ev = checkevent();
	    if (ev==NONE) return(NONE);	/* lost connection */
	    if (ev==ABORT) break;		/* user abort */
	    if (ev==HAVEDATA) dumpcon(ftpnum);	/* msg on command connection */
	}
    }
    if (verbose || (contin) || (myrc>500) || (cnt > 0)) telnet(cnt);	/* informative/error msg or display on */

    if (contin) {
    	continue;			/* end of continuation */
    }

    switch(myrc/100) {			/* first digit */
	case 1:					/* preliminary */
	    continue;
	case 2:					/* positive completion */
	    return(TRUE);
	    break;
	case 3:					/* intermediate */
	    return(INCOMPLETE);
	    break;
	case 4:					/* transient negative completion */
	    return(FALSE);
	    break;
	case 5:					/* Permanent negative completion */
	    return(ERROR);
	    break;
	default:
	       {
	       	    char buff[256];
		    nprintf(SCREEN,"Server response not understood. Terminating command (rcode %d)\n'%s'\n",myrc,s);
		}
	    return(ERROR);
    }
}
}


/************************************************************************/
/* rgetline - get a line from remote server
* return ABORT on user ABORT, NONE on lost connection,
* length of received line on success
*
/************************************************************************/

rgetline(cnum)
int cnum;
{
int cnt,i=0,ev;
while (1) {
	ev = checkevent();
	switch (ev) {
	    case ABORT:				/* user abort */
	    case NONE:				/* lost connection */
		return(ev);
	    case HAVEDATA:
		if (fromtty && n_scrlck()) cnt = 0;		/* if paused, nothing to do */
		else while (1) {
		    cnt = netread(cnum,&s[i],1);	/* get some from queue */
		    if (!cnt) {
                        break;		/* nothing available */
		    }
	            if ((s[i++]=='\n')) {		/* end of line */
	                s[i] = '\0';
	            	return(i);		/* return line length */
	            }
		}
		break;
	    default:		/* ignore other events */
		break;
	}
}
return(0);
}


/************************************************************************/
/* breakstop
* handle cntrl-break
/************************************************************************/

int
breakstop()
	{
	foundbreak = 1;
	return(1);
}


/************************************************************************/
/* userftpd
*  FTP receive and send file functions
/************************************************************************/

userftpd()	{
	int i,r1,r2;
	double rate;
	static int stopcapture=FALSE;	/* bytes xferred % 1024 */
	static long tbytes;

	switch (ftpstate) {
		default:	/* unknown */
			break;
		case 40:		/* start LIST */
			if (!netest(ftpdata)) {
				start = time(NULL);	/* current time */
				tbytes = 0;		/* received so far */
				ftpstate = 41;
			}
			break;
		case 41:		/* get started */
			do {
                                int     cnt = strlen(captlist);

			        if (capture && !stopcapture) {	/* into captlist */
			            fcnt = netread(ftpdata,xs,READSIZE);
				    if (cnt+fcnt>=1999) { /* full */
				        if (!fromtty || !n_scrlck())
					    nprintf(SCREEN,&xs[2000-cnt]);	/* display excess chars */
					strncat(captlist,xs,1999-cnt);
                                        captlist[1999] = 0;     /* make sure its terminated */
					nprintf(SCREEN,"Error: capture list too long\n");
					stopcapture = TRUE;
				    }
				    else {
                                        strncat(captlist,xs,fcnt); /* append */
                                        captlist[cnt+fcnt] = 0; /* make sure buffer is terminated */
                                    }
				}
				else {
				    if (fromtty && n_scrlck()) break;	/* paused */
				    fcnt = netread(ftpdata,xs,READSIZE);
				    for (i=0; i < fcnt; i++) 
				       nprintf(SCREEN,"%c",xs[i]);	/* display */
				}
				if (fcnt>0) tbytes += fcnt;	/* how much */
			} while (fcnt>0);	/* till no more input */
			break;
		case 30:		/* receive */
			if (!netest(ftpdata)) {		/* connection made */
				start = time(NULL);
				ftpstate = 31;
				len = xp = 0;
				tbytes = 0;
			}
			break;
		case 31:
/*
* file has already been opened, take everything from the connection
* and place into the open file: ftpfh
*/
			do {
			/* wait until xs is full before writing to disk */
				if (len <= 0) {
					if (xp) {
						write(ftpfh,xs,xp);
						xp = 0;
					}
					len = BUFFERS;		/* expected or desired len to go */
				}
					/* how much to read */
				if (len < BUFFERS)	/* ### was READSIZE */
					i = len;
				else
					i = BUFFERS;

				fcnt = netread(ftpdata,&xs[xp],i);

				if (fcnt>0) {	/* adjust counts */
				    len -= fcnt;
				    xp += fcnt;
				    tbytes += fcnt;
				}

				if (debug>1) {
				    nprintf(SCREEN,"len %d xp %d fcnt %d\n",len,xp,fcnt);
				}

				if (fcnt < 0) {		/* connection closed */
					write(ftpfh,xs,xp);		/* write last block */
#ifdef	STUPID
					if (ftpfilemode == FASCII) {
						write(ftpfh,"\032",1);	/* EOF char */
					}
#endif
					close(ftpfh);
					ftpfh = 0;
				}

				if (hash) {	/* hash mark printing */
				    for (i=((tbytes-fcnt)%1024+fcnt)/1024; i; i--)
					nprintf(SCREEN,"#");
				}

			} while (fcnt > 0);
			break;

		case 20:	/* send */
			if (!netest(ftpdata)) {		/* connection made */
				start = time(NULL);
				ftpstate = 21;
                                filesiz = filelength(ftpfh);
				if (ftpfilemode == FASCII) {
					filesiz--;			/* leave off ctrl-Z */
				}
				towrite = 0;
				xp = 0;
				tbytes = 0;
			}
			break;

		case 21:
/*
*  transfer file(s) to the other host via ftp request
*  file is already open = ftpfh
*/
			if (towrite <= xp) {	/* need to read again */
/*				if (filesiz < (long)BUFFERS)
					i = (int)filesiz;
				else */
					i = BUFFERS;
				towrite = read(ftpfh,xs,i);
				if(towrite == -1) {
					perror("read in send mode 21:");
					towrite = 0;
				}
				if(towrite > BUFFERS) {

					nprintf(SCREEN,"Fatal, read %d bytes, only wanted %d\n",towrite, i);
				}
				xp = 0;
			}

                        if(towrite > 0 && !netest(ftpdata))
        			i = netwrite(ftpdata,&xs[xp],towrite-xp);
			netpush(ftpdata); 

			if (i > 0) {	/* send successful, adjust counts */
				xp += i;
				filesiz -= i;
                                if(filesiz < 0L)
                                        filesiz = 0;
				tbytes += i;
			}

			if (debug>1) {
			    nprintf(SCREEN,"i %d xp %d towrite %d filesiz %ld tbytes %ld  fcnt %d\n",i,xp,towrite, filesiz, tbytes,fcnt);
			}
			if (hash) {	/* hash printing */
			    for (r1=((tbytes-i)%1024+i)/1024; r1; r1--)
			        nprintf(SCREEN,"#");
			}

/*
*  done if:  the file is all read from disk and all sent
*  or other side has ruined connection
*/
			if ((filesiz <= 0L && xp >= towrite) || (i=netest(ftpdata))) {
				ftpstate = 22;
                                if(debug>1)
                                        nprintf(SCREEN,"File Ended, xp %d towrite %d netest %d filelen %ld\n",xp,towrite,filesiz, i);
			}
			break;

		case 22:	/* send done */
		/* wait for other side to accept everything and then close */
			if ( 0 >= (r1=netpush(ftpdata)))
				fcnt = -1;
			if (debug>1) {
			    nprintf(SCREEN,"fcnt %d r1 %d\n",fcnt,r1);
			}
			break;

	}  /* end of switch */

/*
*  after reading from connection, if the connection is closed,
*  reset up shop.
*/
	if (fcnt < 0) {		/* connection lost */
		if (ftpfh > 0) {	/* close file */
			close(ftpfh);
			ftpfh = 0;
		}
		ftpstate = 0;	/* done */
		fcnt = 0;
		i = (int) (time(NULL)-start);	/* how long to transfer */
		if (!i) rate = ((double) tbytes) / 1024.0;
		else rate = ((double) tbytes) / (i * 1024.0);
		r1 = (int) rate;	/* integer part of rate */
		r2 = (int) ((rate - (double) r1) * 1000);
	 	if(hash || verbose)
			nprintf(SCREEN,"Transferred %ld bytes in %d seconds (%d.%03d Kbytes/sec)\n",tbytes,i,r1,r2);
		netclose(ftpdata);	/* close connection */
		ftpdata = -1;
		if (bell) n_sound(1200,24);
	}
	return(TRUE);
}


/************************************************************************/
/* getword: remove a word from a string.  Things within quotes are
* assumed to be one word.
* return TRUE on success, FALSE on end of string
/************************************************************************/

char
*stpblk(s)
	char *s;
{
	while(*s == ' ')
		s++;
	return(s);
}

getword(string,word)
char *string,*word;
{
char *p,*q;
int i=0;

if (debug>4) {
	nprintf(SCREEN,"getword: string is %s\n",string);
}
p = stpblk(string);			/* skip leading blanks */
if (!(*p)) {				/* no words in string */
	word[0] = '\0';
	return(FALSE);
}
if (*p=='!') {				/* ! is a word */
	word[0] = *p;
	word[1] = '\0';
	strcpy(string,++p);
	return(TRUE);
}
if (*p=='\"') {				/* word delimited by quotes */
    while (p[++i] && p[i]!='\"') word[i-1] = p[i];
    word[i-1] = '\0';
    if (!p[i]) nprintf(SCREEN,"Missing \". Assumed at end of string.\n");
    else i++;
    q = p+i;
}
else   {
	q = strpbrk(p, " \t\r\n");
	if(!q) {
		strcpy(word,p);
		*(string) = 0;
	}
	else {
		*q = 0;
		strcpy(word,p);
		string[0] = 0;
		q = stpblk(q+1);
		if(*q)
			strcpy(string,q);
	}
	return(TRUE);
}
q = stpblk(q);
if(q)
	strcpy(string,q);
return(TRUE);
}


/************************************************************************/
/* lowercase: convert a string to lowercase
*
/************************************************************************/

lowercase(word)
char *word;
{
int i;

for (i=0; word[i]=tolower(word[i]); i++);
return(TRUE);
}


/************************************************************************/
/* checkoredir: check for output redirection.  If the command contains a
* >, assume a filename follows and extract it.  Remove the redirection
* from the original command.
* Also change \ to /
* return TRUE if redirection specified, FALSE otherwise 
/************************************************************************/

checkoredir(command,filename,slashflip)
char *command,*filename;
int slashflip;
{
int i;

filename[0] = '\0';
#ifdef	JUNK
/* 7/20/90 disable command line redirection */

for (i=0; (command[i]!='>'); i++) {	/* process command part */
#else
for (i=0; 1 ; i++) {	/* process command part */
#endif
	if (slashflip && command[i] == '\\') command[i] = '/';
        if (!command[i]) return(FALSE);	/* no redirection */
}
getword(&command[i+1],filename);	/* get redirected filename */
command[i] = '\0';
return(TRUE);
}


/************************************************************************/
/* getdir: get current directory.  Finds current drive and current path
* on drive, returns a string.
*
/************************************************************************/

getdir(drive,path)
int drive;
char *path;
{
char partpath[64];
	if(!drive)
		drive = getdisk();

	getcurdir(drive+1, partpath);
sprintf(path,"%c:\\%s",'A'+drive,partpath);
return(TRUE);
}


/************************************************************************/
/* finduniq: find name that is a unique prefix of one of the entries in
* a list.  Return position of the entry, NONE if none, AMBIGUOUS if more
* than one.
*
/************************************************************************/

finduniq(name,list,listsize)
char *name, *list[];
int listsize;
{
int i,j=NONE,len;

len = strlen(name);
for (i=0; i<listsize; i++) {
    if (!strncmp(name,list[i],len)) {		/* prefix */
	if (len==strlen(list[i])) return(i+1);	/* exact match */
	if (j!=NONE) j = AMBIGUOUS;	/* more than one match */
	else j = i+1;			/* note prefix found */
    }
}
return(j);			/* prefix */
}


/************************************************************************/
/* checkevent
* get and process network events
* returns ABORT on user abort, HAVEDATA if data available on command
* connection, NONE if connection lost, DOMOK if domain search succeeds,
* DOMFAIL if domain search fails, TRUE if no relevant event.
/************************************************************************/

checkevent()
{
int ev,class=0,data;

kbhit();			/* check for cntrl-break */
if (foundbreak) {
	foundbreak = FALSE;
	return(ABORT);
}
userftpd();			/* do ftp stuff */
Stask();			/* keep connections alive */
ev = Sgetevent(CONCLASS|ERRCLASS|USERCLASS, &class,&data);
if (class==CONCLASS) {
    if (data==ftpnum) {		/* command connection */
	if (ev==CONCLOSE) {	/* connection lost */
	    netclose(ftpnum);
	    if (!netest(ftpdata)) netclose(ftpdata);	/* close data connection */
	    connected = FALSE;
	    return(NONE);
	}
	if (ev==CONDATA) return(HAVEDATA);	/* data received */
    }
}
else if (class==USERCLASS) {		
    if (ev==DOMOK) {		/* domain search succeeded */
	ftpnum = data;
	return(DOMOK);
    }
    else if (ev==DOMFAIL) return(DOMFAIL);	/* domain search failed */
}
/* else if (class==ERRCLASS && ev==ERR1) nprintf(SCREEN,neterrstring(data)); */
return(TRUE);
}


/************************************************************************/
/* putstring: display string using vt100 emulation routines
/************************************************************************/

putstring(string)
char *string;
{

for (; *string; string++) nputchar(*string);
return(TRUE);
}


/************************************************************************/
/* printerr: display TCP error messages - disabled
/************************************************************************/

printerr()
{

int data,class;

while (ERR1==Sgetevent(ERRCLASS,&class,&data)) {
    if(debug > 2) {
	    nprintf(SCREEN,"%s\n",neterrstring(data));
    }
}
return(TRUE);
}


/************************************************************************/
/* getnname: get next name from captured list
* names delimited by newlines - <CR> or <LF>
/************************************************************************/

getnname(string,word)
char *string,*word;
{
char *s;

s = string;
while ((*string=='\n') || (*string=='\r')) string++;	/* skip initial newlines */
if (!(*string)) return(FALSE);		/* end of captlist */
while ((*string!='\n') && (*string!='\r') && (*string)) *(word++) = *(string++);
while ((*string=='\n') || (*string=='\r')) string++;	/* skip trailing newline */
*word = '\0';
strcpy(s,string);
return(TRUE);
}



/***************************************************************************/
/*  dosescape
*  escape to dos for processing
*  put the connections to automated sleep while in DOS
/************************************************************************/

dosescape()
{
	int i;
	char	*com;

	nprintf(SCREEN,"Warning, some programs will interfere with network communication and can\n");
	nprintf(SCREEN,"cause lost connections.  Do not run any network programs from this DOS shell.\n");
	nprintf(SCREEN,"Type 'EXIT' to return to FTP\n");
/*
*  invoke a put-to-sleep routine which calls netsleep every 8/18ths of a sec
*/
#ifdef	BADWAY

	i = system("command");		/* call DOS */
#else
	com = getenv("COMSPEC");
     	if(!com) {
	   	nprintf(SCREEN,"COMSPEC variable not found, can not escape to DOS\n");
		i = -1;
	}
     	else 
	   	i = spawnl(P_WAIT,com,com,NULL);
#endif


	if (i < 0) {
		nprintf(SCREEN,"\n\nError loading Shell\n");
		nprintf(SCREEN,"Make sure COMMAND.COM is specified under COMSPEC.\n");
		nprintf(SCREEN,"It must also be in a directory which is in your PATH statement.\n");
	}

	if (fromtty) n_row();
	return(0);
}

static int scrsetup;

nputs(line)
char *line;
{
if (!scrsetup) {
    scrsetup = 1;
	if (fromtty) {
	    n_clear();			/* clear screen */
	    n_wrap(1);			/* cursor positioning */
	    n_cur(0,0);
	    n_color(7);			/* set color to white */
	}

	nprintf(SCREEN,"             National Center for Supercomputing Applications\n");
       nprintf(SCREEN,"             Modified by the Educational Resources Center of Clarkson University\n");
	nprintf(SCREEN,"                      FTP version " VERSION "\n");
}
	nprintf(SCREEN,"%s\n",line);
	return(TRUE);
}

nputchar(ch)
char ch;
{
	nprintf(SCREEN,"%c",ch);
	return(TRUE);
}

/* End of ftp.c */