/* $Id: DATA.H 1.3 1999/01/09 06:00:31 rwhitby Exp $ */
/* $Source: A:/SRC/TCP/NCSATCP/INCLUDE/RCS/DATA.H $ */

/*
 * Portions developed by the Educational Resources Center, Clarkson University.
 * Portions developed by the National Center for Supercomputing Applications,
 * University of Illinois at Urbana-Champaign.
 */

/*
*    data.h
*   Declarations of global variables for TCP/IP libraries
*/

#include "pcdefs.h"

#ifdef MASTERDEF
unsigned char
	nnmyaddr[DADDLEN],		/*  my ethernet hardware address */
	broadaddr[DADDLEN],		/*  the broadcast address */	
	nnipnum[4]={66,79,79,84}, 	/*  my ip number defaults to BOOTP */
	nnredir = 0,			/*  flag indicating need for redirect */
	nnicmpsave[4],			/*  address for icmp redirect */
	nnicmpnew[4],			/*  new gateway from icmp redirect */
	nnmask[4] = {0,0,0,0},	/*  the default subnet mask */
	nnamask[4] = {255,0,0,0},		/* class A mask */
	nnbmask[4] = {255,255,0,0}, 	/* class B mask */
	nncmask[4] = {255,255,255,0},	/* class C mask */
	broadip[4] = {0xff,0xff,0xff,0xff},
	loopbackip[4] = {0x7f,0,0,1};
	
int
	nnipident					/*  ident field of outgoing ip packets */
			=1,	
	nnefirst					/* first entry in event q */
			=0,
	nnelast						/* last entry in event q */
			=0,
	nnefree						/* free list for event q */
			=0,
	nndto						/* dlayertimeout */
			=DLAYTIMEOUT,
	nnfromport					/* can force a port number selection */
			= 0,
	nncredit = CREDIT,			/* limited window in some cases */
	nnsegsize = MAXSEG;			/* maximum segment size  (intswapped) */

struct port *portlist[NPORTS];		/* allocate like iobuffers in UNIX */
struct uport ulist;					/* buffer for UDP */
struct pseudotcp tcps;				/* for checksums */
struct acache arpc[CACHELEN];		/* cache for hardware addresses */
struct eq nnq[NEVENTS];				/* event queue */

ARPKT arp;
DLAYER blankd;
IPKT blankip;
ICMPKT blankicmp;

#else
extern unsigned char
	nnmyaddr[DADDLEN],	/*  my ethernet hardware address */
	broadaddr[DADDLEN]		/*  the broadcast address */,
	broadip[4],
	nnipnum[4],
	nnredir,			/*  flag indicating need for redirect */
	nnicmpsave[4],			/*  address for icmp redirect */
	nnicmpnew[4],			/*  new gateway from icmp redirect */
	nnmask[4],
	nnamask[4],
	nnbmask[4],
	nncmask[4],
	loopbackip[4];

extern int
	nnipident				/*  ident field of ip */,
	nnefirst					/* first entry in event q */,
	nnelast						/* last entry in event q */,
	nndto						/* dlayertimeout */,
	nnefree,
	nnfromport,					/* can force a port number selection */
	nncredit,
	nnsegsize;			/* maximum segment size */

extern struct port *portlist[NPORTS];		/* allocate like iobuffers in UNIX */
extern struct uport ulist;					/* buffer for UDP */
extern struct pseudotcp tcps;				/* for checksums */
extern struct acache arpc[CACHELEN];		/* cache for hardware addresses */
extern struct eq nnq[NEVENTS];				/* event queue */

extern ARPKT arp;
extern DLAYER blankd;
extern IPKT blankip;
extern ICMPKT blankicmp;

#endif

/*
*   defines for types for functions, global to everyone 
*/
char *nbgets();

uint8 *getdlayer(),*netdlayer();

char *neterrstring();			/* some more static data for driver */

/*
*   defines of constants and macros that everyone needs to know
*/

#define nnerror(A)  netposterr(A)

/* End of data.h */
