/* $Id: BKGR.C 1.13 1999/05/06 01:20:59 rwhitby Exp $ */
/* $Source: A:/SRC/TCP/NCSATCP/SRC/RCS/BKGR.C $ */

/*
 * Portions developed by the Educational Resources Center, Clarkson University.
 * Portions developed by the National Center for Supercomputing Applications,
 * University of Illinois at Urbana-Champaign.
 */

/* #define DEBUG	1 */
/* #define DEBUGXY	1 */
/* #define XBUG		1 */

#include <alloc.h>
#include <dos.h>
#include <string.h>
#include <sys/stat.h>

#ifdef	DEBUG
#include <errno.h>
#endif

#include "config.h"
#include "stdio.h"
#include "fcntl.h"
#include "whatami.h"
#include "hostform.h"
#include "windat.h"
#include "newwin.h"
#include "mem.h"

#define HTELNET 23
#define HRSHD 514
#define HFTP 21
#define BUFFERS 2048
#define PATHLEN 73

#define RCPSEGSIZE 1024
#define EOLCHAR 10

int32 atol(),lseek();

char *firstname(),*nextname(),*nextfile,*fixslash();

static int
  ftpenable=0,				/* is file transfer enabled? */
  rcpenable=1,				/* is rcp enabled? */
  ftpdata=-1,					/* port for ftp data connection */
  fnum=-1,					/* port number for incoming ftp */
  rsnum=-1,					/* port number for incoming rshell */
  rserr=-1;					/* port number for rshd() stderr */

unsigned char myuser[17];			/* user name on my machine */

static unsigned char xs[BUFFERS+10],	/* buffer space for file transfer */
  pathname[PATHLEN],			/* space to keep path names */
  newfile[PATHLEN],			/* current file being received */
  hisuser[17],				/* user name on his machine */
  waitchar;					/* character waiting for from net */

static	char	*file_buffer, *file_ptr;
static	unsigned buffer_size;

static int 
curstate = -1,			/* state machine for background processes */
  retstate = 200,			/* to emulate a subroutine call */
  isdir=0,				/* flag for rcp target pathname */
  waitpos=0,				/* marker for gathering strings from net */
  cnt=0,					/* number of characters from last netread() */
  fh=0,					/* file handle when transfer file is open */
  ftpfh=0,				/* file handle for ftp data */
  rc=0;					/* telnet flag */
static unsigned int	xp=0,					/* general pointer */
  towrite=0,				/* file transfer pointer */
  len=0;					/* file transfer length */
static	int olddisk;
static char olddir[128];

static long int
filelen=0L;				/* length of current file for transfer */

static char crfound=0;
static  int     listmode;       /* true if NLST else LIST */


extern char Sptypes[NPORTS];			/* flags for port #'s */

#define PFTP 1
#define PRCP 2
#define PDATA 3

#define ga()  while (!netwrite(rsnum,"",1)) netsleep(0)

#define	ALLOC_BUFFER	0
#define	FREE_BUFFER	1

static void
set_file_buffer(int mode)
{
  unsigned long free_mem = coreleft();

  if(mode == ALLOC_BUFFER) {
    if(file_buffer)
      return;
    free_mem = (free_mem *  25/ 100);
    if(free_mem > 0xfff0)
      free_mem = 0xfff0;
    buffer_size = free_mem;
    if(buffer_size < BUFFERS) {
      file_buffer = file_ptr = xs;
      buffer_size = BUFFERS;
#ifdef DEBUG
      nprintf(CONSOLE,"FTP buffer size is %u\n",BUFFERS);
#endif
    }
    else {
      file_buffer = file_ptr = mem_malloc(buffer_size);
#ifdef DEBUG
      nprintf(CONSOLE,"FTP allocated %u byte transfer buffer\n",buffer_size);
#endif
    }
  }
  else {
    if(file_buffer != xs && file_buffer) {
      mem_free(file_buffer);
#ifdef DEBUG
      nprintf(CONSOLE,"FTP deallocated transfer buffer\n");
#endif
    }
    file_buffer = NULL;
  }
}

/************************************************************************/
/*  unsetrshd
 *   remove the acceptance of rshd calls (rcp)
 */
unsetrshd()
{
  netclose(rsnum);
  rsnum = -1;
  rcpenable = 0;
}

/************************************************************************/

setrshd()
{
  int i;
  /*
   *  set up to receive a rsh call connection 
   */
  if (rsnum >= 0)
    return(0);
  curstate = 199;					/* waiting for connection */
  i = netsegsize(RCPSEGSIZE);
  rsnum = netlisten(HRSHD);
  netsegsize(i);
  if (rsnum >= 0)
    Sptypes[rsnum] = PRCP;

  rcpenable = 1;
}


/************************************************************************/
/*  rshell
 *   take an incoming rshell request and service it.  Designed to handle
 *   rcp primarily.
*/
rshd(code,curcon)
     int code,curcon;
{
  int i,j;

  if (!rcpenable)
    return(0);

  switch (curstate) {
  case 199:					/* wait to get started */
    if (code != CONOPEN)
      break;

    curstate = 0;
    netputuev(SCLASS,RCPACT,rsnum);		/* keep us alive */

    break;
			
    /*
     * in effect, this is a subroutine that captures network traffic while
     * waiting for a specific character to be received
     */
  case 50:
    while (0 < (cnt = netread(rsnum,&xs[waitpos],1))) {
      if (xs[waitpos] == waitchar) {
	curstate = retstate;
	netputuev(SCLASS,RCPACT,rsnum);		/* keep us alive */
	break;
      }
      else 
	waitpos += cnt;
    }
    netpush(rsnum);
    break;

  case 51:				/* for recursion, passes straight through */
    break;

  case 0:					/* waiting for first string */
    retstate = 1;
    curstate = 50;
    waitchar = 0;
    waitpos = 0;
    netputuev(SCLASS,RCPACT,rsnum);		/* keep us alive */
    break;

  case 1:					/* we have received stderr port number */
    i = atoi(xs);		/* port number */
    curstate = 51;
#ifdef notneeded
    /*
     *  caution, netrespond calls netsleep()
     *  which will call this routine
     *  careful with the synchronicity!
     */
    if (i)		/* zero means, don't bother */
      rserr = netrespond(i,rsnum,1);	/* respond to rsh */
    else
#else
      if (i) {
	cnt = -1;		/* abort it all, we don't take rsh */
	break;
      }
      else
#endif
	rserr = -1;

    retstate = 2; curstate = 50;
    waitpos = 0; waitchar = 0;
    break;

  case 2:				/* get user name, my machine */
    strncpy(myuser,xs,16);

    retstate = 3; curstate = 50;
    waitpos = 0; waitchar = 0;
    break;

  case 3: 			/* get user name, his machine */
    strncpy(hisuser,xs,16);
    /*			ftransinfo(hisuser); */

    retstate = 4; curstate = 50;
    waitchar = 0; waitpos = 0;

    break;

  case 4:
    /*			ftransinfo(xs);*/
    /*
     * ACK receipt of command line
     */
    if (rserr >= 0)
      netwrite(rserr,&xp,1);		/* send null byte */
    else {
      ga();			/* send NULL on main connection */
    }

    if (!strncmp(xs,"rcp ",4)) {
      /*
       *  rcp will be using wildcards, target must be a directory
       */
      if (!strncmp(&xs[4],"-d -t",5)) {
	strncpy(pathname,&xs[10],PATHLEN);
	if (direxist(pathname)) {
	  /*						ftransinfo("no directory by that name ");*/
	  netwrite(rsnum,"\001 No dir found ",16);
	  netpush(rsnum);
	  cnt = -1;
	  break;
	}

	isdir = 1;
	retstate = 20; curstate = 50;
	waitchar = '\012'; waitpos = 0;

	ga();		/* ready for them to start */
	break;
      }
      /*
       * target could be a directory or a complete file spec
       */
      if (!strncmp(&xs[4],"-t",2)) {
	strncpy(pathname,&xs[7],PATHLEN);
	if (!direxist(pathname)) 
	  isdir = 1;
	else
	  isdir = 0;

	retstate = 20 ; curstate = 50;
	waitchar = '\012'; waitpos = 0;

	ga();			/* ready for rcp to start */
	break;
      }
      /*
       *  rcp is requesting me to transfer file(s) (or giving directory name)
       */
      if (!strncmp(&xs[4],"-f",2)) {
	strncpy(pathname,&xs[7],PATHLEN);

	/*
	 *  direxist returns whether the path spec refers to a directory, and if
	 *  it does, prepares it as a prefix.  Therefore, if it is a dir, we append
	 *  a '*' to it to wildcard all members of the directory.
	 *  Firstname() takes a file spec (with wildcards) and returns a pointer
	 *  to a prepared ACTUAL file name.  nextname() returns successive ACTUAL
	 *  filenames based on firstname().
	 */
	if (!direxist(pathname)) {
	  i = strlen(pathname);
	  pathname[i] = '*';		/* all members of directory*/
	  pathname[++i] = '\0';
	}
	nextfile = firstname(pathname);

	if (nextfile == NULL) {
	  /* ftransinfo(" file or directory not found ");*/
	  netwrite(rsnum,"\001 File not found ",18);
	  netpush(rsnum);
	  cnt = -1;
	}
	else {
	  /* wait for other side to be ready */
	  retstate = 30;	curstate = 50;
	  waitchar = 0; waitpos = 0;
	}
	break;
      }
    }

    break;

  case 20:
    xs[waitpos] = '\0';		/* add terminator */

    /*
     *  get working values from command line just received
     *  open file for receive
     */
    if (xs[0] != 'C' || xs[5] != ' ') {
      /* ftransinfo(" Cannot parse filename line "); */
      netwrite(rsnum,"\001 Problem with file name ",26);
      cnt = -1;
      break;
    }

    filelen = atol(&xs[6]);

    for (i = 6; xs[i] != ' '; i++) 
      if (!xs[i]) {
	/* ftransinfo(" premature EOL ");*/
	netwrite(rsnum,"\001 Problem with file name ",26);
	cnt = -1;
	break;
      }

    strcpy(newfile,pathname);		/* path spec for file */

    if (isdir)			/* add file name for wildcards */
      strcat(newfile,&xs[++i]);
    if (0 > (fh = open(newfile,O_CREAT|O_BINARY|O_TRUNC,S_IREAD|S_IWRITE))) {
      netwrite(rsnum,"\001 Cannot open file for write ",29);
      cnt = -1;
      break;
    }
    netputevent(USERCLASS,RCPBEGIN,-1);
    ga();			/* start sending the file to me */
    xp = len = 0;
    curstate = 21;		/* receive file, fall through */
    break;

  case 21:
    do {
      /* wait until xs is full before writing to disk */
      if (len <= 0) {
	if (xp) {
	  write(fh,xs,xp);
	  xp = 0;
	}
	if (filelen > (long)BUFFERS)
	  len = BUFFERS;
	else
	  len = (int)filelen;
      }

      cnt = netread(rsnum,&xs[xp],len);

      filelen -= (long)cnt;
      len -= cnt;
      xp += cnt;

      /* printf(" %ld %d %d %d ",filelen,len,xp,cnt);
	 n_row(); n_puts(""); */

      if (filelen <= 0L || cnt < 0) {
	write(fh,xs,xp);		/* write last block */
	close(fh);
	fh = 0;
					
	/* wait for NULL byte at end after closing file */
	curstate = 50;  retstate = 22;
	waitchar = 0;   waitpos = 0;
	break;
      }

    } while (cnt > 0);
    break;

  case 22:
    /* cause next sequence of bytes to be saved as next filename
       to transfer     */
    ga();			/* tell other side, I am ready */
    waitchar = '\012'; waitpos = 0;
    curstate = 50; retstate = 20;
    break;

    /*
     *  transfer file(s) to the sun via rcp
     */
  case 30:
    if (0 > (fh = open(nextfile,O_BINARY|O_RDONLY))) {
      netwrite(rsnum,"\001 File not found ",19);
      /* ftransinfo("Cannot open file to transfer: ");
	 ftransinfo(nextfile); */
      cnt = -1;
      break;
    }
    netputevent(USERCLASS,RCPBEGIN,-1);
    filelen = lseek(fh,0L,2);	/* how long is file? */
    lseek(fh,0L,0);				/* back to beginning */

    for (i=0,j=-1; nextfile[i] ; i++)
      if (nextfile[i] == '\\')
	j = i;

    sprintf(xs,"C0755 %lu %s\012",filelen,&nextfile[j+1]);
    netwrite(rsnum,xs,strlen(xs));	/* send info to other side */

    /* ftransinfo(xs); check it */

    retstate = 31; curstate = 50;
    waitchar = 0;  waitpos = 0;

    towrite = xp = 0;
    break;

  case 31:
    /*
     *   we are in the process of sending the file 
     */
    netputuev(SCLASS,RCPACT,rsnum);		/* keep us alive */

    if (towrite <= xp) {
      towrite = read(fh,xs,BUFFERS);
      xp = 0;
      filelen -= (long)towrite;
    }
    i = netwrite(rsnum,&xs[xp],towrite-xp);
    if (i > 0)
      xp += i;

    /* printf(" %d %d %d %ld\012",i,xp,towrite,filelen);
       n_row();
    */
    /*
     *  done if:  the file is all read from disk and all sent
     *  or other side has ruined connection
     */
    if ((filelen <= 0L && xp >= towrite) || netest(rsnum)) {
      close(fh);
      fh = 0;
      nextfile = nextname();		/* case of wildcards */
      ga(); 
      netputuev(SCLASS,RCPACT,rsnum);
      if (nextfile == NULL)
	retstate = 32;
      else
	retstate = 30;
      curstate = 50;
      waitchar = 0;	waitpos = 0;
    }
    break;
  case 32:
    cnt = -1;
    break;
  case 5:
    break;
  default:
    break;

  }

  /*
   *  after reading from connection, if the connection is closed,
   *  reset up shop.
   */
  if (cnt < 0) {
    if (fh > 0) {
      close(fh);
      fh = 0;
    }
    curstate = 5;
    cnt = 0;
    netclose(rsnum);
    rsnum = -1;
    netputevent(USERCLASS,RCPEND,-1);

    setrshd();					/* reset for next transfer */
  }


}

/***********************************************************************/
/***********************************************************************/
/***********************************************************************/
/************************************************************************/
/*  ftp section
*   This should be extracted from rcp so that it compiles cleanly
*/

#define CRESP(A)  netwrite(fnum, messs[(A)], strlen(messs[(A)]))

#define FASCII  (O_TEXT)
#define FIMAGE  (O_BINARY)
#define FAMODE 0
#define FIMODE 1

static int rfstate = 0,
  ftpstate = 0,			/* state of the ftp data transfer */
  ftpqueued = 0,
  portnum[8],
  ftpfilemode=FASCII,			/* how to open ze file */
  ftptmode=FAMODE;			/* how to transfer ze file on net */

static uint16 fdport;

setftp()
{
  int dummy;

  strcpy(myuser,"unknown");	/* set unknown user name */

  /* Create the initial listener for FTP connections. */
  dummy = netlisten(HFTP);

  if (dummy >= 0) {
    Sptypes[dummy] = PFTP;
    ftpenable = 1;
  }
  else {
    ftpenable = 0;
  }
    
  return;
}

unsetftp()
{

  if (ftpfh > 0) {
    close(ftpfh);
  }
  ftpfh = 0;

  if (ftpdata >= 0) {
    netputevent(USERCLASS,FTPEND,-1);
    netclose(ftpdata);
  }
  ftpdata = -1;

  if (fnum >= 0) {
    netputevent(USERCLASS,FTPCLOSE,fnum);
    Sptypes[fnum] = 0;
    netclose(fnum);
    Stimerunset(CONCLASS,CONCLOSE,fnum);
  }
  fnum = -1;

  ftpenable = 0;
  rfstate = 0;
  ftpstate = 0;
}

char *ufn2dfn(char *xs)
{
  int i;

  /* Flip slashes */

  for (i=0; i < strlen(xs); i++)
    if (xs[i] == '/')
      xs[i] = '\\';
  
  /* Allow '\\c:' as a synonym for 'c:\\' */
    
  if ((strlen(xs) >= 3) && (xs[0] == '\\') && (xs[2] == ':')) {
    if ((strlen(xs) == 3) || (xs[3] != '\\')) {
      xs[0] = xs[1];
      xs[1] = ':';
      xs[2] = '\\';
    }
    else {
      strcpy(xs, xs+1);
    }
  }

  i = strlen(xs);

  /* Remove a trailing \ from non-root directories */
  if ((i > 1) && (xs[i-1] == '\\') && (xs[i-2] != ':')) {
    xs[i-1] = 0;
  }
  
  return xs;
}

/***********************************************************************/
/*
 *  resident ftp server -- enables initiation of ftp without a username
 *  and password, as long as this telnet is active at the same time
 *  Now checks for the need of passwords.
*/

static char *messs[] = {
  "220 Resident FTP server (LXTCP "VERSION" DOS/UNIX) ready.\015\012",  /*0*/
  "451 Error in processing list command \015\012",			/*1*/
  "221 Goodbye. \015\012",						/*2*/
  "200 Command Accepted \015\012",					/*3*/
  "150 File status okay, about to open data connection.\015\012",	/*4*/
  "226 Transfer complete, closing data connection.\015\012",		/*5*/
  "200 Type set to A, ASCII transfer mode.\015\012",			/*6*/
  "200 Type set to I, binary transfer mode.\015\012",			/*7*/
  "500 Syntax error, command unrecognized.\015\012",			/*8*/
  "200 Command successful.\015\012",					/*9*/
  "230 User logged in \015\012",					/*10*/
  "550 File or Directory not found.\015\012",				/*11*/
  "550 Could not create directory.\015\012",				/*12*/
  "250 Requested file action okay, completed.\015\012",			/*13*/
  "257 \"",								/*14*/
  "\" is current directory.\015\012",					/*15*/
  "\" created.\015\012",						/*16*/
  "504 Parameter not accepted, not implemented\015\012",		/*17*/
  "200 Stru F, file structure\015\012",					/*18*/
  "200 Mode S, stream mode\015\012",					/*19*/
  "202 Command not implemented, superfluous at this site.\015\012",	/*20*/
  "553 Cannot open file to write, check for valid name\015\012",	/*21*/
  "530 USER and PASS required to activate me\015\012",			/*22*/
  "331 Password required. \015\012",    				/*23*/
  "530 Login failed, check password.\015\012",				/*24*/
  "552 Disk write error, probably disk full\015\012",			/*25*/
  "502 Command not implemented.\015\012",				/*26*/
  "220-Server currently busy, please wait.\015\012",			/*27*/
  "421 Server has closed connection.\015\012",				/*28*/
  "421 Could not open the data connection.\015\012",			/*29*/
  "550 Permission denied.\015\012",	  				/*30*/
  "214-The following commands are recognized:\015\012",			/*31*/
  "    USER PASS ACCT CWD PWD QUIT PORT MDTM TYPE STRU MODE RETR STOR\015\012",
  "    RNFR RNTO DELE RMD MKD CDUP LIST NLST SITE STAT SYST HELP NOOP\015\012",
  "    Some commands may not be implemented (and will return 502).\015\012",
  "214 Direct comments and bugs to rwhitby@hplx.net\015\012",		/*35*/
  ""};

rftpd(code,curcon)
     int code,curcon;
{
  int i, savefnum;
  char *p;

  /* Return immediately if FTP is not enabled. */
  if (!ftpenable)
    return(0);

  /* Intercept and process non-active connections here. */
  if (curcon != fnum) {
    switch (code) {

    case CONOPEN: /* A new connection opening. */

      /* Save the currently active connection. */
      savefnum = fnum;

      /* Check to see if there is a spare listening port. */
      fnum = netlisten(HFTP);
      if (fnum >= 0) Sptypes[fnum] = PFTP;

      /* If there is an active connection, then queue or reject this one. */
      if (rfstate != 0) {

	if (fnum >= 0) {
	  /* There was a spare port, so queue this connection. */
	  fnum = curcon; CRESP(27); /* 220- (120 if anyone supported it) */
	  netpush(curcon);

	  netputevent(USERCLASS,FTPQUEUED,curcon); /* inform the console */
	  ftpqueued++;

	  /* Check every second to see if we can be unqueued */
	  Stimerset(CONCLASS,CONDATA,curcon,1);

	  /* Give an anonymous or unknown user a five second timeout */
	  if (!strcmp(myuser,"anonymous") || !strcmp(myuser,"unknown")) {
	    Stimerset(CONCLASS,CONCLOSE,savefnum,5);
	  }
	}
	else {
	  /* We've run out of ports, so reject this connection. */
	  fnum = curcon; CRESP(28); /* 421 */
	  netpush(curcon);

 	  netputevent(USERCLASS,FTPREJECTED,curcon); /* inform the console */
	  Sptypes[curcon] = 0;
	  netclose(curcon);
	}

	/* Restore the currently active connection. */
	fnum = savefnum;

	/* Finished with this event. */
	return 0;
      }

      /* Else, no active connection - so activate this connection. */
      else {
	fnum = curcon;
      }

      break;
      
    case CONDATA: /* A queued connection still waiting */

      if (rfstate != 0) {

	/* Check if the other end is still waiting. */
	if (netest(curcon)) {
	  netputevent(USERCLASS,FTPCLOSE,curcon); /* inform the console */
	  Sptypes[curcon] = 0;
	  netclose(curcon);
	  Stimerunset(CONCLASS,CONCLOSE,curcon);
	  ftpqueued--;
	  if (ftpqueued == 0) {
	    Stimerunset(CONCLASS,CONCLOSE,fnum);
	  }
	}
	else {
	  /* Check every second to see if we can be unqueued */
	  Stimerset(CONCLASS,CONDATA,curcon,1);

	  /* Give an anonymous or unknown user a five second timeout */
	  if (!strcmp(myuser,"anonymous") || !strcmp(myuser,"unknown")) {
	    Stimerset(CONCLASS,CONCLOSE,fnum,5);
	  }
	}
      
	/* Finished with this event. */
	return 0;
      }

      /* If there is no active connection, then make this one active. */
      else {

	/* Check if the other end is still waiting. */
	if (netest(curcon)) {
	  netputevent(USERCLASS,FTPCLOSE,curcon); /* inform the console */
	  Sptypes[curcon] = 0;
	  netclose(curcon);
	  Stimerunset(CONCLASS,CONCLOSE,curcon);
	  ftpqueued--;
	  if (ftpqueued == 0) {
	    Stimerunset(CONCLASS,CONCLOSE,fnum);
	  }

	  /* Finished with this event. */
	  return 0;
	}
	else {
	  netputevent(USERCLASS,FTPUNQUEUED,curcon); /* inform the console */
	  fnum = curcon; code = CONOPEN;
	  ftpqueued--;
	}
      }

      break;

    case CONCLOSE: /* A remote connection has closed */

      netputevent(USERCLASS,FTPCLOSE,curcon); /* inform the console */
      Sptypes[curcon] = 0;
      netclose(curcon);
      Stimerunset(CONCLASS,CONCLOSE,curcon);
      ftpqueued--;
      if (ftpqueued == 0) {
	Stimerunset(CONCLASS,CONCLOSE,fnum);
      }
      
      /* Finished with this event. */
      return 0;

    default:

      nprintf(CONSOLE,"FTP server (%d) ILLEGAL CODE %d\n",curcon,code);

      /* Finished with this event. */
      return 0;
     
    }
  }

  netpush(fnum);

  if (code == CONCLOSE) {
    /* Forced closure */
    rfstate = 911;
  }

  switch (rfstate) {
  case 0:
    if (code != CONOPEN) 
      break;
    ftpfilemode = FASCII;
    ftptmode = FAMODE;
    netputevent(USERCLASS,FTPCOPEN,fnum);
    rfstate = 1;				/* drop through */
    set_file_buffer(ALLOC_BUFFER);

    olddisk = getdisk();
    getcwd(olddir,128);
#ifdef	DEBUG
    printf("\n\nolddisk %d, olddir '%s'\n",olddisk, olddir);
#endif

  case 1:
    CRESP(0); /* 220 */
    netgetftp(portnum,fnum);	/* get default ftp information */
    for (i=0; i<4; i++)			/* copy IP number */
      hisuser[i] = portnum[i];
    fdport = portnum[6]*256+portnum[7];

    waitpos = 0; waitchar = '\012';
    rfstate = 50;       		/* note skips over */
    if (Sneedpass()) 
      retstate = 3;				/* check pass */
    else
      retstate = 5;				/* who needs one ? */
    break;
  case 3:				/* check for passwords */
  case 4:
    waitpos = 0;  waitchar = '\012';
    rfstate = 50;  
    if (!strncmp("USER",xs,4)) {
      strncpy(myuser,&xs[5],16);		/* keep user name */
      netputevent(USERCLASS,FTPUSER,-1);
      CRESP(23); /* 331 */
      retstate = 4;		/* wait for password */
      break;
    }
    if (!strncmp("PASS",xs,4)) {
      if (Scheckpass(myuser,&xs[5])) {
	netputevent(USERCLASS,FTPPWOK,-1);
	CRESP(10); /* 230 */
	retstate = 5;
      }
      else {
	netputevent(USERCLASS,FTPPWNO,-1);
	CRESP(24); /* 530 */
	retstate = 3;
      }
      break;
    }
    if (!strncmp("QUIT",xs,4)) {
      CRESP(2); /* 221 */
      cnt = -1;
    }
    else
      CRESP(22); /* 530 */
    retstate = 3;			/* must have password first */
    break;				
				
    /*
     *  interpret commands that are received from the other side
     */
			
  case 5:

    if (ftpqueued > 0) {
      /* Reset the idle timer when a command is received. */
      Stimerunset(CONCLASS,CONCLOSE,fnum);
    }

    /*
     *  set to a safe state to handle recursion
     *  wait for another command line from client
     *  
     */
    rfstate = 50; retstate = 5;
    waitchar = '\012';  waitpos = 0;

#ifdef DEBUG
    nprintf(CONSOLE,"FTP command: %s\n",xs);
#endif

    if (!strncmp(xs,"LIST",4) || !strncmp(xs,"NLST",4)) {

      /* Simulate the behaviour of Unix LIST commands */
      if (xs[5] == '-') {
	p = &xs[5];
	while (*p && (*p++ != ' ')) {
	}
	strcpy(xs, "LIST ");
	strcpy(&xs[5], p);
      }

      if(!strncmp(xs,"NLST",4))
	listmode = -1;
      else
	listmode = 0;

      ufn2dfn(&xs[5]);

      i = strlen(xs);
      if (i < 6) {
	strcpy(&xs[4], " *");
      }
      else {

	/* Need to handle the following cases:

	   a) \
	   b) \.
	   c) C:
	   d) C:.
	   e) C:\
	   f) C:\.
	   g) C:\X     C:X     X
	   h) C:\X.    C:X.    X.
	   i) C:\X\    C:X\    X\	(turned into g by ufn2dfn)
	   j) C:\X\.   C:X\.   X\.
	   k) C:\X\Y   C:X\Y   X\Y
	   l) C:\X\Y.  C:X\Y.  X\Y.
	   m) C:\X\Y\  C:X\Y\  X\Y\	(turned into k by ufn2dfn)
	   n) C:\X\Y\. C:X\Y\. X\Y\.
	   
	*/

	/* Check for a lone \ */
	if ((i == 6) && (xs[5] == '\\')) {
	  strcpy(&xs[6], "*");
	} /* Cases: a */

	/* Check for a lone drive letter */
	else if ((i == 7) && (xs[6] == ':')) {
	  strcpy(&xs[7], "*");
	} /* Cases: c */

	/* Check for a relative drive letter */
	else if ((i == 8) && (xs[7] == '.')) {
	  xs[7] = '*';
	} /* Cases: d */

	/* Check for a trailing \. */
	else if ((xs[i-2] == '\\') && (xs[i-1] == '.')) {
	  xs[i-1] = '*';
	} /* Cases: b, f, j, n */

	/* Check for a lone trailing \ */
	else if (xs[i-1] == '\\') {
	  strcpy(&xs[i-1], "*");
	} /* Cases: e, i, m */

	/* Check for directories with no trailing information */
	else {
	  if (!direxist(&xs[5])) {
	    i = strlen(xs);
	    xs[i] = '*';
	    xs[++i] = 0;
	  }
	} /* Cases: g, h, k, l */
      }

      /* dopwd() always inserts a drive letter first. */
      dopwd(newfile,PATHLEN-2);

      if (newfile[strlen(newfile)-1] != '\\') { 
	strcat(newfile,"\\");
      }
      /* A drive specification overrides everything. */
      if (strchr(xs,':')) {
	newfile[0] = 0;
      }
      /* A leading \\ uses the current drive. */
      else if ((strlen(xs) >= 6) && (xs[5] == '\\')) {
	newfile[2] = 0;
      }
      strncat(newfile,&xs[5],PATHLEN-1-strlen(newfile));

      nextfile = firstname(&xs[5],listmode);	/* find first name */
      if (nextfile == NULL) {
	CRESP(11); /* 550 */
      }
      else {
	if ((p = strrchr(nextfile, '/')) != NULL) {
	  nextfile = p+1;
	}
	ftpgo();			/* open the connection */
	fdport = portnum[6]*256+portnum[7]; /* reset to def */
	if (ftpdata >= 0) {
	  Sptypes[ftpdata] = PDATA;
	  ftpstate = 40;		/* ready to transmit */
	  CRESP(4); /* 150 */
	  netputevent(USERCLASS,FTPLIST,-1);
	}
	else {
	  nprintf(CONSOLE,"FTP server (%d) NO DATA CONNECTION\n",curcon);
	  CRESP(29); /* 421 */
	  cnt = -1;
	}
      }
    }
    else if (!strncmp(xs,"CWD",3)) {
      if (chgdir(ufn2dfn(&xs[4]))) 			/* failed */
	CRESP(11); /* 550 */
      else						/* success */
	CRESP(13); /* 250 */
    }
    else if (!strncmp(xs,"XCWD",4)) {
      if (chgdir(ufn2dfn(&xs[5]))) 			/* failed */
	CRESP(11); /* 550 */
      else						/* success */
	CRESP(13); /* 250 */
    }
    else if (!strncmp(xs,"CDUP",4) || !strncmp(xs,"XCUP",4)) {
      if (chgdir("..")) 			/* failed */
	CRESP(11); /* 550 */
      else						/* success */
	CRESP(13); /* 250 */
    }
    else if (!strncmp(xs,"DELE", 4)) {	/* delete file */
      if (!strcmp("anonymous",myuser))
	CRESP(30); /* 550 */
      else if(unlink(ufn2dfn(&xs[5])))
	CRESP(11); /* 550 */
      else
	CRESP(13); /* 250 */
    }
    else if(!strncmp(xs, "MKD", 3)) {
      if (!strcmp("anonymous",myuser))
	CRESP(30); /* 550 */
      else if(mkdir(ufn2dfn(&xs[4])))
	CRESP(12); /* 550 */
      else {
	CRESP(14); /* 257 */				/* start reply */
	netwrite(fnum,fixslash(&xs[4]),strlen(&xs[4]));	/* write dir name */
	CRESP(16); /* 257 */				/* finish reply */
      }
    }
    else if(!strncmp(xs, "XMKD", 4)) {
      if (!strcmp("anonymous",myuser))
	CRESP(30); /* 550 */
      else if(mkdir(ufn2dfn(&xs[5])))
	CRESP(12); /* 550 */
      else {
	CRESP(14); /* 257 */				/* start reply */
	netwrite(fnum,fixslash(&xs[5]),strlen(&xs[5]));	/* write dir name */
	CRESP(16); /* 257 */				/* finish reply */
      }
    }
    else if(!strncmp(xs, "RMD", 3)) {
      if (!strcmp("anonymous",myuser))
	CRESP(30); /* 550 */
      else if(rmdir(ufn2dfn(&xs[4])))
	CRESP(11); /* 550 */
      else
	CRESP(13); /* 250 */
    }
    else if(!strncmp(xs, "XRMD", 4)) {
      if (!strcmp("anonymous",myuser))
	CRESP(30); /* 550 */
      else if(rmdir(ufn2dfn(&xs[5])))
	CRESP(11); /* 550 */
      else
	CRESP(13); /* 250 */
    }
    else if (!strncmp(xs,"STOR",4)) {

     if (!strcmp("anonymous",myuser))
	CRESP(30); /* 550 */
     else {

      ufn2dfn(&xs[5]);

      if (0 > (ftpfh = open(&xs[5], ftpfilemode|O_WRONLY|O_CREAT|O_TRUNC,
			    S_IREAD|S_IWRITE))) {
	CRESP(21); /* 553 */
	break;
      }

      ftpstate = 0;

      strncpy(newfile,&xs[5],PATHLEN-1);

      ftpgo();				/* open connection */
      fdport = portnum[6]*256+portnum[7]; /* reset to def */
      if (ftpdata >= 0) {
	Sptypes[ftpdata] = PDATA;
	ftpstate = 30;		/* ready for data */
	CRESP(4); /* 150 */
      }
      else {
	nprintf(CONSOLE,"FTP server (%d) NO DATA CONNECTION\n",curcon);
	CRESP(29); /* 421 */
	cnt = -1;
      }
     }
    }

    else if (!strncmp(xs,"RETR",4)) {

      ufn2dfn(&xs[5]);

      if (0 > (ftpfh = open(&xs[5],ftpfilemode|O_RDONLY))) {
	CRESP(11); /* 550 */
	break;
      }

      strncpy(newfile,&xs[5],PATHLEN-1);

      ftpgo();				/* open connection */
      fdport = portnum[6]*256+portnum[7]; /* reset to def */

      if (ftpdata >= 0) {
	Sptypes[ftpdata] = PDATA;
	ftpstate = 20;		/* ready for data */
	CRESP(4); /* 150 */
      }
      else {
	nprintf(CONSOLE,"FTP server (%d) NO DATA CONNECTION\n",curcon);
	CRESP(29); /* 421 */
	cnt = -1;
      }
    }
    else if (!strncmp(xs,"TYPE",4)) {
      if (toupper(xs[5]) == 'I') {
	ftpfilemode = FIMAGE;
	ftptmode = FIMODE;
	CRESP(7); /* 200 */
      }
      else if (toupper(xs[5]) == 'A') {
	ftpfilemode = FASCII;
	ftptmode = FAMODE;
	CRESP(6); /* 200 */
      }
      else
	CRESP(17); /* 504 */

    }
    else if (!strncmp(xs,"PORT",4)) {
      /*
       * get the requested port number from the command given
       */
      sscanf(&xs[5],"%d,%d,%d,%d,%d,%d",&portnum[0],&portnum[1],
	     &portnum[2],&portnum[3],&portnum[4],&portnum[5]);
      fdport = portnum[4]*256+portnum[5];
      CRESP(3); /* 200 */
    }
    else if (!strncmp(xs,"QUIT",4)) {
      CRESP(2); /* 221 */
      rfstate = 60;
      netputuev(CONCLASS,CONDATA,fnum);	/* post back to me */
    }
    else if (!strncmp(xs,"PWD",3) || !strncmp(xs,"XPWD",4)) {
      CRESP(14); /* 257 */				/* start reply */
      dopwd(xs,1000);					/* get directory */
      netwrite(fnum,fixslash(xs),strlen(xs));	/* write dir name */
      CRESP(15); /* 257 */				/* finish reply */
    }
    else if (!strncmp(xs,"USER",4)) {
      strncpy(myuser,&xs[5],16);		/* keep user name */
      netputevent(USERCLASS,FTPUSER,-1);
      CRESP(23); /* 331 */
      retstate = 4;		/* wait for password */
      break;
    }
    else if (!strncmp(xs,"STRU",4)) {	/* only one stru allowed */
      if (xs[5] == 'F') 
	CRESP(18); /* 200 */
      else
	CRESP(17); /* 504 */
    }
    else if (!strncmp(xs,"MODE",4)) {	/* only one mode allowed */
      if (xs[5] == 'S') 
	CRESP(19); /* 200 */
      else
	CRESP(17); /* 504 */
    }
    else if (!strncmp(xs,"ACCT",4) || !strncmp(xs,"ALLO",4) ||
	     !strncmp(xs,"SITE",4))
      CRESP(20); /* 202 */
    else if (!strncmp(xs,"SMNT",4) || !strncmp(xs,"REIN",4) ||
	     !strncmp(xs,"PASV",4) || !strncmp(xs,"STOU",4) ||
	     !strncmp(xs,"APPE",4) || !strncmp(xs,"REST",4) ||
	     !strncmp(xs,"RNFR",4) || !strncmp(xs,"RNTO",4) ||
	     !strncmp(xs,"ABOR",4) || !strncmp(xs,"STAT",4) ||
	     !strncmp(xs,"SYST",4) || !strncmp(xs,"MDTM",4))
      CRESP(26); /* 502 */
    else if (!strncmp(xs,"HELP",4)) {
      for (i=31; i<=35; i++)
	CRESP(i); /* 214 */
    }
    else if (!strncmp(xs,"NOOP",4)) 
      CRESP(9); /* 200 */
    else			/* command not understood */
      CRESP(8); /* 500 */

    break;

    /*
     *  subroutine to wait for a particular character
     */
  case 50:
    while (0 < (cnt = netread(fnum,&xs[waitpos],1))) {
      if (xs[waitpos] == waitchar) {
	rfstate = retstate;

	while (xs[waitpos] < 33)		/* find end of string */
	  waitpos--;
	xs[++waitpos] = '\0';			/* put in terminator */

	for (i=0; i<4; i++)				/* want upper case */
	  xs[i] = toupper(xs[i]);

	break;
      }
      else
	waitpos += cnt;

    }
    break;

  case 60:				/* wait for message to get through */
    /* or connection is broken */
    /* printf("%d,%d",netpush(fnum),netest(fnum));*/
    if (!netpush(fnum) || netest(fnum))
      cnt = -1;
    else
      netputuev(CONCLASS,CONDATA,fnum);	/* post back to me */
    break;

  case 911:
    CRESP(28); /* 421 */
    cnt = -1;
    break;

  default:
    break;

  }

  if (cnt < 0) {

    cnt = 0;

    if (ftpfh > 0) {
      close(ftpfh);
    }
    ftpfh = 0;

    if (ftpdata >= 0) {
      netputevent(USERCLASS,FTPEND,-1);
      netclose(ftpdata);
    }
    ftpdata = -1;

    if (fnum >= 0) {
      netputevent(USERCLASS,FTPCLOSE,fnum);
      Sptypes[fnum] = 0;
      netclose(fnum);
      Stimerunset(CONCLASS,CONCLOSE,fnum);
    }
    fnum = -1;
      
    rfstate = 0;
    ftpstate = 0;

    set_file_buffer(FREE_BUFFER);

    setdisk(olddisk);
    chdir(olddir);
#ifdef	DEBUG
    printf("chdir '%s' errno %d\n",olddir,errno);
#endif

    setftp();				/* reset it */
  }

}

/***********************************************************************/
/* ftpgo
 *  open the FTP data connection to the remote host
 */
ftpgo()
{
  int savest;
  struct machinfo *m;
  char    buff[17];

  netfromport(20);	 /* ftp data port */

  /* Check to see if we have an entry for this IP address. */
  if (NULL == (m = Slookip(portnum))) {
    /* If we don't already have an entry, then just use the default entry. */
    sprintf(buff, "%d.%d.%d.%d",
	    portnum[0], portnum[1], portnum[2], portnum[3]);
    m = Sgethost(buff);
  }

  ftpdata = Snetopen(m,fdport);
  return(ftpdata);
}

/*********************************************************************/
/*
 *  FTP receive and send file functions
 */
static int fcnt=0;

ftpd(code,curcon)
     int code,curcon;
{
  int i;
  char *p;

  if (curcon != ftpdata)		/* wrong event, was for someone else */
    return(0);

  if (ftpqueued > 0) {
    /* Reset the idle timer when transferring. */
    Stimerunset(CONCLASS,CONCLOSE,fnum);
  }

  switch (ftpstate) {
  default:
    break;

  case 40:				/* list file names in current dir */

    if (code == CONFAIL)	/* something went wrong */
      fcnt = -1;
    if (code != CONOPEN) 	/* waiting for connection to open */
      break;
			
    ftpstate = 41;

    /*
     *  send the "nextfile" string and then see if there is another file
     *  name to send
     */
  case 41:
    netputuev(SCLASS,FTPACT,ftpdata);
    netpush(ftpdata);
    i = strlen(nextfile);
    if(netroom(ftpdata) < i + 2)
      break;
    if (i != netwrite(ftpdata,nextfile,i)) {
      CRESP(1); /* 451 */
      fcnt = -1;
      break;
    }
    netwrite(ftpdata,"\015\012",2);
    if (NULL == (nextfile = nextname(listmode))) {	/* normal end */
      ftpstate = 22;   			/* push data through */
    }
    else {
      if ((p = strrchr(nextfile, '/')) != NULL) {
	nextfile = p+1;
      }
    }
    break;
			
  case 30:
    if (code == CONFAIL)	/* something went wrong */
      fcnt = -1;
    if (code != CONOPEN)	/* waiting for connection to open */
      break;
    ftpstate = 31;
    crfound = 0;
    len = xp = 0;
    file_ptr = file_buffer;
    filelen = 0L;
    netputevent(USERCLASS,FTPBEGIN,-2);
    break;
  case 31:
    /*
     * file has already been opened, take everything from the connection
     * and place into the open file: ftpfh
     */
    do {
      /* wait until xs is full before writing to disk */
      if (len == 0 || ((ftptmode == FAMODE) && len < 2048)) {

	if (xp) {
#ifdef	DEBUG
	  nprintf(CONSOLE,"Write %d\n",xp);
#endif
	  if (xp > write(ftpfh,file_buffer,xp)) { /* disk full err */
	    netclose(ftpdata);
	    fcnt = -1;
	    CRESP(25);
	    close(ftpfh);
	    ftpfh = 0;
	    break;
	  }
	  xp = 0;
	}
	file_ptr = file_buffer;
	len = buffer_size;		/* expected or desired len to go */
      }

      if (ftptmode == FAMODE)
	fcnt = Sfread(ftpdata,file_ptr,len > 0x7fff ? 0x7fff : len);
      else
	fcnt = netread(ftpdata,file_ptr,len > 0x7fff ? 0x7fff : len);

      if (fcnt > 0) {
	xp += fcnt;
	len -= fcnt;
	file_ptr += fcnt;
	filelen += fcnt;
      }
#ifdef	DEBUGX
      nprintf(CONSOLE,"len  %d  xp %d fcnt %d \012",len,xp,fcnt);
#endif
      n_row();  

      if (fcnt < 0) {
	if (xp > write(ftpfh,file_buffer,xp)) { /* disk full check */
	  CRESP(25);
	  break;
	}
	close(ftpfh);
	ftpfh = 0;
	CRESP(5);
      }

    } while (fcnt > 0);
    break;

  case 20:

    if (code == CONFAIL)	/* something went wrong */
      fcnt = -1;
    if (code != CONOPEN)	/* waiting for connection to open */
      break;
    ftpstate = 21;
    filelen = lseek(ftpfh,0L,2);	/* how long is file? */
    lseek(ftpfh,0L,0);				/* back to beginning */
    towrite = 0;
    xp = 0;
    file_ptr = file_buffer;
    netputevent(USERCLASS,FTPBEGIN,-1);

  case 21:
    /*
     *  transfer file(s) to the other host via ftp request
     *  file is already open = ftpfh
     */
    netputuev(SCLASS,FTPACT,ftpdata);
		
    if (towrite == 0) { /* was <= xp */

      i = buffer_size;
#ifdef  XBUG
      printf("FTPGO case 21 reading %d bytes to %lp for %d\n",i,file_buffer,ftpdata);
      n_row();
#endif
      towrite = read(ftpfh,file_buffer,i);
#ifdef  XBUG
      printf("FTPGO case 21 read %d bytes\n",towrite);
      n_row();
#endif
      xp = 0;
      file_ptr = file_buffer;
    }
    if (!towrite || netest(ftpdata)) {		/* we are done */
#ifdef	DEBUGXY
      nprintf(CONSOLE,"towrite is %x, state now 22\n",towrite);
#endif
      ftpstate = 22;
      break;
    }

    if (ftptmode == FAMODE)
      i = Sfwrite(ftpdata,file_ptr,towrite > 0x7fff ? 0x7fff : towrite);
    else
      i = netwrite(ftpdata,file_ptr,towrite > 0x7fff ? 0x7fff: towrite);

#ifdef  XBUG
    printf("FTPGO case 21 wrote %d bytes on channel, wanted %d on %d\n",i,towrite-xp,ftpdata);
    n_row();  

#endif
    netpush(ftpdata);
    /* #### */
    /*			printf(" wrote %d sent %d to go %d wanted %d at %ld\012",i,xp,towrite,towrite-xp,(long) time(NULL)); */

    if (i > 0) {
      xp += i;
      file_ptr += i;
      filelen -= i;
      towrite -= i;
      if (filelen < 0L)
	filelen = 0L;
    }

    break;

  case 22:		/* wait for data to be accepted */
    netputuev(SCLASS,FTPACT,ftpdata);

    fcnt = netpush(ftpdata);		/* will go negative on err */
    if (!fcnt || netest(ftpdata))
      fcnt = -1;
    if (fcnt < 0)
      CRESP(5);
    break;

  case 0:
    break;

  }  /* end of switch */

  /*
   *  after reading from connection, if the connection is closed,
   *  reset up shop.
   */
  if (fcnt < 0) {
    if (ftpfh > 0) {
      close(ftpfh);
      ftpfh = 0;
    }
    ftpstate = 0;
    fcnt = 0;
    if (ftpdata >= 0) {
      netclose(ftpdata);
      netputevent(USERCLASS,FTPEND,-1);
      ftpdata = -1;
    }
  }

}


/***************************************************************************/
/*  Sfwrite
 *   Write an EOL translated buffer into netwrite.
 *   Returns the number of bytes which were processed from the incoming
 *   buffer.  Uses its own 1024 byte buffer for the translation (with Sfread).
*/

Sfwrite(pnum,buf,nsrc)
     int pnum,nsrc;
     char *buf;
{
  int i,ndone,nout,lim;
  char *p,*q;
  char    mungbuf[1024];

  ndone = 0;

  while (ndone < nsrc) {

    if (0 > ( i = netroom(pnum)))
      return(-1);

    if (i < 1024)					/* not enough room to work with */
      return(ndone);
    /*
     *  process up to 512 source bytes for output (could produce 1K bytes out) 
     */
    if (nsrc - ndone > 512)
      lim = 512;
    else
      lim = nsrc-ndone;

    p = buf + ndone;				/* where to start this block */
    q = mungbuf;					/* where munged stuff goes */
    for (i=0; i < lim; i++) {
      if (*p == EOLCHAR) {
	*q++ = 13;
	*q++ = 10;
	p++;
      }
      else
	*q++ = *p++;
    }
    ndone += lim;					/* # of chars processed */
    nout = q-mungbuf;				/* # of chars new */

    netwrite(pnum,mungbuf,nout);	/* send them on their way */

  }

  return(ndone);
}

/*
*  important note:  for Sfread, nwant must be 256 bytes LARGER than the amount
*  which will probably be read from the connection.
*  Sfread will stop anywhere from 0 to 256 bytes short of filling nwant
*  number of bytes.
*/
Sfread(pnum,buf,nwant)
     int pnum,nwant;
     char *buf;
{
  int i,ndone,lim;
  char *p,*q;
  char mungbuf[1024];

  if (nwant < 1024)
    return(-1);

  ndone = 0;

  while (ndone < nwant - 1024) {		/* bugfix 6/88 - TK (added -1024) */

    if (0 >= (lim = netread(pnum,mungbuf,1024))) {
      if (ndone || !lim)			/* if this read is valid, but no data */
	return(ndone);
      else
	return(-1);				/* if connection is closed for good */
    }

    p = mungbuf;
    q = buf + ndone;

    /*		printf("\012 lim=%d done=%d want=%d",lim,ndone,nwant);
		n_row();
    */
    for (i=0; i < lim; i++) {

      if (crfound) {
	if (*p == 10)
	  *q++ = EOLCHAR;
	else if (*p == 0)
	  *q++ = 13;			/* CR-NUL means CR */
	else {
	  *q++ = 13;
	  *q++ = *p;
	}
	crfound = 0;
      }
      else if (*p == 13)
	crfound = 1;
      else 
	*q++ = *p;				/* copy the char */

      p++;
    }

    ndone = q-buf;					/* count chars ready */
  }

  return(ndone);
}

/***********************************************************************/
/* Sftpname and Sftpuser and Sftphost
 *  record the name of the file being transferred, to use in the status
 *  line updates
 */

Sftpname(s)
     char *s;
{
  strcpy(s,newfile);
}

Sftpuser(user)
     char *user;
{
  strcpy(user,myuser);			/* user name entered to log in */
}

Sftphost(host)
     char *host;
{
  movebytes(host,hisuser,4);		/* IP address of remote host */
}

Sftpstat(byt)
     long *byt;
{
  *byt = filelen;

}

/***********************************************************************/
/* ftpstart
 *  update status line with new file length remaining
 */
ftpstart(dir,buf)
     char dir,*buf;
{
  int r,c,cl,len;
  long int fpos;

  r = n_row();
  c = n_col();
  cl = n_color(current->colors[0]);

  if (dir)
    dir = '<';
  else
    dir = '>';

  Sftpname(&buf[100]);	/* get file name */
  if ((len = strlen(&buf[100])) > 28) {
    strcpy(&buf[100], &buf[100+len-28]);
  }
  Sftpstat(&fpos);		/* get position in file */

  n_cur(NUMLINES+1,36);
  sprintf(buf,"FTP %c %-28s %9lu",dir,&buf[100],fpos);

  if (scmode()) 
    n_cheat(buf,strlen(buf));
  else
    n_draw(buf,strlen(buf));

  n_color(cl);
  n_cur(r,c);
  return(0);
}

/* End of bkgr.c */
