/* $Id: PCTOOLS.C 1.4 1999/01/09 06:03:29 rwhitby Exp $ */
/* $Source: A:/SRC/TCP/NCSATCP/SRC/RCS/PCTOOLS.C $ */

/*
 * Portions developed by the Educational Resources Center, Clarkson University.
 * Portions developed by the National Center for Supercomputing Applications,
 * University of Illinois at Urbana-Champaign.
 */

#include <alloc.h>
#include <stdio.h>
#include <string.h>

#include "config.h"
#include "protocol.h"
#include "data.h"
#include "mem.h"
#include "windat.h"
#include "newwin.h"

/* #define XDEBUG  1 */

/*
 *   defined in assembly language file for interrupt driven Ether buffering
 *
*/

extern unsigned char stat;                    /* status from last read */
extern int bufbig,buflim;
extern  int     slip_mode;              /* set in packet.c if slip driver */
unsigned int	rawbuff_size={RAWBUFF_LEN};

int	slip_mode;
/*
*  Declare each and every Ethernet driver.
*  To add a driver, pick a unique 2 char prefix and declare your own
*  routines.  I want to keep the same parameters for EVERY driver.
*  If your driver needs additional parameters, then see netconfig() below 
*  for an indication of where to put custom board code.
*/

extern char far *bufpt;
extern char far *bufend;
extern char far *bufread;
extern char far *buforg;

extern int pketopen(),pkgetaddr(),pkrecv(),pkxmit(),pketupdate(),pketclose();

int	no_arpme;		/* set if we are not to arp ourselves */

/**********************************************************************/
/*  statcheck
 *   look at the connection status of the memory buffers to see if the
 *   allocation schemes are working.  Only used as a debug tool.
*/
statcheck(struct twin *t)
{
  int i;
  static char *states[]={"",
			 "CLOSED  ",
			 "LISTEN  ",
			 "TWAIT   ",
			 "SYNR    ",
			 "SYNS    ",
			 "EST     ",
			 "CWAIT	 ",
			 "FW1     ",
			 "FW2     ",
			 "CLOSING ",
			 "LAST	 "
  };
#define	WR(t,s)	VSwrite((t)->vs,(s),strlen((s)))

  char	buffer[120];
  register struct port *p;

  sprintf(buffer,"Port  State     Lport   Rport                   InQBytes  OutQBytes Rto Lasttime\r\n");
  if(!t)
    nprintf(CONSOLE,"%s",buffer);
  else
    WR(t,buffer);

  for (i=0; i< NPORTS; i++) {
    p = portlist[i];
    if (p != NULL) {
      long now;

      now = n_clicks(NULL);
      if(!p->nextstate)
	sprintf(buffer,"% 2d    %s % 6d  % 3d.%03d.%03d.%03d:%-6d     % 5d    % 5d   % 3d % 7ld\r\n",

		i,p->flags & PORT_FLAGS_LOOPBACK ?
		"LOOPBACK" : states[p->state],intswap(p->tcpout.t.source),
		p->tcpout.i.ipdest[0],
		p->tcpout.i.ipdest[1],
		p->tcpout.i.ipdest[2],
		p->tcpout.i.ipdest[3],
		intswap(p->tcpout.t.dest), p->in.contain,
		p->out.contain,p->rto, now - p->out.lasttime);
      else
	sprintf(buffer,"\033[1m% 2d    %s % 6d  % 3d.%03d.%03d.%03d:%-6d     % 5d    % 5d * %3d %s\033[m\r\n",

		i,p->flags & PORT_FLAGS_LOOPBACK ?
		"LOOPBACK" : states[p->state],intswap(p->tcpout.t.source),
		p->tcpout.i.ipdest[0],
		p->tcpout.i.ipdest[1],
		p->tcpout.i.ipdest[2],
		p->tcpout.i.ipdest[3],
		intswap(p->tcpout.t.dest), p->in.contain, p->out.contain,
		(int) (p->alarm - time(NULL)), states[p->nextstate]);

      if(!t)
	nprintf(CONSOLE,"%s",buffer);
      else
	WR(t,buffer);
    }

  }
}

/**********************************************************************/
/*  netarpme
 *   send an arp to my address.  arpinterpret will notice any response.
 *   Checks for adapters which receive their own broadcast packets.
 */
netarpme(s)
     char *s;
{
  if(slip_mode || no_arpme)
    return(0);
  reqarp(s);		/* send it */

  return(0);
}


/**********************************************************************/

initbuffer()
{

  char *raw;

  raw = mem_malloc(rawbuff_size+1520);
  if(!raw) {
    fprintf(stderr,"Error. Can't allocate Rawbuffer, not enough memory\n");
    exit(1);
  }
  bufpt = bufread = buforg = raw;	/*  start at the beginning */

  bufend = raw + rawbuff_size;    /* leave 512bytes breathing room, required */
  buflim = rawbuff_size;                      /* 1K breathing room */
  pkgetaddr(nnmyaddr,0,0);
  return(0);
}

/**********************************************************************/
/*   demux
 *      find the packets in the buffer, determine their lowest level
 *  packet type and call the correct interpretation routines
 *
 *  the 'all' parameter tells demux whether it should attempt to empty
 *  the input packet buffer or return after the first packet is dealt with.
*
*  returns the number of packets demuxed
*/
demux(all)
     int all;
{
  uint16 getcode;
  int nmuxed;
  DLAYER *firstlook;

  nmuxed = 0;

  do {						/* while all flag is on */

    pkrecv();					/* NULL operation for 3COM */

    if (bufbig > 0) {

      nmuxed++;
      firstlook = (DLAYER *)(bufread+2); 	/* where packet is */
      getcode = firstlook->type;		/* where does it belong? */

#ifdef  XDEBUG
      printf("Pkt Demux type %04x",getcode);
#endif
      switch (getcode) {			/* what to do with it? */
      case EARP:
      case ERARP:
	arpinterpret(firstlook);	/* handle ARP packet */
	break;
      case EIP:
	ipinterpret(firstlook);
	break;
      default:
	break;
      }

      pketupdate();   	/* update read pointers in buffer, free packet */

    }
    else 
      all = 0;


  } while (all);	/* should we look for more to deal with? */


  return(nmuxed);          /* no packets anymore */

}

/************************************************************************/
/*  dlayersend
 *
 *  usage:   err = dlayersend(ptr,size)
 *      err = 0 for successful, non-zero error code otherwise
 *      ptr is to a dlayer packet header
 *      size is the number of bytes total
 *
 *  This particular dlayer routine is for Ethernet.  It will have to be
 *  replaced for any other dlayer.
*
*  Ethernet addresses are resolved at higher levels because they will only
*  need to be resolved once per logical connection, instead of once per
*  packet.  Not too layer-like, but hopefully modular.
*
*/

dlayersend(ptr,size)
     DLAYER *ptr;
     unsigned size;
{
  int ret;

#ifdef  XDEBUG
  { char xx[80]; 
  nprintf(CONSOLE,"dlayer send %d bytes\n",size);
  }
#endif
  ret = pkxmit(ptr,size);	/* send it out, pass back return code */
  /* xmit checks for size < 60 */

  /*
   *   automatic, immediate retry once
   */
  if (ret) {
    if (ret == pkxmit(ptr,size))
      nnerror(100);		/* post user error message */
  }

  return(ret);
}

/***************************************************************************/
/* dlayerinit
 *  Do machine dependent initializations of whatever hardware we have
 *  (happens to be ethernet board here ) 
 */
dlayerinit()
{
  if (initbuffer()){
    return(-1);
  }
  
  return(pketopen(nnmyaddr,0,0,0));
}

dlayershut()
{
  pketclose();
}

/***************************************************************************/
/*  pcgetaddr
 *   return results from indirect pkgetaddr call.
 *   This is a pc-specific request for the 48-bit address which was added
 *   so that the user program could print the value.
*/
pcgetaddr(s,x,y)
     char *s;
     int x,y;
{
  pkgetaddr(s, x , y);
}

/* End of pctools.c */
