/* $Id: VSEM.C 1.4 1999/03/03 12:33:56 rwhitby Exp $ */
/* $Source: A:/SRC/TCP/NCSATCP/SRC/RCS/VSEM.C $ */

/*
 * Portions developed by the Educational Resources Center, Clarkson University.
 * Portions developed by the National Center for Supercomputing Applications,
 * University of Illinois at Urbana-Champaign.
 */

/*
 *
 *      Virtual Screen Kernel Emulation Routines
 *                      (vsem.c)
 *  
 *   National Center for Supercomputing Applications
 *      by Gaige B. Paulsen
 *
 *    This file contains the private emulation calls for the NCSA
 *  Virtual Screen Kernel.
 *
 *      Version Date    Notes
 *      ------- ------  ---------------------------------------------------
 *      0.01    861102  Initial coding -GBP
 *      0.10    861111  Added/Modified VT emulator -GBP
 *      0.50    861113  First compiled edition -GBP
 *		2.1		871130	NCSA Telnet 2.1 -GBP
 *		2.2 	880715	NCSA Telnet 2.2 -GBP
 */

#include <stdio.h>

#include "config.h"
#include "newwin.h"
#include "windat.h"
#include "vsdata.h"
#include "vskeys.h"

#if	COMIO
extern struct twin *com_tw;
extern int	com_port;
#endif

VSem(c,ctr)
     register int ctr;
     register unsigned char *c;
{
  register int i,sx;
  register int escflg;
  int insert,ocount,attrib,wrapit,extra,offend;
  char *acurrent,*current,*start;
  struct twin *tptr;

  escflg= VSIw->escflg;

  if(escflg == 128)	{		/* delayed turn on of capture file */
    extern int capon;
    struct twin *tptr;
    extern FILE *Sopencap();

    tptr = screens[VSIwn];

    if (NULL == (tptr->capfp = Sopencap())) {
      vprint(console->vs,"\r\nCannot open capture file for for printthrough");
      wrest(console);
    }
    else {
      capon = tptr->capon = 1;
      capstat("Capture On ");
#if	COMIO
      if(com_port)
	com_tw = tptr;
#endif
    }
    VSIw->escflg = escflg = 0;
  }
  else
    if(escflg == 129) {		/* fudge turn off */
      ctr -= 4;
      c += 4;
      VSIw->escflg = escflg = 0;
    }

  while (ctr>0) {
    while ( (escflg==0) && (ctr>0) && (*c<32) ) {
      switch(*c) {
      case 0x1b:
	escflg++;
	break;
      case 0x0e:
	if (VSIw->G1)
	  VSIw->attrib=VSgraph(VSIw->attrib);
	else
	  VSIw->attrib=VSnotgraph(VSIw->attrib);
	VSIw->charset=1;
	break;
      case 0x0f:
	if (VSIw->G0)
	  VSIw->attrib=VSgraph(VSIw->attrib);
	else
	  VSIw->attrib=VSnotgraph(VSIw->attrib);
	VSIw->charset=0;
	break;
      case 0x07:
	RSbell(VSIwn);
	break;
      case 0x08:
	VSIw->x--;
	if (VSIw->x<0) VSIw->x=0;
	break;
      case 0x0c:
	VSIindex();
	break;
      case 0x09:              /* Later change for versatile tabbing */
	VSItab();
	break;
      case 0x0a:
	VSIindex();
	if(!VSIw->LNM)
	  break;	/* else fall through and do line wrap */
      case 0x0d:
	VSIw->x=0;
	break;
      case 0x0b:
	VSIindex();
	break;
#ifdef CISB
      case 0x10:
	bp_DLE( c, ctr);
	ctr = 0;
	break;
      case 0x05:
	bp_ENQ();
	break;
#endif CISB
      }
      c++;ctr--;
    }
    while( (ctr>0) && (escflg==0) && (*c>=32) ) {
      /* the following line is important, both are * chars */
      current = start = &VSIw->linest[VSIw->y]->text[VSIw->x];
      acurrent = &VSIw->attrst[VSIw->y]->text[VSIw->x];
      attrib = VSIw->attrib;
      insert = VSIw->IRM;           /* boolean */
      ocount = VSIw->x;
      wrapit=0;offend=0;extra=0;
      sx=VSIw->x;
      if ( VSIw->x > VSIw->maxwidth ) {
	if ( VSIw->DECAWM ) {
	  VSIw->x=0;
	  VSIindex();
	}
	else
	  VSIw->x=VSIw->maxwidth;
	current = start = &VSIw->linest[VSIw->y]->text[VSIw->x];
	acurrent = &VSIw->attrst[VSIw->y]->text[VSIw->x];
	ocount = VSIw->x;
	sx=VSIw->x;
      }
      while( (ctr>0) && (*c>=32) && (offend==0)) {
	if (insert) VSIinschar(1);
	*current = VSisgrph(attrib) ? translate(*c) : *c; /* ### bkc 2/13/90 */
	*acurrent=attrib & 0xff;
	c++;
	ctr--;
	if (VSIw->x < VSIw->maxwidth)
	  {acurrent++; current++; VSIw->x++; }
	else {
	  if (VSIw->DECAWM) {
	    VSIw->x++;
	    offend=1;
	  }
	  else {
	    VSIw->x=VSIw->maxwidth;
	    extra=1;
	  }
	}
      }
      if (insert) {
	VSIinsstring(VSIw->x-ocount+offend+extra,start);
                                /* actually just decides which RS to use */
      }
      else VSIdraw(VSIwn,sx,VSIw->y,VSIw->attrib & 0xff,VSIw->x-ocount+offend+extra,start);
    }

    while( (ctr>0) && (escflg==1) ) {
      switch(*c) {
      case 0x08:
	VSIw->x--;
	if (VSIw->x<0) VSIw->x=0;
	break;
      case 12 :		/* auto switch to tek mode */
	/* TEK removed. */
	break;
      case '[': 
	VSIapclear();
	escflg++;
	break;
      case '7':
	VSIsave();
	escflg = 0;
	break;
      case '8':
	VSIrestore();
	escflg = 0;
	break;
      case 'c':
	VSIreset();
	break;
      case 'D':
	VSIindex();
	escflg = 0;
	break;
      case 'E':
	VSIw->x=0;
	VSIindex();
	escflg = 0;
	break;
      case 'M':
	VSIrindex();
	escflg = 0;
	break;
      case '>':
	VSIw->DECPAM=0;
	escflg = 0;
	break;
      case '=':
	VSIw->DECPAM=1;
	escflg = 0;
	break;
      case 'Z':
	VTsendident();
	escflg = 0;
	break;
      case '#':
	escflg=3;
	break;
      case '(':
	escflg=4;
	break;
      case ')':
	escflg=5;
	break;
      case 'H':
	VSIw->tabs[VSIw->x]='x';
	escflg=0;
	break;
#ifdef CISB
      case 'I':
	bp_ESC_I();
	break;
#endif CISB
      default:
	escflg = 0;
	break;
      }
      c++;ctr--;
    }
    while ( (escflg==2) && (ctr>0) ) {
      switch(*c) {
      case 0x08:
	VSIw->x--;
	if (VSIw->x<0) VSIw->x=0;
	break;
      case '0':
      case '1':
      case '2':
      case '3':
      case '4':
      case '5':
      case '6':
      case '7':
      case '8':
      case '9':
	if (VSIw->parms[VSIw->parmptr]<0) VSIw->parms[VSIw->parmptr]=0;
	VSIw->parms[VSIw->parmptr] *= 10;
	VSIw->parms[VSIw->parmptr] += *c-'0';
	break;
      case '?':
	VSIw->parms[VSIw->parmptr++] = -2;
	break;
      case ';':
	VSIw->parmptr++;
	break;
      case 'A':
	if (VSIw->parms[0]<1) VSIw->y--;
	else VSIw->y-=VSIw->parms[0];
#ifdef	NO_DECOM
	if ( VSIw->y < VSIw->top ) VSIw->y=VSIw->top;
#endif
	VSIrange();
	escflg = 0;
	break;
      case 'B':
	if (VSIw->parms[0]<1) VSIw->y++;
	else VSIw->y+=VSIw->parms[0];
#ifdef	NO_DECOM
	if ( VSIw->y > VSIw->bottom ) VSIw->y=VSIw->bottom;
#endif
	VSIrange();
	escflg = 0;
	break;
      case 'C':
	if (VSIw->parms[0]<1) VSIw->x++;
	else VSIw->x+=VSIw->parms[0];
	VSIrange();
	if (VSIw->x > VSIw->maxwidth)
	  VSIw->x = VSIw->maxwidth;
	escflg = 0;
	break;
      case 'D':
	if (VSIw->parms[0]<1) VSIw->x--;
	else VSIw->x-=VSIw->parms[0];
	VSIrange();
	escflg = 0;
	break;
      case 'f':
      case 'H':
	VSIw->x=VSIw->parms[1]-1;
	VSIw->y=VSIw->parms[0]-1;
	VSIrange();
	escflg = 0;
	break;
      case 'K':
	switch(VSIw->parms[0]) {
	case -1:
	case  0:
	  VSIeeol();
	  break;
	case  1:
	  VSIebol();
	  break;
	case  2:
	  VSIel(-1);        
	  break;
	default:
	  escflg=0;
	  break;
	}
	escflg = 0;
	break;
      case 'J':
	switch(VSIw->parms[0]) {
	case -1:
	case  0:
	  VSIeeos();
	  break;
	case  1:
	  VSIebos();
	  break;
	case  2:
	  VSIes();
	  break;
	default:
	  escflg=0;
	  break;
	}
	escflg = 0;
	break;
      case 'm':
	{
	  int temp=0;
	  int attrib;
	  tptr = screens[VSIwn];
	  if(VSIw->parms[0] < 1)
	    VSIw->attrib = tptr->colors[0] | VSisgrph(VSIw->attrib); /* reset colors */
	  attrib = VSIw->attrib;
	  while(temp <= VSIw->parmptr) {
	    switch (VSIw->parms[temp]) {
	    case 0:              /* normal */
	      attrib = tptr->colors[0];
	      break;
	    case 1:              /* bold */
	      attrib |= 8;
	      break;
	    case 4:              /* underline */
	      attrib = tptr->colors[1];
	      break;
	    case 5:              /* blink */
	      attrib |= 128;
	      break;
	    case 7:              /* reverse */
	      attrib = tptr->colors[2];
	      break;
	    default:
	      break;
	    } /* end switch */
	    temp++;
	  }  /* end while */
	  VSIw->attrib = attrib | VSisgrph(VSIw->attrib);
	}
	escflg = 0;
	break;
      case 'q':
	escflg = 0;
	break;
      case 'c':
	VTsendident();
	escflg = 0;
	break;
      case 'n':
	switch(VSIw->parms[0]) {
	case 5:
	  VTsendstat();
	  break;
	case 6:
	  VTsendpos();
	  break;
	}
	escflg = 0;
	break;
      case 'L':
	if(VSIw->parms[0]<1) VSIw->parms[0]=1;
	VSIinslines(VSIw->parms[0],-1);
	escflg = 0;
	break;
      case 'M':
	if(VSIw->parms[0]<1) VSIw->parms[0]=1;
	VSIdellines(VSIw->parms[0],-1);
	escflg = 0;
	break;
      case 'P':
	if(VSIw->parms[0]<1) VSIw->parms[0]=1;
	VSIdelchars(VSIw->parms[0]);
	escflg = 0;
	break;
      case 'r':
	if (VSIw->parms[0]<0) VSIw->top=0;
	else VSIw->top=VSIw->parms[0]-1;
	if (VSIw->parms[1]<0) VSIw->bottom=NUMLINES;
	else VSIw->bottom=VSIw->parms[1]-1;
	if (VSIw->top<0) VSIw->top=0;
	if (VSIw->top> (NUMLINES-2)) VSIw->top=NUMLINES-2;
	if (VSIw->bottom<1) VSIw->bottom=NUMLINES;
	if (VSIw->bottom>NUMLINES) VSIw->bottom=NUMLINES;
	VSIw->x=0; VSIw->y=0;
	escflg = 0;
	break;
      case 'h':
	VSIsetoption(1);
	escflg = 0;
	break;
      case 'i' :              /* new print through mode */
	{
	  extern int capon;
	  struct twin *tptr;
	  int mode;                    /* esc [ P i
					  P = 0   screen dump to capture file
					  P = 4, 6  turn off capture file
					  P = 5, 7  turn on capture file
					  if no P, use mode 0 screen dump
				       */
	  if(VSIw->parms[0] < 0)
	    mode = 0;
	  else
	    mode = VSIw->parms[0];
	  tptr = screens[VSIwn];
	  switch (mode )  {

	  case 0 :               /* screen dump */
	    if(!capon) {
	      extern FILE *Sopencap();
	      if (NULL == (tptr->capfp = Sopencap())) {
		vprint(console->vs,"\r\nCannot open capture file for screendump ");
		wrest(console);
		break;
	      }
	      screendump(tptr);
	      fclose(tptr->capfp);
	      tptr->capfp = NULL;
	      break;
	    }
	    if(tptr->capon && tptr->capfp)
	      screendump(tptr);

	    break;
	  case 4:
	  case 6:                 /* turn off capture file */
	    if(capon && tptr->capon && tptr->capfp) {
#ifdef OLDCAP
	      fclose(tptr->capfp);
	      capon = tptr->capon = 0;
	      tptr->capfp = NULL;
	      capstat("Capture Off");
#else
	      tptr->capon = -1;
	      capstat("Capture Closing");
	      VSIw->escflg=129;
	      return(ctr+3);
#endif
	    }
	    break;

	  case 5:
	  case 7:                 /* turn on capture file */
	    if(!capon) {
	      VSIw->escflg=128;
	      return(--ctr);	
	    }
	    break;
	  default:;
	  } /* end switch */
	}
	escflg = 0;
	break;

      case 'l':
	VSIsetoption(0);
	escflg = 0;
	break;
      case 'g':
	if (VSIw->parms[0]==3) VSItabclear();
	else if (VSIw->parms[0]==0 || VSIw->parms[0]<0)
	  VSIw->tabs[VSIw->x]=' ';
	escflg =0;
	break;
      default:			/* Dag blasted strays... */
	escflg=0;
	break;
      }
      c++; ctr--;
    }

    while ( (escflg==3) && (ctr>0) ) {	/* #  Handling */
      switch(*c) {
      case 0x08:
	VSIw->x--;
	if (VSIw->x<0) VSIw->x=0;
	break;
      case '8':
	VTalign();
	escflg=0;
	break;
      default:
	escflg=0;
	break;
      }
      c++; ctr--;
    }

    while ( (escflg==4) && (ctr>0) ) {	/* (  Handling */
      switch(*c) {
      case 0x08:
	VSIw->x--;
	if (VSIw->x<0) VSIw->x=0;
	break;
      case 'A':
      case 'B':
      case '1':
	VSIw->G0=0;
	if ( !VSIw->charset )
	  VSIw->attrib=VSnotgraph(VSIw->attrib);
	escflg=0;
	break;
      case '0':
      case '2':
	VSIw->G0=1;
	if ( !VSIw->charset )
	  VSIw->attrib=VSgraph(VSIw->attrib);
	escflg=0;
	break;
      default:
	escflg=0;
	break;
      }
      c++; ctr--;
    }

    while ( (escflg==5) && (ctr>0) ) {	/* )  Handling */
      switch(*c) {
      case 0x08:
	VSIw->x--;
	if (VSIw->x<0) VSIw->x=0;
	break;
      case 'A':
      case 'B':
      case '1':
	VSIw->G1=0;
	if ( VSIw->charset )
	  VSIw->attrib=VSnotgraph(VSIw->attrib);
	escflg=0;
	break;
      case '0':
      case '2':
	VSIw->G1=1;
	if ( VSIw->charset )
	  VSIw->attrib=VSgraph(VSIw->attrib);
	escflg=0;
	break;
      default:
	escflg=0;
	break;
      }
      c++; ctr--;
    }

    if ((escflg>2) && (ctr>0)) {escflg=0; c++; ctr--;}
  }
  VSIw->escflg=escflg;
  return(0);
}

/* End of vsem.c */
