Below are the steps required to flash a NextThingCo CHIP or PocketCHIP from the command line, as of November 2018. The web flasher no longer works, and there are numerous errors when flashing from the command line, mostly due to broken dependencies. The following method works for flashing a CHIP as of November 2018:

Note: Flashing must be done on Linux. Tested on Ubuntu and Rasparian. Mac OS seems to not work. 

1. Download and unpack the CHIP-SDK.zip from one of the following:
* https://archive.org/details/C.h.i.p.FlashCollection
* https://github.com/NextThingCo/CHIP-SDK
* https://github.com/Project-chip-crumbs/CHIP-SDK

2. Download and unpack CHIP-tools.zip from one of the following:
* https://archive.org/details/C.h.i.p.FlashCollection
* https://github.com/NextThingCo/CHIP-tools-backup
* https://github.com/Project-chip-crumbs/CHIP-tools

3. Move the CHIP-tools directory inside CHIP-SDK directory (CHIP-SDK/CHIP-tools). 

4. Download flash-collection.zip from https://archive.org/details/C.h.i.p.FlashCollection. Unpack it and move it into the CHIP-SDK directory (CHIP-SDK/flash-collection)

5. Navigate to the CHIP-SDK directory in terminal and run the build script: `./setup_ubuntu1404.sh` The build script should run. Multiple errors will be shown, including a fatal error when the script tries to get the CHIP-tools from a non-existant repo. This can be ignored since we already downloaded the CHIP-tools directory in step 2.

6. Put your chip in FEL mode and connect by USB. 

7. Navigate to the CHIP-tools directory at CHIP-SDK/CHIP-tools and run the update firmware script. Use the -L option to explicitly specify of of the firmware versions from the flash-collection directory: `./chip-update-firmware.sh -L ../stable-pocketchip-b128`
