REM Program: Hex Editor v5.6a, Module 3 of 5, PD 2004.
REM Author: Erik Jon Oredson AS. Csci
REM Release: 02/01/2004.
REM Status: Public Domain.
REM Email: eoredson@yahoo.com
REM Urls: www.simtel.net www.filegate.net
REM  www.winsite.com

REM Help/main screens for main menu and file menu.
REM Ansi/Hex Charts and Print subroutines.
REM Screen/File Dump and Print subroutines.
REM Clipboard and ViewFile subroutines.

' get include file.
REM $INCLUDE: 'hexedit.inc'

REM File box main menu.

SUB FileMainMenu
 CALL HMouse
 COLORf2 White, 1
 CLS
 LOCATEf Xcoor, Ycoor, 0
 COLORf2 White, 0
 COLORf Yellow
 PRINTf CHR$(ULcorner) + STRING$(39, Hline) + CHR$(URcorner)
 LOCATEf Xcoor + 1, Ycoor, 0
 PRINTf CHR$(Vline) + " "
 COLORf White
 PRINTf "Filename:"
 COLORf Yellow
 PRINTf SPACE$(29) + CHR$(Vline)
 LOCATEf Xcoor + 2, Ycoor, 0
 PRINTf CHR$(Vline) + SPACE$(39) + CHR$(Vline)
 LOCATEf Xcoor + 3, Ycoor, 0
 PRINTf CHR$(Vline) + " "
 COLORf White
 PRINTf "Files:          Dirs:          Drives:"
 COLORf Yellow
 PRINTf CHR$(Vline)
 LOCATEf Xcoor + 4, Ycoor, 0
 PRINTf CHR$(Vline)
 COLORf Magenta
 PRINTf " " + CHR$(ULcorner) + STRING$(12, Hline) + CHR$(URcorner) + "  "
 PRINTf CHR$(ULcorner) + STRING$(12, Hline) + CHR$(URcorner) + "  "
 PRINTf CHR$(ULcorner) + STRING$(3, Hline) + CHR$(URcorner) + " "
 COLORf Yellow
 PRINTf CHR$(Vline)
 COLORf Yellow
 LOCATEf Xcoor + 5, Ycoor, 0
 PRINTf CHR$(Vline)
 COLORf Magenta
 PRINTf " " + CHR$(Vline) + SPACE$(12) + CHR$(Vline) + "  "
 PRINTf CHR$(Vline) + SPACE$(12) + CHR$(Vline) + "  "
 PRINTf CHR$(Vline) + SPACE$(3) + CHR$(Vline) + " "
 COLORf Yellow
 PRINTf CHR$(Vline)
 COLORf Yellow
 LOCATEf Xcoor + 6, Ycoor, 0
 PRINTf CHR$(Vline)
 COLORf Magenta
 PRINTf " " + CHR$(Vline) + SPACE$(12) + CHR$(Vline) + "  "
 PRINTf CHR$(Vline) + SPACE$(12) + CHR$(Vline) + "  "
 PRINTf CHR$(Vline) + SPACE$(3) + CHR$(Vline) + " "
 COLORf Yellow
 PRINTf CHR$(Vline)
 COLORf Yellow
 LOCATEf Xcoor + 7, Ycoor, 0
 PRINTf CHR$(Vline)
 COLORf Magenta
 PRINTf " " + CHR$(Vline) + SPACE$(12) + CHR$(Vline) + "  "
 PRINTf CHR$(Vline) + SPACE$(12) + CHR$(Vline) + "  "
 PRINTf CHR$(Vline) + SPACE$(3) + CHR$(Vline) + " "
 COLORf Yellow
 PRINTf CHR$(Vline)
 COLORf Yellow
 LOCATEf Xcoor + 8, Ycoor, 0
 PRINTf CHR$(Vline)
 COLORf Magenta
 PRINTf " " + CHR$(Vline) + SPACE$(12) + CHR$(Vline) + "  "
 PRINTf CHR$(Vline) + SPACE$(12) + CHR$(Vline) + "  "
 PRINTf CHR$(Vline) + SPACE$(3) + CHR$(Vline) + " "
 COLORf Yellow
 PRINTf CHR$(Vline)
 COLORf Yellow
 LOCATEf Xcoor + 9, Ycoor, 0
 PRINTf CHR$(Vline)
 COLORf Magenta
 PRINTf " " + CHR$(Vline) + SPACE$(12) + CHR$(Vline) + "  "
 PRINTf CHR$(Vline) + SPACE$(12) + CHR$(Vline) + "  "
 PRINTf CHR$(Vline) + SPACE$(3) + CHR$(Vline) + " "
 COLORf Yellow
 PRINTf CHR$(Vline)
 COLORf Yellow
 LOCATEf Xcoor + 10, Ycoor, 0
 PRINTf CHR$(Vline)
 COLORf Magenta
 PRINTf " " + CHR$(Vline) + SPACE$(12) + CHR$(Vline) + "  "
 PRINTf CHR$(Vline) + SPACE$(12) + CHR$(Vline) + "  "
 PRINTf CHR$(Vline) + SPACE$(3) + CHR$(Vline) + " "
 COLORf Yellow
 PRINTf CHR$(Vline)
 COLORf Yellow
 LOCATEf Xcoor + 11, Ycoor, 0
 PRINTf CHR$(Vline)
 COLORf Magenta
 PRINTf " " + CHR$(Vline) + SPACE$(12) + CHR$(Vline) + "  "
 PRINTf CHR$(Vline) + SPACE$(12) + CHR$(Vline) + "  "
 PRINTf CHR$(Vline) + SPACE$(3) + CHR$(Vline) + " "
 COLORf Yellow
 PRINTf CHR$(Vline)
 COLORf Yellow
 LOCATEf Xcoor + 12, Ycoor, 0
 PRINTf CHR$(Vline)
 COLORf Magenta
 PRINTf " " + CHR$(Vline) + SPACE$(12) + CHR$(Vline) + "  "
 PRINTf CHR$(Vline) + SPACE$(12) + CHR$(Vline) + "  "
 PRINTf CHR$(Vline) + SPACE$(3) + CHR$(Vline) + " "
 COLORf Yellow
 PRINTf CHR$(Vline)
 COLORf Yellow
 LOCATEf Xcoor + 13, Ycoor, 0
 PRINTf CHR$(Vline)
 COLORf Magenta
 PRINTf " " + CHR$(Vline) + SPACE$(12) + CHR$(Vline) + "  "
 PRINTf CHR$(Vline) + SPACE$(12) + CHR$(Vline) + "  "
 PRINTf CHR$(Vline) + SPACE$(3) + CHR$(Vline) + " "
 COLORf Yellow
 PRINTf CHR$(Vline)
 COLORf Yellow
 LOCATEf Xcoor + 14, Ycoor, 0
 PRINTf CHR$(Vline)
 COLORf Magenta
 PRINTf " " + CHR$(Vline) + SPACE$(12) + CHR$(Vline) + "  "
 PRINTf CHR$(Vline) + SPACE$(12) + CHR$(Vline) + "  "
 PRINTf CHR$(Vline) + SPACE$(3) + CHR$(Vline) + " "
 COLORf Yellow
 PRINTf CHR$(Vline)
 COLORf Yellow
 LOCATEf Xcoor + 15, Ycoor, 0
 PRINTf CHR$(Vline)
 COLORf Magenta
 PRINTf " " + CHR$(LLcorner) + STRING$(12, Hline) + CHR$(LRcorner) + "  "
 PRINTf CHR$(LLcorner) + STRING$(12, Hline) + CHR$(LRcorner) + "  "
 PRINTf CHR$(LLcorner) + STRING$(3, Hline) + CHR$(LRcorner) + " "
 COLORf Yellow
 PRINTf CHR$(Vline)
 LOCATEf Xcoor + 16, Ycoor, 0
 PRINTf CHR$(LLcorner) + STRING$(39, Hline) + CHR$(LRcorner)
 COLORf White
 ' make file input box mouse symbols.
 LOCATEf Xcoor + 4, Ycoor + 16, 0
 PRINTf "<"
 LOCATEf Xcoor + 5, Ycoor + 16, 0
 PRINTf "|"
 LOCATEf Xcoor + 14, Ycoor + 16, 0
 PRINTf "|"
 LOCATEf Xcoor + 15, Ycoor + 16, 0
 PRINTf ">"
 ' make directory input box mouse symbols.
 LOCATEf Xcoor + 4, Ycoor + 32, 0
 PRINTf "<"
 LOCATEf Xcoor + 5, Ycoor + 32, 0
 PRINTf "|"
 LOCATEf Xcoor + 14, Ycoor + 32, 0
 PRINTf "|"
 LOCATEf Xcoor + 15, Ycoor + 32, 0
 PRINTf ">"
 ' make drive input box mouse symbols.
 LOCATEf Xcoor + 5, Ycoor + 39, 0
 PRINTf "|"
 LOCATEf Xcoor + 14, Ycoor + 39, 0
 PRINTf "|"
 ' make file menu box question symbol.
 LOCATEf Xcoor, Ycoor + 39, 0
 PRINTf "?"
 ' make file menu box exit symbol.
 LOCATEf Xcoor, Ycoor + 40, 0
 PRINTf "x"
 ' make remaining menu box areas.
 IF Xcoor - 1 > 0 THEN
    COLORf2 Green, 1
    LOCATEf Xcoor - 1, Ycoor, 0
    PRINTf "Hexedit " + Version + " For DOS & Windows PD 2004."
 END IF
 CALL BottomRow
 CALL SMouse
END SUB

REM File box bottom row menu.

SUB BottomRow
 CALL HMouse
 IF Xcoor + 17 <= 24 THEN
    COLORf2 Green, 1
    LOCATEf Xcoor + 17, Ycoor, 0
    PRINTf "Path:"
 END IF
 IF Xcoor + 18 <= 24 THEN
    COLORf2 Green, 1
    LOCATEf Xcoor + 18, Ycoor, 0
    PRINTf "File:"
 END IF
 IF Xcoor + 19 <= 24 THEN
    COLORf2 Green, 1
    LOCATEf Xcoor + 19, Ycoor, 0
    PRINTf "Size:"
 END IF
 COLORf2 Plain, 0
 CALL SMouse
END SUB

' display filename border area.
SUB DisplayScreen3X
 LOCATEf 3, 2, 0
 COLORf Magenta
 PRINTf CHR$(Vline) + " "
 COLORf Green
 PRINTf CHR$(ULcorner) + STRING$(46, Hline) + CHR$(URcorner) + " "
 PRINTf CHR$(ULcorner) + STRING$(22, Hline) + CHR$(URcorner)
 COLORf White
 PRINTf "x"
 COLORf Magenta
 PRINTf CHR$(Vline)
END SUB

' draws window 2.
SUB Window2DrawSub
 Row = False
 FOR NextLine = (FilePage - 1) * 320 + 1 TO (FilePage - 1) * 320 + 320 STEP 20
    LOCATEf Row + 4, 54, 0
    Row = Row + 1
    IF NextLine <= FileLength THEN
       IF NextLine + 19 <= FileLength THEN
          COLORf White
          PRINTf "x" + RIGHT$("00000000" + HEX$(NextLine - 1), 8)
          COLORf Yellow
          PRINTf " - "
          COLORf White
          PRINTf "x" + RIGHT$("00000000" + HEX$(NextLine + 19 - 1), 8)
       ELSE
          COLORf White
          PRINTf "x" + RIGHT$("00000000" + HEX$(NextLine - 1), 8)
          COLORf Yellow
          PRINTf " - "
          COLORf White
          PRINTf "x" + RIGHT$("00000000" + HEX$(FileLength - 1), 8)
       END IF
    ELSE
       PRINTf SPACE$(22)
    END IF
 NEXT
END SUB

REM Help screen subroutines:

' display help for menu input box.
SUB DisplayHelp
 COLORf2 White, 1
 CLS
 LOCATEf 8, 16, 0
 PRINTf "File Menu Box Function Keys Help Screen " + Version
 LOCATEf 9, 16, 0
 COLORf2 White, 0
 COLORf Yellow
 PRINTf CHR$(ULcorner) + STRING$(44, Hline) + CHR$(URcorner)
 LOCATEf 10, 16, 0
 PRINTf CHR$(Vline) + " "
 COLORf White
 PRINTf "Press <escape> To Return To Menu:          "
 COLORf Yellow
 PRINTf CHR$(Vline)
 LOCATEf 11, 16, 0
 PRINTf CHR$(Vline) + " "
 PRINTf "Function keys:                             "
 COLORf Yellow
 PRINTf CHR$(Vline)
 LOCATEf 12, 16, 0
 PRINTf CHR$(Vline) + " "
 COLORf White
 PRINTf "Alt-A to Alt-Z  Select Drive Letter        "
 COLORf Yellow
 PRINTf CHR$(Vline)
 LOCATEf 13, 16, 0
 PRINTf CHR$(Vline) + " "
 COLORf White
 PRINTf "F1 - Change Drive     F4 - Back Drive      "
 COLORf Yellow
 PRINTf CHR$(Vline)
 LOCATEf 14, 16, 0
 COLORf Yellow
 PRINTf CHR$(Vline) + " "
 COLORf White
 PRINTf "F2 - Toggle Sort      F5 - Forward Drive   "
 COLORf Yellow
 PRINTf CHR$(Vline)
 LOCATEf 15, 16, 0
 PRINTf CHR$(Vline) + " "
 COLORf White
 PRINTf "F3 - Move File Box    F6 - Toggle Ambiguate"
 COLORf Yellow
 PRINTf CHR$(Vline)
 LOCATEf 16, 16, 0
 PRINTf CHR$(Vline) + " "
 COLORf White
 PRINTf "F7 - Redraw File Menu Box                  "
 COLORf Yellow
 PRINTf CHR$(Vline)
 LOCATEf 17, 16, 0
 PRINTf CHR$(Vline) + " "
 COLORf White
 PRINTf "F8 - Specify Filename Attribute Override   "
 COLORf Yellow
 PRINTf CHR$(Vline)
 COLORf Yellow
 LOCATEf 18, 16, 0
 PRINTf CHR$(LLcorner) + STRING$(44, Hline) + CHR$(LRcorner)
 COLORf White
 WHILE INKEY$<>CHR$(27)
 WEND
END SUB

' display help screens.
SUB HelpScreen
 GOSUB DisplayHelpScreen1
 GOSUB DisplayHelpScreen2
 GOSUB DisplayHelpScreen3
 GOSUB DisplayHelpScreen4
 GOSUB DisplayHelpScreen5
 EXIT SUB

' help screen header.
HelpHeader:
 CALL DisplayScreen2
 LOCATEf 2, 2, 0
 COLORf White
 PRINTf "Help screen: Hex Editor " + Version + " " + Release + " functions:"
 RETURN

' help screen key prompt.
PressKey:
 COLORf White
 PRINTf "Press a key:"
 GOSUB PromptKeyX1
 RETURN

' prompts for a key or left mouse click.
PromptKeyX1:
 DO
    ' check escape key pressed.
    IF INKEY$ <> "" THEN
       EXIT DO
    END IF
    ' call mouse subroutine.
    CALL MouseDriver
    ' check left mouse button release.
    IF Mouse.ButtonX THEN
       EXIT DO
    END IF
    Var = ReleaseTime
 LOOP
 RETURN

' help screen 1.
DisplayHelpScreen1:
 GOSUB HelpHeader
 COLORf Red
 LOCATEf 3, 2, 0
 PRINTf "Function keys:"
 COLORf Yellow
 LOCATEf 4, 2, 0
 PRINTf "Alt-A  Append multiple bytes to file.   Alt-U  Undo last byte change."
 LOCATEf 5, 2, 0
 PRINTf "Alt-B  Append multiple null bytes.      Alt-V  View files."
 LOCATEf 6, 2, 0
 PRINTf "Alt-C  ANSI Chart.                      Alt-W  Close file."
 LOCATEf 7, 2, 0
 PRINTf "Alt-D  HEX Screen Dump.                 Alt-X  Exit program."
 LOCATEf 8, 2, 0
 PRINTf "Alt-E  HEX File Dump.                   Alt-Y  Toggle right window."
 LOCATEf 9, 2, 0
 PRINTf "Alt-F  Start input menu.                Alt-Z  Undo all bytes changes."
 LOCATEf 10, 2, 0
 PRINTf "Alt-G  Append multiple specified bytes. "
 COLORf Red
 PRINTf "Editing keys:"
 COLORf Yellow
 LOCATEf 11, 2, 0
 PRINTf "Alt-H  HEX Chart.                       Tab    -- Switch windows."
 LOCATEf 12, 2, 0
 PRINTf "Alt-J  Jump to byte position.           Enter  -- Change byte value."
 LOCATEf 13, 2, 0
 PRINTf "Alt-K  Search for ASCII string.         Insert -- Change string value."
 LOCATEf 14, 2, 0
 PRINTf "Alt-L  Jump to page position.           Delete -- Change hex string."
 LOCATEf 15, 2, 0
 PRINTf "Alt-M  Append ASCII string to file.     Escape -- Input Menu."
 LOCATEf 16, 2, 0
 PRINTf "Alt-N  Open new file.                   "
 COLORf Red
 PRINTf "Other keys:"
 COLORf Yellow
 LOCATEf 17, 2, 0
 PRINTf "Alt-O  Print help.                      (hex value numeral preceded)."
 LOCATEf 18, 2, 0
 PRINTf "Alt-P  HEX Screen Print.                (right window unprintable chars"
 LOCATEf 19, 2, 0
 PRINTf "Alt-Q  Help screen.                     are represented with a dot)."
 LOCATEf 20, 2, 0
 PRINTf "Alt-R  Redraw screen.                   (ascii values preceded with H"
 LOCATEf 21, 2, 0
 PRINTf "Alt-S  Search for multiple bytes.       are treated as hexidecimal).
 LOCATEf 22, 2, 0
 PRINTf "Alt-T  HEX File Print.                  (<escape> key exits search)."
 LOCATEf 23, 2, 0
 GOSUB PressKey
 RETURN

' help screen 2.
DisplayHelpScreen2:
 GOSUB HelpHeader
 COLORf Red
 LOCATEf 3, 2, 0
 PRINTf "Marker keys:"
 COLORf Yellow
 LOCATEf 4, 2, 0
 PRINTf "1   add marker"
 LOCATEf 5, 2, 0
 PRINTf "2   add specific marker value"
 LOCATEf 6, 2, 0
 PRINTf "3   delete marker"
 LOCATEf 7, 2, 0
 PRINTf "4   delete specific marker"
 LOCATEf 8, 2, 0
 PRINTf "5   jump previous marker"
 LOCATEf 9, 2, 0
 PRINTf "6   jump current marker"
 LOCATEf 10, 2, 0
 PRINTf "7   jump next marker"
 LOCATEf 11, 2, 0
 PRINTf "8   jump specific marker"
 LOCATEf 12, 2, 0
 PRINTf "9   list all markers"
 LOCATEf 13, 2, 0
 PRINTf "0   list specific marker"
 LOCATEf 14, 2, 0
 PRINTf "-   list markers of value"
 LOCATEf 15, 2, 0
 PRINTf "+   list range of markers"
 LOCATEf 16, 2, 0
 PRINTf "=   delete a range"
 LOCATEf 17, 2, 0
 PRINTf "[   delete all markers"
 LOCATEf 18, 2, 0
 PRINTf "]   delete markers of value"
 LOCATEf 19, 2, 0
 GOSUB PressKey
 RETURN

' help screen 3.
DisplayHelpScreen3:
 GOSUB HelpHeader
 COLORf Red
 LOCATEf 3, 2, 0
 PRINTf "Information keys:"
 COLORf Yellow
 LOCATEf 4, 2, 0
 PRINTf "? key displays file length, and undos remaining."
 LOCATEf 5, 2, 0
 PRINTf "! key displays current page, row, and column."
 LOCATEf 6, 2, 0
 PRINTf "~ key displays last page and markers used."
 LOCATEf 7, 2, 0
 PRINTf CHR$(34) + " key displays current path of file being edited."
 LOCATEf 8, 2, 0
 PRINTf "; key displays the range of the current hilighted area."
 LOCATEf 9, 2, 0
 PRINTf "{ key displays number of pasted entries stored in the undo file."
 COLORf Red
 LOCATEf 10, 2, 0
 PRINTf "Display keys:"
 COLORf Yellow
 LOCATEf 11, 2, 0
 PRINTf "F1 key toggles 64-byte filename display."
 LOCATEf 12, 2, 0
 PRINTf "F2 key toggles lower screen help key list."
 LOCATEf 13, 2, 0
 PRINTf "F11 key opens DOS shell in editor or file menu box."
 LOCATEf 14, 2, 0
 PRINTf "F12 key or Alt-I prompts for DOS command in editor."
 LOCATEf 15, 2, 0
 COLORf Red
 PRINTf "Hilight keys:"
 COLORf Yellow
 LOCATEf 16, 2, 0
 PRINTf "Shift-<key> hilights area, where <key> is:"
 LOCATEf 17, 2, 0
 PRINTf "<left>/<right>/<up>/<down>/<page up>/<page down>/<home>/<end>"
 LOCATEf 18, 2, 0
 COLORf Red
 PRINTf "Clipboard controls:"
 COLORf Yellow
 LOCATEf 19, 2, 0
 PRINTf "Control-C (copy)/Control-V (paste)"
 LOCATEf 20, 2, 0
 PRINTf "Control-X (undo previous paste)/Control-Z (undo all pastes)"
 LOCATEf 21, 2, 0
 GOSUB PressKey
 RETURN

' help screen 4.
DisplayHelpScreen4:
 GOSUB HelpHeader
 COLORf Red
 LOCATEf 3, 2, 0
 PRINTf "Multiple file keys:"
 COLORf Yellow
 LOCATEf 4, 2, 0
 PRINTf "F6     -  Next file."
 LOCATEf 5, 2, 0
 PRINTf "F7     -  Previous file."
 LOCATEf 6, 2, 0
 PRINTf "F8     -  Load new file."
 LOCATEf 7, 2, 0
 PRINTf "F9     -  Close file."
 LOCATEf 8, 2, 0
 PRINTf "F10    -  View files."
 LOCATEf 9, 2, 0
 PRINTf "Alt-1 to Alt-9  -  select specific file."
 COLORf Red
 LOCATEf 10, 2, 0
 PRINTf "File menu box keys:"
 COLORf Yellow
 LOCATEf 11, 2, 0
 PRINTf "F1  -  drive change.       F4  -  back 1 drive letter."
 LOCATEf 12, 2, 0
 PRINTf "F2  -  toggle file sort.   F5  -  forward 1 drive letter."
 LOCATEf 13, 2, 0
 PRINTf "F3  -  move file menu box. F6  -  toggle 8.3 ambiguation."
 LOCATEf 14, 2, 0
 PRINTf "F7  -  redraw file menu box. F8  -  specify filename attribute override."
 LOCATEf 15, 2, 0
 PRINTf "Alt-A to Alt-Z  selects drive letter."
 LOCATEf 16, 2, 0
 GOSUB PressKey
 RETURN

' help screen 5.
DisplayHelpScreen5:
 CALL DisplayScreen2
 COLORf White
 LOCATEf 2, 2, 0
 PRINTf "Hexedit information: "
 IF Windows.Detected THEN
    PRINTf "(Windows loaded) "
    PRINTf "[process #" + MID$(STR$(Process.Number + 1), 2) + "]"
 ELSE
    PRINTf "(DOS loaded)"
 END IF
 COLORf Yellow
 LOCATEf 3, 2, 0
 PRINTf "Program: " + Program + " " + Version + " " + Release + "."
 LOCATEf 4, 2, 0
 PRINTf "Author: " + Author
 LOCATEf 5, 2, 0
 PRINTf "Release: " + Publish
 LOCATEf 6, 2, 0
 PRINTf "Status: " + Status
 LOCATEf 7, 2, 0
 PRINTf "Email: " + Email
 LOCATEf 8, 2, 0
 PRINTf "Urls: " + Urls
 LOCATEf 9, 2, 0
 GOSUB PressKey
 RETURN
END SUB

' routine to print screen.
SUB PrintScreenSub
 ON LOCAL ERROR GOTO Error.Routinex1
 Column = False
 ColumnSpace = False
 HexLine$ = Nul
 HexLine2$ = Nul
 FirstByte = (FilePage - 1) * 320 + 1
 LastByte = (FilePage - 1) * 320 + 320
 DumpLine$ = DumpLineRange$
 PRINT #1, ""
 PRINT #1, DumpLine$
 Temp# = FirstByte
 FOR NextByte = FirstByte TO LastByte
    IF NextByte <= FileLength THEN
       SeekPosition = NextByte
       GOSUB LseekFilex1
       GOSUB ReadFilex1
       FileByte = Buffer
       ByteValue = ASC(FileByte)
       IF ByteValue < 32 THEN
          HexLine2$ = HexLine2$ + "."
       ELSE
          HexLine2$ = HexLine2$ + FileByte
       END IF
       HexLine$ = HexLine$ + RIGHT$("00" + HEX$(ASC(FileByte)), 2)
    ELSE
       HexLine$ = HexLine$ + "  "
       HexLine2$ = HexLine2$ + " "
    END IF
    ColumnSpace = ColumnSpace + 1
    IF ColumnSpace = 4 THEN
       HexLine$ = HexLine$ + " "
       Column = Column + 1
       ColumnSpace = False
    END IF
    Column = Column + 2
    IF Column > 44 THEN
       HexFile$ = HexLine$ + " " + HexLine2$
       HexFile$ = RTRIM$(HexFile$)
       IF LEN(HexFile$) THEN
          HexFile$ = HexFile$ + SPACE$(67 - LEN(HexFile$))
          HexFile$ = HexFile$ + "x" + RIGHT$("00000000" + HEX$(Temp# - 1#), 8)
          PRINT #1, HexFile$
       END IF
       HexLine$ = Nul
       HexLine2$ = Nul
       Temp# = NextByte + 1#
       Column = False
    END IF
 NEXT
 PRINT #1, CHR$(12);
Error.Exitx1:
 EXIT SUB
' position pointer in file.
LseekFilex1:
 ' calculate high/low seek position.
 SeekPosition2 = SeekPosition - 1 ' offset is from zero.
 ' seek values are signed bit sensitive.
 High = INT(SeekPosition2 / 65536)
 Low = SeekPosition2 AND 65535
 ' seek position in file.
 InregsX.AX = &H4200
 InregsX.BX = Handle
 InregsX.CX = INT(VAL("&H" + HEX$(High)))
 InregsX.DX = INT(VAL("&H" + HEX$(Low)))
 CALL InterruptX(&H21, InregsX, OutregsX)
 RETURN
' read 1 byte from file.
ReadFilex1:
 InregsX.AX = &H3F00
 InregsX.BX = Handle
 InregsX.CX = 1
 InregsX.DS = VARSEG(Buffer)
 InregsX.DX = VARPTR(Buffer)
 CALL InterruptX(&H21, InregsX, OutregsX)
 RETURN
Error.Routinex1:
 RESUME Error.Exitx1
END SUB

' routine to print file.
SUB PrintFileSub
 ON LOCAL ERROR GOTO Error.Routinex2
 Column = False
 ColumnSpace = False
 HexLine$ = Nul
 HexLine2$ = Nul

 ' calculate last page
 FirstByte = 1
 LastPage = INT((FileLength - 1) / 320) + 1
 LastByte = (LastPage - 1) * 320 + 320

 ' write to printer
 FileDumped = True
 ' display message about dumping.
 COLORf Yellow
 LOCATEf 2, 4, 0
 PRINTf SPACE$(74)
 LOCATEf 2, 4, 0
 PRINTf "Printing file: (Press <esc> to quit):"
 DumpLine$ = DumpLineRange$
 PRINT #1, ""
 PRINT #1, DumpLine$
 Temp# = FirstByte
 PercentDisplayed! = 0!
 LOCATEf 2, 41, 0
 PRINTf " 0%"
 FOR NextByte = FirstByte TO LastByte
    IF NextByte <= FileLength THEN
       SeekPosition = NextByte
       GOSUB LseekFilex2
       GOSUB ReadFilex2
       FileByte = Buffer
       ByteValue = ASC(FileByte)
       ' skip unprintable characters
       IF ByteValue < 32 THEN
          HexLine2$ = HexLine2$ + "."
       ELSE
          HexLine2$ = HexLine2$ + FileByte
       END IF
       HexLine$ = HexLine$ + RIGHT$("00" + HEX$(ASC(FileByte)), 2)
    ELSE
       HexLine$ = HexLine$ + "  "
       HexLine2$ = HexLine2$ + " "
    END IF
    ColumnSpace = ColumnSpace + 1
    IF ColumnSpace = 4 THEN
       HexLine$ = HexLine$ + " "
       Column = Column + 1
       ColumnSpace = False
    END IF
    Column = Column + 2
    IF Column > 44 THEN
       IF INKEY$ = CHR$(27) THEN
          FileDumped = False
          EXIT FOR
       END IF
       HexFile$ = HexLine$ + " " + HexLine2$
       HexFile$ = RTRIM$(HexFile$)
       IF LEN(HexFile$) THEN
          HexFile$ = HexFile$ + SPACE$(67 - LEN(HexFile$))
          HexFile$ = HexFile$ + "x" + RIGHT$("00000000" + HEX$(Temp# - 1#), 8)
          PRINT #1, HexFile$
          PercentCopied! = INT(CSNG(NextByte / LastByte) * 100!)
          IF PercentCopied! > PercentDisplayed! THEN
             LOCATEf 2, 41, 0
             PRINTf STR$(PercentCopied!) + "%"
             PercentDisplayed! = PercentCopied!
          END IF
       END IF
       HexLine$ = Nul
       HexLine2$ = Nul
       Temp# = NextByte + 1#
       Column = False
    END IF
 NEXT
 PRINT #1, CHR$(12);
Error.Exitx2:
 EXIT SUB
' position pointer in file.
LseekFilex2:
 ' calculate high/low seek position.
 SeekPosition2 = SeekPosition - 1 ' offset is from zero.
 ' seek values are signed bit sensitive.
 High = INT(SeekPosition2 / 65536)
 Low = SeekPosition2 AND 65535
 ' seek position in file.
 InregsX.AX = &H4200
 InregsX.BX = Handle
 InregsX.CX = INT(VAL("&H" + HEX$(High)))
 InregsX.DX = INT(VAL("&H" + HEX$(Low)))
 CALL InterruptX(&H21, InregsX, OutregsX)
 RETURN
' read 1 byte from file.
ReadFilex2:
 InregsX.AX = &H3F00
 InregsX.BX = Handle
 InregsX.CX = 1
 InregsX.DS = VARSEG(Buffer)
 InregsX.DX = VARPTR(Buffer)
 CALL InterruptX(&H21, InregsX, OutregsX)
 RETURN
Error.Routinex2:
 RESUME Error.Exitx2
END SUB

' subroutine to dump screen contents to file.
SUB DumpScreenSub
 ON LOCAL ERROR GOTO Dump.Error1
 FirstByte = (FilePage - 1) * 320 + 1
 LastByte = (FilePage - 1) * 320 + 320
 DumpLine$ = DumpLineRange$
 PRINT #1, ""
 PRINT #1, DumpLine$
 Temp# = FirstByte
 FOR NextByte = FirstByte TO LastByte
    IF NextByte <= FileLength THEN
       SeekPosition = NextByte
       GOSUB LseekFilex3
       GOSUB ReadFilex3
       FileByte = Buffer
       ByteValue = ASC(FileByte)
       ' skip unprintable characters
       IF ByteValue < 32 THEN
          HexLine2$ = HexLine2$ + "."
       ELSE
          HexLine2$ = HexLine2$ + FileByte
       END IF
       HexLine$ = HexLine$ + RIGHT$("00" + HEX$(ASC(FileByte)), 2)
    ELSE
       HexLine$ = HexLine$ + "  "
       HexLine2$ = HexLine2$ + " "
    END IF
    ColumnSpace = ColumnSpace + 1
    IF ColumnSpace = 4 THEN
       HexLine$ = HexLine$ + " "
       Column = Column + 1
       ColumnSpace = False
    END IF
    Column = Column + 2
    IF Column > 44 THEN
       HexFile$ = HexLine$ + " " + HexLine2$
       HexFile$ = RTRIM$(HexFile$)
       IF LEN(HexFile$) THEN
          HexFile$ = HexFile$ + SPACE$(67 - LEN(HexFile$))
          HexFile$ = HexFile$ + "x" + RIGHT$("00000000" + HEX$(Temp# - 1#), 8)
          PRINT #1, HexFile$
       END IF
       HexLine$ = Nul
       HexLine2$ = Nul
       Temp# = NextByte + 1#
       Column = False
    END IF
 NEXT
Dump.Exit1:
 EXIT SUB
' position pointer in file.
LseekFilex3:
 ' calculate high/low seek position.
 SeekPosition2 = SeekPosition - 1 ' offset is from zero.
 ' seek values are signed bit sensitive.
 High = INT(SeekPosition2 / 65536)
 Low = SeekPosition2 AND 65535
 ' seek position in file.
 InregsX.AX = &H4200
 InregsX.BX = Handle
 InregsX.CX = INT(VAL("&H" + HEX$(High)))
 InregsX.DX = INT(VAL("&H" + HEX$(Low)))
 CALL InterruptX(&H21, InregsX, OutregsX)
 RETURN
' read 1 byte from file.
ReadFilex3:
 InregsX.AX = &H3F00
 InregsX.BX = Handle
 InregsX.CX = 1
 InregsX.DS = VARSEG(Buffer)
 InregsX.DX = VARPTR(Buffer)
 CALL InterruptX(&H21, InregsX, OutregsX)
 RETURN
Dump.Error1:
 RESUME Dump.Exit1
END SUB

' subroutine to dump file contents to file.
SUB DumpFileSub
 ON LOCAL ERROR GOTO Dump.Error2
 ' calculate last page
 FirstByte = 1
 LastPage = INT((FileLength - 1) / 320) + 1
 LastByte = (LastPage - 1) * 320 + 320

 ' write to file
 FileDumped = True
 COLORf Yellow
 LOCATEf 2, 4, 0
 PRINTf SPACE$(74)
 LOCATEf 2, 4, 0
 PRINTf "Writing file: (Press <esc> to quit):"
 DumpLine$ = DumpLineRange$
 PRINT #1, ""
 PRINT #1, DumpLine$
 Temp# = FirstByte
 PercentDisplayed! = 0!
 LOCATEf 2, 40, 0
 PRINTf " 0%"
 FOR NextByte = FirstByte TO LastByte
    IF NextByte <= FileLength THEN
       SeekPosition = NextByte
       GOSUB LseekFilex4
       GOSUB ReadFilex4
       FileByte = Buffer
       ByteValue = ASC(FileByte)
       ' skip unprintable characters
       IF ByteValue < 32 THEN
          HexLine2$ = HexLine2$ + "."
       ELSE
          HexLine2$ = HexLine2$ + FileByte
       END IF
       HexLine$ = HexLine$ + RIGHT$("00" + HEX$(ASC(FileByte)), 2)
    ELSE
       HexLine$ = HexLine$ + "  "
       HexLine2$ = HexLine2$ + " "
    END IF
    ColumnSpace = ColumnSpace + 1
    IF ColumnSpace = 4 THEN
       HexLine$ = HexLine$ + " "
       Column = Column + 1
       ColumnSpace = False
    END IF
    Column = Column + 2
    IF Column > 44 THEN
       IF INKEY$ = CHR$(27) THEN
          FileDumped = False
          EXIT FOR
       END IF
       HexFile$ = HexLine$ + " " + HexLine2$
       HexFile$ = RTRIM$(HexFile$)
       IF LEN(HexFile$) THEN
          HexFile$ = HexFile$ + SPACE$(67 - LEN(HexFile$))
          HexFile$ = HexFile$ + "x" + RIGHT$("00000000" + HEX$(Temp# - 1#), 8)
          PRINT #1, HexFile$
          PercentCopied! = INT(CSNG(NextByte / LastByte) * 100!)
          IF PercentCopied! > PercentDisplayed! THEN
             LOCATEf 2, 40, 0
             PRINTf STR$(PercentCopied!) + "%"
             PercentDisplayed! = PercentCopied!
          END IF
       END IF
       HexLine$ = Nul
       HexLine2$ = Nul
       Temp# = NextByte + 1#
       Column = False
    END IF
 NEXT
Dump.Exit2:
 EXIT SUB
' position pointer in file.
LseekFilex4:
 ' calculate high/low seek position.
 SeekPosition2 = SeekPosition - 1 ' offset is from zero.
 ' seek values are signed bit sensitive.
 High = INT(SeekPosition2 / 65536)
 Low = SeekPosition2 AND 65535
 ' seek position in file.
 InregsX.AX = &H4200
 InregsX.BX = Handle
 InregsX.CX = INT(VAL("&H" + HEX$(High)))
 InregsX.DX = INT(VAL("&H" + HEX$(Low)))
 CALL InterruptX(&H21, InregsX, OutregsX)
 RETURN
' read 1 byte from file.
ReadFilex4:
 InregsX.AX = &H3F00
 InregsX.BX = Handle
 InregsX.CX = 1
 InregsX.DS = VARSEG(Buffer)
 InregsX.DX = VARPTR(Buffer)
 CALL InterruptX(&H21, InregsX, OutregsX)
 RETURN
Dump.Error2:
 RESUME Dump.Exit2
END SUB

' routine to display Ansi chart.
SUB DisplayANSIChart
 CALL DisplayScreen2
 COLORf White
 LOCATEf 2, 2, 0
 PRINTf "ASCII Chart for characters 1 to 127:"
 Var2 = 3
 LOCATEf 3, 2, 0
 FOR Char = 1 TO 127
    SELECT CASE Char
    ' skip unprintable characters
    CASE 0, 7, 9 TO 13, 28 TO 32
       DisplayChar$ = " "
    ' store character
    CASE ELSE
       DisplayChar$ = CHR$(Char)
    END SELECT
    Var$ = MID$(STR$(Char), 2)
    Var1$ = RIGHT$("00" + Var$, 3) + " "
    COLORf Green
    PRINTf Var1$
    COLORf Yellow
    PRINTf DisplayChar$ + " "
    ' check full screen line
    IF (Char MOD 10) = False THEN
       Var2 = Var2 + 1
       LOCATEf Var2, 2, 0
    END IF
 NEXT
 LOCATEf 16, 2, 0
 GOSUB PressKeyx1
 CALL DisplayScreen2
 COLORf White
 LOCATEf 2, 2, 0
 PRINTf "ASCII Chart for characters 128 to 255:"
 Var2 = 3
 LOCATEf 3, 2, 0
 FOR Char = 128 TO 255
    DisplayChar$ = CHR$(Char)
    Var$ = MID$(STR$(Char), 2)
    Var1$ = RIGHT$("00" + Var$, 3) + " "
    COLORf Green
    PRINTf Var1$
    COLORf Yellow
    PRINTf DisplayChar$ + " "
    ' check full screen line
    IF ((Char - 7) MOD 10) = False THEN
       Var2 = Var2 + 1
       LOCATEf Var2, 2, 0
    END IF
 NEXT
 LOCATEf 16, 2, 0
 GOSUB PressKeyx1
 EXIT SUB
' key prompt.
PressKeyx1:
 COLORf White
 PRINTf "Press a key:"
 DO
    ' check a key pressed.
    IF INKEY$ <> "" THEN
       EXIT DO
    END IF
    ' call mouse subroutine.
    CALL MouseDriver
    ' check left mouse button release.
    IF Mouse.ButtonX THEN
       EXIT DO
    END IF
    Var = ReleaseTime
 LOOP
 RETURN
END SUB

' routine to display Hex chart.
SUB DisplayHEXChart
 CALL DisplayScreen2
 COLORf White
 LOCATEf 2, 2, 0
 PRINTf "HEX Chart for characters 1 to 127:"
 Var2 = 3
 LOCATEf 3, 2, 0
 FOR Char = 1 TO 127
    SELECT CASE Char
    ' skip unprintable characters
    CASE 0, 7, 9 TO 13, 28 TO 32
       DisplayChar$ = " "
    ' store character
    CASE ELSE
       DisplayChar$ = CHR$(Char)
    END SELECT
    Var$ = HEX$(Char)
    Var1$ = RIGHT$("0" + Var$, 2) + " "
    COLORf Green
    PRINTf Var1$
    COLORf Yellow
    PRINTf DisplayChar$ + " "
    ' check full screen line
    IF (Char MOD 10) = False THEN
       Var2 = Var2 + 1
       LOCATEf Var2, 2, 0
    END IF
 NEXT
 LOCATEf 16, 2, 0
 GOSUB PressKeyx2
 COLORf Plain
 CALL DisplayScreen2
 COLORf White
 LOCATEf 2, 2, 0
 PRINTf "HEX Chart for characters 128 to 255:"
 Var2 = 3
 LOCATEf 3, 2, 0
 FOR Char = 128 TO 255
    DisplayChar$ = CHR$(Char)
    Var$ = HEX$(Char)
    Var1$ = RIGHT$("0" + Var$, 2) + " "
    COLORf Green
    PRINTf Var1$
    COLORf Yellow
    PRINTf DisplayChar$ + " "
    ' check full screen line
    IF ((Char - 7) MOD 10) = False THEN
       Var2 = Var2 + 1
       LOCATEf Var2, 2, 0
    END IF
 NEXT
 LOCATEf 16, 2, 0
 GOSUB PressKeyx2
 EXIT SUB
' key prompt.
PressKeyx2:
 COLORf White
 PRINTf "Press a key:"
 DO
    ' check a key pressed.
    IF INKEY$ <> "" THEN
       EXIT DO
    END IF
    ' call mouse subroutine.
    CALL MouseDriver
    ' check left mouse button release.
    IF Mouse.ButtonX THEN
       EXIT DO
    END IF
    Var = ReleaseTime
 LOOP
 RETURN
END SUB

REM Clipboard routines:

SUB Clipboard2(Var)
' declare error trap.
ON LOCAL ERROR GOTO Error.Routine

IF Var = 1 THEN
   GOSUB CopyToClipboard
   EXIT SUB
END IF
IF Var = 2 THEN
   GOSUB PasteFromClipboard
   EXIT SUB
END IF
IF Var = 3 THEN
   GOSUB ClipboardUndo
   EXIT SUB
END IF
IF Var = 4 THEN
   GOSUB ClipboardUndoAll
   EXIT SUB
END IF
TopProgram:
EXIT SUB

' copy hilighted area to clipboard file.
CopyToClipboard:
 IF CopyPositionStart = 0 THEN
    RETURN
 END IF
 ' store clipboard length.
 ByteLength# = CopyPositionEnd - CopyPositionStart + 1#
 IF ByteLength# + 4# > 2147483647# THEN
    StatusMessage = "Copy extends beyond clipboard file length."
    GOSUB DisplayStatus2Q
    RETURN
 END IF
 GOSUB ClearStatusQ
 PRINTf "Editing file: " + RTRIM$(Filename) + " :"
 PRINTf " Copying bytes to clipboard.."
 GOSUB LocateCursor2Q
 Bytes$ = RIGHT$("00000000" + HEX$(ByteLength#), 8)
 CopyByte = CHR$(VAL("&H" + MID$(Bytes$, 1, 2)))
 PUT #4, 1, CopyByte
 CopyByte = CHR$(VAL("&H" + MID$(Bytes$, 3, 2)))
 PUT #4, 2, CopyByte
 CopyByte = CHR$(VAL("&H" + MID$(Bytes$, 5, 2)))
 PUT #4, 3, CopyByte
 CopyByte = CHR$(VAL("&H" + MID$(Bytes$, 7, 2)))
 PUT #4, 4, CopyByte
 ' write clipboard.
 Temp# = FilePosition
 Temp2# = 4#
 FOR NextByte = CopyPositionStart TO CopyPositionEnd
    SeekPosition = NextByte
    GOSUB LseekFile
    GOSUB ReadFile
    FileByte = Buffer
    Temp2# = Temp2# + 1#
    PUT #4, Temp2#, FileByte
 NEXT
 FilePosition = Temp#
 GOSUB ClearStatusQ
 PRINTf "Editing file: " + RTRIM$(Filename) + " :"
 UndoToggle = NOT UndoToggle
 IF UndoToggle THEN
    PRINTf " (+)"
 ELSE
    PRINTf " (X)"
 END IF
 PRINTf STR$(ByteLength#) + " bytes copied to clipboard."
 GOSUB LocateCursor2Q
 RETURN

' paste clipboard to current file position.
PasteFromClipboard:
 ' read clipboard length.
 IF LOF(4) = 0 THEN
    RETURN
 END IF
 ' get clipboard length.
 ByteLength# = 0#
 GET #4, 1, CopyByte
 ByteLength# = ByteLength# + ASC(CopyByte) * 16 ^ 6
 GET #4, 2, CopyByte
 ByteLength# = ByteLength# + ASC(CopyByte) * 16 ^ 4
 GET #4, 3, CopyByte
 ByteLength# = ByteLength# + ASC(CopyByte) * 16 ^ 2
 GET #4, 4, CopyByte
 ByteLength# = ByteLength# + ASC(CopyByte) 
 ' check end of file.
 IF FilePosition + ByteLength# - 1# > FileLength THEN
    StatusMessage = "Paste extends beyond file length."
    GOSUB DisplayStatus2Q
    RETURN
 END IF
 ' clear hilight area.
 IF CopyPositionStart > 0# THEN
    GOSUB ResetHilightBytesQ
 END IF
 ' store paste area to undo clipboard file.
 GOSUB StoreUndoPaste
 IF ValidPaste = 0 THEN
    RETURN
 END IF
 ' write paste bytes.
 Temp# = FilePosition
 LastPage = FilePage
 FOR NextByte = 1# TO ByteLength#
    GET #4, NextByte + 4#, FileByte
    SeekPosition = FilePosition
    GOSUB LseekFile
    GOSUB WriteFile
    GOSUB CalculatePosition1Q
    IF LastPage = FilePage THEN
       GOSUB ClearPageByteQ
    END IF
    IF NextByte < ByteLength# THEN
       FilePosition = FilePosition + 1
    END IF
 NEXT
 FilePosition = Temp#
 GOSUB CalculatePosition1Q
 GOSUB DisplayPageByteQ
 GOSUB ClearStatusQ
 PRINTf "Editing file: " + RTRIM$(Filename) + " :"
 PRINTf STR$(ByteLength#) + " bytes "
 PRINTf "(entry #" + MID$(STR$(ByteEntries), 2) + ") pasted."
 GOSUB LocateCursor2Q
 RETURN

' store area to be over-written into paste undo file.
'   see also: Struc.txt describes file format.
StoreUndoPaste:
 IF LEN(5)=0 THEN
    CopyByte = CHR$(0)
    PUT #5, 1, CopyByte
    PUT #5, 2, CopyByte
 END IF
 ValidPaste = True
 ' get maximum entries.
 ByteEntries = 0
 GET #5, 1, CopyByte
 ByteEntries = ByteEntries + ASC(CopyByte) * 16 ^ 2
 GET #5, 2, CopyByte
 ByteEntries = ByteEntries + ASC(CopyByte) 
 IF ByteEntries >= 32767 THEN
    ValidPaste = 0
    StatusMessage = "Paste undo entries extend beyond file length."
    GOSUB DisplayStatus2Q
    RETURN
 END IF
 ' scan to last entry position in paste undo file.
 Temp2# = 3#
 Temp3 = 1
 DO
    ' check last entry.
    IF Temp3 > ByteEntries THEN
       EXIT DO
    END IF
    ' skip file start position.
    Temp2# = Temp2# + 4#
    LengthOfRecord# = 0#
    GET #5, Temp2#, CopyByte
    LengthOfRecord# = LengthOfRecord# + ASC(CopyByte) * 16 ^ 6
    Temp2# = Temp2# + 1#
    GET #5, Temp2#, CopyByte
    LengthOfRecord# = LengthOfRecord# + ASC(CopyByte) * 16 ^ 4
    Temp2# = Temp2# + 1#
    GET #5, Temp2#, CopyByte
    LengthOfRecord# = LengthOfRecord# + ASC(CopyByte) * 16 ^ 2
    Temp2# = Temp2# + 1#
    GET #5, Temp2#, CopyByte
    LengthOfRecord# = LengthOfRecord# + ASC(CopyByte) 
    Temp2# = Temp2# + LengthOfRecord# + 1#
    Temp3 = Temp3 + 1
 LOOP
 ' get maximum entries.
 TotalBytes# = Temp2# + ByteLength# + 8#
 IF TotalBytes# >= 2147483647# THEN
    ValidPaste = 0
    StatusMessage = "Paste undo extends beyond file length."
    GOSUB DisplayStatus2Q
    RETURN
 END IF
 GOSUB ClearStatusQ
 PRINTf "Editing file: " + RTRIM$(Filename) + " :"
 PRINTf " Pasting bytes from clipboard.."
 GOSUB LocateCursor2Q
 ' store new entry.
 ByteEntries = ByteEntries + 1
 Bytes$ = RIGHT$("0000" + HEX$(ByteEntries), 4)
 CopyByte = CHR$(VAL("&H" + MID$(Bytes$, 1, 2)))
 PUT #5, 1, CopyByte
 CopyByte = CHR$(VAL("&H" + MID$(Bytes$, 3, 2)))
 PUT #5, 2, CopyByte
 ' store file position of undo paste area.
 Bytes$ = RIGHT$("00000000" + HEX$(FilePosition), 8)
 CopyByte = CHR$(VAL("&H" + MID$(Bytes$, 1, 2)))
 PUT #5, Temp2#, CopyByte
 CopyByte = CHR$(VAL("&H" + MID$(Bytes$, 3, 2)))
 Temp2# = Temp2# + 1#
 PUT #5, Temp2#, CopyByte
 CopyByte = CHR$(VAL("&H" + MID$(Bytes$, 5, 2)))
 Temp2# = Temp2# + 1#
 PUT #5, Temp2#, CopyByte
 CopyByte = CHR$(VAL("&H" + MID$(Bytes$, 7, 2)))
 Temp2# = Temp2# + 1#
 PUT #5, Temp2#, CopyByte
 ' store length of undo paste area.
 Bytes$ = RIGHT$("00000000" + HEX$(ByteLength#), 8)
 CopyByte = CHR$(VAL("&H" + MID$(Bytes$, 1, 2)))
 Temp2# = Temp2# + 1#
 PUT #5, Temp2#, CopyByte
 CopyByte = CHR$(VAL("&H" + MID$(Bytes$, 3, 2)))
 Temp2# = Temp2# + 1#
 PUT #5, Temp2#, CopyByte
 CopyByte = CHR$(VAL("&H" + MID$(Bytes$, 5, 2)))
 Temp2# = Temp2# + 1#
 PUT #5, Temp2#, CopyByte
 CopyByte = CHR$(VAL("&H" + MID$(Bytes$, 7, 2)))
 Temp2# = Temp2# + 1#
 PUT #5, Temp2#, CopyByte
 ' write undo clipboard.
 Temp# = FilePosition
 FOR NextByte = Temp# TO Temp# + ByteLength# - 1#
    SeekPosition = NextByte
    GOSUB LseekFile
    GOSUB ReadFile
    FileByte = Buffer
    Temp2# = Temp2# + 1#
    PUT #5, Temp2#, FileByte
 NEXT
 FilePosition = Temp#
 RETURN

' undo last paste clipboard.
ClipboardUndo:
 IF LEN(5)=0 THEN
    CopyByte = CHR$(0)
    PUT #5, 1, CopyByte
    PUT #5, 2, CopyByte
    ValidPaste = 0
 ELSE
    GOSUB ClearStatusQ
    PRINTf "Editing file: " + RTRIM$(Filename) + " :"
    PRINTf " Undoing bytes from pastefile.."
    GOSUB LocateCursor2Q
    GOSUB UndoClipboard
 END IF
 GOSUB ClearStatusQ
 PRINTf "Editing file: " + RTRIM$(Filename) + " :"
 IF ValidPaste = 0 THEN
    PRINTf " 0 bytes paste undo."
 ELSE
    PRINTf STR$(ByteLength#) + " bytes "
    PRINTf "(entry #" + MID$(STR$(ByteEntries + 1), 2) + ") paste undo."
 END IF
 GOSUB LocateCursor2Q
 RETURN

' undo all paste clipboard.
ClipboardUndoAll:
 TotalEntries = 0
 IF LEN(5)=0 THEN
    CopyByte = CHR$(0)
    PUT #5, 1, CopyByte
    PUT #5, 2, CopyByte
 ELSE
    ByteEntries = 0
    GET #5, 1, CopyByte
    ByteEntries = ByteEntries + ASC(CopyByte) * 16 ^ 2
    GET #5, 2, CopyByte
    ByteEntries = ByteEntries + ASC(CopyByte)
    IF ByteEntries > 0 THEN
       TotalEntries = ByteEntries
       GOSUB ClearStatusQ
       PRINTf "Editing file: " + RTRIM$(Filename) + " :"
       PRINTf " Undoing all entries from paste file.."
       GOSUB LocateCursor2Q
       DO
          GOSUB UndoClipboard
          IF ValidPaste = 0 THEN
             EXIT DO
          END IF
       LOOP
    END IF
 END IF
 GOSUB ClearStatusQ
 PRINTf "Editing file: " + RTRIM$(Filename) + " :"
 PRINTf " Total" + STR$(TotalEntries) + " entries in paste undos."
 GOSUB LocateCursor2Q
 RETURN

' copy last undo paste entry.
UndoClipboard:
 ' get last entry.
 ByteEntries = 0
 GET #5, 1, CopyByte
 ByteEntries = ByteEntries + ASC(CopyByte) * 16 ^ 2
 GET #5, 2, CopyByte
 ByteEntries = ByteEntries + ASC(CopyByte) 
 ValidPaste = True
 IF ByteEntries = 0 THEN
    ValidPaste = 0
    RETURN
 END IF
 ' scan to last entry position in paste undo file.
 Temp# = FilePosition
 Temp2# = 3#
 Temp3 = 1
 DO
    ' check last entry.
    IF Temp3 = ByteEntries THEN
       EXIT DO
    END IF
    ' skip file start position.
    Temp2# = Temp2# + 4#
    LengthOfRecord# = 0#
    GET #5, Temp2#, CopyByte
    LengthOfRecord# = LengthOfRecord# + ASC(CopyByte) * 16 ^ 6
    Temp2# = Temp2# + 1#
    GET #5, Temp2#, CopyByte
    LengthOfRecord# = LengthOfRecord# + ASC(CopyByte) * 16 ^ 4
    Temp2# = Temp2# + 1#
    GET #5, Temp2#, CopyByte
    LengthOfRecord# = LengthOfRecord# + ASC(CopyByte) * 16 ^ 2
    Temp2# = Temp2# + 1#
    GET #5, Temp2#, CopyByte
    LengthOfRecord# = LengthOfRecord# + ASC(CopyByte) 
    Temp2# = Temp2# + LengthOfRecord# + 1#
    Temp3 = Temp3 + 1
 LOOP
 ' restore last entry.
 ByteEntries = ByteEntries - 1
 Bytes$ = RIGHT$("0000" + HEX$(ByteEntries), 4)
 CopyByte = CHR$(VAL("&H" + MID$(Bytes$, 1, 2)))
 PUT #5, 1, CopyByte
 CopyByte = CHR$(VAL("&H" + MID$(Bytes$, 3, 2)))
 PUT #5, 2, CopyByte
 ' restore file position of undo paste area.
 NextByte = 0#
 GET #5, Temp2#, CopyByte
 NextByte = NextByte + ASC(CopyByte) * 16 ^ 6
 Temp2# = Temp2# + 1#
 GET #5, Temp2#, CopyByte
 NextByte = NextByte + ASC(CopyByte) * 16 ^ 4
 Temp2# = Temp2# + 1#
 GET #5, Temp2#, CopyByte
 NextByte = NextByte + ASC(CopyByte) * 16 ^ 2
 Temp2# = Temp2# + 1#
 GET #5, Temp2#, CopyByte
 NextByte = NextByte + ASC(CopyByte) 
 ' restore length of undo paste area.
 ByteLength# = 0#
 Temp2# = Temp2# + 1#
 GET #5, Temp2#, CopyByte
 ByteLength# = ByteLength# + ASC(CopyByte) * 16 ^ 6
 Temp2# = Temp2# + 1#
 GET #5, Temp2#, CopyByte
 ByteLength# = ByteLength# + ASC(CopyByte) * 16 ^ 4
 Temp2# = Temp2# + 1#
 GET #5, Temp2#, CopyByte
 ByteLength# = ByteLength# + ASC(CopyByte) * 16 ^ 2
 Temp2# = Temp2# + 1#
 GET #5, Temp2#, CopyByte
 ByteLength# = ByteLength# + ASC(CopyByte) 
 ' undo paste area.
 Temp# = FilePosition
 Temp3# = NextByte
 LastPage = FilePage
 FOR FilePosition = Temp3# TO Temp3# + ByteLength# - 1#
    Temp2# = Temp2# + 1#
    GET #5, Temp2#, FileByte
    SeekPosition = FilePosition
    GOSUB LseekFile
    GOSUB WriteFile
    GOSUB CalculatePosition1Q
    IF LastPage = FilePage THEN
       GOSUB ClearPageByteQ
    END IF
 NEXT
 FilePosition = Temp#
 GOSUB CalculatePosition1Q
 GOSUB DisplayPageByteQ
 RETURN

' read 1 byte from file.
ReadFile:
 InregsX.AX = &H3F00
 InregsX.BX = Handle
 InregsX.CX = 1
 InregsX.DS = VARSEG(Buffer)
 InregsX.DX = VARPTR(Buffer)
 CALL InterruptX(&H21, InregsX, OutregsX)
 RETURN

' write 1 byte to file.
WriteFile:
 Buffer = FileByte
 InregsX.AX = &H4000
 InregsX.BX = Handle
 InregsX.CX = 1
 InregsX.DS = VARSEG(Buffer)
 InregsX.DX = VARPTR(Buffer)
 CALL InterruptX(&H21, InregsX, OutregsX)
 RETURN

' position pointer in file.
LseekFile:
 ' calculate high/low seek position.
 SeekPosition2 = SeekPosition - 1
 High = INT(SeekPosition2 / 65536)
 Low = SeekPosition2 AND 65535
 ' seek position in file.
 InregsX.AX = &H4200
 InregsX.BX = Handle
 InregsX.CX = INT(VAL("&H" + HEX$(High)))
 InregsX.DX = INT(VAL("&H" + HEX$(Low)))
 CALL InterruptX(&H21, InregsX, OutregsX)
 RETURN

' clear top status area
ClearStatusQ:
 COLORf Yellow
 LOCATEf 2, 4, 0
 PRINTf SPACE$(74)
 LOCATEf 2, 4, 0
 RETURN

' display status line message and prompt type 2Q.
DisplayStatus2Q:
 StatusMessage = StatusMessage + " Press <esc> to continue:"
 GOSUB ClearStatusQ
 PRINTf StatusMessage
 GOSUB LocateCursor2Q
 DO
    ' check escape key pressed.
    IF INKEY$ = CHR$(27) THEN
       EXIT DO
    END IF
    ' call mouse subroutine.
    CALL MouseDriver
    ' check left mouse button release.
    IF Mouse.ButtonX THEN
       EXIT DO
    END IF
    Var = ReleaseTime
 LOOP
 GOSUB DisplayFilenameQ
 RETURN

' display name of file being edited.
DisplayFilenameQ:
 GOSUB ClearStatusQ
 PRINTf "Editing file: " + RTRIM$(Filename) + " "
 IF FileLength = False THEN
    GOSUB LockedFileQ
    RETURN
 END IF
 GOSUB DisplayPositionQ
 RETURN

' display info on file being edited.
DisplayPositionQ:
 COLORf Yellow
 StringLength = LEN("Editing file: " + RTRIM$(Filename) + " ") + 4
 LOCATEf 2, StringLength, 0
 PRINTf SPACE$(77 - StringLength)
 LOCATEf 2, StringLength, 0
 IF FileLength = False THEN
    GOSUB LockedFileQ
    RETURN
 END IF
 IF CurrentWindow2 = False THEN
    PRINTf "(Position:" + STR$(FilePosition - 1) + ") "
 ELSE
    PRINTf "(Position: " + RIGHT$("00000000" + HEX$(FilePosition - 1), 8) + "H) "
 END IF
 PRINTf "(Ascii:" + STR$(AsciiValue) + ") "
 PRINTf "(Hex: " + RIGHT$("00" + HEX$(AsciiValue), 2) + "H)"
 GOSUB LocateCursor2Q
 RETURN

' display message for locked file.
LockedFileQ:
 COLORf White
 PRINTf "<locked file>"
 LOCATEf 1, 1, 0
 RETURN

' select cursor on window.
LocateCursor2Q:
 IF CopyPositionStart = 0 THEN
    GOSUB LocateCursorQ
 ELSE
    GOSUB LocateHilightCursorQ
 END IF
 RETURN

' locate cursor on window.
LocateCursorQ:
 IF FileLength = False THEN
    LOCATEf 1, 1, 0
    RETURN
 END IF
 IF CurrentWindow = False THEN
    LOCATEf PageRow + 3, Column + 5, 1
 ELSE
    LOCATEf PageRow + 3, PageColumn + 54, 1
 END IF
 RETURN

' locate cursor on window for hilighted area.
LocateHilightCursorQ:
 IF FileLength = False THEN
    LOCATEf 1, 1, 0
    RETURN
 END IF
 IF CurrentWindow = False THEN
    LOCATEf PageRow + 3, Column + 7, 1
 ELSE
    LOCATEf PageRow + 3, PageColumn + 55, 1
 END IF
 RETURN

' reset hilight bytes.
ResetHilightBytesQ:
 Temp# = FilePosition
 Temp2# = FilePage
 IF CopyPositionStart < (Temp2# - 1) * 320 + 1 THEN
    CopyPositionStart = (Temp2# - 1) * 320 + 1
 END IF
 IF CopyPositionEnd > (Temp2# - 1) * 320 + 320 THEN
    CopyPositionEnd = (Temp2# - 1) * 320 + 320
 END IF
 IF CopyPositionEnd > FileLength THEN
    CopyPositionEnd = FileLength
 END IF
 FOR FilePosition = CopyPositionStart TO CopyPositionEnd
    GOSUB CalculatePosition1Q
    COLORf White
    GOSUB BytePrintQ
 NEXT
 CopyPositionStart = 0
 CopyPositionEnd = 0
 FilePosition = Temp#
 GOSUB CalculatePosition1Q
 IF PageColumn + 1 <= 20 THEN
    IF FilePosition + 1 <= FileLength THEN
       GOSUB ClearPageByteQ
       PageColumn = PageColumn + 1
       FilePosition = FilePosition + 1
       GOSUB DisplayPageByteQ
    END IF
 END IF
 COLORf Yellow
 GOSUB BytePrintQ
 RETURN

' print the byte.
BytePrintQ:
 SeekPosition = FilePosition
 GOSUB LseekFile
 GOSUB ReadFile
 FileByte = Buffer
 ByteValue = ASC(FileByte)
 GOSUB CalculateColumnQ
 ' display hex byte.
 CALL HMouse
 LOCATEf PageRow + 3, Column + 5, 0
 PRINTf RIGHT$("00" + HEX$(ByteValue), 2)
 ' check right window toggled.
 IF CurrentWindow2 = False THEN
    ' display ascii byte.
    LOCATEf PageRow + 3, PageColumn + 54, 0
    ' skip unprintable characters.
    SELECT CASE ByteValue
    CASE 0, 7, 9 TO 13, 28 TO 32
       PRINTf "."
    CASE ELSE
       PRINTf FileByte
    END SELECT
 END IF
 CALL SMouse
 RETURN

' clear current byte on screen.
ClearPageByteQ:
 IF FileLength = False THEN
    LOCATEf 1, 1, 0
    RETURN
 END IF
 IF CopyPositionStart > 0# THEN
    GOSUB ResetHilightBytesQ
 END IF
 COLORf White
 GOSUB BytePrintQ
 RETURN

' calculate current screen page number, row, and column, given file position.
CalculatePosition1Q:
 FilePage = INT((FilePosition - 1) / 320) + 1
 PageRow = INT((FilePosition - (FilePage - 1) * 320 - 1) / 20) + 1
 PageColumn = INT((FilePosition - (FilePage - 1) * 320) - (PageRow - 1) * 20)
 RETURN

' display current byte being edited.
DisplayPageByteQ:
 ' check filelength.
 IF FileLength = False THEN
    LOCATEf 1, 1, 0
    RETURN
 END IF
 ' check hilighted bytes.
 IF CopyPositionStart > 0# THEN
    GOSUB ResetHilightBytesQ
 END IF
 ' display byte.
 COLORf Yellow
 GOSUB BytePrintQ
 ' store the current byte value being edited.
 AsciiValue = ASC(FileByte)
 RETURN

' calculate the spaces between hex value groups.
CalculateColumnQ:
 SELECT CASE PageColumn
 CASE 1 TO 4
    Column = (PageColumn - 1) * 2 + 1
 CASE 5 TO 8
    Column = (PageColumn - 1) * 2 + 2
 CASE 9 TO 12
    Column = (PageColumn - 1) * 2 + 3
 CASE 13 TO 16
    Column = (PageColumn - 1) * 2 + 4
 CASE 17 TO 20
    Column = (PageColumn - 1) * 2 + 5
 END SELECT
 RETURN

' critical error trap.
Error.Routine:
 ErrorTrap = ERR
 IF ScreenDrawn THEN
    CLS
 END IF
 ScreenDrawn = False
 COLORf White
 LOCATEf Csrlin, 1, 0
 PRINTf "Hex Editor Clipboard " + Version + " " + Release + " critical error trap:"
 COLORf Yellow
 LOCATEf Csrlin+1, 1, 0
 CALL DisplayCriticalError(ErrorTrap)
 ' display error prompt.
 COLORf Green
 LOCATEf Csrlin+1, 1, 0
 PRINTf "Press R(etry), C(ontinue), Q(uit):"
 LOCATEf Csrlin, 35, 1
 ' get keypress.
 DO
    ErrorRespond$ = Nul
    DO
       ErrorRespond$ = INKEY$
       IF LEN(ErrorRespond$) THEN
          EXIT DO
       END IF
    LOOP
    ' parse key.
    SELECT CASE LCASE$(ErrorRespond$)
    CASE "r"
       PRINTf "r"
       LOCATEf Csrlin+1, 1, 0
       RESUME TopProgram
    CASE "c"
       PRINTf "c"
       LOCATEf Csrlin+1, 1, 0
       RESUME TopProgram
    CASE "q"
       PRINTf "q"
       LOCATEf Csrlin+1, 1, 0
       RESUME TopProgram
    END SELECT
 LOOP
END SUB

REM Viewfile routine:

' returns Var=1 to 9 of file number.
SUB Viewfiles(Var)
' declare error trap.
ON LOCAL ERROR GOTO Error.Routine2
 GOSUB StoreArea
 GOSUB DrawMenu
 MenuSelect = 1
 GOSUB DrawCurrentMenuSelection
 CALL SMouse

 ' keyboard/mouse input loop.
 DO
    CharInput$ = ""

    ' call mouse subroutine.
    CALL MouseDriver

    ' check left mouse button.
    IF Mouse.ButtonX THEN
       Mouse.Row = Mouse.RowX
       Mouse.Column = Mouse.ColumnX
       GOSUB MouseButton1Y
    ELSE
       ' check right/middle mouse button.
       IF Mouse.Button2 OR Mouse.Button3 THEN
          GOSUB RestoreArea
          Var = False
          EXIT SUB
       ELSE
          ' check mouse position.
          IF Mouse.Row OR Mouse.Column THEN
             GOSUB MoveMouse
          END IF
       END IF
    END IF
    ' store keyboard buffer.
    CharInput$ = INKEY$
    IF LEN(CharInput$) THEN
       SELECT CASE LEN(CharInput$)
       CASE 1
          SELECT CASE ASC(CharInput$)
          CASE 13 ' Enter
             GOSUB RestoreArea
             IF MenuSelect > NumberFiles THEN
                Var = False
             ELSE
                Var = MenuSelect
             END IF
             EXIT SUB
          CASE 27 ' Escape
             GOSUB RestoreArea
             Var = False
             EXIT SUB
          CASE 49 TO 57 ' 1 to 9
             GOSUB EraseCurrentMenuSelection
             MenuSelect = ASC(CharInput$) - 48
             GOSUB DrawCurrentMenuSelection
          END SELECT
       CASE 2
          SELECT CASE ASC(RIGHT$(CharInput$, 1))
          CASE 72 ' Up
             GOSUB MenuUp
          CASE 80 ' Down
             GOSUB MenuDown
          END SELECT
       END SELECT
    END IF
    ' release time slice,
    Var = ReleaseTime
 LOOP
 EXIT SUB

' draws menu.
DrawMenu:
 CALL HMouse
 BoxDrawX1 = 4
 BoxDrawX2 = 14
 BoxDrawY1 = 6
 BoxDrawY2 = 21
 BoxDrawLength = 16
 GOSUB DrawBox
 COLORf2 White, 0
 FOR Var2 = 1 TO 9
    LOCATEf 4 + Var2, 7, 0
    PRINTf MID$(STR$(Var2), 2) + " "
    IF Var2 > NumberFiles THEN
       PRINTf "<none>      "
    ELSE
       PRINTf File(Var2).Filename
    END IF
 NEXT
 CALL SMouse
 RETURN

' draws box from (BoxDrawX1,BoxDrawY1) To (BoxDrawX2,BoxDrawY2),
'  length of box from left to right being BoxDrawLength.
DrawBox:
 COLORf Yellow
 LOCATEf BoxDrawX1, BoxDrawY1, 0
 PRINTf CHR$(ULcorner) + STRING$(BoxDrawLength - 2, Hline) + CHR$(URcorner)
 FOR RowX1 = BoxDrawX1 + 1 TO BoxDrawX2 - 1
    LOCATEf RowX1, BoxDrawY1, 0
    PRINTf CHR$(Vline)
    LOCATEf RowX1, BoxDRawY2, 0
    PRINTf CHR$(Vline)
 NEXT
 LOCATEf BoxDrawX2, BoxDrawY1, 0
 PRINTf CHR$(LLcorner) + STRING$(BoxDrawLength - 2, Hline) + CHR$(LRcorner)
 COLORf2 0, 7
 LOCATEf 4, 9, 0
 PRINTf "View Files"
 COLORf Yellow
 RETURN

' stores area under menu.
StoreArea:
 CALL HMouse
 RowX1 = 0
 ColumnY1 = 0
 FOR RowX2 = 4 TO 14
    RowX1 = RowX1 + 1
    ColumnY1 = 0
    FOR ColumnY2 = 6 TO 21
       ColumnY1 = ColumnY1 + 1
       ' store ascii character.
       Area1(RowX1, ColumnY1) = SCREEN(RowX2, ColumnY2)
       ' store color. (undocumented: also stores background color).
       Area2(RowX1, ColumnY1) = SCREEN(RowX2, ColumnY2, 1)
    NEXT
 NEXT
 CALL SMouse
 RETURN

' restores area under menu.
RestoreArea:
 CALL HMouse
 RowX1 = 0
 ColumnY1 = 0
 FOR RowX2 = 4 TO 14
    RowX1 = RowX1 + 1
    ColumnY1 = 0
    FOR ColumnY2 = 6 TO 21
       ColumnY1 = ColumnY1 + 1
       LOCATEf RowX2, ColumnY2, 1
       ' restore color.
       TempZ = Area2(RowX1, ColumnY1)
       VarB = INT(TempZ / 16)
       VarF = TempZ MOD 16
       COLORf2 VarF, VarB
       ' restore ascii character.
       PRINTf CHR$(Area1(RowX1, ColumnY1))
    NEXT
 NEXT
 CALL SMouse
 RETURN

' moves menu up, wrapping.
MenuUp:
 GOSUB EraseCurrentMenuSelection
 IF MenuSelect = 1 THEN
    MenuSelect = 9
 ELSE
    MenuSelect = MenuSelect - 1
 END IF
 GOSUB DrawCurrentMenuSelection
 RETURN

' moves menu down, wrapping.
MenuDown:
 GOSUB EraseCurrentMenuSelection
 IF MenuSelect = 9 THEN
    MenuSelect = 1
 ELSE
    MenuSelect = MenuSelect + 1
 END IF
 GOSUB DrawCurrentMenuSelection
 RETURN

' removes hilight from current menu selection.
EraseCurrentMenuSelection:
 CALL HMouse
 COLORf2 White, 0
 GOSUB DisplayCurrentMenuSelection
 COLORf2 White, 0
 CALL SMouse
 RETURN

' adds hilight to current menu selection.
DrawCurrentMenuSelection:
 CALL HMouse
 COLORf2 White, 1
 GOSUB DisplayCurrentMenuSelection
 COLORf2 White, 0
 CALL SMouse
 RETURN

' draws current menu selection.
DisplayCurrentMenuSelection:
 LOCATEf 4 + MenuSelect, 7, 0
 PRINTf MID$(STR$(MenuSelect), 2) + " "
 IF MenuSelect > NumberFiles THEN
    PRINTf "<none>      "
    GOSUB ClearStatus2Z
    PRINTf "View file" + STR$(MenuSelect) + ": <none>"
 ELSE
    PRINTf File(MenuSelect).Filename
    GOSUB DisplayPath
 END IF
 RETURN

' display path of file being edited.
DisplayPath:
 GOSUB ClearStatus2Z
 Z$ = RTRIM$(File(MenuSelect).ShortFilename)
 CALL Deconcatenate(Z$, 64)
 Z2$ = LEFT$(Z$, 2)
 Z$ = MID$(Z$, 3)
 Var = LEN(Z$)
 DO
    Var = Var - 1
    IF Var = False THEN
       Z$ = ""
       EXIT DO
    END IF
    IF MID$(Z$, Var, 1) = "\" THEN
       Z$ = LEFT$(Z$, Var)
       EXIT DO
    END IF
 LOOP
 IF Z$ = "" THEN
    Z$ = "\"
 END IF
 PRINTf "Viewing path: " + Z2$ + Z$ + " "
 FileDisplay2 = True
 RETURN

' clear top status area
ClearStatus2Z:
 COLORf2 Yellow, 0
 LOCATEf 2, 4, 0
 PRINTf SPACE$(74)
 LOCATEf 2, 4, 0
 RETURN

' process left mouse button.
MouseButton1Y:
 IF Mouse.Row >= 5 AND Mouse.Row <= 13 THEN
    IF Mouse.Column >= 7 AND Mouse.Column <= 20 THEN
       Var = Mouse.Row - 4
       GOSUB RestoreArea
       EXIT SUB
    END IF
 END IF
 RETURN

' process mouse move.
MoveMouse:
 ' check mouse selection boundaries.
 IF Mouse.Row >=5 AND Mouse.Row <= 13 THEN
    IF Mouse.Column >= 7 AND Mouse.Column <= 20 THEN
       IF Mouse.Row - 4 <> MenuSelect THEN
          GOSUB EraseCurrentMenuSelection
          MenuSelect = Mouse.Row - 4
       END IF
       GOSUB DrawCurrentMenuSelection
    END IF
 END IF
 RETURN

TopProgram1:
 EXIT SUB

' critical error trap.
Error.Routine2:
 ErrorTrap = ERR
 IF ScreenDrawn THEN
    CLS
 END IF
 ScreenDrawn = False
 COLORf White
 LOCATEf Csrlin, 1, 0
 PRINTf "Hex Editor Viewfile " + Version + " " + Release + " critical error trap:"
 COLORf Yellow
 LOCATEf Csrlin+1, 1, 0
 CALL DisplayCriticalError(ErrorTrap)
 ' display error prompt.
 COLORf Green
 LOCATEf Csrlin+1, 1, 0
 PRINTf "Press R(etry), C(ontinue), Q(uit):"
 LOCATEf Csrlin, 35, 1
 ' get keypress.
 DO
    ErrorRespond$ = Nul
    DO
       ErrorRespond$ = INKEY$
       IF LEN(ErrorRespond$) THEN
          EXIT DO
       END IF
    LOOP
    ' parse key.
    SELECT CASE LCASE$(ErrorRespond$)
    CASE "r"
       PRINTf "r"
       LOCATEf Csrlin+1, 1, 0
       RESUME TopProgram1
    CASE "c"
       PRINTf "c"
       LOCATEf Csrlin+1, 1, 0
       RESUME TopProgram1
    CASE "q"
       PRINTf "q"
       LOCATEf Csrlin+1, 1, 0
       RESUME TopProgram1
    END SELECT
 LOOP
END SUB
