/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "strings.h"

/***
 *  Function    :  strmvchr
 *
 *  Description :  Replace all occurences of a target character
 *		   by a new character.
 *
 *  Parameters  :  in/out   char  *string
 *                 in       char  target     target char to replace
 *                 in       char  new_char   char to put in place of target
 *
 *  Return code :  pointer to result.
 *
 *  OS/Compiler :  All
 ***/
    
char *strmvchr( char *string, char target, char new_char )

{ char *ptr;

  for ( ptr = string; *ptr ; ptr ++ )
      if ( *ptr == target ) *ptr = new_char;

  return string;
}
