/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "strings.h"

/***
 *  Function    :  strright
 *
 *  Description :  Copy the last ... characters of a string.
 *
 *  Decisions   :  If given length > string length : normal strcpy
 *		   If given length <= 0 returns an empty string.
 *
 *  Parameters  :  out  char  *out_str     result
 *                 in   char  *in_str      in string
 *                 in   int   length       length to be copied
 *
 *  Return code :   pointer to result.
 *
 *  OS/Compiler :   All
 */

char *strright( char *out_str, const char *in_str, int length )

{ const char *ptr = in_str;

  if ( length <= 0 ) { *out_str = '\0';
		       return out_str;
		     }

  while ( *ptr++ );

  if ( ptr - length - 1 > in_str ) in_str = ptr - length - 1;

  return strcpy( out_str, in_str );
}
