/* -- File:     line.h
   --
   -- Author:   Anthony Lander
   -- Date:     January 10, 1989.
   --
   -- Description:
   --           Structures and #defines for LINE.C, an example library of
   --           doubly linked functions
   -- */





/* ------------------------------------------------------------------------ */
/*                              Structures                                  */
/* ------------------------------------------------------------------------ */


/* -- This is an example structure, one which might be used for a text
   -- based applocation.  It stores a string of text, the length of the line,
   -- and links to the next and previous links in the list.
   -- */

struct _line    {
    char *string;                       /* Text of the line */
    int  length;                        /* Length of the line */

    struct _line *prev_line;            /* PTR to struct of prev line */
    struct _line *next_line;            /* PTR to struct of next line */
};








/* ------------------------------------------------------------------------ */
/*                                Defines                                   */
/* ------------------------------------------------------------------------ */



/* -- This defines the maximum length allowed for _line.string.  It's up to
   -- you to check for this, though.
   -- */

#define     L_MAX_LEN       256         /* max line length */

