
/* jis2c.c   EOUE Project, 1997 by Michael Mangelsdorf   */
/* THIS FILE IS PUBLIC DOMAIN.
   LEAVE THIS MESSAGE IN PLACE AS COURTESY TO THE AUTHOR */



#include <stdio.h>


/* This program creates a C-array of unsigned from a JIS source file.
   Last element of the array is the value 0xFFFF, and whenever a line
   break or a JIS/ASCII transition is detected, 0x0000 is written.
   Practically, the JIS source file contains strings, one on each
   line, that can be displayed from within a program using EOUE using
   the  jprint(...) or tategaki(...) function!

   old-JIS in a JIFFY:
                        MODE CHANGE     ESCAPE SEQUENCE
                        jis/ascii         1B 28 42
                                       or 1B 28 4A  
                        ascii/jis         1B 24 40
                                          1B 24 42

   Take a look at DEMO.C, where jprint() is used to see how easy
   these string resources are.
*/
void main (int argc, char * argv[]) {
 FILE *i,*o;
 int ch;
 unsigned char mode=0, istate=2, ostate=2, counter=0;
 unsigned jiscode=0;
  printf ("JIS2C - EOUE project, public domain by Michael Mangelsdorf");
  if (argc!=2) {printf("\r\n -missing input file name-"); return;}
  if (i=fopen(argv[1],"rb")) {
    o=fopen("JIS2C.OUT","wb");
    fprintf (o,"unsigned j_resource [] = {\r\n     ");
    while ((ch=fgetc(i))!=EOF) {
	if (!istate) {istate=2; continue;}
	if ((ch==0x24)&&(istate==1)) {istate=0; mode=1; continue;}
	if ((ch==0x28)&&(istate==1)) {istate=0; mode=0; continue;}
	if (ch==0x1B) {istate=1; continue;}
	if (!mode) {if (ch==0x0A) {fprintf(o,"0x0000,"); counter++;}}
	else {
	  if (ostate==2) {jiscode+=256*ch; ostate=1; continue;}
	  else {ostate=2; jiscode+=ch;}
	  fprintf (o,"0x%04X,",jiscode);  jiscode=0; counter++;
	}
	if (counter==8) {fprintf(o,"\r\n     "); counter=0;}
    }
    fprintf (o,"0xFFFF\r\n     };");
    fclose (i); fclose (o);
    printf ("\r\nOutput file: JIS2C.OUT.");
  } else printf ("\r\n -could not open file '%s'-",argv[1]);
}

