/* isascii.S, ilibc_64.a */
/* Byron Young, 2002 */

#include "ilibc_64/ilibc_64.inc"

	.file	"isascii.S"
	.pred.safe_across_calls p1-p5,p16-p63
	
#if ILIBC_64_EXTERN_PTRS==ILIBC_64_EXTERN_PTRS_YES
ilibc_64_extern_ptrs_define(isascii)
#endif

// isascii() -- Is char ascii?
// GIVEN:
//	chr	character to use in comparison.
// RETURNS: (r8)
//	0	if condition false.
//	!0	if condition is true.
// NOTES:
//  the entire integer is used for the check.
ILIBC_64_PROCEDURE_SECTION_NAME
ilibc_64_proc_start(isascii)
ilibc_64_proc_prologue
ilibc_64_proc_body
ret_val==r8
chr==r32
tmp==r11
	mov tmp=0xFF		// tmp=0xFF;
	mov ret_val=r0		// ret_val==0;
	cmp.geu p30,p31=tmp,chr	// if (0xFF>chr)
	(p30) add ret_val=ret_val,r0,1	// ++ret_val;
ilibc_64_proc_epilogue
	br.ret.sptk.many b0
ilibc_64_proc_end(isascii)
