/* strstr.S, ilibc_64.a */
/* Byron Young, 2002 */

#include "ilibc_64/ilibc_64.inc"

	.file	"strstr.S"
	.pred.safe_across_calls p1-p5,p16-p63
	
#if ILIBC_64_EXTERN_PTRS==ILIBC_64_EXTERN_PTRS_YES
ilibc_64_extern_ptrs_define(strstr)
#endif

// strstr() -- Find a substring.
// GIVEN:
//	p_str1		Searched string.
//	p_str2		String to find.
// RETURNS: (r8)
//	pointer		to the first occurrence of p_str2 in p_str1.
//	pointer		to the terminating '\0' if no found.
// NOTES:
//  undefined behavior if strings overlap.
//  Uses r9,r10,r11,r30,r31,p30,p31
ILIBC_64_PROCEDURE_SECTION_NAME
ilibc_64_proc_start(strstr)
ilibc_64_proc_prologue
ilibc_64_proc_body
p_str1==r32
p_str2==r33
ret_ptr==r8
tmp==r11
tmp2==r10
chr==r9
p_t1==r30
p_t2==r31
	ld1 chr=[p_str2],1	// chr=*(p_str2++); Advances Pointer!!
Loop1:
	ld1 tmp=[p_str1],1	// tmp=*(p_str1++);
	cmp.eq p30,p31=tmp,r0	// if (tmp==0) goto Exit
	(p30) br.cond.spnt Exit // 
	cmp.ne p30,p31=tmp,chr	// if (*p_str1!=*p_str2) goto Loop2
	(p30) br.cond.sptk Loop1
	// first letters match, check rest
	mov p_t2=p_str2		// pointer is advanced.
	mov p_t1=p_str1		// pointer is advanced.
Loop2:
	ld1 tmp=[p_t1],1	// tmp=*(p_t1++);
	ld1 tmp2=[p_t2],1	// tmp2=*(p_t2++);
	cmp.eq p30,p31=tmp,tmp2	// if (tmp==tmp2)
	(p30) br.cond.sptk Equal //  goto Equal
	cmp.eq p30,p31=tmp2,r0	// if(tmp2==0)
	(p30) br.cond.spnt Exit	//   goto Match
	br Loop1               	// else   goto NoMatch
Equal:
	cmp.ne p30,p31=tmp,r0	// if ((tmp==tmp2)!=0)
	(p30) br.cond.sptk Loop2 //  goto Loop2
				// else goto Match
Exit:
	mov ret_ptr=p_str1
	sub ret_ptr=ret_ptr,r0,1	// -- ret_ptr
ilibc_64_proc_epilogue
	br.ret.sptk.many b0
ilibc_64_proc_end(strstr)
