INCLUDE CLIBC_16.INC

; skipsp
; char __near * __near skipsp(const char __near * const);
; GIVEN:
;   p_str	near pointer, offset from ss
; RETURNS: (char __near *)
;   pointer	near pointer, offset from ss
;		to the first non white space character in the string
;		if no more non white space characters in the string,
;		   then points to ending 0
; NOTES:
;   see isspace for the definition of a white space character
_TEXT SEGMENT
skipsp PROC NEAR16 C USES ds si, p_str:NEAR16 PTR BYTE
    mov ax, ss
    mov ds, ax

    mov si, [p_str]
@@luup:
    lods BYTE PTR ds:[si]
    cmp al, 20h
    je @@luup
    cmp al, 09h
    jl @@done
    cmp al, 0Dh
    jbe @@luup
@@done:
    dec si
    mov ax, si
    ret
skipsp ENDP

; __fastcall
;   BX	    p_str
; char * __fastcall __near skipsp(const char __near * const);
@skipsp PROC NEAR16 USES ds si
    mov ax, ss
    mov ds, ax

    mov si, bx
@@luup:
    lods BYTE PTR ds:[si]
    cmp al, 20h
    je @@luup
    cmp al, 09h
    jl @@done
    cmp al, 0Dh
    jbe @@luup
@@done:
    dec si
    mov ax, si
    ret
@skipsp ENDP
_TEXT ENDS
END
