INCLUDE CLIBC_16.INC

;isxdigit() - Hexadecimal digit ('A'-'F', 'a'-'f', '0'-'9')
;int __near isxdigit(const int);

;RETURNS:
;   0	    if NOT a hex digit
;   1	    if	   a hex digit

_TEXT SEGMENT
isxdigit PROC NEAR16 C, num:WORD
    xor ax, ax
    mov bx, num

    cmp bl, '0' ; digit?
    jb @@done
    cmp bl, '9'
    jbe @@yes

    cmp bl, 'A' ; Hex letter?
    jb @@done
    cmp bl, 'F'
    jbe @@yes

    cmp bl, 'a' ; Hex letter?
    jb @@done
    cmp bl, 'f'
    ja @@done
@@yes:
    inc ax
@@done:
    ret
isxdigit ENDP

; __fastcall
;   AX	    num
;int __fastcall __near isxdigit(const int);
@isxdigit PROC NEAR16 USES bx
    mov bx, ax
    xor ax, ax

    cmp bl, '0' ; digit?
    jb @@done
    cmp bl, '9'
    jbe @@yes

    cmp bl, 'A' ; Hex letter?
    jb @@done
    cmp bl, 'F'
    jbe @@yes

    cmp bl, 'a' ; Hex letter?
    jb @@done
    cmp bl, 'f'
    ja @@done
@@yes:
    inc ax
@@done:
    ret
@isxdigit ENDP
_TEXT ENDS
END
