INCLUDE CLIBC_16.INC

;memmove() -- Copy memory block
;void __near * __near memmove(void __near * const, void __near * const, const int);
;GIVEN:
;   p_m1	near pointer, (dest) offset from ds
;   p_m2	near pointer, (source) offset from ds
;   num 	bytes to move
;RETURNS: (void __near *)
;   pointer	near pointer, offset from ds (p_m1)
;NOTES:
;   assumes that the pointer segments will never overlap or are equal
;   makes no assumptions concerning DF
;   returns without altering DF
_TEXT SEGMENT
memmove PROC NEAR16 C USES es si di,
	    p_m1:NEAR16 PTR, p_m2:NEAR16 PTR, num:WORD
	    pushf

	    mov ax, ds
	    mov es, ax

	    mov di, [p_m1]	    ;es:DI = destination
	    mov si, [p_m2]	    ;ds:SI = source
	    mov cx, [num]	    ;CX = count

	    cmp di,si		    ;Make forward moves
	    jb @@normal		   ;normal
	    je @@done
	    ; reverse
	    std
	    add si, cx
	    add di, cx
	    dec si
	    dec di
	    jmp @@doit
@@normal:
	    cld
@@doit:
	    rep movs BYTE PTR es:[di], ds:[si]
	    ; done
@@done:
	    mov ax, [p_m1]
	    popf
	    ret
memmove ENDP

; __fastcall
;   BX	    p_m1, (dest) offset from ds
;   AX	    p_m2, (source) offset from ds
;   DX	    num
;void __near * __farcall __near memmove(void __near * const, void __near * const, const int);
@memmove PROC NEAR16 USES es si di bx cx dx
	    pushf

	    mov di, bx		    ;es:DI = p_m1
	    mov si, ax		    ;ds:SI = p_m2
	    mov cx, dx		    ;cx = count
	    mov dx, bx		    ; dx = p_m1

	    mov ax, ds
	    mov es, ax

	    cmp di,si		    ;Make forward moves
	    jb @@normal		   ;normal
	    je @@done
	    ; reverse
	    std
	    add si, cx
	    add di, cx
	    dec si
	    dec di
	    jmp @@doit
@@normal:
	    cld
@@doit:
	    rep movs BYTE PTR es:[di], ds:[si]
	    ; done
@@done:
	    mov ax, dx
	    popf
	    ret
@memmove ENDP

;memmove_sss() -- Copy memory block
;void __near * __near memmove_sss(void __near * const, void __near * const, const int);
;GIVEN:
;   p_m1	near pointer, (dest) offset from ds
;   p_m2	near pointer, (source) offset from ss
;   num 	bytes to move
;RETURNS: (void __near *)
;   pointer	near pointer, offset from ds (p_m1)
;NOTES:
;   assumes that the pointer segments will never overlap or are equal
;   makes no assumptions concerning DF
;   returns without altering DF
memmove_sss PROC NEAR16 C USES ds es si di,
	    p_m1:NEAR16 PTR, p_m2:NEAR16 PTR, num:WORD
	    pushf

	    mov ax, ds
	    mov es, ax

	    mov di, [p_m1]	    ;es:DI = destination
	    mov si, [p_m2]	    ;ds:SI = source
	    mov cx, [num]	    ;CX = count

	    mov bx, ss
	    mov ds, bx
	    cmp ax, bx
	    je @@possiblerev
	    jmp @@doit
@@possiblerev:
	    cmp di,si		    ;Make forward moves
	    jb @@normal		   ;normal
	    je @@done
	    ; reverse
	    std
	    add si, cx
	    add di, cx
	    dec si
	    dec di
	    jmp @@doit
@@normal:
	    cld
@@doit:
	    rep movs BYTE PTR es:[di], ds:[si]
	    ; done
@@done:
	    mov ax, [p_m1]
	    popf
	    ret
memmove_sss ENDP

; __fastcall
;   BX	    p_m1, (dest) offset from ds
;   AX	    p_m2, (source) offset from ss
;   DX	    num
;void __near * __farcall __near memmove_sss(void __near * const, void __near * const, const int);
@memmove_sss PROC NEAR16 USES ds es si di bx cx dx
	    pushf

	    mov di, bx		    ;es:DI = p_m1
	    mov si, ax		    ;ds:SI = p_m2
	    mov cx, dx		    ;cx = count
	    mov dx, bx		    ; dx = p_m1

	    mov ax, ds
	    mov es, ax

	    mov bx, ss
	    mov ds, bx
	    cmp ax, bx
	    je @@possiblerev
	    jmp @@doit
@@possiblerev:
	    cmp di,si		    ;Make forward moves
	    jb @@normal		   ;normal
	    je @@done
	    ; reverse
	    std
	    add si, cx
	    add di, cx
	    dec si
	    dec di
	    jmp @@doit
@@normal:
	    cld
@@doit:
	    rep movs BYTE PTR es:[di], ds:[si]
	    ; done
@@done:
	    mov ax, dx
	    popf
	    ret
@memmove_sss ENDP

;memmove_dss() -- Copy memory block
;void __near * __near memmove_dss(void __near * const, void __near * const, const int);
;GIVEN:
;   p_m1	near pointer, (dest) offset from ss
;   p_m2	near pointer, (source) offset from ds
;   num 	bytes to move
;RETURNS: (void __near *)
;   pointer	near pointer, offset from ss (p_m1)
;NOTES:
;   assumes that the pointer segments will never overlap or are equal
;   makes no assumptions concerning DF
;   returns without altering DF
memmove_dss PROC NEAR16 C USES es si di,
	    p_m1:NEAR16 PTR, p_m2:NEAR16 PTR, num:WORD
	    pushf

	    mov ax, ss
	    mov es, ax

	    mov di, [p_m1]	    ;es:DI = destination
	    mov si, [p_m2]	    ;ds:SI = source
	    mov cx, [num]	    ;CX = count

	    mov ax, ds
	    mov bx, es
	    cmp ax, bx
	    je @@possiblerev
	    jmp @@doit
@@possiblerev:
	    cmp di,si		    ;Make forward moves
	    jb @@normal		   ;normal
	    je @@done
	    ; reverse
	    std
	    add si, cx
	    add di, cx
	    dec si
	    dec di
	    jmp @@doit
@@normal:
	    cld
@@doit:
	    rep movs BYTE PTR es:[di], ds:[si]
	    ; done
@@done:
	    mov ax, [p_m1]
	    popf
	    ret
memmove_dss ENDP

; __fastcall
;   BX	    p_m1, (dest) offset from ss
;   AX	    p_m2, (source) offset from ds
;   DX	    num
;void __near * __farcall __near memmove_dss(void __near * const, void __near * const, const int);
@memmove_dss PROC NEAR16 USES es si di bx cx dx
	    pushf

	    mov di, bx		    ;es:DI = p_m1
	    mov si, ax		    ;ds:SI = p_m2
	    mov cx, dx		    ;cx = count
	    mov dx, bx		    ; dx = p_m1

	    mov ax, ss
	    mov es, ax

	    mov ax, ds
	    mov bx, es
	    cmp ax, bx
	    je @@possiblerev
	    jmp @@doit
@@possiblerev:
	    cmp di,si		    ;Make forward moves
	    jb @@normal		   ;normal
	    je @@done
	    ; reverse
	    std
	    add si, cx
	    add di, cx
	    dec si
	    dec di
	    jmp @@doit
@@normal:
	    cld
@@doit:
	    rep movs BYTE PTR es:[di], ds:[si]
	    ; done
@@done:
	    mov ax, dx
	    popf
	    ret
@memmove_dss ENDP
_TEXT ENDS
END
