INCLUDE CLIBC_16.INC

IFDEF CLIBC_16_FC_EXT_PTRS
 IF CLIBC_16_FC_EXT_PTRS EQ CLIBC_16_FC_EXT_PTRS_YES

_DATA SEGMENT
EXTERNDEF C p_fn_fc_strchr:FN_CALL PTR
p_fn_fc_strchr LABEL FN_CALL PTR
	P_FN_CALL @strchr
	P_FN_CALL @strchr_sss
_DATA ENDS

 ENDIF
ENDIF

;strchr() -- Search string for char
;char __near *	fn_call strchr(const char __near * const,const int);

; GIVEN:
;   p_str	near pointer, offset from ds
;   chr 	the character to search for
; RETURNS: (char *)
;   pointer	near pointer, offset from ds
;		to the ending '\0' if char not found
;		to the character if found
; NOTES:
;   may search for '\0', then will return pointing to '\0'
;   MSC 7.0 assumes p_str offset from ds

CLIBC_16_CS SEGMENT
strchr PROC FN_CALL C USES si, p_str:NEAR16 PTR BYTE, chr:WORD
	    mov si, [p_str]	    ;ds:si = string pointer
	    mov ah, BYTE PTR [chr]  ;AH = char

@@loop:     lods BYTE PTR ds:[si]   ;Load char
	    test al,al		    ;Null, not found
	    jz @@done
            cmp al,ah               ;Loop while not equal
	    jne @@loop

@@done:
	    dec si
	    mov ax, si
	    ret
strchr	ENDP

; __fastcall
;   bx	    p_str, offset from ds
;   ax	    chr
;char __near *	__fastcall fn_call strchr(const char __near * const,const int);
@strchr PROC FN_CALL USES si
	    mov si, bx	    ;ds:si = p_str
	    xchg ah, al	    ;ah = chr

@@loop:     lods BYTE PTR ds:[si]   ;Load char
	    test al,al		    ;Null, not found
	    jz @@done
            cmp al,ah               ;Loop while not equal
	    jne @@loop

@@done:     dec si
	    mov ax, si
	    ret
@strchr ENDP

;strchr_sss() -- Search string for char
;char __near *	fn_call strchr_sss(const char __near * const,const int);
; GIVEN:
;   p_str	near pointer, offset from ss
;   chr 	the character to search for
; RETURNS: (char *)
;   pointer	near pointer, offset from ss
;		to the ending '\0' if char not found
;		to the character if found
; NOTES:
;   may search for '\0', then will return pointing to '\0'
;   MSC 7.0 assumes p_str offset from ds
strchr_sss PROC FN_CALL C USES ds si, p_str:NEAR16 PTR BYTE, chr:WORD
	    mov ax, ss
	    mov ds, ax

	    mov si, [p_str]	    ;ds:si = string pointer
	    mov ah, BYTE PTR [chr]  ;AH = char

@@loop:     lods BYTE PTR ds:[si]   ;Load char
	    test al,al		    ;Null, not found
	    jz @@done
            cmp al,ah               ;Loop while not equal
	    jne @@loop

@@done:     dec si
	    mov ax, si
	    ret
strchr_sss	ENDP

; __fastcall
;   bx	    p_str, offset from ss
;   ax	    chr
;char __near *	__fastcall fn_call strchr_sss(const char __near * const,const int);
@strchr_sss PROC FN_CALL USES ds si bx
	    mov si, bx	    ;ds:si = p_str
	    xchg ah, al	    ;ah = chr
	    mov bx, ss
	    mov ds, bx

@@loop:     lods BYTE PTR ds:[si]   ;Load char
	    test al,al		    ;Null, not found
	    jz @@done
            cmp al,ah               ;Loop while not equal
	    jne @@loop

@@done:     dec si
	    mov ax, si
	    ret
@strchr_sss ENDP
CLIBC_16_CS ENDS
END
