; strcat
;   AAA=str
;   BBB=004
;   F=
;   O=
; str004.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_strcat:FN_CALL PTR
p_fn_strcat P_FN_CALL strcat
EXTERNDEF C p_fn_fc_strcat:FN_CALL PTR
p_fn_fc_strcat P_FN_CALL @strcat
EXTERNDEF C p_fn_strcat_sss:FN_CALL PTR
p_fn_strcat_sss P_FN_CALL strcat_sss
EXTERNDEF C p_fn_fc_strcat_sss:FN_CALL PTR
p_fn_fc_strcat_sss P_FN_CALL @strcat_sss
EXTERNDEF C p_fn_strcat_dss:FN_CALL PTR
p_fn_strcat_dss P_FN_CALL strcat_dss
EXTERNDEF C p_fn_fc_strcat_dss:FN_CALL PTR
p_fn_fc_strcat_dss P_FN_CALL @strcat_dss
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;strcat() -- Concatenate strings
; appends string2 to end of string1
;char __near * fn_call strcat(char __near * const, const char __near * const);
; GIVEN:
;   p_str1	near pointer, (destination) offset from ds
;   p_str2	near pointer, (source) offset from ds
; RETURNS: (char __near *)
;   pointer	near pointer, offset from ds (p_str1)
; NOTES:
;   if p_str1 == p_str2, then just returns p_str1
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
strcat PROC FN_CALL C uses es si di, p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE

	    mov ax, ds
	    mov es, ax

	    mov si, [p_str2]	    ; ds:si = source
	    mov di, [p_str1]	    ;es:di = destination
	    cmp si, di	    ; equal strings?
	    jne @@cont

	    mov ax, di
	    jmp @@exit


@@cont:
	    mov bx, di		    ; save destination pointer
	    ; find end of p_str1
	    xor ax, ax		    ; compare with zero
	    mov cx, ax
	    dec cx		    ; cx = -1

	    repne scas BYTE PTR es:[di]	;check for zero
	    dec di		    ; [es]:di = null of p_str1


@@loop:     lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jnz @@loop

	    mov ax, bx
@@exit:
	    ret
strcat ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

;strcat() -- Concatenate strings
; appends string2 to end of string1
; __fastcall
; GIVEN:
;   BX	    p_str1, (destination) offset from ds
;   AX	    p_str2, (source) offset from ds
; RETURNS:
;   AX	    p_str1, offset from ds
;char __near * __fastcall fn_call strcat(char __near * const, const char __near * const);
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
@strcat PROC FN_CALL USES es si di cx

	    mov si, ax	; ds:si = p_str2, source
	    mov di, bx	; es:di = p_str1, destination

	    mov ax, ds
	    mov es, ax

	    cmp si, di	    ; equal strings?
	    jne @@cont

	    mov ax, di
	    jmp @@exit


@@cont:
	    ; find end of p_str1
	    xor ax, ax		    ; compare with zero
	    mov cx, ax
	    dec cx		    ; cx = -1

	    repne scas BYTE PTR es:[di]	;check for zero
	    dec di		    ; [es]:di = null of p_str1


@@loop:     lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jnz @@loop

	    mov ax, bx
@@exit:
	    ret
@strcat ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

;strcat_sss() -- Concatenate strings
; appends string2 to end of string1
; GIVEN:
;   p_str1	near pointer, (destination) offset from ds
;   p_str2	near pointer, (source) offset from ss
; RETURNS: (char __near *)
;   pointer	near pointer, offset from ds (p_str1)
; NOTES:
;   if p_str1 == p_str2, then just returns p_str1
;char __near * __fastcall fn_call strcat_sss(char __near * const, const char __near * const);
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
strcat_sss PROC FN_CALL C uses ds es si di, p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE

	    mov ax, ds
	    mov es, ax

	    mov bx, ss
	    mov ds, bx

	    mov si, [p_str2]	    ; ds:si = source
	    mov di, [p_str1]	    ;es:di = destination

	    cmp ax, bx
	    jne @@cont
	    cmp si, di	    ; equal strings?
	    jne @@cont

	    mov ax, di
	    jmp @@exit


@@cont:
	    mov bx, di		    ; save destination pointer
	    ; find end of p_str1
	    xor ax, ax		    ; compare with zero
	    mov cx, ax
	    dec cx		    ; cx = -1

	    repne scas BYTE PTR es:[di]	;check for zero
	    dec di		    ; [es]:di = null of p_str1


@@loop:     lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jnz @@loop

	    mov ax, bx
@@exit:
	    ret
strcat_sss ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

;strcat_sss() -- Concatenate strings
; appends string2 to end of string1
;char __near * __fastcall fn_call strcat_sss(char __near * const, const char __near * const);
; __fastcall
; GIVEN:
;   BX	    p_str1, (destination) offset from ds
;   AX	    p_str2, (source) offset from ss
; RETURNS:
;   AX	    p_str1, offset from ss
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
@strcat_sss PROC FN_CALL USES ds es si di cx

	    mov si, ax	; ds:si = p_str2, source
	    mov di, bx	; es:di = p_str1, destination

	    mov ax, ds
	    mov es, ax

	    mov cx, ss
	    mov ds, cx

	    cmp ax, cx
	    jne @@cont
	    cmp si, di	    ; equal strings?
	    jne @@cont

	    mov ax, di
	    jmp @@exit


@@cont:
	    ; find end of p_str1
	    xor ax, ax		    ; compare with zero
	    mov cx, ax
	    dec cx		    ; cx = -1

	    repne scas BYTE PTR es:[di]	;check for zero
	    dec di		    ; [es]:di = null of p_str1


@@loop:     lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jnz @@loop

	    mov ax, bx
@@exit:
	    ret
@strcat_sss ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

;strcat_dss() -- Concatenate strings
; appends string2 to end of string1
; GIVEN:
;   p_str1	near pointer, (destination) offset from ss
;   p_str2	near pointer, (source) offset from ds
; RETURNS: (char __near *)
;   pointer	near pointer, offset from ss (p_str1)
; NOTES:
;   if p_str1 == p_str2, then just returns p_str1
;char __near * fn_call strcat_dss(char __near * const, const char __near * const);
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
strcat_dss PROC FN_CALL C uses es si di, p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE

	    mov ax, ss
	    mov es, ax
	    mov bx, ds

	    mov si, [p_str2]	    ; ds:si = source
	    mov di, [p_str1]	    ;es:di = destination

	    cmp ax, bx
	    jne @@cont
	    cmp si, di	    ; equal strings?
	    jne @@cont

	    mov ax, di
	    jmp @@exit


@@cont:
	    mov bx, di		    ; save destination pointer
	    ; find end of p_str1
	    xor ax, ax		    ; compare with zero
	    mov cx, ax
	    dec cx		    ; cx = -1

	    repne scas BYTE PTR es:[di]	;check for zero
	    dec di		    ; [es]:di = null of p_str1


@@loop:     lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jnz @@loop

	    mov ax, bx
@@exit:
	    ret
strcat_dss ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

;strcat_dss() -- Concatenate strings
; appends string2 to end of string1
;char __near * __fastcall fn_call strcat_dss(char __near * const, const char __near * const);
; __fastcall
; GIVEN:
;   BX	    p_str1, (destination) offset from ss
;   AX	    p_str2, (source) offset from ds
; RETURNS:
;   AX	    p_str1, offset from ss
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
@strcat_dss PROC FN_CALL USES es si di cx

	    mov si, ax	; ds:si = p_str2, source
	    mov di, bx	; es:di = p_str1, destination

	    mov ax, ss
	    mov es, ax

	    mov cx, ds
	    cmp ax, cx
	    jne @@cont
	    cmp si, di	    ; equal strings?
	    jne @@cont

	    mov ax, di
	    jmp @@exit


@@cont:
	    ; find end of p_str1
	    xor ax, ax		    ; compare with zero
	    mov cx, ax
	    dec cx		    ; cx = -1

	    repne scas BYTE PTR es:[di]	;check for zero
	    dec di		    ; [es]:di = null of p_str1


@@loop:     lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jnz @@loop

	    mov ax, bx
@@exit:
	    ret
@strcat_dss ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS
END
