/****************************************************************
*   MOUSE1.C - demonstrate mouse functions 0, 1, 2, & 3         *
*   To compile: cl mouse1.c /link graphics                      *
****************************************************************/

#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <graph.h>

void main(void)
    {
    int right, left, center, row, col;
    union REGS in_regs, out_regs;

    /* Initialize the screen */
    _setvideomode(_TEXTC80);
    _clearscreen(_GCLEARSCREEN);

    /* Initialize the mouse */
    in_regs.x.ax = 0;
    int86(0x33, &in_regs, &out_regs);
    if (!out_regs.x.ax)
        {
        printf("Mouse could not be initialized.\n");
        exit(1);
        }
    printf("Mouse initialized.\n");

    /* Show the mouse cursor */
    in_regs.x.ax = 1;
    int86(0x33, &in_regs, &out_regs);

    /* Hide the mouse cursor */
    printf("Press any key to hide the mouse cursor.\n");
    getch();
    in_regs.x.ax = 2;
    int86(0x33, &in_regs, &out_regs);

    /* Redisplay the mouse cursor */
    printf("Press any key to show the mouse cursor again.\n");
    getch();
    in_regs.x.ax = 1;
    int86(0x33, &in_regs, &out_regs);

    /* Monitor the button states & position */
    while (1==1)        /* DO FOREVER... */
        {
        /* Get mouse information */
        in_regs.x.ax = 3;
        int86(0x33, &in_regs, &out_regs);

        /* Convert to more useful form */
        left   = !!(out_regs.x.bx & 0x01);
        right  = !!(out_regs.x.bx & 0x02);
        center = !!(out_regs.x.bx & 0x04);
        row = out_regs.x.dx / 8 + 1;
        col = out_regs.x.cx / 8 + 1;

        /* Print current mouse information */
        _settextposition(10,1);
        printf("Right button is %s.  \n",
                right ? "down" : "up");
        printf("Left button is %s.  \n",
                left ? "down" : "up");
        printf("Center button is %s.  \n",
                center ? "down" : "up");
        printf("Cursor row: %d, cursor column: %d.  \n",
                       row,               col);

        /* Quit the loop when user presses '*' */
        if (kbhit())
            if (getch()=='*')
                break;
        }

    /* Turn off the cursor before we quit */
    in_regs.x.ax = 2;
    int86(0x33, &in_regs, &out_regs);
    }

