/*******************************************************************
* Customizing the graphics mouse cursor: code from Figure 4J   	*
*******************************************************************/
#include <conio.h>  /* kbhit(), getch()     */
#include <dos.h>    /* int86(), union REGS  */
#include <stdio.h>  /* puts()               */
#include <stdlib.h> /* exit(), EXIT_FAILURE */
#include <graph.h>

void main(void)
    {
    union REGS regs;
	struct SREGS sregs;
	unsigned int bullseye[]=
	    {
    	/* Screen Mask */
    	0x0000, 0x0000, 0x0000, 0x0000,
    	0x0000, 0x0000, 0x03c0, 0x03c0,
    	0x0000, 0x0000, 0x0000, 0x0000,
    	0x0000, 0x0000, 0xffff, 0xffff,
    	/* Cursor Mask */
    	0xaaaa, 0xaaaa, 0x9556, 0x9556,
    	0x9ff6, 0x9ff6, 0x9ff6, 0x9ff6,
    	0x9ff6, 0x9ff6, 0x9556, 0x9556,
    	0xaaaa, 0xaaaa, 0x0000, 0x0000
    	};
	unsigned int *f = bullseye;
	char fred[100];

	_setvideomode(_MRES4COLOR);
	_selectpalette(0);

    /* Initialize the mouse */
    regs.x.ax = 0x00;
    int86(0x33, &regs, &regs);
    if (!regs.x.ax)
        {
        puts("ERROR-can't initialize mouse");
        exit(EXIT_FAILURE);
        }

    /* Show the mouse */
    regs.x.ax = 0x01;
    int86(0x33, &regs, &regs);

    /* Wait for the user to quit */
    puts("You can now see the mouse");
    puts("Press RETURN key to quit");

	/* Set the shape of the mouse */
	regs.x.ax = 9;
	regs.x.bx = 7;
	regs.x.cx = 7;
	regs.x.dx = FP_OFF(f);
	sregs.es  = FP_SEG(f);
	int86x(0x33,&regs,&regs,&sregs);

	/* Wait for a carriage return */
	gets(fred);
	
	/* Hide the mouse */
    regs.x.ax = 0x02;
    int86(0x33, &regs, &regs);

	_setvideomode(_DEFAULTMODE);
    }
