/**  strfmon.c ***********************************************************

     Locales' support for DOS / Win31 / Win32.
            Copyright (c) 1995-1997  by Timofei Bondarenko <tim@ipi.ac.ru>

     Localized strfmon().
 *-----------------------------------------------------------------------*/
#include "config.h"
#include <math.h>
#include <ctype.h>
#include <errno.h>
#include <float.h>  /* for NANs only */
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>

#include "_locale.h"
#include "monetary.h"

#define LCONV_UNDEFINED(x) ('\xC0' & (x))
#ifndef DEF_PRECESION
#define DEF_PRECESION      -1 /* 2 or 3, -1 mean all significant digits */
#endif
#define DEF_SIGN_POSN       1 /* 3 */
/* Note: sign posn has alternative meaning:
  -1  Supress the sign string;
   0  Parentheses surround the amount and currency_symbol;
   1  The sign string precedes the amount and currency_symbol;
   2  The sign string succeeds the amount and currency_symbol;
   3  The sign string immediately precedes the amount;
   4  The sign string immediately succeeds the amount.
*/
#if defined(__DJGPP__) && 2 == __DJGPP__ && 1 == __DJGPP_MINOR__ \
 && defined(USE_NATIVE_INTERFACE)
#define mon_thousands_sep thousands_sep /* bug */
#endif
#if defined(__WATCOMC__) || defined(_MSC_VER)
#define pow10(x) pow(10,(x))
#endif

struct STR { char *str, *stop; };

static int put_char(struct STR *s, char val, int size)
{
 while(size--)
   if (s->str == s->stop) return -1;
   else *s->str++ = val;
 return 0;
}

static int put_digit(struct STR *s, double val)
{
 return put_char(s, '0' + (int)fmod(val, 10), 1);
}

static int put_str(struct STR *s, const char *str)
{
 while(*str) if (put_char(s, *str++, 1)) return -1;
 return 0;
}

int strfmon(char *buf, size_t max, const char *fmt, ...)
{
 static const char c_sign[2][2] = { "+", "-" };
 static const char c_empty[1] = ""; /*1      2       3       4 */
 static const char c_nan[4][5] = { "INF", "NaN", "sNAN", "qNAN" };
#define FINAL_PRECESION (DBL_DIG + 2 /*1*/)
 const double dbl_digits = pow10(FINAL_PRECESION);
 const struct lconv *lc = localeconv();
 struct STR stp;
 va_list ap;

 va_start(ap, fmt);

 stp.str = buf;
 stp.stop = buf + max;
 if (!max--) goto Error;

 while(max && *fmt) /* while() */
   if ('%' != *fmt || '%' == *++fmt)
     {
OrdinaryChar:
      max--; *stp.str++ = *fmt++;
     }
   else
     {
/* The general formatting parameters: */
      int left_filler = ' ';
      int sign_style;
      int right_prec, left_prec;
      int field_width, fmt_flags;
#define FMT_LEFT_JUST  1
#define FMT_DONT_CSYM  2
#define FMT_DONT_GROUP 4
      int cs_precedes[2], sep_by_space[2], sign_posn[2];

      const char *currS, *decimalS, *groupS,
                 *thousandS, *sign2[2];

      right_prec = sign_style = -1;
      left_prec = field_width = fmt_flags =
/*    sign_posn[0] = sign_posn[1] = */
      cs_precedes[0] = cs_precedes[1] =
      sep_by_space[0] = sep_by_space[1] = 0;

      sign2[0] = lc->positive_sign;
      sign2[1] = lc->negative_sign;
/* Format-line parsing only parameters: */
{     char default_prec = DEF_PRECESION;

      for(;;) /* for() */
        {
         int ii = (unsigned char)*fmt;
         if (isdigit(ii)) goto setWidth;
         fmt++;
         switch(ii)
           {
         case 'F': /* another lconv: EXTENSION */
                   lc = va_arg(ap, struct lconv *); goto Cont0;
         default : fmt--; goto OrdinaryChar;
         case  0 : fmt--; goto Cont0;
         case '=': if (!(left_filler = *fmt)) goto Cont0;
                   fmt++;          break;
         case '+': sign_style = 8; break;
         case '(': sign_style = 0; break;
         case '^': fmt_flags |= FMT_DONT_GROUP; break;
         case '!': fmt_flags |= FMT_DONT_CSYM;  break;
         case '-': fmt_flags |= FMT_LEFT_JUST;
setWidth:          field_width = (int)strtoul(fmt, (char**)&fmt, 10); break;
         case '#': left_prec   = (int)strtoul(fmt, (char**)&fmt, 10); break;
         case '.': right_prec  = (int)strtoul(fmt, (char**)&fmt, 10); break;

         case 'i': /* International currency */
            currS = lc->int_curr_symbol;
            default_prec = lc->int_frac_digits;
            cs_precedes[0] = cs_precedes[1] = 1;
        /* DEFAULTS:
            sep_by_space = [0] = sep_by_space[1] = 0; */
            sign_posn[0] = (sign_style == 0 || sign_style < 0 &&
                            LCONV_UNDEFINED(lc->p_sign_posn)
                                           )? -1: DEF_SIGN_POSN;
            sign_posn[1] =  sign_style == 0 ?  0: DEF_SIGN_POSN;
            goto CommonMonetary;

         case 'n': /*      National currency */
            currS = lc->currency_symbol;
            default_prec = lc->frac_digits;
            if (0 != lc->p_cs_precedes)   cs_precedes[0] = 1;
            if (0 != lc->n_cs_precedes)   cs_precedes[1] = 1;
            if (1 == lc->p_sep_by_space) sep_by_space[0] = 1;
            if (1 == lc->n_sep_by_space) sep_by_space[1] = 1;

            sign_posn[0] = (0 <= (ii = lc->p_sign_posn) &&
                            4 >=  ii)? ii: -1;
            sign_posn[1] = (0 <= (ii = lc->n_sign_posn) &&
                            4 >=  ii)? ii: -1;
            for(ii = 0; ii <= 1; ii++)
              { static const char spos[2][2] = {
             /* cs_precedes = 0 */    { 4, 2 },
             /* cs_precedes = 1 */    { 1, 3 } };
             /* sign_posn: -1, 0, 1, 2, 3, 4 */
               if (sign_posn[ii] >= 3)
                 sign_posn[ii] = spos[cs_precedes[ii]][sign_posn[ii]-3];
              }

            if (0 < sign_style)
              {
               if (sign_posn[1] <= 0) sign_posn[1] = DEF_SIGN_POSN;
               if (sign_posn[0] <= 0) sign_posn[0] = sign_posn[1];
              }
            else if (!sign_style) { sign_posn[0] = -1; sign_posn[1] = 0; }
CommonMonetary:
            groupS = lc->mon_grouping;
            decimalS = lc->mon_decimal_point;
            thousandS = lc->mon_thousands_sep;
            goto Break1;

         case 'f': /* Numeric: EXTENSION */
            fmt_flags |= FMT_DONT_CSYM;
            groupS = lc->grouping;
            decimalS = lc->decimal_point;
            thousandS = lc->thousands_sep;
            sign2[0] = c_sign[0]; sign2[1] = c_sign[1];
            sign_posn[0] = sign_style <= 0? -1: DEF_SIGN_POSN;
            sign_posn[1] = sign_style != 0?  1: 0;
            goto Break1;
        }  } /* end of switch(), for() */
Break1:
/*    if (sign_posn[1] != 0 && sign_posn[1] != 5 &&
        !sign2[1][0]) sign2[1] = "-"; */
      if (right_prec < 0)
        if (!LCONV_UNDEFINED(default_prec))
          right_prec = default_prec;
#if 0 <= DEF_PRECESION
        else right_prec = DEF_PRECESION;
#endif
}  /* end of scanning */
{
 typedef union {             /* The value for printing (the_XXXX)*/
                double value;
                char  v_char[sizeof(double)/sizeof(char)];
                short v_shrt[sizeof(double)/sizeof(short)];
                long  v_long[sizeof(double)/sizeof(long)];
               } sDOUBLE;
      sDOUBLE the;
      double the_frac;
      int the_sign = 0;
      int the_inval = 0;

/* Prepare the amount */
      the = va_arg(ap, sDOUBLE); /* the_value = va_arg(ap, double); */
        /* don't use FPU (before NANs are checked out)-
           don't make an exception on possible NANs */
#if (DBL_MANT_DIG != 53) || (DBL_DIG != 15) || (DBL_MAX_10_EXP != 308)
#error Unknown layout of 'double': no NANs
#else
                  /* 64-bits double in hex, sign:  8
                                   11-bits power:  7ff
                                52-bits mantisse:     fffffffffffff
                       hidden 53 bit of mantisse:    1
                  highgest real bit  of mantisse:     8            */
#define DBL_MANT_LO(dbl)     ((unsigned long) (dbl).v_long[0])
#define DBL_MANT_HI(dbl)     ((dbl).v_long[1] &     0xfffffL)
#define DBL_IS_NAN(dbl)     (((dbl).v_shrt[3] &  0x7ff0) == 0x7ff0)
#define DBL_SIGN(dbl)       (((dbl).v_char[7] &  0x80)   != 0)
#define DBL_MANT_Quiet(dbl) (((dbl).v_char[6] &    0x08) != 0)
#define DBL_UNDEF_HI(dbl)    ((dbl).v_long[1] == 0xfff80000L)
#define DBL_NAN_HI(dbl)      ((dbl).v_long[1] &     0x7ffffL)
#define DBL_NAN_NORM(dbl)    ((dbl).v_shrt[3] &= 0x3ff7)

     if (DBL_IS_NAN(the)) /* NANs handling */
        {
         sign2[0] = c_sign[DBL_SIGN(the)];
         the_inval =  0 != (DBL_MANT_LO(the) | DBL_MANT_HI(the));
#if 1
         if (the_inval)
           if (DBL_UNDEF_HI(the) && !DBL_MANT_LO(the))
             {
              the_inval = 1; sign2[0] = c_empty;
             }
           else
             {
              the_inval += DBL_MANT_Quiet(the)? 2: 1;
              DBL_NAN_NORM(the);
/* 52 == DBL_MANT_DIG-1, where 1 is hidden bit */
/*            the.value = ldexp(the.value - 1, 52); */
/* 0x4000000 * 0x4000000 == 2^52 */
              the.value = (the.value - 1) * 0x4000000L * 0x4000000L;
              fmt_flags |= FMT_DONT_GROUP;
             }
#endif
         the_inval++;
/* Prepare a mandatory sign at fixed posiion */
         sep_by_space[0] = !(fmt_flags & FMT_DONT_CSYM);
         sign_posn[0] = 3;
        }
      else /* Valid number */
#endif
        {
         int dec_dig;
         if (the.value < 0) the.value = -the.value, the_sign++;
         if (the.value > dbl_digits && /* Huge value -> exponent */
             left_prec < (dec_dig = floor(log10(the.value))) /* &&
             left_prec < (dec_dig -= pow10(dec_dig) >= the.value)*/)
           {
/* Note: log10() used there for counting decimal digits in a number,
   but log10() hasn't sufficient precesion for such operations:
   for example: log10(999,999,999,999,999.999)
                 can return 15 instead 14.99999999999999...
   thus we loose one significant digit from FINAL_PRECESION
   it is not so bad! because FINAL_PRECESION defined as DBL_DIG+someting */
            dec_dig -= FINAL_PRECESION   > left_prec ?
                       FINAL_PRECESION-1 : left_prec-1;
            the.value = floor(the.value / pow10(dec_dig) + .5);
            the_frac = dec_dig / pow10(right_prec =
                                       1 + floor(log10(dec_dig)));
            decimalS = "e";
           }
         else
           {
            the_frac = modf(the.value, &the.value);
#if  0 > DEF_PRECESION
            if (right_prec < 0)
              {
               double prec = 1;
               volatile /* prevent from 'long double' computing */
               double foo, tv = the.value + the_frac;
               right_prec = 0;
               do {
                   right_prec++; prec *= 10;
                   foo = the.value + floor(the_frac * prec) / prec;
                  }
               while(tv > foo);
              }
            else
#endif /*DEF_PRECESION*/
              {
               double foo = pow10(right_prec);
               the_frac = floor(the_frac * foo + .5);
               if (the_frac >= foo)
                   the_frac -= foo, the.value++;
               the_frac /= foo;
        }  }  }

/* The string generating helper variables: */
{     char *st0, *st1;
      const char *signS;
      int add_len[2][2]; /*  "+$ 1.1 +$"
                  add_len[0] =^^^   ^^^= add_len[1]
          add_len[X][0] - positive, add_len[X][1] - negative
          add_len[X][0] - total     add_len[X][1] - additional */
#define  left_len add_len[0]
#define right_len add_len[1]
      int int_digits, ii;

 /* Compute the additional field's sizes */
      if (fmt_flags & FMT_DONT_CSYM) currS = c_empty;
      if (fmt_flags & FMT_DONT_GROUP) groupS = c_empty;

      for(ii = 0; ii <= 1; ii++)
        {
         int ix, cl;
         if (0 == (ix = sign_posn[ii]))
           left_len[ii] = right_len[ii] = 1;
         else
           {
            left_len[ii] = right_len[ii] = 0;
            if (0 < ix)
              {
               cl = strlen(sign2[ii]);
               if (1 & ix) left_len[ii] += cl;
               else       right_len[ii] += cl;
           }  }
         cl = strlen(currS) + sep_by_space[ii];
         if (cs_precedes[ii]) left_len[ii] += cl;
         else                right_len[ii] += cl;
        }
      for(ii = 0; ii <= 1; ii++)
        {
         int ix, max;
         max = add_len[ii][ix = 0];
         if (max < add_len[ii][1])
           max = add_len[ii][ix = 1];
         add_len[ii][1] = ix == the_sign? 0:
                          max - add_len[ii][1^ix];
         add_len[ii][0] = max;
        }

/* Format output: integer part */
      sign_style = sign_posn[the_sign];
      signS = sign2[the_sign];
      st0 = stp.str;
      if (put_char(&stp, ' ', left_len[1]) ||
          0 == sign_style && put_char(&stp, '(', 1) ||
          1 == sign_style && put_str(&stp, signS) ||
          cs_precedes[the_sign] && (put_str(&stp, currS)
          || put_char(&stp, ' ', sep_by_space[the_sign])) ||
          3 == sign_style && put_str(&stp, signS)) goto Error;

#ifdef DBL_IS_NAN
      if (the_inval)
        {
         st1 = stp.str;
         if (0 > put_str(&stp, c_nan[the_inval-1])) goto Error;
         int_digits = stp.str - st1;
         if (the_inval <= 2) goto ComputeWidth;
         the_inval = int_digits;
        }
#endif
      st1 = stp.str;
      for(ii = 0;;)
        {
         if (put_digit(&stp, the.value)) goto Error;
         if (1 > (the.value /= 10)) break;
         else if (!LCONV_UNDEFINED(*groupS) && ++ii == *groupS)
           if (put_str(&stp, thousandS)) goto Error;
           else
             {
              ii = 0;
              if (groupS[1]) groupS++;
        }    }
      int_digits = stp.str - st1;
      ii = int_digits >> 1;
      stp.str--; /* to the last char */
{     int ix;    /* strrev() */
      for(ix = 0; ix < ii; ix++)
        {
         char tmp = st1[ix];
         st1[ix] = stp.str[-ix];
         stp.str[-ix] = tmp;
        }
}
#ifdef DBL_IS_NAN
      st1 -= the_inval;
      int_digits += the_inval;
#endif
ComputeWidth:
      if (left_prec < int_digits) left_prec = int_digits;
      ii = left_prec + left_len[0] + right_len[0];
      if (right_prec > 0) ii += right_prec + strlen(decimalS);
#ifdef DBL_IS_NAN
      if (the_inval) left_prec = right_prec = 0;
#endif
      if (field_width < ii) field_width = ii;
      if (field_width > max) goto Error;
      if (field_width > ii)
        {
         ii = field_width - ii;
         if (fmt_flags & FMT_LEFT_JUST) right_len[1] += ii;
         else
           {
            memmove(st0 + ii, st0, left_len[0] + int_digits);
            memset(st0, ' ', ii); st1 = st0 + ii + left_len[0];
        }  }
      if (left_prec > int_digits)
        {
         ii = left_prec - int_digits;
         memmove(st1 + ii, st1, int_digits);
         memset(st1, left_filler, ii); st1 += ii;
        }
      stp.str = st1 + int_digits;

/* Format output: fractional part */
      if (right_prec > 0)
        {
         put_str(&stp, decimalS);
         while(right_prec--) put_digit(&stp, the_frac *= 10);
        }

      if (4 == sign_style) put_str(&stp, signS);
      if (!cs_precedes[the_sign])
        put_char(&stp, ' ', sep_by_space[the_sign]),
        put_str(&stp, currS);
      if (2 == sign_style) put_str(&stp, signS);
      else if (!sign_style) put_char(&stp, ')', 1);
      put_char(&stp, ' ', right_len[1]);
      max -= field_width;
} } /* end of sublocal variables */
Cont0:;
     } /* end of while() */

 if (!*fmt)
   {
    *stp.str = '\0'; max = stp.str - buf;
   }
 else
   {
Error: errno = E2BIG; max = (size_t)-1;
   }
 va_end(ap);
 return (int)max;
}

/* end of strfmon.c */