/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xahfile.h"


/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AplsB_BplsA(int n)
{
double pbA       [MXR][MXC*TWOCOL];matrix mA        ={MXR,MXC*TWOCOL,&pbA       [0][0]};
double pbB       [MXR][MXC*TWOCOL];matrix mB        ={MXR,MXC*TWOCOL,&pbB       [0][0]};
double pbAplsB   [MXR][MXC*TWOCOL];matrix mAplsB    ={MXR,MXC*TWOCOL,&pbAplsB   [0][0]};
double pbAplsB_p2[MXR][MXC*TWOCOL];matrix mAplsB_p2 ={MXR,MXC*TWOCOL,&pbAplsB_p2[0][0]};
double pbA_p2    [MXR][MXC*TWOCOL];matrix mA_p2     ={MXR,MXC*TWOCOL,&pbA_p2    [0][0]};
double pbB_p2    [MXR][MXC*TWOCOL];matrix mB_p2     ={MXR,MXC*TWOCOL,&pbB_p2    [0][0]};
double pbAB      [MXR][MXC*TWOCOL];matrix mAB       ={MXR,MXC*TWOCOL,&pbAB      [0][0]};
double pbBA      [MXR][MXC*TWOCOL];matrix mBA       ={MXR,MXC*TWOCOL,&pbBA      [0][0]};
double pbT1      [MXR][MXC*TWOCOL];matrix mT1       ={MXR,MXC*TWOCOL,&pbT1      [0][0]};
double pbT2      [MXR][MXC*TWOCOL];matrix mT2       ={MXR,MXC*TWOCOL,&pbT2      [0][0]};

                     mA.rows=n;                   mA.cols=n*TWOCOL;
                     mB.rows=n;                   mB.cols=n*TWOCOL;
                 mAplsB.rows=n;               mAplsB.cols=n*TWOCOL;
              mAplsB_p2.rows=n;            mAplsB_p2.cols=n*TWOCOL;
                  mA_p2.rows=n;                mA_p2.cols=n*TWOCOL;
                  mB_p2.rows=n;                mB_p2.cols=n*TWOCOL;
                    mAB.rows=n;                  mAB.cols=n*TWOCOL;
                    mBA.rows=n;                  mBA.cols=n*TWOCOL;
                    mT1.rows=n;                  mT1.cols=n*TWOCOL;
                    mT2.rows=n;                  mT2.cols=n*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */

  rndmF(&mA,9,5);
  rndmF(&mB,9,5);

  clrscrn();
  printf("                                                       A :");
  printmF(&mA);
  printf("                                                       B :");
  printmF(&mB);
  getchar();

  clrscrn();
  printf("                                                       A :");
  printmF(&mA);
  printf("                                                       B :");
  printmF(&mB);
  printf("                                                     A+B :\n");
  addmF(&mA, &mB, &mAplsB);
  printmF(       &mAplsB);
  getchar();

  clrscrn();
  printf("                                                 A+B     :\n");
  printmF(       &mAplsB);
  printf("                                                (A+B)**2 :\n");
  multmF(&mAplsB,&mAplsB,&mAplsB_p2);
  printmF(               &mAplsB_p2);
  getchar();

  clrscrn();
  printf("                                                       A :");
  printmF(&mA);
  printf("                                                    A**2 :\n");
  multmF(&mA,&mA,&mA_p2);
  printmF(       &mA_p2);
  getchar();

  clrscrn();
  printf("                                                       A :");
  printmF(&mA);
  printf("                                                       B :");
  printmF(&mB);
  printf("                                                      AB :\n");
  multmF(&mA,&mB,&mAB);
  printmF(       &mAB);
  getchar();

  clrscrn();
  printf("                                                       B :");
  printmF(&mB);
  printf("                                                       A :");
  printmF(&mA);
  printf("                                                      BA :\n");
  multmF(&mB,&mA,&mBA);
  printmF(       &mBA);
  getchar();

  clrscrn();
  printf("                                                       B :");
  printmF(&mB);
  printf("                                                    B**2 :\n");
  multmF(&mB,&mB,&mB_p2);
  printmF(       &mB_p2);
  getchar();

  clrscrn();
  printf("                                        A**2+AB+BA+B**2  :\n");
  addmF(&mA_p2,&mAB,&mT1);
  addmF(&mBA,  &mT1,&mT2);
  addmF(&mB_p2,&mT2,&mT1);
  printmF(          &mT1);
  printf("\n                                                (A+B)**2 :\n");
  printmF(               &mAplsB_p2);
  printf("\n                            (A+B)**2 - (A**2+AB+BA+B**2) :\n");
  submF(&mT1,&mAplsB_p2,&mT2);
  printmF(              &mT2);
}


void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n          (A+B)**2 = A**2+AB+BA+B**2              ");
  printf("\n          **************************            \n");
  printf("\n The size of mA, mB      : 1x1 ... 4x4.         \n");
  printf("\n     ex : \"idmaf.exe\"                         \n");
  printf("\n You can choose the size :                      \n");
  printf("\n     ex : \"idmaf.exe 2\" -> 2x2                  ");
  printf("\n          \"idmaf.exe 1\" -> 1x1                  ");
  printf("\n          \"idmaf.exe 4\" -> 2x2                  ");
  printf("\n\n                                                ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press a key to continue                          ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]) )
 {n = atoi(argv[1]); if( n > 4){n=4;} }
else
 {    n=rndpI(4);  }
   if(n<1){n=1;}


  AplsB_BplsA(n);


printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}












