/* myfpivot.h                   freeware                   xhunga@tiscali.fr  */

/* ------------------------------ FUNCTION -------------------- pivotntzero() */
/*                                                                            */
/* -------------------------------------------------------------------------- */
int pivotntzeroF(
pmatrix mOut,
int row1,
int row2)
{
   int sign = 1;
double pivot;
double t;

  pivot = *(mOut->pblock + row1 *mOut->cols + row2 * 2);
  if(pivot == 0)
  {
   row2 = row1 + 1;
   do
   {
    t = *(mOut->pblock + row2 *mOut->cols + row1 * 2);
    if(!(t==0.0))
    {
     swaprowF(mOut,row1,row2);
     row2 = mOut->rows;
     sign = -1;
    }
    row2++;
   }
   while(row2 < mOut->rows);
  }
return(sign);
}

/* ------------------------------ FUNCTION -------------------- pivotntzero() */
/*                                                                            */
/* -------------------------------------------------------------------------- */
void pivotminiF(
pmatrix m)
{
   int row;
double numer;
double denom;

  for (row = 0 ; row < m->rows ; row++)
   {
    numer =  (*(m->pblock + row *m->cols + row * 2     ));
    denom =   *(m->pblock + row *m->cols + row * 2  + 1);
    if(numer)
      {
       mulrowF(m,row,denom,numer);
       frowminiF(m,row);
      }
   }
}


/* ------------------------------ FUNCTION ------------------------- addrow() */
/* returns a copy of the matrix m in which row r2 is replaced  by (s*r1 + r2) */
/* -------------------------------------------------------------------------- */
void pivotworkF(
pmatrix m,
int     row1,
int     row2)
{
  int             j;
  double          t;
  double      numer = -(*(m->pblock + row2 *m->cols + row1 * 2 ));
  double      denom =   *(m->pblock + row2 *m->cols + row1 * 2  + 1);
  double pivotnumer =  (*(m->pblock + row1 *m->cols + row1 * 2  ));
  double pivotdenom =   *(m->pblock + row1 *m->cols + row1 * 2  + 1);
fraction f;

 for ( j = 0 ; j < m->cols ; j++,j++ )
    {
/* ---------------------------------------------------------------- numerator */
                                                          f.numer = \
                       (
                       numer * *(m->pblock + row1 *m->cols + j     )\
                               * \
                  pivotdenom * *(m->pblock + row2 *m->cols + j  + 1)\
                        )
                        + \
                        (
                    pivotnumer * *(m->pblock + row2 *m->cols + j      )\
                             * \
                       denom   * *(m->pblock + row1 *m->cols + j  + 1 )
                         );
/* -------------------------------------------------------------- denominator */
                                                       f.denom = \
               denom * *(m->pblock + row1 *m->cols + j   + 1)  * \
          pivotdenom * *(m->pblock + row2 *m->cols + j   + 1);

          if(!f.numer){ f.denom = 1;}

          f = fminiF(f);

    *(m->pblock + row2 *m->cols + j    ) = f.numer;
    *(m->pblock + row2 *m->cols + j + 1) = f.denom;
    }
}

