/*   NJSDK.H - Header file for NJSDK - Chinese software development kits
 *
 *   Copyright (c) Hongbo Ni 1991-1993. All Rights Reserved.
 *
 *   Last modified: HBNI 18:29:47 Thu  03-18-1993
 */
/***************************************************************************
     NJSDK - NJSTAR Chinese Software Development Kits. Version 2.1:
     a C Library as  being  used  by  NJSTAR  V2.1.  It  contains  all  the
     functions for handling  Chinese  Input,  display  and  printing.  With
     NJSDK, user can develop any Chinese applications without  knowing  how
     Chinese characters are inputed, displayed or  printed.  LICENSED  USER
     can distribute all NJSTAR dictionaries and fonts (30 files) with their
     applicationa without any further royalty payment. Please  contact  the
     author  for current price.
***************************************************************************/

/*=========== VIDEO MODE ==============*/
#define EGA   3   /* 640x350  80x19x16 */
#define MEGA  4   /* 640x350  80x19x2  */
#define MCGA  5   /* 640x480  80x25x2  */
#define VGA   6   /* 640x480  80x25x16 */
#define SVGA  7   /* 800x600 100x31x16 */
/*=========== VIDEO MODE ==============*/

struct NJVIDEO {
    int Videomode;    /* Current Video Mode (see above)      */
    int Nrows;        /* number of rows EGA=18 VGA=24 SVGA=29*/
    int BytesPerLine; /* bytes per line EGA/VGA=80 SVGA=100  */
    int PixelsPerRow; /* Pixels per row EGA=18 VGA/SVGA=19   */
    int Mono;         /* Is a monochrome mornitor            */
};

struct MENU_S {
    char row;        /* display row */
    char col;        /* display col */
    char len;        /* display background len */
    char list;       /* the selection key in upper case */
    char *str;       /* menu string */
    char *msg;       /* message assorciated */
} ;

/* The Entry Field type can be
 * 1 - string             : stored in str[80]
 * 2 - integer            : stored in str[80]
 * 3 - float(signed)      : stored in str[80]
 * 4 - Date (DD/MM/YY)    : stored in str[80] len == 8
 * 5 - Time (HH:MM:SS)    : stored in str[80] len == 8
 * 6 - limited chars      : len=1
 */
struct ENTRY_S {
    char row;        /* display row */
    char col;        /* display row */
    char len;        /* len of the  field */
    char type;       /* type of the field */
    char str[80];    /* str to hold field */
    char *msg;       /*message assorciated*/

};

/* type field of dialog */
#define BUTTON -1
#define RADIO  -2

struct DIALOG_S {
    char row;        /* display row */
    char col;        /* display row */
    char len;        /* len of the  field */
    char type;       /* type of the field */
    char radio;      /* store radio status*/
    char str[80];    /* str to hold field */
    char *msg;       /*message assorciated*/
};

typedef unsigned char uchar;

int NJ_init(char *homedir);
int NJ_AutoSave(int(*asfun)());
int NJ_getvideo(struct NJVIDEO *v);
int NJ_end();

int NJ_ChineseInput(int Ok);
int NJ_setlxonoff(int on);
int NJ_setinput(int method, int select);


int NJ_getkey()                                                            ;
int NJ_getmouse(int *row, int *col)                                        ;
int NJ_setinput(int m, int c)                                              ;
int NJ_gets0(uchar *str, int row, int col, int len, int Fcolor, int Bcolor);
int NJ_gets(uchar *str, int row, int col, int len, int Fcolor, int Bcolor) ;
int NJ_puts(uchar *str, int row, int col, int Fcolor, int Bcolor)          ;
int NJ_putc(uchar c, int row, int col, int Fcolor, int Bcolor)             ;
int NJ_window(int r1, int c1, int r2, int c2, int color)                   ;
int NJ_fillwin(int r1, int c1, int r2, int c2, int color)                  ;
int NJ_clscolum(int row1, int col1, int col2, int color)                   ;
int NJ_clsrows(int row1, int row2, int color)                              ;
int NJ_cursorOnOff(int on)                                                 ;
int NJ_setcursor(int row, int col)                                         ;
int NJ_mousecursor(int on)                                                 ;
int NJ_line(int row1, int col1, int row2, int col2, int color);
int NJ_box(int row1, int col1, int row2, int col2, int color) ;

int NJ_entry(int Fcolor1, int Bcolor1, int Fcolor2,int Bcolor2,
             struct ENTRY_S *sl,int ns,int ini,int(*msgfun)(char *))       ;
int NJ_menu(int Fcolor1, int Bcolor1, int Fcolor2,int Bcolor2, int pressed,
             struct MENU_S *sl,int ns,int ini,int(*msgfun)(char *))        ;
int NJ_button(struct MENU_S *sl,int ns,int ini,int pressed);
int NJ_dialog(int Fcol1,int Bcol1,int Fcol2,int Bcol2,int Fcol3,int Bcol3,
             struct DIALOG_S *sl,int ns,int ini,
             int(*mdialog)(int, int), int(*msgfun)(char *));
/*---------------------------------------------------------------------------*/
