;CRC - Cycle Redundance Check
; by : Peter Quiring
;Source : DDJ Apr/97

include src\qlib.inc
include alloc.inc
include crc.inc

.code

CRC16init proc,poly:dword,flgs:dword
  pushad

  callp malloc,512
  test eax,eax
  jz bad  ;no ram?
  xor ecx,ecx
  mov edi,eax
  mov [esp+4*7],eax  ;save EAX for popad
  mov edx,poly
  test flgs,CRC_SHIFT_REV
  jnz _16k
_16_for1:
  xor eax,eax
  mov al,cl
  shl eax,8
  mov ch,8
_16_for2:
  xor ebx,ebx
  test eax,08000h
  jz _16_not1
  mov ebx,edx
_16_not1:
  shl eax,1
  xor eax,ebx
  dec ch
  jnz _16_for2
  stosw
  inc cl
  jnz _16_for1
  jmp done

_16k:
_16k_for1:
  xor eax,eax
  mov al,cl
  mov ch,8
_16k_for2:
  xor ebx,ebx
  test eax,1
  jz _16k_not1
  mov ebx,edx
_16k_not1:
  shr eax,1
  xor eax,ebx
  dec ch
  jnz _16k_for2
  stosw
  inc cl
  jnz _16k_for1

done:
  popad
  ret

bad:
  popad
  mov eax,ERROR      ;memory returned can not be (-1)
  ret
CRC16init endp

CRC32init proc,poly:dword,flgs:dword
  pushad

  callp malloc,1024
  test eax,eax
  jz bad  ;no ram?
  xor ecx,ecx
  mov edi,eax
  mov [esp+4*7],eax  ;save EAX for popad
  mov edx,poly
  test flgs,CRC_SHIFT_REV
  jnz _32k
_32_for1:
  xor eax,eax
  mov al,cl
  shl eax,24
  mov ch,8
_32_for2:
  xor ebx,ebx
  test eax,080000000h
  jz _32_not1
  mov ebx,edx
_32_not1:
  shl eax,1
  xor eax,ebx
  dec ch
  jnz _32_for2
  stosd
  inc cl
  jnz _32_for1
  jmp done

_32k:
_32k_for1:
  xor eax,eax
  mov al,cl
  mov ch,8
_32k_for2:
  xor ebx,ebx
  test eax,1
  jz _32k_not1
  mov ebx,edx
_32k_not1:
  shr eax,1
  xor eax,ebx
  dec ch
  jnz _32k_for2
  stosd
  inc cl
  jnz _32k_for1
done:
  popad
  ret

bad:
  popad
  mov eax,ERROR      ;memory returned can not be (-1)
  ret
CRC32init endp

CRC16 proc,crc:word,table:dword,buf:dword,blen:dword,flgs:dword
  pushad
  mov esi,buf
  mov ecx,blen
  xor ebx,ebx
  mov bx,crc         ;initial CRC
  mov edi,table
  test flgs,CRC_METHOD2
  jnz _m2

  test flgs,CRC_SHIFT_REV
  jnz _m1_rev
_m1:          ;XYZModem algo
;crc = crc16table [ ((crc >> 8) & 255) ] ^ (crc << 8) ^ data;
@@:
  xor eax,eax
  lodsb
  mov edx,ebx
  shl edx,8
  xor edx,eax        ;b = (crc << 8) ^ data
  mov eax,ebx
  shr eax,8
  and eax,0ffh
  shl eax,1   ;words!
  mov ax,[edi+eax]   ;a = crc16table [ ((crc >> 8) & 255) ]
  xor eax,edx
  mov ebx,eax        ;crc = a ^ b
  dec ecx
  jnz @b
  jmp done

_m1_rev:
;crc = crc16table [ (crc & 255) ] ^ (crc >> 8) ^ data;
@@:
  xor eax,eax
  lodsb
  mov edx,ebx
  shr edx,8
  xor edx,eax        ;b = (crc >> 8) ^ data
  mov eax,ebx
  and eax,0ffh
  shl eax,1   ;words!
  mov ax,[edi+eax]   ;a = crc16table [ (crc & 255) ]
  xor eax,edx
  mov ebx,eax        ;crc = a ^ b
  dec ecx
  jnz @b
  jmp done

_m2:
  test flgs,CRC_SHIFT_REV
  jnz _m2_rev
;crc = crc16table [ (((crc >> 8) ^ data) & 255) ] ^ (crc << 8);
@@:
  xor eax,eax
  lodsb
  mov edx,ebx
  shr edx,8
  xor edx,eax
  and edx,0ffh
  shl edx,1   ;words!
  mov dx,[edi+edx]   ;a = crc16table[ (((crc >> 8) ^ data) & 255) ]
  shl ebx,8          ;b = (crc << 8)
  xor ebx,edx        ;crc = a ^ b
  dec ecx
  jnz @b
  jmp done

_m2_rev:      ;Kermit algo
;crc = crc16table [ ((crc ^ data) & 255) ] ^ (crc >> 8);
@@:
  xor eax,eax
  lodsb
  mov edx,ebx
  xor edx,eax
  and edx,0ffh
  shl edx,1   ;words!
  mov dx,[edi+edx]   ;a = crc16table[ ((crc ^ data) & 255) ]
  shr ebx,8          ;b = (crc >> 8)
  xor ebx,edx        ;crc = a ^ b
  dec ecx
  jnz @b
  jmp done

done:
  xor eax,eax
  mov ax,bx
  mov [esp+4*7],eax  ;save EAX for popad
  popad
  ret
CRC16 endp

CRC32 proc,crc:dword,table:dword,buf:dword,blen:dword,flgs:dword
  pushad
  mov esi,buf
  mov ecx,blen
  mov ebx,crc         ;initial CRC
  mov edi,table
  test flgs,CRC_METHOD2
  jnz _m2

  test flgs,CRC_SHIFT_REV
  jnz _m1_rev
_m1:
;crc = crc32table [ ((crc >> 24) & 255) ] ^ (crc << 8) ^ data;
@@:
  xor eax,eax
  lodsb
  mov edx,ebx
  shl edx,8
  xor edx,eax        ;b = (crc << 8) ^ data
  mov eax,ebx
  shr eax,24
  and eax,0ffh
  shl eax,2   ;dwords!
  mov eax,[edi+eax]  ;a = crc32table [ ((crc >> 8) & 255) ]
  xor eax,edx
  mov ebx,eax        ;crc = a ^ b
  dec ecx
  jnz @b
  jmp done

_m1_rev:
;crc = crc32table [ (crc & 255) ] ^ (crc >> 24) ^ data;
@@:
  xor eax,eax
  lodsb
  mov edx,ebx
  shr edx,24
  xor edx,eax        ;b = (crc >> 24) ^ data
  mov eax,ebx
  and eax,0ffh
  shl eax,2   ;dwords!
  mov eax,[edi+eax]  ;a = crc32table [ (crc & 255) ]
  xor eax,edx
  mov ebx,eax        ;crc = a ^ b
  dec ecx
  jnz @b
  jmp done

_m2:          ; ZModem-32 algo
  test flgs,CRC_SHIFT_REV
  jnz _m2_rev
;crc = crc32table [ (((crc >> 24) ^ data) & 255) ] ^ (crc << 8);
@@:
  xor eax,eax
  lodsb
  mov edx,ebx
  shr edx,24
  xor edx,eax
  and edx,0ffh
  shl edx,2   ;dwords!
  mov dx,[edi+edx]   ;a = crc32table[ (((crc >> 8) ^ data) & 255) ]
  shl ebx,8          ;b = (crc << 8)
  xor ebx,edx        ;crc = a ^ b
  dec ecx
  jnz @b
  jmp done

_m2_rev:
;crc = crc32table [ ((crc ^ data) & 255) ] ^ (crc >> 24);
@@:
  xor eax,eax
  lodsb
  mov edx,ebx
  xor edx,eax
  and edx,0ffh
  shl edx,2   ;dwords!
  mov dx,[edi+edx]   ;a = crc32table[ ((crc ^ data) & 255) ]
  shr ebx,24         ;b = (crc >> 24)
  xor ebx,edx        ;crc = a ^ b
  dec ecx
  jnz @b
  jmp done

done:
  mov [esp+4*7],ebx  ;save EAX for popad
  popad
  ret
CRC32 endp

_endseg

end
