/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB(
int n
)
{
fraction Norm_u;
fraction Norm_v;
fraction Normu_Normv;

fraction InnerProduct;

double pbA[MXR][MXC*TWOCOL];matrix mA={MXR,MXC*TWOCOL,&pbA[0][0]};
double pbu[MXR][MXC*TWOCOL];matrix mu={MXR,MXC*TWOCOL,&pbu[0][0]};
double pbv[MXR][MXC*TWOCOL];matrix mv={MXR,MXC*TWOCOL,&pbv[0][0]};

       mA.rows = n;               mA.cols = n*TWOCOL;
       mu.rows = n;               mu.cols =   TWOCOL;
       mv.rows = n;               mv.cols =   TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
mdiagpF(&mA,3,1);
  rndmF(&mu,3,1);
  rndmF(&mv,3,1);

  clrscrn();
  printf("  Copy the weights w1,..,wn on the identity matrix : A \n");
  printmF(&mA);
  printf("\n                               (n x 1) : u \n");
  printmF(&mu);
  printf("\n                               (n x 1) : v \n");
  printmF(&mv);
  getchar();

  clrscrn();
  Norm_u = norm_WP2(&mA,&mu);                       /* It is the square of the norm.*/
  Norm_v = norm_WP2(&mA,&mv);
  printf("\n\n\n         ||u|| = (%.0lf/%-.0lf)**(1/2)\n",
            Norm_u.numer,
            Norm_u.denom);

  printf("\n         ||v|| = (%.0lf/%-.0lf)**(1/2)\n\n",
            Norm_v.numer,
            Norm_v.denom);

  Normu_Normv = multF(Norm_u,Norm_v);
  printf("\n  ||u||  ||v|| = (%.0lf/%-.0lf)**(1/2) \n\n",
            Normu_Normv.numer,
            Normu_Normv.denom);
  getchar();

  clrscrn();
  InnerProduct = innerprod_W(&mA,&mu,&mv);
  printf("                  u.v =   %.0lf/%-.0lf \n\n",
            InnerProduct.numer,
            InnerProduct.denom);

  printf("          ||u|| ||v|| =   (%.0lf/%-.0lf)**(1/2) \n\n",
            Normu_Normv.numer,
            Normu_Normv.denom);

  printf("\n     Cauchy-Schwarz inequality on           ");
  printf("\n   Weighed Euclidean Inner Product on R**n\n\n");
  printf("               |u.v|  =<  ||u|| ||v|| \n\n");

  printf("              |%.0lf/%-.0lf|  =<  (%.0lf/%-.0lf)**(1/2) \n\n",
            InnerProduct.numer,InnerProduct.denom,
             Normu_Normv.numer, Normu_Normv.denom);

  printf("             |%.3lf|  =<  %.3lf \n\n",
            InnerProduct.numer/InnerProduct.denom,
        sqrt(Normu_Normv.numer/Normu_Normv.denom));

}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n                                                ");
  printf("\n     Cauchy-Schwarz inequality on                 ");
  printf("\n   Weighed Euclidean Inner Product on R**n      \n");
  printf("\n                                                  ");
  printf("\n          |u.v|  =< ||u|| ||v||                   ");
  printf("\n          *********************                   ");
  printf("\n                                                  ");
  printf("\n The size of u, v : 1x2 ... 1x4.                \n");
  printf("\n     ex : \"causchWF.exe\"                      \n");
  printf("\n You can choose the size :                      \n");
  printf("\n     ex : \"causchWF.exe 2\" -> 1x2               ");
  printf("\n          \"causchWF.exe 4\" -> 1x4             \n");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                          ");
  printf("\n                                                  ");
  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
int main(int argc, char *argv[])
{
time_t t;
int    n;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]) )
 {
  n = atoi(argv[1]); if( n > 4){n=4;}
  }
else
 {
  n=rndpI(4);
 }
   if(n<2){n=2;}


  AB(n);


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}












