/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
detab(
int n)
{
fraction detA;
fraction detAT_A;

double pbA   [MXR][MXC*TWOCOL];matrix mA   ={MXR,MXC*TWOCOL,&pbA   [0][0]};
double pbAT  [MXR][MXC*TWOCOL];matrix mAT  ={MXR,MXC*TWOCOL,&pbAT  [0][0]};
double pbAT_A[MXR][MXC*TWOCOL];matrix mAT_A={MXR,MXC*TWOCOL,&pbAT_A[0][0]};

                   mA.rows=n;                   mA.cols=n*TWOCOL;
                  mAT.rows=n;                  mAT.cols=n*TWOCOL;
                mAT_A.rows=n;                mAT_A.cols=n*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
  rndm0F(&mA,3,2);

  clrscrn();
  printf("                                                       A :");
  printmF(&mA);
  detA = detF(&mA);
  printf("\n                                      det(A) = %.0f/%.0f\n",
         detA.numer, detA.denom);
  getchar();

  clrscrn();
  printf("                                                       A  :");
  printmF(&mA);
  printf("                                                       AT :");
  transposemF(&mA,&mAT);
      printmF(    &mAT);
       multmF(&mA,&mAT,&mAT_A);
  printf("                                                     AT_A :");
         printmF(&mAT_A);
  detAT_A = detF(&mAT_A);
  printf("\n     If det(A) != 0  then det(A**T A) != 0; \n\n");
  printf("\n                          det(A**T A)  = %.0f/%.0f \n",
         detAT_A.numer, detAT_A.denom );

}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n    A has linearly independent column vectors.    ");
  printf("\n                                                  ");
  printf("\n                      <=>                         ");
  printf("\n                                                  ");
  printf("\n            (A**T A) is invertible                ");
  printf("\n            **********************                ");
  printf("\n\n\n\n\n\n\n\n\n\n                                ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                          ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;

/*-------------------------------- PROGRAM ---------------------------------- */
   srand(time(&t));
   hello();
do
{

if( argc == 2 && atoi(argv[1]))
 {  n = atoi(argv[1]); if( n > 4){n=4;}}
else
 {  n = rndpI(4);}
if( n < 1){n=1;}


  detab(n);


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}












