
// Copyright 1992, David Perelman-Hall & Jamshid Afshar


#ifndef EDGE_H
#define EDGE_H

#include "category.h"
#include "tree.h"


class Edge {
friend Edge combine( const Edge& edge1, const Edge& edge2 );
friend ostream& operator << ( ostream& os, const Edge& edge );
private:
   int _start;
   int _finish;
   Tree _tree;
   Category_Sequence _toFind;
public:
   // constructor
   Edge( int start, int finish, const Category& label );

   // constructor
   Edge( int start, int finish, const Category& label,
               const Category_Sequence& toFind );
   
   // constructor
   Edge( int start, int finish, const Tree& tree,
               const Category_Sequence& toFind );

   // copy constructor
   Edge( const Edge& edge );
   // assignment operator
   void operator = ( const Edge& edge );
   bool operator == ( const Edge& edge ) const;
   bool canCombineWith( const Edge& edge ) const;
   bool isActive() const{ return !_toFind.isEmpty(); }
   int start() const { return _start; }
   int finish() const { return _finish; }
   Category label() const { return _tree.cat(); }
   Category_Sequence found() const { return _tree.get_children(); }
   const Category_Sequence& toFind() const { return _toFind; }
   const Tree& parse() const { return _tree; }
};


class Edge_List {
friend ostream& operator << ( ostream& os, const Edge_List& list );
private:
   struct edgeNode{
      Edge _edge;
      edgeNode *_next;
      edgeNode( const Edge& edge, edgeNode *next)
         : _edge(edge), _next(next) {}
      };
   edgeNode *_firstNode;
public:
   // constructor
   Edge_List();
   // copy constructor
   Edge_List( const Edge_List& edge_List );
   // destructor
   ~Edge_List();

   void push( const Edge& edge );
   Edge pop();
   // assignment operator 
   void operator = ( const Edge_List& edge_List );
   void clear();

   bool isMember( const Edge& edge ) const;
   bool isEmpty() const;
};


#endif
