/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
    USA
*/

/*
 * txtlines -- reformat text lines
 */



#include <stdio.h>
#include "str_fun.h"
#include <string.h>
#include "txtlines.h"
#include <stdlib.h>


 char ein_name[PFAD_LEN];
 char aus_name[PFAD_LEN];

 long zeilenlaenge;

 char * eingabezeile;
 char * ausgabezeile;
 char * puffer1;

 FILE * fpein;
 FILE * fpaus;

 int procedure_type;

      /*
         1 -> produce text file with long lines
         2 -> produce text file with short lines
         3 -> copy text file
      */


 int hilfe(void);
 int puffer_allokieren(void);
 int puffer_free(void);
 int dateien_oeffnen(void);
 int dateien_schliessen(void);
 int eingabedatei_lesen(void);
 int kopieren(void);
 int ausgabedatei_schreiben(void);
 int to_long(void);
 int to_short(void);

int main(int argc, char * argv[])
{
   int i;

   if ((argc==1) ||
           stricmp(argv[1],"-?")==0 || stricmp(argv[1],"-?")==0 ||
           stricmp(argv[1],"-help")==0)
   {
       hilfe();
       return 0;
   }
   procedure_type=0;
   strcpy(ein_name,"");
   strcpy(aus_name,"");

   for (i=1;i<argc;i++)
   {
      if(locate_substring("-i",argv[i])==0)
      {
          if (strlen(ein_name)>0)
          {
              hilfe();
              return 1;
          }
          extract_subs(ein_name,argv[i],2,PFAD_LEN);
      }
      if(locate_substring("-o",argv[i])==0)
      {
          if (strlen(aus_name)>0)
          {
              hilfe();
              return 1;
          }
          extract_subs(aus_name,argv[i],2,PFAD_LEN);
      }
      if (locate_substring("-l",argv[i])==0)
      {
         if (procedure_type != 0)
         {
              hilfe();
              return 1;
         }
         procedure_type=1;
      }
      if (locate_substring("-s",argv[i])==0)
      {
         char zahlstring[ZAHL_LEN+1];
         int ok;

         if (procedure_type != 0)
         {
              hilfe();
              return 1;
         }
         extract_subs(zahlstring,argv[i],2,ZAHL_LEN);
         if (strlen(zahlstring) < 1)
         {
              hilfe();
              return 1;
         }
         string_in_long(zahlstring,&zeilenlaenge,&ok);
         if (!ok || zeilenlaenge<4 || zeilenlaenge > 999)
         {
              hilfe();
              return 1;
         }
         procedure_type=2;
      }
      if (locate_substring("-c",argv[i])==0)
      {
         if (procedure_type != 0)
         {
              hilfe();
              return 1;
         }
         procedure_type=3;
      }
   }
   if (procedure_type==0)
   {
       hilfe();
       return 1;
   }
   upper(ein_name);
   upper(aus_name);

   if (strlen(ein_name)==0)
   {
      fprintf(stderr,"\nProblem: no input file entered\n");
      return 1;
   }

   if (!strcmp(ein_name,aus_name))
   {
       fprintf(stderr,"\nProblem: identical names assigned to input file and "
                      "output file\n");
       return 1;
   }

   if (strlen(aus_name)>0)
   {
      if ((fpaus = fopen(aus_name,"rt"))!=NULL)
      {
        fclose(fpaus);
        fprintf(stderr,"\nProblem: file '%s' already exists \n",aus_name);
        return 1;
      }
   }

   if (!puffer_allokieren())
   {
      return 1;
   }

   strcpy(eingabezeile,"");
   strcpy(ausgabezeile,"");
   strcpy(puffer1,"");

   if (!dateien_oeffnen())
   {
      puffer_free();
      return 1;
   }
   if (!eingabedatei_lesen())
   {
      puffer_free();
      dateien_schliessen();
      return 1;
   }

   /* printf("\nPlease wait...\n"); */ 
   fprintf(stderr,"\nPlease wait...\n");

   fflush(stdout);

   if (procedure_type==3)
   {
      kopieren();
   }
   else if (procedure_type==1)
   {
     to_long();
   }
   else if (procedure_type==2)
   {
     to_short();
   }


   ausgabedatei_schreiben();

   dateien_schliessen();
   return 0;
}

int hilfe(void)
{
   printf("%s",HILFE_TEXT);
   return 0;
}

int puffer_allokieren(void)
{
   if ((eingabezeile=(char *) malloc((MAX_LEN + 1) * sizeof(char)))==NULL)
   {
      fprintf(stderr,"\nProblem: unable to allocate memory for buffer1\n");
      return 0;
   }
   if ((ausgabezeile=(char *) malloc((MAX_LEN + 1) * sizeof(char)))==NULL)
   {
      fprintf(stderr,"\nProblem: unable to allocate memory for buffer2\n");
      free(eingabezeile);
      return 0;
   }
   if ((puffer1=(char *) malloc((MAX_LEN + 1) * sizeof(char)))==NULL)
   {
      fprintf(stderr,"\nProblem: unable to allocate memory for buffer3\n");
      free(eingabezeile);
      free(ausgabezeile);
      return 0;
   }
   return 1;
}

int puffer_free(void)
{
   free(eingabezeile);
   free(ausgabezeile);
   free(puffer1);
   return 1;
}

int dateien_oeffnen(void)
{
   if ((fpein = fopen(ein_name,"rt"))==NULL)
   {
     fprintf(stderr,"\nProblem: cannot open for reading file '%s'\n",ein_name);
     return 0;
   }
   if (strlen(aus_name)==0)
   {
      fpaus=stdout;
   }
   else
   {
      if ((fpaus = fopen(aus_name,"wt"))==NULL)
      {
        fprintf(stderr,"\nProblem: cannot open for writing file '%s'\n",aus_name);
        fclose(fpein);
        return 0;
      }
   }
   return 1;
}

int dateien_schliessen(void)
{
   fclose(fpein);
   if (strlen(aus_name)>0)
   {
      fclose(fpaus);
   }
   return 1;
}

int eingabedatei_lesen(void)
{
    int zeichen;
    int i;

    i=0;
    do
    {
       zeichen=fgetc(fpein);
       if (zeichen!=EOF)
          eingabezeile[i]=zeichen;
       else eingabezeile[i] = '\0';
       i++;
       if (i>=MAX_LEN)
       {
          fprintf(stderr,"\nProblem: input file too long.\n");
          return 0;
       }
    } while (zeichen!=EOF);
    eingabezeile[i]='\0';
    return 1;
}

int kopieren(void)
{
   strcpy(ausgabezeile,eingabezeile);
   return 1;
}

int ausgabedatei_schreiben(void)
{

    int laenge;
    int i;

    laenge = strlen(ausgabezeile);
    for (i=0;i<laenge;i++)
    {
      fputc(ausgabezeile[i],fpaus);
    }
    return 1;

}

int to_long(void)
{
   int i;
   int laenge;
   int code;

   laenge=strlen(eingabezeile);
   if (laenge < 4)
   {
     strcpy(ausgabezeile,eingabezeile);
     return 1;
   }
   for(;;)
   {
        int posneu;
        posneu = 0;
        code = serepl(
                     eingabezeile,
                     " \n",
                     "\n",
                     MAX_LEN,
                     &posneu,
                     puffer1
                     );
        if ( code!=1) break;
   }

   for (i=0;i<laenge;i++)
   {
      if (eingabezeile[i]=='\n')
      {
         if (i==0)
         {
            ausgabezeile[i]='\n';
            ausgabezeile[i+1]='\0';
         }
         else if (i==laenge-1)
         {
            ausgabezeile[i]='\n';
            ausgabezeile[i+1]='\0';
         }
         else
         {
           if (eingabezeile[i-1]=='\n' || eingabezeile[i+1]=='\n' ||
               eingabezeile[i-1]=='\f' || eingabezeile[i+1]=='\f')
           {
              ausgabezeile[i]='\n';
              ausgabezeile[i+1]='\0';
           }
           else
           {
              ausgabezeile[i]=' ';
              ausgabezeile[i+1]='\0';
           }
         }
      }
      else
      {
          ausgabezeile[i]=eingabezeile[i];
          ausgabezeile[i+1]='\0';
      }
   }
   return 1;
}

int to_short(void)
{
   int i;
   char zle[2];
   int in_text;
   int laenge;

   laenge=strlen(eingabezeile);
   strcat(puffer1,"");

   if (laenge < 4)
   {
     strcpy(ausgabezeile,eingabezeile);
     return 1;
   }

   in_text = 1;

   strcpy(puffer1,"");

   for (i=0;i<laenge;i++)
   {

      if (i==0)
      {
         if (eingabezeile[i]=='\n')
         {
            zle[0]='\n';
            zle[1]='\0';
            strcat(ausgabezeile,zle);
            in_text = 0;
            continue;
         }
      }


      if (eingabezeile[i]=='\n')
      {
         if (!in_text)
         {
            zle[0]='\n';
            zle[1]='\0';
            strcat(ausgabezeile,zle);
         }
         else
         {
            wwrap(puffer1,zeilenlaenge);
            strcat(ausgabezeile,puffer1);
            zle[0]='\n';
            zle[1]='\0';
            strcat(ausgabezeile,zle);
            strcpy(puffer1,"");
            in_text=0;
         }
      }
      else
      {
         if (!in_text)
         {
            in_text=1;
         }
         zle[0] = eingabezeile[i];
         zle[1] = '\0';
         strcat(puffer1,zle);
      }
   } /* for... */

   if (strlen(puffer1) > 0)
   {
      wwrap(puffer1,zeilenlaenge);
      strcat(ausgabezeile,puffer1);
      /* Bei fehlendem terminalem Zeilenendezeichen... */
   }
   return 1;
}
