#include <stdio.h>
#include <conio.h>
#include <ctype.h>
#include <stdlib.h>
#include <dos.h>
#include <string.h>

extern void normal(void);
extern void read(char filename[]);
void run2(void);
extern void readdata(char ext[]);
extern void readinst(char filename[]);
extern int sort_function( const void *a, const void *b);
void white(void);

extern void sperling(void) {

 char choice;

 for(;;) {
  normal();
  _setcursortype(_NOCURSOR);
  window(18,6,62,19);
  textbackground(LIGHTGRAY);
  clrscr();
  window(20,7,60,18);
  textcolor(WHITE);
  textbackground(BLUE);
  clrscr();
  gotoxy(15,2);
  cprintf("SPERLING MENU:");
  gotoxy(5,4);
  cprintf("1. Run the experiment");
  gotoxy(5,5);
  cprintf("2. Show individual results ");
  gotoxy(5,6);
  cprintf("3. Show SPSS ready file ");
  gotoxy(5,7);
  cprintf("4. Details of design");
  gotoxy(5,8);
  cprintf("5. References for further reading");
  gotoxy(5,9);
  cprintf("6. Return to main menu");
  gotoxy(2,12);
  cprintf("Enter choice (1-6)");

  Repeat:
  choice=getch();
  switch (choice) {
   case '1': run2();break;
   case '2': readdata(".spe");break;
   case '3': read("Sperling.cat");break;
   case '4': read("Spedets.txt");break;
   case '5': read("Sperefs.txt");break;
   case '6': return;
   default: goto Repeat;
  }
 }
}




 /*RUN2(): Runs the experiment */
 void run2(void)
 {
  char *strng;
  float value,temp;
  int dec, sign;
  int ndig = 1;
  char topline[220][10], midline[220][10], botline[220][10];
  char ptopline[30][10], pmidline[30][10], pbotline[30][10];
  int prnum1[30],rnum1[220], compare, rn;
  char tempstr[10], response[10];
  float PC1,PC2,PC3,PC4,PC5;
  int total1=0,total2=0,total3=0,total4=0,total5=0;
  int num1=0,num2=0,num3=0,num4=0,num5=0;
  int pcond[30],cond[300],pause;
  int count,a,i,sexno, x, y, comp;
  int rnumber, rnum[300],let;
  char init[5], sex,aword[10];
  char sexstr[2];
  char filename[20],filetemp[20],fileinfo[20];
  char ch_ins, quit, cha, resp,let1,let2;
  char ch, string[80];
  FILE *fpins,*fpmaster,*fpdat;
  struct find_t ffblk;

  normal();


  /* record personal data */

   for(;;) {
    textcolor(WHITE);

    do{
     clrscr();
     printf("\nPlease, enter up to four initials\n(press 'enter' when finished): ");
     gets(init);
    } while (strlen(init)>4);

    do {
     clrscr();
     printf("\nMale or female? (just press 'm' or 'f'): ");
     sex=getche();
     delay(300);
    } while (tolower(sex)!='m'&&tolower(sex)!='f');
    sexstr[0]=sex;
    sexstr[1]=0;




    do {
     clrscr();
     printf("\nInitials: %s\nSex: %c\n",init, sex);
     printf("\nAre these correct? (press 'y' or 'n')");
     resp=getche();
    } while (tolower(resp)!='y' && tolower(resp)!='n');

    if (tolower(resp)=='y') break;
    clrscr();
   }


   /*CHECK IF THE FILE EXISTS, ADD NUMBER AND SAVE*/

   value=0;
   ndig=1;
   strcpy(filename,init);
   strcat(filename,sexstr);

   for(;;){
    strcpy(filetemp,filename);
    if(value>9) ndig=2;
    strng = ecvt(value, ndig, &dec, &sign);
    strcat(filetemp,strng);
    strcpy(fileinfo,filetemp);
    strcat(filetemp,".SPE");
    if(ch=='q') exit(0);
    if(!_dos_findfirst(filetemp,_A_NORMAL,&ffblk)) value++;
    else break;
   }


   if((fpdat=fopen(filetemp,"w"))==NULL) {
    printf("Error: Cannot open %s file",filename);
    exit(1);
   }

   fprintf(fpdat,"Initials: %s \nSex: %c\n",init,sex);
   fclose(fpdat);
   clrscr();


    /* instructions */

   readinst("speins.txt");
   white();
   delay(500);






    /* create letters */

   randomize();
   y=0;
   for(x=0;x<100;x++) {   //change
    for(a=0;a<12;) {
     comp=0;
     rnumber=random(26);
     for(i=0;i<a;i++) if(rnumber==rnum[i]) comp++;
     if(!comp) {
      rnum[a]=rnumber;
      a++;
     }
    }

    for(a=0;a<12;a++) rnum[a]=rnum[a]+65;


    for(a=0;;a++) {
     if(a==4) {
      if(y>4) y=0;
      y++;
      cond[x]=y;
      topline[x][2*a]=0;
      midline[x][2*a]=0;
      botline[x][2*a]=0;
      break;
     }
     else {
      topline[x][2*a]= (char) rnum[a];
      topline[x][2*a+1]=' ';
      midline[x][2*a]= (char) rnum[a+4];
      midline[x][2*a+1]= ' ';
      botline[x][2*a]= (char) rnum[a+8];
      botline[x][2*a+1]= ' ';
     }
    }
   }


   for(a=0;a<100;) {        //change
    comp=0;
    rnumber=random(100);            //change
    for(i=0;i<a;i++) if(rnumber==rnum1[i]) comp++;
    if(comp==0) {
     rnum1[a]=rnumber;
     a++;
    }
   }

   /*practice trials letters*/
   y=0;
   for(x=0;x<20;x++) {   //change
    for(a=0;a<12;) {
     comp=0;
     rnumber=random(26);
     for(i=0;i<a;i++) if(rnumber==rnum[i]) comp++;
     if(!comp) {
      rnum[a]=rnumber;
      a++;
     }
    }

    for(a=0;a<12;a++) rnum[a]=rnum[a]+65;


    for(a=0;;a++) {
     if(a==4) {
      if(y>4) y=0;
      y++;
      pcond[x]=y;
      ptopline[x][2*a]=0;
      pmidline[x][2*a]=0;
      pbotline[x][2*a]=0;
      break;
     }
     else {
      ptopline[x][2*a]= (char) rnum[a];
      ptopline[x][2*a+1]=' ';
      pmidline[x][2*a]= (char) rnum[a+4];
      pmidline[x][2*a+1]= ' ';
      pbotline[x][2*a]= (char) rnum[a+8];
      pbotline[x][2*a+1]= ' ';
     }
    }
   }


   for(a=0;a<20;) {        //change
    comp=0;
    rnumber=random(20);            //change
    for(i=0;i<a;i++) if(rnumber==prnum1[i]) comp++;
    if(comp==0) {
     prnum1[a]=rnumber;
     a++;
    }
   }


   /*PRACTICE TRIALS*/

   _setcursortype(_NOCURSOR);

     /* present fixation field*/

   for(a=0;a<20;a++) {     //change

    switch(pcond[prnum1[a]]) {
     case 1: pause=0;break;
     case 2: pause=100;break;
     case 3: pause=250;break;
     case 4: pause=500;break;
     case 5: pause=750;break;
    }


    gotoxy(30,10);
    cprintf("---------");
    gotoxy(30,14);
    cprintf("---------");
    delay(500);
    clrscr();

     /*present stimuli*/
    gotoxy(31,11);
    printf("%s", ptopline[prnum1[a]]);
    gotoxy(31,12);
    printf("%s", pmidline[prnum1[a]]);
    gotoxy(31,13);
    printf("%s", pbotline[prnum1[a]]);
    delay(100);
    clrscr();

    delay(pause);

    /*sound */

    rn=random(3);
    switch(rn) {
     case 0: sound(50);strcpy(tempstr,pbotline[prnum1[a]]);break;
     case 1: sound(200);strcpy(tempstr,pmidline[prnum1[a]]);break;
     case 2: sound(900);strcpy(tempstr,ptopline[prnum1[a]]);break;
    }
    delay(200);
    nosound();

    /* get response */
    _setcursortype(_NORMALCURSOR);
    while(kbhit()) getch();
    do{
     clrscr();
     gets(response);
    } while (strlen(response)>4);

    for(x=0;x<strlen(response);x++)
     for(y=0;y<x;y++) if(response[x]==response[y]) response[x]=' ';

    compare=0;
    for(x=0;x<strlen(response);x++)
     for(y=0;y<8;y=y+2) if(toupper(response[x])==tempstr[y]) compare++;

    _setcursortype(_NOCURSOR);
    clrscr();
    /*give feedback*/

    gotoxy(20,10);
    printf("You had %d correct letters.", compare);
    gotoxy(22,12);
    printf("Target line: %s",tempstr);
    gotoxy(22,13);
    printf("Your response: %s", response);
    gotoxy(1,25);
    printf("Press any key to continue...");
    while(kbhit()) getch();
    getch();
    clrscr();
   }



     /* Pause between sessions*/
   normal();
   gotoxy(1,25);
   cprintf("Press any key to go on to experimental trials...");
   window(1,1,80,24);
   textcolor(BLACK);
   textbackground(LIGHTGRAY);
   clrscr();

   if((fpins=fopen("speins2.txt","r"))==NULL) {
    printf("Cannot open 'FININST.TXT' file!");
    exit(1);
   }

   while((ch_ins=fgetc(fpins))!=EOF) putchar(ch_ins);
   fclose(fpins);
   while(kbhit()) getch();
   getch();
   white();
   delay(500);




     /* EXPERIMENTAL TRIALS*/


   _setcursortype(_NOCURSOR);

     /* present fixation field*/

   for(a=0;a<100;a++) {

    switch(cond[rnum1[a]]) {
     case 1: pause=0;break;
     case 2: pause=100;break;
     case 3: pause=250;break;
     case 4: pause=500;break;
     case 5: pause=750;break;
    }

    gotoxy(30,10);
    cprintf("---------");
    gotoxy(30,14);
    cprintf("---------");
    delay(500);
    clrscr();

     /*present stimuli*/
    gotoxy(31,11);
    printf("%s", topline[rnum1[a]]);
    gotoxy(31,12);
    printf("%s", midline[rnum1[a]]);
    gotoxy(31,13);
    printf("%s", botline[rnum1[a]]);
    delay(100);
    clrscr();

    /* delay between a stimulus and a response cue*/

    delay(pause);

    /*sound */

    rn=random(3);
    switch(rn) {
     case 0: sound(50);strcpy(tempstr,botline[rnum1[a]]);break;
     case 1: sound(200);strcpy(tempstr,midline[rnum1[a]]);break;
     case 2: sound(900);strcpy(tempstr,topline[rnum1[a]]);break;
    }
    delay(200);
    nosound();

    /* get response */
    _setcursortype(_NORMALCURSOR);
    while(kbhit()) getch();
    do{
     clrscr();
     gets(response);
    } while (strlen(response)>4);

    for(x=0;x<strlen(response);x++)
     for(y=0;y<x;y++) if(response[x]==response[y]) response[x]=' ';

    compare=0;
    for(x=0;x<strlen(response);x++)
     for(y=0;y<8;y=y+2) if(toupper(response[x])==tempstr[y]) compare++;

    switch(cond[rnum1[a]]) {
     case 1: num1++;total1=total1+compare;break;
     case 2: num2++;total2=total2+compare;break;
     case 3: num3++;total3=total3+compare;break;
     case 4: num4++;total4=total4+compare;break;
     case 5: num5++;total5=total5+compare;break;
    }



    _setcursortype(_NOCURSOR);
    clrscr();


    /*pause after every 20 trials*/
    if(a>0 && a%20==0) {
     clrscr();
     printf("\a");
     gotoxy(20,10);
     printf("Have a short rest.\n");
     gotoxy(1,25);
     printf("Press any key to continue...");
     getch();
     clrscr();
     delay(500);
    }

    delay(500);
   }

   //Calculate results
   if(total1)PC1=(100*total1)/(num1*4);
   else PC1=0;
   if(total2)PC2=(100*total2)/(num2*4);
   else PC2=0;
   if(total3)PC3=(100*total3)/(num3*4);
   else PC3=0;
   if(total4)PC4=(100*total4)/(num4*4);
   else PC4=0;
   if(total5)PC5=(100*total5)/(num5*4);
   else PC5=0;

   /*Record results*/
   if((fpdat=fopen(filetemp,"a"))==NULL) {
    printf("Cannot open '%s' file!",filetemp);
    exit(1);
   }


   fprintf(fpdat,"\n\t\t\t\t  Percent correct");
   fprintf(fpdat,"\n   0ms. delay condition:\t  %6.2f",PC1);
   fprintf(fpdat,"\n 100ms. delay condition:\t  %6.2f",PC2);
   fprintf(fpdat,"\n 250ms. delay condition:\t  %6.2f",PC3);
   fprintf(fpdat,"\n 500ms. delay condition:\t  %6.2f",PC4);
   fprintf(fpdat,"\n 750ms. delay condition:\t  %6.2f",PC5);
   fclose(fpdat);

      /* Update master catalogue */
   if((fpmaster=fopen("sperling.cat","a"))==NULL) {
    printf("Error: Cannot open SPERLING.CAT file\n");
    exit(1);
   }
   if (tolower(sex)=='m') sexno=1;
   else if(tolower(sex)=='f') sexno=2;

   fprintf(fpmaster,"%4s %d %6.2f %6.2f %6.2f %6.2f %6.2f\n", init, sexno, PC1,PC2,PC3,PC4,PC5);
   fclose(fpmaster);





      /* END MESSAGE*/

   normal();
   _setcursortype(_NOCURSOR);
   window(9,8,71,17);
   textbackground(LIGHTGRAY);
   clrscr();
   window(10,9,70,16);
   textbackground(GREEN);
   textcolor(BLACK);
   clrscr();
   gotoxy(3,2);
   printf("THIS IS THE END OF THE EXPERIMENT");
   gotoxy(3,3);
   printf("YOUR SCORE IS %6.2f %% CORRECT",(PC1+PC2+PC3+PC4+PC5)/5);
   gotoxy(3,5);
   printf("Your complete results were saved in the '%s' file.",filetemp);
   while(kbhit()) getch();
   getch();
   return;






 }



