#include "list.h"


template <class T>
List<T>::List ()
{
	head = NULL ;
	tail = NULL ;
	currentNode = NULL ;
	previousNode = NULL ;
}

template <class T>
List<T>::List ( List<T>& copy )
{
	head = NULL ;
	tail = NULL ;
	currentNode = NULL ;
	previousNode = NULL ;
	
	this -> copy ( copy ) ;	
}

template <class T>
List<T>& List<T>::operator = ( List<T>& copy )
{
	if ( this != &copy )
	{
		deleteList () ;
		this -> copy ( copy ) ;
	}
	return *this ;
}	

template <class T>
List<T>::~List ()
{
	deleteList ();
}

template <class T>
void List<T>::copy ( List<T>& copy )
{
	for ( copy.start () ; ! copy.atEnd () ; copy.next () )
	{
		insertAtTail ( copy.current () ) ;
	}
}

template <class T>
void List<T>::deleteList ()
{
	while ( head != NULL )
	{
		ListNode<T>* old = head ;
		head = head -> next ;
		delete old ;
	}
	tail = NULL ;
	currentNode = NULL ;
	previousNode = NULL ;
}

template <class T>
bool List<T>::isEmpty ()
{
	return bool(head == NULL) ;
}

template <class T>
T& List<T>::itemAtHead ()
{
	if ( isEmpty () )
	{
		error( "empty list" ) ;
	}
	return head -> item ;
}

template <class T>
T& List<T>::itemAtTail ()
{
	if ( isEmpty() )
	{
		error( "empty list" ) ;
	}
	return tail -> item ;
}

template <class T>
void List<T>::start ()
{
	currentNode = head ;
	previousNode = NULL ;
}

template <class T>
void List<T>::next ()
{
	if ( currentNode == previousNode )
	{
		if ( previousNode )
		{
			currentNode = previousNode -> next ;
		}
		else
		{
			currentNode = head ;
		}
	}
	else
	{
		if ( currentNode )
		{
			previousNode = currentNode ;
			currentNode = currentNode -> next ;
		}
		else
		{
			error ( "at end of list" ) ;
		}
	}
}

template <class T>
T& List<T>::current ()
{
	if ( currentNode == NULL )
	{
		error ( "no current item" ) ;
	}
	return currentNode -> item ;
}

template <class T>
T List<T>::itemAtCurrent ()
{
	return current () ;
}

template <class T>
bool List<T>::atEnd ()
{
	return bool( currentNode == NULL ) ;
}

template <class T>
void List<T>::insertAtHead ( T item )
{
	head = new ListNode<T> ( item, head ) ;
	if ( tail == NULL )
	{
		tail = head ;
	}
	if ( currentNode == head -> next )
	{
		previousNode = head ;
	}
}

template <class T>
void List<T>::insertAtTail ( T item )
{
	ListNode<T>* newTail = new ListNode<T> ( item, NULL ) ;
	if ( isEmpty () )
	{
		head = tail = newTail ;
	}
	else
	{
		// if the list is not empty, tail is not NULL

		tail -> next = newTail ;
		tail = newTail ;
	}
}

template <class T>
void List<T>::insertBeforeCurrent ( T item )
{
	if ( isEmpty () )
	{
		// special case

		insertAtHead ( item ) ;
	}
	else if ( previousNode == currentNode )
	{
		error( "no current item" ) ;
	}
	else if ( previousNode )
	{
		previousNode -> insertAfter ( item ) ;
		if ( previousNode == tail )
		{
			tail = previousNode -> next ;
		}
		previousNode = previousNode -> next ;
	}
	else
	{
		insertAtHead ( item ) ;
	}
}

template <class T>
void List<T>::insertAfterCurrent ( T item )
{
	if ( previousNode == currentNode )
	{
		error( "no current item" ) ;
	}
	else if ( currentNode == NULL )
	{
		error( "at end of list" ) ;
	}
	else
	{
		currentNode -> insertAfter ( item ) ;
		if ( currentNode == tail )
		{
			tail = currentNode -> next ;
		}
	}
}

template <class T>
void List<T>::deleteHead ()
{
	if ( isEmpty () )
	{
		error ( "delete from empty list" ) ;
	}
	else
	{
		ListNode<T>* old = head ;
		head = head -> next ;		
		if ( currentNode == old )
		{
			currentNode = NULL ;
		}
		if ( previousNode == old )
		{
			previousNode = NULL ;
		}		
		delete old ;		
		if ( isEmpty () )
		{
			tail = NULL ;
		}		
	}
}

template <class T>
void List<T>::deleteTail ()
{
	if ( tail == NULL )
	{
		error( "delete from empty list" ) ;
	}
	else if ( tail == head )
	{
		delete tail ;
		head = NULL ;
		tail = NULL ;
	}
	else
	{
		ListNode<T>* newTail = head ;
		while ( newTail -> next != tail )
		{
			newTail = newTail -> next ;
		}
		if ( previousNode == tail )
		{
			previousNode = newTail ;
		}
		if ( currentNode == tail )
		{
			currentNode = previousNode ;
		}
		delete tail ;
		tail = newTail ;
	}
}

template <class T>
void List<T>::deleteCurrent ()
{
	if ( previousNode == currentNode )
	{
		error( "no current item" ) ;
	}
	else if ( currentNode == NULL )
	{
		error( "at end of list" ) ;
	}
	else if ( previousNode == NULL )
	{
		deleteHead () ;
	}
	else
	{
		previousNode -> deleteAfter () ;
		if ( currentNode == tail )
		{
			tail = previousNode ;
		}
		currentNode = previousNode ;
	}
}



