/*
   Maximalny rozmer textury 1024
   Pred 1. pouzitim treba volat glIni32();
 */

#include <stdlib.h>
#include <string.h>
#include <math.h>

#define XRES 640				//maximalne rozlisenie
#define YRES 480
#define VTEX 5000				//maximalna vyska ciary po transformaciach

#ifdef __WATCOMC__
#define M_PI 3.1415926 
#endif

#define PI M_PI

struct P4TD
{
	long int x, p;
	char h;
};
struct _2D
{
	long int x, y;
};
struct _3D
{
	float x, y, z;
};

//Inicializacna struktura
struct _IniGl32
{
	long int XMAX;				//rozmery okna do ktoreho sa kresli

	long int YMAX;
	long int maxvr;				//maximalny pocet vrcholov sceny

	long int maxpo;				//maximalny pocet polygonov

	long int maxtex;			//maximalny pocet textur

	float maxvzd;				//maximalna zobrazovana vzdialenost

	float _8per;				//nekonecno pre perspektivu

};

//Struktura pre pole polygonov
struct TPol
{
	long int i1, i2, i3, i4;	//index do pola bodov

	long int t1, t2;			//ID textury

	float d;					//hranicna vzdialenost pre pouzitie 2. textury

	char c;						//farba ak polygon je jednofarebny

	char f;						//priznak obsadenosti

};

//Struktura pre zoznam polygonov
struct TZPol
{
	long int i1, i2, i3, i4;
	long int t;
	float n;					//najvzdialenejsia suradnica

	char c;
	struct TZPol *next;
};

//Struktura pre pole vrcholov
struct TVrch
{
	float x, y, z;				//suradnice bodu

	long int ID;				//0-neobsadeny,>=16 id cislo

};

//Struktura pre pole textur
struct TTex
{
	char *a;					//adresa textury

	long int ID;				//priznak obsadenia 0-neobsadena ,>=16 id cislo

};

//Struktura pre transformaciu objektu
struct TOStat
{
	float ux, uy, uz;			//uhly otocenia okolo jednotlivych osi

	float ox, oy, oz;			//absolutne suradnice stredu otacania

	float dx, dy, dz;			//relativne suradnice posunutia objektu

	float m;					//zmena mierky vzhladom na stred otacania

};


long int XMAX = 320;
long int YMAX = 200;
long int maxvr = 1000;
long int maxpo = 1000;
long int maxtex = 100;
float _8per = 1000, maxvzd = 800;
char *vm32 = NULL;
struct TPol *PPol = NULL;
struct TVrch *PVrch = NULL, *PTVr = NULL;
struct TTex *PTex = NULL;
struct TZPol *ZPol = NULL;

struct P4TD a1[YRES], a2[YRES], a3[YRES], a4[YRES];
long int yr[YRES], yl[YRES];


void P4T(struct _2D, struct _2D, struct _2D, struct _2D, char *);
void Poly3(struct _2D, struct _2D, struct _2D, char);

//h velkost hlavicky kresliaceho okna
//vrati adresu kres. okna, ak NULL ALLOC_ERR
char *glIni32(struct _IniGl32 * r, long int h)
{
	char *p;
	struct TVrch *o;
	struct TPol *t;
	struct TTex *x;

	if (vm32 != NULL)
		free(vm32);
	if (PPol != NULL)
		free(PPol);
	if (PVrch != NULL)
		free(PVrch);
	if (PTex != NULL)
		free(PTex);
	if (PTVr != NULL)
		free(PTVr);
	XMAX = r->XMAX;
	YMAX = r->YMAX;
	maxvr = r->maxvr;
	maxpo = r->maxpo;
	_8per = r->_8per;
	maxtex = r->maxtex;
	maxvzd = r->maxvzd;
	if ((p = (char *) malloc(XMAX * YMAX + h)) == NULL)
		return NULL;
	vm32 = p + h;
	if ((PPol = (struct TPol *) malloc(sizeof(struct TPol) * maxpo)) == NULL)
		return NULL;
	if ((PTex = (struct TTex *) malloc(sizeof(struct TTex) * maxtex)) == NULL)
		return NULL;
	if ((PVrch = (struct TVrch *) malloc(sizeof(struct TVrch) * maxvr)) == NULL)
		return NULL;
	if ((PTVr = (struct TVrch *) malloc(sizeof(struct TVrch) * maxvr)) == NULL)
		return NULL;
	for (o = PVrch; o < PVrch + maxvr; o++)
		o->ID = 0;
	for (o = PTVr; o < PTVr + maxvr; o++)
		o->ID = 0;
	for (t = PPol; t < PPol + maxpo; t++)
		t->f = 0;
	for (x = PTex; x < PTex + maxtex; x++)
		x->ID = 0;
	return p;
}

//Vyplni vm32
void glSetVM32(char v)
{
	memset(vm32, v, XMAX * YMAX);
}

//Prida vrchol do PVrch vrati >0-index do pola bodov, -1 neuspech
long int glAddVertex(struct _3D * r, long int ID)
{
	struct TVrch *p = PVrch;
	long int i = 0;

	while (p->ID && p < PVrch + maxvr)
	{
		p++;
		i++;
	}
	if (p >= PVrch + maxvr)
		return -1;
	p->x = r->x;
	p->y = r->y;
	p->z = r->z;
	p->ID = ID;
	return i;
}

//Prida polygon do PPol  0-OK, -1 neuspech
int glAddPoly(long int i1, long int i2, long int i3, long int i4, long int t1, long int t2, float d, char c)
{
	struct TPol *p = PPol;

	while (p->f && p < PPol + maxpo)
		p++;
	if (p >= PPol + maxpo)
		return -1;
	p->i1 = i1;
	p->i2 = i2;
	p->i3 = i3;
	p->i4 = i4;
	p->t1 = t1;
	p->t2 = t2;
	p->d = d;
	p->c = c;
	p->f = 1;
	return 0;
}

//Prida texturu do PTex 0-OK, -1 ERR
int glAddTex(char *a, long int ID)
{
	struct TTex *p = PTex;

	while (p->ID && p < PTex + maxtex)
		p++;
	if (p >= PTex + maxtex)
		return -1;
	p->a = a;
	p->ID = ID;
	return 0;
}

//Zmazanie jedneho prvku zoznamu ZPol
void DelZPol(struct TZPol * d)
{
	struct TZPol *p = ZPol, *pr;

	if (p == d)
	{
		ZPol = ZPol->next;
		free(p);
		return;
	}
	p = p->next;
	pr = ZPol;
	while (p != d)
	{
		pr = p;
		p = p->next;
	}
	pr->next = p->next;
	free(p);
}

//Tuto funkciu treba volat pre vsetky objekty na scene
void glTransObj(struct TOStat * o, long int ID)
{
	struct TVrch *p, *pp = PTVr;
	float sx, sy, sz, cx, cy, cz, f;

	if (o->ux != 0)
	{
		sx = sin(PI / 180 * o->ux);
		cx = cos(PI / 180 * o->ux);
	}
	if (o->uy != 0)
	{
		sy = sin(PI / 180 * o->uy);
		cy = cos(PI / 180 * o->uy);
	}
	if (o->uz != 0)
	{
		sz = sin(PI / 180 * o->uz);
		cz = cos(PI / 180 * o->uz);
	}
	for (p = PVrch; p < PVrch + maxvr; p++)
	{
		if (p->ID == ID)
		{
			*(pp) = *(p);
			if (o->m != 1)
			{
				pp->x = o->ox + (pp->x - o->ox) * o->m;
				pp->y = o->oy + (pp->y - o->oy) * o->m;
				pp->z = o->oz + (pp->z - o->oz) * o->m;
			}
			if (o->uz != 0)
			{
				pp->x -= o->ox;
				pp->y -= o->oy;
				f = pp->x;
				pp->x = f * cz - pp->y * sz;
				pp->y = f * sz + pp->y * cz;
				pp->x += o->ox;
				pp->y += o->oy;
			}
			if (o->uy != 0)
			{
				pp->x -= o->ox;
				pp->z -= o->oz;
				f = pp->x;
				pp->x = f * cy - pp->z * sy;
				pp->z = f * sy + pp->z * cy;
				pp->x += o->ox;
				pp->z += o->oz;
			}
			if (o->ux != 0)
			{
				pp->y -= o->oy;
				pp->z -= o->oz;
				f = pp->y;
				pp->y = f * cx - pp->z * sx;
				pp->z = f * sx + pp->z * cx;
				pp->y += o->oy;
				pp->z += o->oz;
			}
			pp->x += o->dx;
			pp->y += o->dy;
			pp->z += o->dz;
		}
		pp++;
	}
}

//Najde adresu textury podla ID
char *GetAdrTex(long int ID)
{
	struct TTex *t = PTex;

	while (t->ID != ID && t < PTex + maxtex)
		t++;
	if (t >= PTex + maxtex)
		return NULL;
	return t->a;
}

//Zobrazenie sceny  ox,oy,oz-poloha pozorovatela
int glCamera(struct TOStat * o)
{
	struct TVrch *pv;
	struct TPol *pp;
	float sx, sy, sz, cx, cy, cz, f, u1, u2, v1, v2;
	char i, *k;
	struct TZPol *j, *jj;
	long int vx = XMAX >> 1;
	struct _2D b1, b2, b3, b4;

	sx = sin(PI / 180 * o->ux);
	cx = cos(PI / 180 * o->ux);
	sy = sin(PI / 180 * o->uy);
	cy = cos(PI / 180 * o->uy);
	sz = sin(PI / 180 * o->uz);
	cz = cos(PI / 180 * o->uz);
	for (pv = PTVr; pv < PTVr + maxvr; pv++)
		if (pv->ID)
		{
			pv->x = (pv->x - o->ox) * o->m;		//posunutie do polohy pozorovatela a zmena mierky

			pv->y = (pv->y - o->oy) * o->m;
			pv->z = (pv->z - o->oz) * o->m;
			if (o->uz != 0)
			{
				f = pv->x;
				pv->x = f * cz - pv->y * sz;
				pv->y = f * sz + pv->y * cz;
			}
			if (o->uy != 0)
			{
				f = pv->x;
				pv->x = f * cy - pv->z * sy;
				pv->z = f * sy + pv->z * cy;
			}
			if (o->ux != 0)
			{
				f = pv->y;
				pv->y = f * cx - pv->z * sx;
				pv->z = f * sx + pv->z * cx;
			}
			pv->x *= 1 - pv->y / _8per;		//perspektiva

			pv->z *= 1 - pv->y / _8per;
		}

	pv = PTVr;
	for (pp = PPol; pp < PPol + maxpo; pp++)
		if (pp->f)
		{
			i = 1;
			u1 = pv[pp->i2].x - pv[pp->i1].x;
			u2 = pv[pp->i2].z - pv[pp->i1].z;
			v1 = pv[pp->i2].x - pv[pp->i3].x;
			v2 = pv[pp->i2].z - pv[pp->i3].z;
			if (u1 * v2 - u2 * v1 >= 0)
				i = 0;
			f = pv[pp->i1].y;
			if (f < pv[pp->i2].y)
				f = pv[pp->i2].y;
			if (f < pv[pp->i3].y)
				f = pv[pp->i3].y;
			if (f < pv[pp->i4].y)
				f = pv[pp->i4].y;
			if (f < 0 || f > maxvzd)
				i = 0;
			if (i)
			{
				if ((j = (struct TZPol *) malloc(sizeof(struct TZPol))) == NULL)
					return -1;
				j->next = ZPol;
				ZPol = j;
				j->i1 = pp->i1;
				j->i2 = pp->i2;
				j->i3 = pp->i3;
				j->i4 = pp->i4;
				j->n = f;
				j->c = pp->c;
				if (f < pp->d)
					j->t = pp->t1;
				else
					j->t = pp->t2;
			}
		}

	while (ZPol != NULL)
	{
		j = jj = ZPol;
		while (jj != NULL)
		{
			if (j->n < jj->n)
				j = jj;
			jj = jj->next;
		}
		b1.x = vx + pv[j->i1].x + o->dx;
		b1.y = YMAX - (pv[j->i1].z + o->dz);
		b2.x = vx + pv[j->i2].x + o->dx;
		b2.y = YMAX - (pv[j->i2].z + o->dz);
		b3.x = vx + pv[j->i3].x + o->dx;
		b3.y = YMAX - (pv[j->i3].z + o->dz);
		b4.x = vx + pv[j->i4].x + o->dx;
		b4.y = YMAX - (pv[j->i4].z + o->dz);
		switch (j->t)
		{
			case 1:
				Poly3(b1, b2, b3, j->c);
				Poly3(b1, b3, b4, j->c);
				break;			//jednofarebny polygon

			default:
				k = GetAdrTex(j->t);
				if (k != NULL)
					P4T(b1, b2, b3, b4, k);
		}
		DelZPol(j);
	}

	return 0;
}


void P4TL(struct _2D b1, struct _2D b2, char n, long int pp2)
{
	static long int q[VTEX];
	long int qcnt = 0, pp1, *qq, c, i, kx, ky, dx, dy;
	struct P4TD *g;

	pp1 = labs(b2.y - b1.y) + 1;
	pp2++;
	qq = q;
	if (pp1 > pp2)
	{							//zvacsujeme texturu

		c = pp1 - 1;
		for (i = 0; i < pp1; i++)
		{
			if (qq >= q && qq < q + VTEX)
				*(qq) = qcnt;
			c -= pp2;
			if (c < 0)
			{
				c += pp1;
				qcnt++;
			}
			qq++;
		}
	}
	else
	{							//zmensujeme texturu

		c = pp2 - 1;
		for (i = 0; i < pp2; i++)
		{
			if (qq >= q && qq < q + VTEX)
				*(qq) = qcnt;
			c -= pp1;
			if (c < 0)
			{
				c += pp2;
				qq++;
			}
			qcnt++;
		}
	}

	switch (n)
	{
		case 1:
			g = a1;
			break;
		case 2:
			g = a2;
			break;
		case 3:
			g = a3;
			break;
		case 4:
			g = a4;
			break;
	}

	if (b1.x < b2.x)
		kx = 1;
	else
		kx = -1;
	if (b1.y < b2.y)
		ky = 1;
	else
		ky = -1;
	dx = labs(b1.x - b2.x);
	dy = labs(b1.y - b2.y);
	qq = q;
	g += b1.y;
	if (dx > dy)
	{
		c = dx - 1;
		for (i = 0; i <= dx; i++)
		{
			if (b1.y >= 0 && b1.y < YMAX && !g->h)
			{
				g->x = b1.x;
				g->h = 1;
				g->p = *(qq);
			}
			c -= dy;
			if (c < 0)
			{
				c += dx;
				b1.y += ky;
				g += ky;
				qq++;
			}
			b1.x += kx;
		}
	}
	else
	{
		c = dy - 1;
		for (i = 0; i <= dy; i++)
		{
			if (b1.y >= 0 && b1.y < YMAX)
			{
				g->x = b1.x;
				g->h = 1;
				g->p = *(qq);
			}
			c -= dx;
			if (c < 0)
			{
				c += dy;
				b1.x += kx;
			}
			b1.y += ky;
			g += ky;
			qq++;
		}
	}
}

void P4T(struct _2D b1, struct _2D b2, struct _2D b3, struct _2D b4, char *o)
{
	long int ox, oy, miny = b1.y, maxy = b1.y, i, minx = b1.x, maxx = b1.x,
	  tx, ty, txx, tyy, kx, ky, dx, dy, j, c, pp1, pp2;
	struct P4TD *g1, *g2, *g3, *g4;
	char *adr, ini, mini, maxi, *texp, *oo, *aa;
	static char tex[1024];

	ox = (long int) (*(o + 1) * 256 + *(o)) - 1;
	oy = (long int) (*(o + 3) * 256 + *(o + 2)) - 1;

	if (minx > b2.x)
		minx = b2.x;
	if (maxx < b2.x)
		maxx = b2.x;
	if (minx > b3.x)
		minx = b3.x;
	if (maxx < b3.x)
		maxx = b3.x;
	if (minx > b4.x)
		minx = b4.x;
	if (maxx < b4.x)
		maxx = b4.x;
	if (minx >= XMAX || maxx < 0)
		return;

	if (miny > b2.y)
		miny = b2.y;
	if (maxy < b2.y)
		maxy = b2.y;
	if (miny > b3.y)
		miny = b3.y;
	if (maxy < b3.y)
		maxy = b3.y;
	if (miny > b4.y)
		miny = b4.y;
	if (maxy < b4.y)
		maxy = b4.y;

	if (miny >= YMAX)
		return;					//pod zobrazovacim oknom

	if (maxy < 0)
		return;					//nad zobrazaovacim oknom

	if (miny < 0)
		miny = 0;
	if (maxy >= YMAX)
		maxy = YMAX - 1;

	g1 = a1 + miny;
	g2 = a2 + miny;
	g3 = a3 + miny;
	g4 = a4 + miny;
	for (i = miny; i <= maxy; i++)
	{
		g1->h = g2->h = g3->h = g4->h = 0;
		g1++;
		g2++;
		g3++;
		g4++;
	}

	if (b1.y != b2.y)
		P4TL(b1, b2, 1, oy);
	if (b2.y != b3.y)
		P4TL(b2, b3, 2, ox);
	if (b3.y != b4.y)
		P4TL(b4, b3, 3, oy);
	if (b4.y != b1.y)
		P4TL(b1, b4, 4, ox);

	adr = vm32 + miny * XMAX;
	g1 = a1 + miny;
	g2 = a2 + miny;
	g3 = a3 + miny;
	g4 = a4 + miny;
	for (i = miny; i <= maxy; i++)
	{
		ini = 0;
		if (g1->h)
		{
			minx = maxx = g1->x;
			ini = 1;
			mini = maxi = 1;
		}
		if (g2->h)
		{
			if (ini)
			{
				if (minx > g2->x)
				{
					minx = g2->x;
					mini = 2;
				}
				if (maxx < g2->x)
				{
					maxx = g2->x;
					maxi = 2;
				}
			}
			else
			{
				minx = maxx = g2->x;
				ini = 1;
				mini = maxi = 2;
			}
		}
		if (g3->h)
		{
			if (ini)
			{
				if (minx > g3->x)
				{
					minx = g3->x;
					mini = 3;
				}
				if (maxx < g3->x)
				{
					maxx = g3->x;
					maxi = 3;
				}
			}
			else
			{
				minx = maxx = g3->x;
				ini = 1;
				mini = maxi = 3;
			}
		}
		if (g4->h)
		{
			if (ini)
			{
				if (minx > g4->x)
				{
					minx = g4->x;
					mini = 4;
				}
				if (maxx < g4->x)
				{
					maxx = g4->x;
					maxi = 4;
				}
			}
			else
			{
				minx = maxx = g4->x;
				ini = 1;
				mini = maxi = 4;
			}
		}
		if (!ini)
			return;
		switch (mini)
		{
			case 1:
				tx = 0;
				ty = g1->p;
				break;
			case 2:
				tx = g2->p;
				ty = oy;
				break;
			case 3:
				tx = ox;
				ty = g3->p;
				break;
			case 4:
				tx = g4->p;
				ty = 0;
				break;
		}
		switch (maxi)
		{
			case 1:
				txx = 0;
				tyy = g1->p;
				break;
			case 2:
				txx = g2->p;
				tyy = oy;
				break;
			case 3:
				txx = ox;
				tyy = g3->p;
				break;
			case 4:
				txx = g4->p;
				tyy = 0;
				break;
		}

		texp = tex;
		if (tx < txx)
			kx = 1;
		else
			kx = -1;
		if (ty < tyy)
			ky = 1;
		else
			ky = -1;
		dx = labs(tx - txx);
		dy = labs(ty - tyy);
		oo = o + 4 + ty * (ox + 1);
		if (dx > ox || dy > oy)
			return;
		if (dx > dy)
		{
			pp2 = dx + 1;
			c = dx - 1;
			for (j = 0; j <= dx; j++)
			{
				*(texp) = *(oo + tx);
				texp++;
				c -= dy;
				if (c < 0)
				{
					c += dx;
					if (ky == 1)
						oo += (ox + 1);
					else
						oo -= (ox + 1);
				}
				tx += kx;
			}
		}
		else
		{
			pp2 = dy + 1;
			c = dy - 1;
			for (j = 0; j <= dy; j++)
			{
				*(texp) = *(oo + tx);
				texp++;
				c -= dx;
				if (c < 0)
				{
					c += dy;
					tx += kx;
				}
				if (ky == 1)
					oo += (ox + 1);
				else
					oo -= (ox + 1);
			}
		}

		pp1 = maxx - minx + 1;
		texp = tex;
		aa = adr + minx;
		if (pp1 > pp2)
		{
			c = pp1 - 1;
			for (j = 0; j < pp1; j++)
			{
				if (minx >= 0 && minx < XMAX)
					*(aa) = *(texp);
				c -= pp2;
				if (c < 0)
				{
					c += pp1;
					texp++;
				}
				minx++;
				aa++;
			}
		}
		else
		{
			c = pp2 - 1;
			for (j = 0; j < pp2; j++)
			{
				if (minx >= 0 && minx < XMAX)
					*(aa) = *(texp);
				c -= pp1;
				if (c < 0)
				{
					c += pp2;
					minx++;
					aa++;
				}
				texp++;
			}
		}

		adr += XMAX;
		g1++;
		g2++;
		g3++;
		g4++;
	}
}

void PLi(long int *dst, long int x, long int y, long int xx, long int yy)
{
	long int k, dx, dy, c, i;

	if (x > xx)
		k = -1;
	else
		k = 1;
	dx = labs(xx - x);
	dy = labs(yy - y);
	if (dx < dy)
	{
		c = dy - 1;
		dst += y;
		for (i = y; i <= yy; i++)
		{
			if (i >= 0 && i < YMAX)
				*(dst) = x;
			dst++;
			c -= dx;
			if (c < 0)
			{
				c += dy;
				x += k;
			}
		}
	}
	else
	{
		c = dx - 1;
		dst += y;
		for (i = 0; i <= dx; i++)
		{
			if (y >= 0 && y < YMAX)
				*(dst) = x;
			x += k;
			c -= dy;
			if (c < 0)
			{
				c += dx;
				y++;
				dst++;
			}
		}
	}
}

void Poly3(struct _2D b1, struct _2D b2, struct _2D b3, char f)
{
	struct _2D pom;
	long int i = 0, *ylp, *yrp, p;
	char *va;

	if (b1.y > b2.y)
	{
		pom = b1;
		b1 = b2;
		b2 = pom;
	}
	if (b1.y > b3.y)
	{
		pom = b1;
		b1 = b3;
		b3 = pom;
	}
	if (b2.y > b3.y)
	{
		pom = b2;
		b2 = b3;
		b3 = pom;
	}

	if (b1.y >= YMAX || b3.y < 0)
		return;

	if (b1.y != b3.y)
	{
		PLi(yl, b1.x, b1.y, b3.x, b3.y);
		i++;
	}
	if (b1.y != b2.y)
	{
		PLi(yr, b1.x, b1.y, b2.x, b2.y);
		i++;
	}
	if (b2.y != b3.y)
	{
		PLi(yr, b2.x, b2.y, b3.x, b3.y);
		i++;
	}
	if (i < 2)
		return;

	if (b1.y < 0)
		b1.y = 0;
	if (b3.y >= YMAX)
		b3.y = YMAX - 1;
	ylp = (yl + b1.y);
	yrp = (yr + b1.y);
	va = vm32 + (XMAX * b1.y);
	for (i = b1.y; i <= b3.y; i++)
	{
		if (*(ylp) > *(yrp))
		{
			p = *(ylp);
			*(ylp) = *(yrp);
			*(yrp) = p;
		}
		if (*(yrp) >= 0 && *(ylp) < XMAX)
		{
			if (*(ylp) < 0)
				*(ylp) = 0;
			if (*(yrp) >= XMAX)
				*(yrp) = XMAX - 1;
			memset(va + *(ylp), f, *(yrp) - *(ylp) + 1);
		}
		va += XMAX;
		ylp++;
		yrp++;
	}
}
