/* autogrph.c V. 2.0*/

/* identify type of video adapter being used (graphics types, only) and
return the identification code for that adapter.  This module is designed
to be compiled alone, and the object code bound into the auxgraph library
file.

calling  unsigned video_test ();

Version 1.0
	returns disp_a + disp_b << 8 for primary and secondary displays, 
	respectively.

Version 2.0
	changed header files and return variable for video_test () from
	unsigned to struct *.

	added code to detect ATT Display Enhancement Board
*/

/* copyright 1990 - 1992  Robert C. Becker, Lantern Systems */

#include <stdio.h>
#include <dos.h>
#include <string.h>
#include <conio.h>
#include "graph.h"
#include "hpgl.h"


#define		DEB_PORT	0x3da		/* port # for ATT graphics controller status port */

/* this structure is made visible to all other programs that use the
video_test () function call.  It is necessary because the function returns
a display type number which references an index into this table. */

struct video_type__ display_adapter__ [Num_Adapters];



static struct video_display video_adapter;

static int ps2_test ( void );
static int ega_test ( void );
static void cga_test ( void );
static int herc_test ( void );
static int att_test ( void );
static void assign_video_a ( unsigned );
static void assign_video_b ( unsigned );
static void init_videostr ( void );
static void init_adapters ( unsigned adr, unsigned type, struct _vid_x_parm_ *vid_mode, char * display);

static unsigned ega_mry;
static unsigned ps2vid[] = { NOGRAPHICS, NOGRAPHICS, CGA, NOGRAPHICS, CEGA, MEGA,
			PGC, MVGA, CVGA, NOGRAPHICS, EMCGA, CMCGA, CMCGA };

static unsigned ega_config[] = { CGA, CEGA, MEGA };	/* only need 3 of 6: order is same for last 3 configs */

static char attlogo[] = "OLIVETTI";
static char far *romid;
static char romstr [10];

static char copyright [] = "copyright 1990, 1991  Robert C. Becker, Lantern Systems";

static union REGS regs;

/*---------------------------------------*/

struct video_display *video_test ( void )
	{
	int j;

	init_videostr ();

	video_adapter.disp_a = video_adapter.disp_b = NOGRAPHICS;	/* initialize: no supported video graphics modes */

	if (ps2_test () > 1) return ( &video_adapter );
	/* done: VGA interrupt answered all questions */

	if ( !ega_test () ) 	/* returns 1 if EGA: if EGA, no CGA possible  */
		if ( !att_test () ) cga_test ();

	/* The value of the adapter returned by ega_test () is one of CEGA, CGA, MEGA.
	The CGA value is returned because an EGA adapter using a CGA monitor can't reproduce
	the high resolution graphics modes.  Also, because the adapter port adr's are
	programmable and change when using mono modes, we can't look for Herc cards if we
	have a mono EGA adapter since the ports overlap.  We test first for an ATT graphics
	adapter because it is basically a CGA adapter and will pass the CGA test.  By testing
	first for the ATT card, we can separate them. */

	/* if either display is MONO, No Herc cards possible */
	/* this includes the InColor card which uses the mono address space */
	if (( video_adapter.disp_a != NOGRAPHICS ) || ( video_adapter.disp_b != NOGRAPHICS )) return ( &video_adapter );
	if ( j = herc_test () )
		{
		if ( video_adapter.disp_a == NOGRAPHICS )
			assign_video_a (j);
		else
			/* never get here if disp_b already assigned */
			/* (another type of mono display would be present) */
			assign_video_b (j);
		}

	/* a complete video test would also determine which adapter is presently the
	primary display.  We don't care here, because we are going to take the highest
	resolution display and switch to it for graphics */

	return ( &video_adapter );
	}

/*---------------------------------------*/

int ps2_test ( void )	/* test for PS/2 VGA or MCGA  */
	{	/* returns # of displays found: 0 for none/unsupported */
	int i = 0;

	regs.x.ax = 0x1A00;		/* get video display configuration */
	int86 (VIDEO, &regs, &regs);
	if (regs.h.al != 0x1a)	return (0);	/* unsupported command */
	if (regs.h.bl > 0 && regs.h.bl <= 0x0C )	/* active display */
		{
		++i;	/* found one display */
		assign_video_b (ps2vid [regs.h.bl] );	/* type number */
		}
	if (regs.h.bh > 0 && regs.h.bh <= 0x0C )	/* inactive display */
		{
		assign_video_b (ps2vid [regs.h.bh]);	/* type number */
		return ( ++i);			/* found a display */
		}
	return (i);
	}

/*---------------------------------------*/

int ega_test ( void )		/* test for EGA display */
	{
	unsigned i;

	regs.x.ax = 0x1200;	/* code for Alternate Select */
	regs.h.bl = 0x10;	/* code for return EGA information */
	int86 (VIDEO, &regs, &regs);

	if (regs.h.bl == 0x10 )	return ( 0 );	/* No EGA present */
	i = regs.h.cl > 1;			/* bit 0 = don't care */
	i = (i > 2) ? i - 3: i;			/* fold repeated pattern into 1st three types */
	ega_mry = regs.h.bl;			/* EGA memory code */

	/* we have an EGA adapter, but find out how it is configured.  Need to
	know if it is EGA color, CGA color, or BW graphics */

	if (video_adapter.disp_a == NOGRAPHICS )	/* no prior active display identified */
		{
		assign_video_a ( ega_config [i] );
		return ( 1 );	/* return EGA found: do not test for CGA */
		}
	if ( video_adapter.disp_b == NOGRAPHICS )	/* no prior secondary display identified */
		{
		assign_video_b ( ega_config [i] );
		return ( 1 );		/* this is the alternative adapter: done searching */
		}
	return (0);
	}

/*---------------------------------------*/
void cga_test ( void )
	{
	unsigned cur_pos;
	int i, j;

	/* test for CGA by testing for 6845 CRTC chip at 0x3d4 */
	outp ( 0x3d4, 0x0F );	/* select cursor position low byte reg */
	cur_pos = (unsigned) inp (0x3d5);	/* read current value of cursor low reg */
	outp (0x3d5, 0x66);	/* arbitrary value */


	for (i = 0; i < 100; ++i) j = inp (0x3d5);	/* kill time */

	if (inp (0x3d5) == 0x66 )	/* have CGA */
		{
		outp ( 0x3d5, cur_pos );	/* restore cursor position */
		if (video_adapter.disp_a == NOGRAPHICS )
			{
			assign_video_a (CGA);
			assign_video_b (CGAM);
			return;
			}
		assign_video_b (CGA);	/* if we got here, then there is one other primary display */
		outp ( 0x3d5, cur_pos);	/* restore cursor position */
		}
	return;
	}

/*---------------------------------------*/

int herc_test ( void )
	{
	unsigned st, i;

	st = ( (unsigned) inp (0x3ba) ) & 0x70;	/* read Herc/MDA status reg. Get Herc ID bits */
	if ( st == 0x50 )		/* InColor card */
		return (INCOLOR);
	if ( st == 0x10 )		/* Herc Plus card */
		return (HGCPLUS);
	st = (unsigned) inp (0x3ba);	/* read status port */
	for (i = 0x3fff; i > 0; --i)	/* not a good idea to use clock speed dependent loops */
		{
		if ( (st ^ inp (0x3ba) ) & 0x80 )	/* test for changes in vert retrace bit (80h) */
			return ( HGC );	/* bit 7 changes: must be ordinary Herc card */
		}
	return ( NOGRAPHICS );	/* bit 7 does not change -> MDA card */
	}

/*---------------------------------------*/


static int att_test ( void )
	{
	char *str;
	int i;
	unsigned char c;
	unsigned type;

	FP_SEG (romid) = 0x0fc00;
	FP_OFF (romid) = 0x0050;
	str = romstr;
	for (i = 0; i < 8; ++i, ++str, ++romid) *str = *romid;
	*str = '\0';	/* terminate string */

/*	printf ("ROM ID string = %s\n", romstr);	*/
	if ( !strcmp (romstr, attlogo) )	/* BIOS ROM logo matches */
		{
		type = ATT;
		c = 0xFF & inp (DEB_PORT);		/* ATT CRT controller status reg */
		if ( !(c & 0x0c) ) type = ATT_DEB;	/* found a DEB */
		if (video_adapter.disp_a != NOGRAPHICS )
			{
			assign_video_b (type);
			return (1);
			}
		/* if we got here, then there is no other primary display */
		assign_video_a (type);
		return (1);
		}
	return (0);	/* not ATT */
	}


/*---------------------------------------*/

static void assign_video_a (unsigned type)
	{
	int adr;

	adr = 0x3f & type;
	/* trim off top two bits ( 0x80 = monochrome bit, 0x40 = reserved) */

	video_adapter.disp_a = (display_adapter__ [adr]).type;
	video_adapter.vid_mode_a = (display_adapter__ [adr]).vid_mode;
	video_adapter.display_a = (display_adapter__ [adr]).display;

	return;
	}

/*---------------------------------------*/

static void assign_video_b (unsigned type)
	{

	video_adapter.disp_b = (display_adapter__ [type]).type;
	video_adapter.vid_mode_b = (display_adapter__ [type]).vid_mode;
	video_adapter.display_b = (display_adapter__ [type]).display;

	return;
	}

/*---------------------------------------*/

static void init_videostr ( void )
	{

	init_adapters (NOGRAPHICS, NOGRAPHICS, CGA_320x200, "No Graphics" );
	init_adapters (CGA, CGA, CGA_320x200, "CGA 320x200" );
	init_adapters (CGAM, CGAM, CGA_640x200, "CGA 640x200, BW" );
	init_adapters (MEGA, MEGA, MEGA_640x350, "EGA 640x350, BW" );
	init_adapters (CEGA, CEGA, EGA_640x350, "EGA 640x350, 16 color" );
	init_adapters (MVGA, MVGA, MCGA_640x480, "VGA 640x480, BW" );	/* Mono MCGA */
	init_adapters (CVGA, CVGA, VGA_640x480, "VGA 640x480, 16 color" );
	init_adapters (EMCGA, EMCGA, MCGA_640x480, "MCGA w/ EGA monitor" );	/* MCGA w/ EGA monitor */
	init_adapters (MMCGA, MMCGA, MCGA_640x480, "MCGA 640x480, BW" );	/* Mono MCGA */
	init_adapters (CMCGA, CMCGA, MCGA_640x480, "MCGA 640x480, BW" );	/* Color MCGA */
	init_adapters (ATT, ATT, ATT_640x400, "ATT 640x400, BW" );
	init_adapters (ATT_DEB, ATT_DEB, ATTDEB_640x400, "ATT 640x400, 16 color" );
	init_adapters (PGC, NOGRAPHICS, VGA_640x480, "No Graphics" );	/* use VGA mode to fill struct */
	init_adapters (HGC, NOGRAPHICS, HGC_720x348, "Hercules" );
	init_adapters (HGCPLUS, NOGRAPHICS, HGC_720x348, "Hercules+" );
	init_adapters (INCOLOR, NOGRAPHICS, HGC_720x348, "Hercules InColor" );

	return;
	}

/*---------------------------------------*/

static void init_adapters ( unsigned adr, unsigned type, struct _vid_x_parm_ *vid_mode, char * display)
	{

	/* trim off top two bits ( 0x80 = monochrome bit, 0x40 = reserved) */

	adr &= 0x3F;

	(display_adapter__ [adr]).type = type;
	(display_adapter__ [adr]).vid_mode = vid_mode;
	(display_adapter__ [adr]).display = display;

	return;
	}

/*---------------------------------------*/
