/*
 *	ggets.c  -- get a string in graphic mode with echo
 *
 *	8 oct  1988  Olle
 */

#include <graphics.h>
#include <ctype.h>
#include <conio.h>

void ggets( register char *buf )
{
char c[2];
int n;
int chw, chh;
struct fillsettingstype fis;

/* get a string in graphic mode with echo */
/* assume TOP_TEXT & LEFT_TEXT justification */

/* get character size for erase */
chw = textwidth( "A" );
chh = textheight( "A" );

/* get fill settings */
getfillsettings( &fis );

/* setup for character erase */
setfillstyle( SOLID_FILL, getbkcolor() );

c[1] = '\0';

for ( n = 0;;)
	{
	c[0] = *buf++ = getch();

	if (isprint( c[0] ))
		{
		outtext( c );
		++n;
		}
	else if (c[0] == '\b' && n > 0)
		{
		buf -= 2; --n;
		/* erasing is a bit elaborate */
		moverel( -chw, 0 );

		/* fill with the background color */
		bar( getx(), gety(), getx() + chw - 1, gety() + chh - 1 );
		}
	else if (c[0] == '\b')
		--buf;
	else if (c[0] == '\r' || c[0] == '\n')
		{
		*--buf = '\0';
		break;
		}
	}

/* restore fill settings */
setfillstyle( fis.pattern, fis.color );
}

