/*
 *	unitsquare.c  --  unit square function for edtrans().
 *
 *	9 july 1989  Olle Olsson.
 */

#include "edtrans.h"

void unitsquare( dp, color, menu )
ifsdes *dp;		/* descriptor */
int color;		/* color to use */
menudescr *menu;	/* menu for edispall() */
{
int x0, x1, y0, y1;
register area *ap = &dp -> area;

/* find the coordinates */
/* (y is upside down) */
x0 = MAX_COL * (0 - ap -> xlow) / ap -> xlen;
x1 = MAX_COL * (1 - ap -> xlow) / ap -> xlen;
y0 = MAX_ROW * (1 - (0 - ap -> ylow) / ap -> ylen);
y1 = MAX_ROW * (1 - (1 - ap -> ylow) / ap -> ylen);

#ifdef UNITSQ_REDRAW
/* draw the the square, then the transforms on top */
gm_hide();
cleardevice();

setcolor( color );
setlinestyle( DOTTED_LINE, 0, NORM_WIDTH );
rectangle( x0, y0, x1, y1 );

edispall( dp, menu, 0, 0 );

#else
/* This will leave some debris where the transforms crosses
 * the unit square, but if there is a fractal displayed it won' be erased.
 */

gm_hide();
setcolor( color );
setlinestyle( DOTTED_LINE, 0, NORM_WIDTH );
rectangle( x0, y0, x1, y1 );
gm_show();

#endif
}

