/****************************************************************
** MODULE INFORMATION*
**********************
**      FILE    NAME:       PWINC.H
**      SYSTEM  NAME:       POWER
**      VERSION NUMBER      3.00
**
** DESCRIPTION: Main include file for
**              Programmer Oriented Window Environment Routines.
**              (NoC) July 1989 - Ling Thio Software Productions.
******************************************************************
** ADMINISTRATIVE INFORMATION*
******************************
**      ORIGINAL AUTHOR:    Ling Thio
**      CREATION DATE:      89/07/10
**      CHANGES:            none
*****************************************************************/

/* possibilities:   __TURBOC__
                    __MSC__
                    __MSC__ and __OS2__
                    __TSC__
                    __TSC__ and __OS2__     */

#ifdef __TSC__
#define cdecl
#endif

#if defined __MSC__ || defined __TSC__
#include <malloc.h>                         /* for _fmalloc(), _ffree() */
#include <memory.h>                         /* for memset */
#include <search.h>                         /* for qsort() */

#ifdef __OS2__
#define INCL_DOS
#define INCL_VIO                            /* for Vio*(), Kbd*(), Mou*() */
#define INCL_KBD
#define INCL_NOPM                           /* no presentation manager */
#ifdef MOUSE
#define INCL_MOU
#endif
#include <os2.h>                            /* for _dos_find*() */
#define PWA_NORMAL  FILE_NORMAL
#define PWA_RDONLY  FILE_READONLY
#define PWA_HIDDEN  FILE_HIDDEN
#define PWA_SYSTEM  FILE_SYSTEM
#define PWA_VOLID	0
#define PWA_SUBDIR  FILE_DIRECTORY
#define PWA_ARCH    FILE_ARCHIVED
extern HVIO pw_hvio;
#else
#include <dos.h>                            /* for _dos_find*() */
#define PWA_NORMAL  _A_NORMAL
#define PWA_RDONLY  _A_RDONLY
#define PWA_HIDDEN  _A_HIDDEN
#define PWA_SYSTEM  _A_SYSTEM
#define PWA_VOLID	_A_VOLID
#define PWA_SUBDIR  _A_SUBDIR
#define PWA_ARCH    _A_ARCH
#endif

#endif

#ifdef __TURBOC__
#include <alloc.h>
#include <mem.h>
#include <stdlib.h>                        /* for qsort() */
#include <dos.h>
#include <dir.h>
#define _fmalloc(a) farmalloc(a)
#define _ffree(a)   farfree(a)
#define PWA_NORMAL  0
#define PWA_RDONLY  FA_RDONLY   /* Read only attribute */
#define PWA_HIDDEN  FA_HIDDEN   /* Hidden file */
#define PWA_SYSTEM  FA_SYSTEM   /* System file */
#define PWA_VOLID	FA_LABEL    /* Volume label */
#define PWA_SUBDIR  FA_DIREC    /* Directory */
#define PWA_ARCH    FA_ARCH     /* Archive */
#endif

#include <stdio.h>
#define PWCELL      unsigned int
typedef struct pw_menu {
    int type;
    unsigned int status;
    int element;
} PWMENU;
typedef struct pw_window {
    int srow, scol;                         // start row, column
    int nrow, ncol;                         // # of rows, columns
    int crow, ccol;                         // current row, column
    int level;                              // window level
    PWCELL far *buffer;                     // window buffer
    PWCELL far *winptr;
    PWCELL far *scrptr;
    unsigned char far *levptr;
    unsigned int status;                    // window status
    char *header;                           // header/border text
    int wtype;                              // windowtype
    int ttype;                              // texttype
    int tsrow, tscol;                       // start row, column
    int tnrow, tncol;                       // # of rows, columns
    char *keyleft;                          // left side keyhelp
    char *keyright;                         // right side keyhelp
    PWMENU *menu;
} PWWIN;
#undef PWCELL
#define POWERLIB
#include "power3.h"                         /* programmer functions */
#undef POWERLIB
#include "pwdef.h"                          /* structs & defines */
#include "pwdcl.h"                          /* function declarations */
#include "pwglob.h"                         /* global vars decl */

/* PWSUTI.C */
extern unsigned int _pw_scrsegm;
extern PWKEY _pw_MouDefDefault[];

extern PWWIN *_pw_topwin;
extern FILE *_pw_helpfh;
extern char _pw_f1f9esc[];                  /* "F1=Help F9=Keys Esc=Cancel" */
extern int _pwcf_mode;
extern int _pwcf_mon;


