{$I-}
{$V-}
{$M 4096,0,0}

program update;

uses dos,crt;

const
  buflen = 4096;
  verbose       : boolean = false;
  adding        : boolean = false;
  dots          : boolean = false;
  dayold        : boolean = false;
  makereadwrite : boolean = false;
  makedestdir   : boolean = false;
  queryfirst    : boolean = false;
  makebackup    : boolean = false;
  testonly      : boolean = false;
  bootonupdate  : boolean = false;
  updated       : boolean = false;

var
  dirinfo                 : searchrec;
  srcdir,dstdir           : dirstr;
  srcname,dstname         : namestr;
  srcextn,dstextn         : extstr;
  param,i,numread,attrib  : word;
  thisparam               : string;
  srcfile,dstfile         : file;
  srcfilename,dstfilename : pathstr;
  dstexists,copying       : boolean;
  srctime,dsttime         : longint;
  block                   : array[0..buflen-1] of char;   {used for copying data}
  answer                  : char;
  stdout                  : text;


procedure syntaxmessage;
  begin
    writeln('UPDATE: Updates files from one directory to another - 10 January 1997.');
    writeln('  by Peter Summers <peter@cardiology.medrmh.unimelb.edu.au>');
    writeln;
    writeln('SYNTAX: UPDATE <source filespec> <destination directory> [/ADD] [/VRB]');
    writeln('               [/DOT] [/DAY] [/MRW] [/MKD] [/QUERY] [/BAK] [/TEST] [/BOOT]');
    halt(1)
  end;


procedure REBOOT;
label next;
var regs  : registers;
    i     : byte;
    ticks : longint;
begin
  writeln(^M+^J+'Preparing to reboot, please press reset if reboot fails...');
  delay(1000);
  {... "press" alt-ctrl ...}
  mem[$0040:$0017] := mem[$0040:$0017] or $0C;  { 00001100 }
  {... "press" del, try a few times ...}
  for i := 1 to 10 do
    begin
      FillChar (regs, sizeOf(regs), 0);  { initialize }
      regs.ah := $4F;  { service number }
      regs.al := $53;  { del key's scan code }
      regs.flags := FCarry;  { "sentinel for ignoring key" }
      Intr ($15, regs);
      {... check if the del key registered, if not retry ...}
      if regs.flags and Fcarry > 0 then goto next;
      {... waste some time, watch out for midnight ...}
      ticks := MemL [$0040:$006C];
      repeat until (MemL[$0040:$006C] - ticks > 3) or
                   (MemL[$0040:$006C] - ticks < 0)
  end; {for}
  exit;
next:
  {... disk reset: writes all modified disk buffers to disk ...}
  FillChar (regs, sizeOf(regs), 0);
  regs.ah := $0D;
  MsDos (regs);
  {... set post-reset flag, use $0000 instead of $1234 for coldboot ...}
  memW[$0040:$0072] := $1234;
  {... jump to $FFFF:0000 BIOS reset ...}
  Inline($EA/$00/$00/$FF/$FF);
end;  (* reboot *)


begin

  if (paramcount < 2) then syntaxmessage;

  for param := 3 to paramcount do begin
    thisparam := paramstr(param);
    for i := 1 to length(thisparam) do thisparam[i] := upcase(thisparam[i]);
    if thisparam = '/ADD' then
      adding := true
    else if thisparam = '/VRB' then
      verbose := true
    else if thisparam = '/DOT' then
      dots := true
    else if thisparam = '/DAY' then
      dayold := true
    else if thisparam = '/MRW' then
      makereadwrite := true
    else if thisparam = '/MKD' then
      makedestdir := true
    else if thisparam = '/QUERY' then
      queryfirst := true
    else if thisparam = '/BAK' then
      makebackup := true
    else if thisparam = '/TEST' then
      testonly := true
    else if thisparam = '/BOOT' then
      bootonupdate := true
    else syntaxmessage;
  end;

  assign(stdout,'');
  rewrite(stdout);

  fsplit(paramstr(1),srcdir,srcname,srcextn);
  dstdir := paramstr(2);

  if not (dstdir[length(dstdir)] in ['\','/',':']) then begin
    assign(dstfile,dstdir);
    getfattr(dstfile,attrib);
    if (doserror<>0) or ((attrib and directory) = 0) then begin
      writeln(stdout,'Directory '+paramstr(2)+' does not exist.');
      if makedestdir then begin
        mkdir(dstdir);
        if IOResult=0 then
          writeln(stdout,'Directory '+paramstr(2)+' created.')
        else begin
          writeln(stdout,'Can''t create directory '+paramstr(2)+'.');
          halt(1);
        end
      end else
        halt(1);
    end;
    dstdir := dstdir + '\';
  end;

  FileMode := 0;   { Source files are open Read-Only. }

  if testonly then
    write('Testing updates from '+paramstr(1)+' to '+paramstr(2)+'...')
  else
    write('Updating '+paramstr(1)+' to '+paramstr(2)+'...');

  findfirst(paramstr(1),0,dirinfo);

  if doserror=0 then repeat

    srcfilename := srcdir + dirinfo.name;
    srctime := dirinfo.time;
    dstfilename := dstdir + dirinfo.name;

    assign(dstfile,dstfilename);
    reset(dstfile,1);
    dstexists := (IOResult=0);

    if dstexists then begin
      getftime(dstfile,dsttime);
      if dayold then
        copying := ((dsttime and $FFFF0000) <= (srctime and $FFFF0000))
      else
        copying := (dsttime < srctime);
      close(dstfile);
      if IOResult<>0 then begin
        write(stdout,^M+^J+'Can''t close file '+dstfilename);
        copying := false;
      end;
    end else
      copying := adding;

    if copying and queryfirst then repeat
      write(^M+^J+'Update '+srcfilename+' to '+dstfilename+ ' ? ');
      answer := upcase(readkey);
      if answer = 'N' then copying := false;
      if answer =  ^[ then halt;
      write(answer);
    until answer in ['N','Y',^[];

    if copying and testonly then begin
      write(stdout,^M+^J+srcfilename+' would be copied to '+dstfilename);
      copying := false;
    end;

    if copying then begin
      assign(srcfile,srcfilename);
      reset(srcfile,1);
      if (IOresult<>0) then begin
        write(stdout,^M+^J+'Can''t open file '+srcfilename);
        copying := false;
      end;
    end;

    if copying and dstexists and makereadwrite then begin
      setfattr(dstfile,0);
      if (IOresult<>0) then begin
        write(stdout,^M+^J+'Can''t make writeable file '+dstfilename);
        close(srcfile);
        if IOResult<>0 then write(^M+^J+'Can''t close file '+srcfilename);
        copying := false;
      end;
    end;

    if copying and dstexists and makebackup then begin
      fsplit(dstfilename,dstdir,dstname,dstextn);
      if length(dstextn) < 4 then
        dstextn := dstextn + '~'
      else
        dstextn[4] := '~';
      rename(dstfile,dstdir+'\'+dstname+dstextn);
      assign(dstfile,dstfilename);
      if (IOresult<>0) then begin
        write(stdout,^M+^J+'Can''t rename file '+dstfilename);
        close(srcfile);
        if IOResult<>0 then write(stdout,^M+^J+'Can''t close file '+srcfilename);
        copying := false;
      end;
    end;

    if copying then begin
      rewrite(dstfile,1);
      if (IOresult<>0) then begin
        write(stdout,^M+^J+'Can''t open file '+dstfilename);
        close(srcfile);
        if IOResult<>0 then write(stdout,^M+^J+'Can''t close file '+srcfilename);
        copying := false;
      end;
    end;

    while copying and not eof(srcfile) do begin
      blockread(srcfile,block[0],sizeof(block),numread);
      if (IOresult<>0) then begin
        write(stdout,^M+^J+'Can''t read from file '+srcfilename);
        close(srcfile);
        if IOResult<>0 then {ignore it};
        close(dstfile);
        if IOresult<>0 then write(stdout,^M+^J+'Can''t close file '+dstfilename);
        copying := false;
      end else begin
        blockwrite(dstfile,block[0],numread);
        if (IOresult<>0) then begin
          write(stdout,^M+^J+'Can''t write to file '+dstfilename);
          close(srcfile);
          if IOResult<>0 then write(stdout,^M+^J+'Can''t close file '+srcfilename);
          close(dstfile);
          if IOResult<>0 then {ignore it};
          copying := false;
        end;
      end;
    end;

    if copying then begin
      if not dayold then setftime(dstfile,srctime);
      close(dstfile);
      if IOResult<>0 then
        write(stdout,^M+^J+'Can''t close file '+dstfilename)
      else
        write(stdout,^M+^J+srcfilename+' copied to '+dstfilename);
      close(srcfile);
      if IOResult = 0 then
        updated := true
      else
        write(stdout,^M+^J+'Can''t close file '+srcfilename);
    end else {if not copying then} begin
      if verbose then
        write(stdout,^M+^J+srcfilename+' not copied to ',dstfilename);
      if dots then if dstexists then write('*') else write('.');
    end;

    findnext(dirinfo);

  until doserror<>0 else write(^M+^J+'No files found matching '+paramstr(1));

  close(stdout);
  if bootonupdate and updated then reboot;
  writeln;

end.

