unit profile;
(* (c) Jan-Erik Rosinowski 1989, 1990 *)

interface

procedure pbegin(nr:word);
procedure pend;
procedure specfile(name:string; ext:string);

implementation

uses
  crt;

const
  stacksize        = 5000;             (* no. of stack-components *)
  maxprocedures    = 300;              (* max. no. of procedures *)
  fracs            = 2;                (* no of frac digits *)
  base             = 1000;             (* use ms as orientation-base *)
  clockrate        = 1193181.6667;     (* ticks per second *)
  maxcardinal      = 4294967296.0;     (* 2^32 *)
  adjustruns       = 1000;             (* runs to determine rel. zero *)
  safetyfactor     = 0.8;              (* correction of adjusttimer to prevent underflow *)

type
  stacktype        = array[0..stacksize] of word;

  procstoretype    = array[0..maxprocedures] of record
                                                  calls  : longint;
                                                  time   : longint;
                                                end;

var
  nameoftempfile   : string[64];
  profileextension : string[4];
  stack            : stacktype;
  stackptr         : word;
  procstore        : procstoretype;
  savedexitproc    : pointer;
  adjusttimer      : longint;
  procstart        : longint;
  min              : longint;
  q                : word;

procedure specfile;
begin
  nameoftempfile:=name;
  profileextension:=ext;
end;

procedure inittimer; external;
procedure restoretimer; external;
function readtimer:longint; external;
(*$L protimer *)

function long2real(l:longint):real;
begin
  if l<0 then long2real:=maxcardinal+l
  else long2real:=l;
end;

(*$F+*)
procedure writeprofile;

var
  tempfile         : text;
  profile          : text;
  profilename      : string;
  path             : string;
  iores            : word;
  procnr           : word;
  line             : string;
  error            : boolean;

function nicetime(t:longint):string;
var
  nice             : string[20];
begin
  str(long2real(t)*base/clockrate:17:fracs,nice);
  nicetime:=nice;
end;

begin
  if stackptr<>stacksize then
    begin
      error:=stackptr<>0;
      while stackptr<>0 do pend;
      if nameoftempfile='' then
        begin
          clrscr;
          writeln('** Internal Error occured in PROFILE-Unit **',#7);
          write('Please specify profile''s name :');
          readln(nameoftempfile);
        end;
      profilename:=copy(nameoftempfile,1,
                     length(nameoftempfile)-4)+profileextension;
      path:='';
      repeat
        assign(tempfile,path+nameoftempfile);
        (*$i-*)
        reset(tempfile);
        (*$i+*)
        iores:=ioresult;
        if iores<>0 then
          begin
            clrscr;
            write('Cannot find profile, please enter path :');
            readln(path);
          end;
      until iores=0;
      assign(profile,path+profilename);
      rewrite(profile);
      while not eof(tempfile) do
        begin
          read(tempfile,procnr); readln(tempfile,line);
          with procstore[procnr] do
            writeln(profile,copy(line,2,pred(length(line))),calls:6,
              nicetime(time));
        end;
      if error then
        writeln(profile,#13#10'!! Program terminated due to Halt or Error !!');
      close(tempfile);
      close(profile);
    end;
  restoretimer;
  exitproc:=savedexitproc;
end;
(*$F-*)

procedure pbegin;
begin
  if stackptr>0 then
    with procstore[stack[stackptr]] do
      inc(time,readtimer-procstart-adjusttimer);
  if stackptr=stacksize then
    begin
      clrscr;
      writeln('** Stack Overflow in PROFILE-Unit. **'#7);
      halt(1);
    end;
  inc(stackptr);
  inc(procstore[nr].calls);
  stack[stackptr]:=nr;
  procstart:=readtimer;
end;

procedure pend;
begin
  with procstore[stack[stackptr]] do
    inc(time,readtimer-procstart-adjusttimer);
  dec(stackptr);
  procstart:=readtimer;
end;

begin
  savedexitproc:=exitproc;
  exitproc:=@writeprofile;
  nameoftempfile:='';
  inittimer;
  stackptr:=0;
  fillchar(procstore,sizeof(procstore),0);
  adjusttimer:=0;
  pbegin(0);
  min:=maxlongint;
  for q:=1 to adjustruns do
    begin
      pbegin(1); pend;
      with procstore[1] do
        begin
          if time<min then min:=time;
          time:=0;
        end;
    end;
  pend;
  adjusttimer:=trunc(min*safetyfactor);
  fillchar(procstore,sizeof(procstore),0);
end.