/**********************************************************/
/*/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\*/
/*
CAUTION: Compile using LARGE memory model!!!!!
*/
/*/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\*/
/**********************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>

#include "xsnd.h"

/**********************************************************/
/* basic block length (samples per block):
too sort ==> too much interrupts per second. */
#define N 200

/* sampling rate */
/*#define SRATE 8000*/
#define SRATE 7500  /* shareware version only supports this */

/**********************************************************/
/* in this global variable we store the audio level of the
last audio frame */

volatile UINT32 level = 0;

/**********************************************************/
/* we ignore argument {last}, as this is an end-less program */

void myfunc( BOOL last )
{
	INT16 * p;  /* far pointer to 16 bit integer */
	int i;

	/* get the recorded block. Can't be NULL, because this callback
	is called when a block is filled. */
	p = xsnd16_getblk();

	/* compute audio level. OK, this is not a good algorithm, but
	computing dB needs math.h, and I don't want to :) */
	level = 0;
	for (i=0; i<N; i++)
		level += abs(p[i]);
	level = ((level/N)*80)/(32000);

	/* after processing the block, put it again to the recording queue */
	xsnd16_addblk();
}

/**********************************************************/

int main( void )
{
	int err;
	int i;


	printf("This programs implements a simple audio vumeter.\n"
		"Audio is recorded and a text-bar displays it's level.\n"
		"Press ENTER to continue...");
	fgetc(stdin);

	/* sane state for SB16 */
	xsnd16_initialize();

	/* allocate SB16 resources */
	err=xsnd16_open(XSND_RECORD,  /* record */
			SRATE,       /* sampling rate */
			XSND_MONO,   /* mono recording */
			N,          /* block length */
			4,          /* number of blocks */
			myfunc);    /* no user callback */

	if (err) {    /* if error */
		printf("can't open sb16!\n");
		return 1;
	}

	/* first we add as many free blocks to the recording queue as
	possible. */
	while (!xsnd16_addblk());

	xsnd16_start();  /* start recording */

	printf("press any key to stop...\n");

	do {
		for (i=0; i<79; i++)
			if (i<level)
				printf("*");
			else
				printf(" ");

		printf("\r");
	} while (!kbhit());

	/* free resources */
	xsnd16_close();

	return 0;
}

/**********************************************************/
