unit rtftest;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  RtfDoc, StdCtrls;

type
  TForm1 = class(TForm)
    Close: TButton;
    Button1: TButton;
    Edit1: TEdit;
    RtfDoc1: TRtfDoc;
    procedure Button1Click(Sender: TObject);
    procedure CloseClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
var
   CheckGroupNo:  integer ;
begin
    RtfDoc1.FileName := ExtractFilePath(Application.Exename)
                        + 'sample.rtf' ;

  {Define rtf paragraph defaults - ie the standard for the whole document}
  {for paragraphs}
  RtfDoc1.Align:= jLeft ;          {Paragraph Alignment}
  RtfDoc1.SetFrFontName('Times') ; {Text Font Name}
  RtfDoc1.SetFrFontSize(12) ;      {Text Font Size}
  RtfDoc1.IndentLeft  :=   0 ;     {Paragraph left indent Amount - twips}
  RtfDoc1.Indent1st   := 720 ;     {Paragraph 1st line indent Amount twips}
  RtfDoc1.IndentRight :=   0 ;     {Paragraph Right indent Amount}
  RtfDoc1.Spacing := 20 ;          {Paragraph Line Spacing}
  RtfDoc1.WordWrap := rtfYes ;     {Text Word Wrap}
  {for text}
  RtfDoc1.Color := clBlack ;       {Text Color}
  RtfDoc1.Style := stplain ;       {Text Style}
  RtfDoc1.Underlining := uNone ;   {Text Underlining}

  {show file name so that you can check it.}
  Edit1.Text := RtfDoc1.FFileName ;

  {Open rtf file, file header setup, Group 1 open for document text}
  RtfDoc1.OpenDoc ;
  CheckGroupNo := RtfDoc1.FrGroupNo ; {Group No = 1 }

  {Print a title}
  {Setup commands for the subgroup that I will create}
  RtfDoc1.Align := jCenter ;         {Paragraph Alignment}
  RtfDoc1.Underlining := uSingle ;   {Underlining}
  RtfDoc1.Style := stBold ;          {Text Style}
  RtfDoc1.Indent1st   := 0 ;         {Paragraph 1st line indent Amount twips}
  {open group 2 with these default command settings}
  CheckGroupNo := RtfDoc1.OpenGroup ;

  {First I will show a how to create text within a subgroup}
  {write the text, and close the group}
  RtfDoc1.WriteLineCR('Sample Report') ; {Writes a line & carriage Return}
  RtfDoc1.WriteLineCR('') ;              {writes blank line & carriage Return}
  CheckGroupNo := RtfDoc1.CloseGroup ;   {Close Group 2 for title}

  {Now, Write some text in the standard defaults}
  {Note how I strung long text by breaking it into strings and using the +}
  {Text is limited to 254 characters, including the control commands}
  {   so keep your text groups relatively short}
  RtfDoc1.WriteLine('This is a sample line of data. It may be '
               +'something like a leading paragraph or just text. It '
               +'is using the defaults. Note the wordwrap. Right now '
               +'it is limited to 254 chars including the control '
               +'commands. ') ;
  {Note that I end the string with a blank. If there is no blank,}
  {rtf will put the strings together with no space.}

  RtfDoc1.WriteLine('Note, how the word wrap feature just '
               +'strings all these lines together. Note, how ea'
               +'ch sentence must end in a space in order to av'
               +'oid run-on with the next sentence. ' ) ;
               {The next sentence is appended with no carriage return}
  RtfDoc1.WriteLineCR('Note, I used the RtfWriteLineCR function'
               +' to make an end to a paragraph and stop that word '
               +'wrap. In order to leave a blank line, I print '
               +'a blank string. ') ; {This line has a carriage return}

  RtfDoc1.WriteLineCR('') ; {writes a blank line & carriage Return}

  RtfDoc1.WriteLineCR('RTF has three special characters. the \\ and the'
               +' \{ and the \}. If you want to print them, you have to pr'
               +'eceed the character with a \\. For example, ') ;

  RtfDoc1.ClearTabs ;   {a good habit is to clear the tabs first}
  RtfDoc1.AddTab(2.5, jLeft) ;
  RtfDoc1.WriteLineCR(RtfDoc1.Tab1+'\\\\ prints a \\. ') ;
  RtfDoc1.WriteLineCR(RtfDoc1.Tab1+'\\\{ prints a \{ , and') ;
  RtfDoc1.WriteLineCR(RtfDoc1.Tab1+'\\\} prints a \}. ') ;

  RtfDoc1.WriteLineCR('') ; {writes a blank line & carriage Return}

    {Now I am going to set commands and Open a subgroup for a special paragraph}
    {I will set tabs for a numeric list}
    RtfDoc1.ClearTabs ;   {a good habit is to clear the tabs first}
    RtfDoc1.AddTab(2.0, jLeft) ;     {for the word 'Note:'}
    RtfDoc1.AddTab(2.75, jLeft) ;    {Set a left tab for the 'Number' and '_______'}
    RtfDoc1.AddTab(3.25, jDecimal) ; {Set a decimal tab for the list}
    RtfDoc1.AddTab(4.2, jRight) ;    {offset total}
    RtfDoc1.Color := clNavy ;        {Set Text Color}
    RtfDoc1.Spacing := 300 ;         {Paragraph Line Spacing}
    RtfDoc1.Underlining := uNone ;   {Text Underlining}
    RtfDoc1.WordWrap := RtfNo ;      {Text Word Wrap}
    CheckGroupNo := RtfDoc1.OpenGroup ;  {open group 2 to do a list}

      {I am now going to setup the commands for a subgroup within the group}
      {I am going to open a group, add text and close the group}
      {See below, it is easier to use WriteGroup}
      {Open a group within the group - ie. a title for the list}
      RtfDoc1.Style := stBold ;         {Style set to Bold}
      CheckGroupNo := RtfDoc1.OpenGroup ;  {open group 3 to do title of the list}

        {Print title of list}
        {This is where I show how to use the rtf command }
        {as part of the string.  I do this because I }
        {do not want the whole line underlined}
        {So I just use the rtf command '\bdbl ' before the }
        {word 'Numbers' and the rtf command '\b0 ' after.}
        {I could have used the command RtfDoc1.uWord. It is }
        {the component code for word underline}
        {If I set it as a paragraph standard, the tab would be underlined}
        RtfDoc1.WriteLineCR( RtfDoc1.Tab1
                             +RtfDoc1.Tab1
                             +'\uldb '        {double underline}
                             +'Numbers'
                             +'\ul0 ') ;      {turn off underlining}
        {Note: how the rtf command is Separated from the string with a ' '}

        {close group 3 for the title of the list}
        CheckGroupNo := RtfDoc1.CloseGroup ;

        {This close group eliminates the Bold that was set for this sample}

      {Now I will Print the list - note use of decimal tab}
      {I had set two tabs, one jLeft, and one jDecimal}
      RtfDoc1.WriteLineCR( RtfDoc1.Tab1
                           +RtfDoc1.Tab1
                           +RtfDoc1.Tab1
                           +'435.65') ;
      RtfDoc1.WriteLineCR( RtfDoc1.Tab1
                           +RtfDoc1.Tab1
                           +RtfDoc1.Tab1
                           +'5.35') ;
      RtfDoc1.WriteLineCR( '\tab '    {another way to enter a tab}
                           +'\tab '
                           +'\tab '
                           +'1423.25') ;
      RtfDoc1.WriteLineCR( RtfDoc1.Tab1
                           +RtfDoc1.Tab1
                           +RtfDoc1.Tab1
                           +'34.69') ;

      {Now I want to print one number in red }
      {I use the WriteGroup function so that I can embed an rtf command}
      {This prints the string as an enclosed group with RtfDoc1.rclRed}
      RtfDoc1.WriteGroup( rtfYes,
                          RtfDoc1.Tab1
                          +'Note: '
                          +RtfDoc1.Tab1
                          +RtfDoc1.Tab1
                          +RtfDoc1.rclRed
                          +' '
                          +'-431.65',
                          rtfYes,rtfYes) ;
      {Group 3 was opened and closed in the WriteGroup}
      CheckGroupNo := RtfDoc1.FrGroupNo ;
      {GroupNo still 2: Note group 2 closed and color goes back to clNavy}

      {Alternatively, I could have included either of the following:}
      {RtfDoc1.WriteLineCR(RtfDoc1.Tab1
                           +'Note: '
                           +RtfDoc1.Tab1
                           +RtfDoc1.Tab1
                           +'\cf6'
                           +'-431.65'
                           +'\cf9') ;}
      {   or}
      {RtfDoc1.WriteLineCR(RtfDoc1.Tab1
                           +'Note: '
                           +RtfDoc1.Tab1
                           +RtfDoc1.Tab1
                           +RtfDoc1.rclRed
                           +'-431.65'
                          + RtfDoc1.rclNavy) ; }

      {Print more}
      RtfDoc1.WriteLineCR( RtfDoc1.Tab1
                           +RtfDoc1.Tab1
                           +RtfDoc1.Tab1
                           +'71.69') ;
      RtfDoc1.WriteLineCR( RtfDoc1.Tab1
                           +RtfDoc1.Tab1
                           +RtfDoc1.Tab1
                           +'282.69') ;

        {open a subgroup for the total}
        RtfDoc1.Style := stBold ;     {Text Style}
        {Print total}
        RtfDoc1.WriteLineCR( RtfDoc1.Tab1
                             +RtfDoc1.Tab1
                             +RtfDoc1.Tab1
                             +'_________') ;

        {RtfDoc1.WriteLineCR(RtfDoc1.Tab1+'1821.67') ;}
        RtfDoc1.WriteGroup( rtfYes,
                            RtfDoc1.Tab1
                            +'Total'
                            +RtfDoc1.Tab1
                            +RtfDoc1.Tab1
                            +'\b '                   {bold on}
                            +RtfDoc1.Tab1+'1821.67'
                            +'\b0 ',                {bold off}
                            rtfYes,rtfYes) ;
        {Group 3 Opened and closed to print total in bold}

        {Close group 2 for the list group}
        CheckGroupNo := RtfDoc1.CloseGroup ;    {Close group for the list FrGroupNo = 1}

      {Add another line of special paragraph text}
      RtfDoc1.WriteLineCR('') ; {writes a blank line and a carriage Return}
      RtfDoc1.WriteGroup( rtfYes,
                             '\fs48'   {this is rtf command for 12 points}
                             +' '      {this space separates command from text}
                             +'And '
                             +'\cf4 '
                             +'that is '
                             +'\cf6 '
                             +'the end'
                             +'\cf12 '
                             +' of the'
                             +'\cf1 '
                             +' sample. ',
                             rtfYes,rtfYes) ;
      {Group 2 was opened and closed to print the color line}
      CheckGroupNo := RtfDoc1.FrGroupNo ;  {GroupNo still 1}

      RtfDoc1.WriteLineCR('') ; {writes a blank line and a carriage Return}
      RtfDoc1.WriteLineCR('') ; {writes a blank line and a carriage Return}

      {Now I will print a narrow column}
      RtfDoc1.Indent1st   :=  720 ;   {0.5 inch paragraph indent}
      RtfDoc1.IndentLeft  := 1440 ;   {1 inch left margin}
      RtfDoc1.IndentRight := 3*1440 ; {3 inch right margin}
      RtfDoc1.Spacing := 600 ;
      RtfDoc1.Align := jJustify ;
      {Open Group 2 to activate these rtf commands for the poem}
      CheckGroupNo := RtfDoc1.OpenGroup ;

      {Note appending text --- no cariage returns below}
      RtfDoc1.WriteLine('Once upon a time ') ;
      RtfDoc1.WriteLine('on the border of a brook, ') ;
      RtfDoc1.WriteLine('there was a wicked little froggie ') ;
      RtfDoc1.WriteLine('who had never read a book. ') ;
      RtfDoc1.WriteLine('He never read a story ') ;
      RtfDoc1.WriteLine('or a funny little rhyme. ') ;
      RtfDoc1.WriteLine('Had a sad and tragic ending ') ;
      RtfDoc1.WriteLine('and a once upon a time.... ') ;
      RtfDoc1.WriteLineCR('') ; {writes a blank line and a carriage Return}
      {Close group 2 for the poem}
      CheckGroupNo := RtfDoc1.CloseGroup ;

      {Close group 1 finished document}
      CheckGroupNo := RtfDoc1.CloseGroup ;

   {Close rtf file, closes all groups}
   RtfDoc1.CloseDoc ;
  CheckGroupNo := RtfDoc1.FrGroupNo ; {This is now -1 --- the file is closed }


end;

procedure TForm1.CloseClick(Sender: TObject);
begin
   HAlt ;
end;

end.
