# Include file used for all project makefiles

# Pre-defined include and source code paths for this project
# INCLUDE_PATH = $(PROJECT_INCLUDE_PATH)$(PATHSEP)
# SRC_PATH = $(PROJECT_SRC_PATH)$(PATHSEP)

INCLUDE_PATH = ../../include/
SRC_PATH = ../../src/

# Build dependency rules
# ===============================================================
GXINT32_DEP = $(INCLUDE_PATH)gxint32.h 

GXUINT32_DEP = $(INCLUDE_PATH)gxuint32.h

GXSTREAM_DEP = $(INCLUDE_PATH)gxsocket.h $(INCLUDE_PATH)gxstypes.h \
	$(INCLUDE_PATH)gxstream.h $(INCLUDE_PATH)gxheader.h \
	$(INCLUDE_PATH)gxdtypes.h $(INCLUDE_PATH)gxd_ver.h \
	$(INCLUDE_PATH)gxint32.h $(INCLUDE_PATH)gxuint32.h

GXDATAGM_DEP = $(INCLUDE_PATH)gxsocket.h $(INCLUDE_PATH)gxstypes.h \
	$(INCLUDE_PATH)gxdatagm.h $(INCLUDE_PATH)gxheader.h \
	$(INCLUDE_PATH)gxdtypes.h $(INCLUDE_PATH)gxd_ver.h \
	$(INCLUDE_PATH)gxint32.h $(INCLUDE_PATH)gxuint32.h

GXSOCKET_DEP = $(INCLUDE_PATH)gxsocket.h $(INCLUDE_PATH)gxstypes.h

GXSCOMM_DEP = $(INCLUDE_PATH)gxscomm.h

SCOMSERV_DEP = $(INCLUDE_PATH)gxscomm.h $(INCLUDE_PATH)scomserv.h \
	$(INCLUDE_PATH)gxheader.h $(INCLUDE_PATH)gxdtypes.h \
	$(INCLUDE_PATH)gxd_ver.h $(INCLUDE_PATH)gxint32.h \
	$(INCLUDE_PATH)gxuint32.h

DEVCACHE_DEP =  $(INCLUDE_PATH)devcache.h $(INCLUDE_PATH)devtypes.h \
	$(INCLUDE_PATH)membuf.h $(INCLUDE_PATH)memblock.h

MEMBUF_DEP = $(INCLUDE_PATH)membuf.h

MEMBLOCK_DEP = $(INCLUDE_PATH)memblock.h

GXSFILE_DEP = $(INCLUDE_PATH)gxsocket.h $(INCLUDE_PATH)gxstypes.h \
	$(INCLUDE_PATH)gxstream.h $(INCLUDE_PATH)gxheader.h \
	$(INCLUDE_PATH)gxdtypes.h $(INCLUDE_PATH)gxd_ver.h \
	$(INCLUDE_PATH)gxint32.h $(INCLUDE_PATH)gxuint32.h \
	$(INCLUDE_PATH)gxscomm.h $(INCLUDE_PATH)scomserv.h \
	$(INCLUDE_PATH)gxdatagm.h $(INCLUDE_PATH)devcache.h \
	$(INCLUDE_PATH)devtypes.h $(INCLUDE_PATH)membuf.h \
	$(INCLUDE_PATH)memblock.h 

PROJECT_DEP = $(INCLUDE_PATH)gxsocket.h $(INCLUDE_PATH)gxstypes.h \
	$(INCLUDE_PATH)gxstream.h $(INCLUDE_PATH)gxheader.h \
	$(INCLUDE_PATH)gxdtypes.h $(INCLUDE_PATH)gxd_ver.h \
	$(INCLUDE_PATH)gxint32.h $(INCLUDE_PATH)gxuint32.h \
	$(INCLUDE_PATH)gxscomm.h $(INCLUDE_PATH)scomserv.h \
	$(INCLUDE_PATH)gxdatagm.h $(INCLUDE_PATH)devcache.h \
	$(INCLUDE_PATH)devtypes.h $(INCLUDE_PATH)membuf.h \
	$(INCLUDE_PATH)memblock.h 
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT)$(EXE_EXT)

gxint32$(OBJ_EXT):	$(SRC_PATH)gxint32.cpp $(GXINT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)gxint32.cpp

gxuint32$(OBJ_EXT):	$(SRC_PATH)gxuint32.cpp $(GXUINT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)gxuint32.cpp

gxscomm$(OBJ_EXT):	$(SRC_PATH)gxscomm.cpp $(GXSCOMM_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)gxscomm.cpp

scomserv$(OBJ_EXT):	$(SRC_PATH)scomserv.cpp $(SCOMSERV_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)scomserv.cpp

gxsocket$(OBJ_EXT):	$(SRC_PATH)gxsocket.cpp $(GXSOCKET_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)gxsocket.cpp

gxstream$(OBJ_EXT):	$(SRC_PATH)gxstream.cpp $(GXSTREAM_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)gxstream.cpp

gxdatagm$(OBJ_EXT):	$(SRC_PATH)gxdatagm.cpp $(GXDATAGM_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)gxdatagm.cpp

devcache$(OBJ_EXT):	$(SRC_PATH)devcache.cpp $(DEVCACHE_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)devcache.cpp

membuf$(OBJ_EXT):	$(SRC_PATH)membuf.cpp $(MEMBUF_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)membuf.cpp

memblock$(OBJ_EXT):	$(SRC_PATH)memblock.cpp $(MEMBLOCK_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)memblock.cpp

gxsfile$(OBJ_EXT):	gxsfile.cpp $(GXSFILE_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) gxsfile.cpp

$(PROJECT)$(OBJ_EXT):	$(PROJECT).cpp $(PROJECT_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(PROJECT).cpp

leaktest$(OBJ_EXT):    $(SRC_PATH)leaktest.cpp $(LEAKTEST_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(SRC_PATH)leaktest.cpp

# Make the executable
OBJECTS = $(PROJECT)$(OBJ_EXT) leaktest$(OBJ_EXT) \
	gxsocket$(OBJ_EXT)  gxscomm$(OBJ_EXT) scomserv$(OBJ_EXT) \
	gxint32$(OBJ_EXT) gxuint32$(OBJ_EXT) gxstream$(OBJ_EXT) \
	gxdatagm$(OBJ_EXT) devcache$(OBJ_EXT) membuf$(OBJ_EXT) \
	memblock$(OBJ_EXT) gxsfile$(OBJ_EXT)
# ===============================================================
