# Include file used for all project makefiles

# Pre-defined include and source code paths for this project
INCLUDE_PATH = $(PROJECT_INCLUDE_PATH)$(PATHSEP)
SRC_PATH = $(PROJECT_SRC_PATH)$(PATHSEP)

# Build dependency rules
# ===============================================================
USTRING_DEP = $(INCLUDE_PATH)ustring.h

DFILEB_DEP = $(INCLUDE_PATH)dfileb.h

MEMBUF_DEP = $(INCLUDE_PATH)membuf.h

GXLISTB_DEP = $(INCLUDE_PATH)gxlistb.h

GXSHTML_DEP = $(INCLUDE_PATH)gxshtml.h $(INCLUDE_PATH)gxstring.h \
	$(INCLUDE_PATH)ustring.h $(INCLUDE_PATH)membuf.h \
	$(INCLUDE_PATH)gxlist.h $(INCLUDE_PATH)gxlistb.h \
	$(INCLUDE_PATH)dfileb.h

PROJECT_DEP = $(INCLUDE_PATH)gxshtml.h $(INCLUDE_PATH)gxstring.h \
	$(INCLUDE_PATH)ustring.h $(INCLUDE_PATH)membuf.h \
	$(INCLUDE_PATH)gxlist.h $(INCLUDE_PATH)gxlistb.h \
	$(INCLUDE_PATH)dfileb.h
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT)$(EXE_EXT)

ustring$(OBJ_EXT):	$(SRC_PATH)ustring.cpp $(USTRING_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)ustring.cpp

gxlistb$(OBJ_EXT):	$(SRC_PATH)gxlistb.cpp $(GXLISTB_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)gxlistb.cpp

membuf$(OBJ_EXT):	$(SRC_PATH)membuf.cpp $(MEMBUF_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)membuf.cpp

gxshtml$(OBJ_EXT):	$(SRC_PATH)gxshtml.cpp $(GXSHTML_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)gxshtml.cpp

dfileb$(OBJ_EXT):	$(SRC_PATH)dfileb.cpp $(DFILEB_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)dfileb.cpp

$(PROJECT)$(OBJ_EXT):	$(PROJECT).cpp $(PROJECT_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(PROJECT).cpp

leaktest$(OBJ_EXT):    $(SRC_PATH)leaktest.cpp $(LEAKTEST_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(SRC_PATH)leaktest.cpp

# Make the executable
OBJECTS = $(PROJECT)$(OBJ_EXT) leaktest$(OBJ_EXT) \
	ustring$(OBJ_EXT) dfileb$(OBJ_EXT) gxlistb$(OBJ_EXT) \
	gxshtml$(OBJ_EXT) membuf$(OBJ_EXT)
# ===============================================================
