// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Header File Name: edscfg.h
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 10/15/1999 
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

Code used to generate encrypted program configuration files.
*/
// ----------------------------------------------------------- // 
#ifndef __GX_EDSCFG_HPP__
#define __GX_EDSCFG_HPP__

#include "eds101.h"
#include "gxlistb.h"
#include "ustring.h"
#include "gxdbase.h"

// Configuration data nodes 
struct edsConfigNode
{
  edsConfigNode() { }
  edsConfigNode(const UString &s) { str = s; address = gxCurrAddress; }
  edsConfigNode(const UString &s, FAU a) { str = s; address = a; }
  edsConfigNode(const edsConfigNode &ob) {
    address = ob.address;    
    str = ob.str;
  }
  edsConfigNode &operator=(const edsConfigNode &ob) {
    address = ob.address;    
    str = ob.str;
    return *this;
  }
  ~edsConfigNode() { }
  
  friend int operator==(const edsConfigNode &a, const edsConfigNode &b) {
    return a.str == b.str;
  }

  FAU address;    
  UString str;
};

class edsConfigListNode: public gxListNodeB
{
public:
  edsConfigListNode() { data = (void *)&node_data; } 
  edsConfigListNode(const edsConfigNode &X) : node_data(X) {
    data = (void *)&node_data;
  } 

public:
  edsConfigListNode *GetNext() { return (edsConfigListNode *)next; }
  const edsConfigListNode *GetNext() const {
    return (edsConfigListNode *)next;
  }

public:
  edsConfigNode node_data;
};

class edsConfig : public edsString, public gxListB
{
public:
  edsConfig();
  edsConfig(const UString &fname);
  edsConfig(char *fname);
  edsConfig(const char *fname);

  // Constructors add to set the parameter ID string
  edsConfig(const UString &fname, const UString &p_id);
  edsConfig(const UString &fname, char *p_id); 
  edsConfig(const UString &fname, const char *p_id);
  ~edsConfig();

private:
  edsConfig(const edsConfig &ob) { }      // Disallow copying
  void operator=(const edsConfig &ob) { } // Disallow assignment

public: // Functions used to load and unload config file
  int Load();
  int Load(char *fname); 
  int Load(const char *fname);
  int Load(const UString &fname);
  int ReLoad();
  int ReLoad(char *fname); 
  int ReLoad(const char *fname);
  int ReLoad(const UString &fname);
  void UnLoad();
  char *GetFileName() { return FileName.c_str(); }
  void SetFileName(const UString &s) { FileName = s; }
  void SetFileName(const char *s) { FileName = s; }
  void SetFileName(char *s) { FileName = s; }
 
public: // Formatting functions
  // Treat all characters after the ID string as a parameter value
  void SetParmID(const UString &s) { parm_ID = s; }
  void SetParmID(char *s) { parm_ID = s; }
  void SetParmID(const char *s) { parm_ID = s; }
  char *GetParmID() { return parm_ID.c_str(); }
  char GetCommentChar() { return comment_char; }
  void SetCommentChar(char c) { comment_char = c; }
  void FilterComments() { filter_comments = 1; }
  void ReadComments() { filter_comments = 0; }
  
public: // Functions used to read config file values
  double GetFloatValue(char *Name); 
  double GetFloatValue(const char *Name);    
  double GetFloatValue(const UString &Name); 
  char* GetStrValue(char *Name);          
  char* GetStrValue(const char *Name);    
  char* GetStrValue(const UString &Name); 
  int GetIntValue(char *Name);            
  int GetIntValue(const char *Name);      
  int GetIntValue(const UString &Name);   
  long GetLongValue(char *Name);       
  long GetLongValue(const char *Name);    
  long GetLongValue(const UString &Name); 

public: // Functions used to write config values
  int WriteConfigLine(const UString &parm, const UString &value);
  int WriteConfigLine(const char *parm, const char *value);
  int WriteConfigLine(char *parm, char *value);
  int WriteCommentLine(const UString &s);
  int WriteCommentLine(const char *s);
  int WriteCommentLine(char *s);
  int WriteLine(const UString &s);
  int WriteLine(const char *s);
  int WriteLine(char *s);
  int ChangeConfigValue(const UString &parm, const UString &value);
  int ChangeConfigValue(const char *parm, const UString &value);
  int ChangeConfigValue(char *parm, const UString &value);
  int ChangeConfigValue(const UString &parm, const char *value);
  int ChangeConfigValue(const UString &parm, char *value);
  int ChangeConfigValue(const char *parm, const char *value);
  int ChangeConfigValue(char *parm, char *value);
  int ChangeConfigValue(const UString &parm, int value);
  int ChangeConfigValue(const char *parm, int value);
  int ChangeConfigValue(char *parm, int value);
  int ChangeConfigValue(const UString &parm, unsigned value);
  int ChangeConfigValue(const char *parm, unsigned value);
  int ChangeConfigValue(char *parm, unsigned value);
  int ChangeConfigValue(const UString &parm, long value);
  int ChangeConfigValue(const char *parm, long value);
  int ChangeConfigValue(char *parm, long value);
  int ChangeConfigValue(const UString &parm, float value);
  int ChangeConfigValue(const char *parm, float value);
  int ChangeConfigValue(char *parm, float value);
  int ChangeConfigValue(const UString &parm, double value);
  int ChangeConfigValue(const char *parm, double value);
  int ChangeConfigValue(char *parm, double value);

public: // Linked list functions
  edsConfigListNode *Find(const edsConfigNode &X, edsConfigListNode *ptr=0);
  edsConfigListNode *Add(const edsConfigNode &X);

private: // Internal processing functions
  int StoreCfgData(const edsWORD *eds_string, FAU addr);
  int ChangeConfigLine(const UString &parm, const UString &value);
  int ConnectConfigFile();
  
public: // GXD File functions
  int Write(const char *s, FAU addr = (FAU_t)0);
  edsWORD *Read(FAU addr = gxCurrAddress);
  gxDatabaseError Open(const UString &fname);
  gxDatabaseError Disconnect();
  gxDatabaseError Create(const UString &fname);
  gxDatabaseError Create(const char *fname);
  gxDatabaseError Flush();
  gxDatabaseError Close() { return Disconnect(); }
  gxDatabase *OpenDatabase() { return opendatabase; }
  gxDatabase *OpenDatabase() const { return opendatabase; }
  int Exists() const { return exists; }
  int Exists() { return exists; }

private:
  gxDatabase *opendatabase;  // GXD file pointer to the data file
  int exists;                // True if data file already exists

private: // Config manager members
  UString FileName;    // Name of the configuration file
  UString parm_ID;     // String used indentify parameters in the file
  char comment_char;   // Char used to ID comments in the config file
  int filter_comments; // If ture all comments will be ignored
};

#endif // __GX_EDSCFG_HPP__
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
