// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: gxsocket.h
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 09/20/1999
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The gxSocket class is an object-oriented Winsock/BSD wrapper 
used to create TCP/IP sockets on WIN32 and UNIX platforms. The 
gxSocket class supports stream sockets and datagram sockets and 
includes several low-level functions needed by derived classes to 
establish communication end-points and transfer data.
*/
// ----------------------------------------------------------- //   
#ifndef __GX_SOCKET_HPP__
#define __GX_SOCKET_HPP__

#include "gxstypes.h"

// gxSocket class 
class gxSocket
{
public:
  gxSocket(); 
  gxSocket(gxsSocket_t st, gxsPort_t port, char *hostname = 0); 
  gxSocket(gxsAddressFamily af, gxsSocket_t st, gxsProtocolFamily pf,
	   int port, char *hostname = 0);
  virtual ~gxSocket();
  
private: // Disallow copying and assignment
  gxSocket(const gxSocket &ob) { }
  void operator=(const gxSocket &ob) { }
  
public: // Functions used to set the socket parameters
  void SetAddressFamily(gxsAddressFamily af) { address_family = af; }
  void SetProtocolFamily(gxsProtocolFamily pf) { protocol_family = pf; }
  gxsProtocolFamily GetProtocolFamily() { return protocol_family; }
  void SetSocketType(gxsSocket_t st) { socket_type = st; }
  gxsSocket_t GetSocketType() { return socket_type; }
  void SetPortNumber(gxsPort_t p) { port_number = p; }
  gxsSocket_t GetBoundSocket() { return gxsocket; } 
  gxsSocket_t GetSocket() { return gxsocket; }  
  gxsSocket_t GetRemoteSocket() { return remote_socket; }
  
public: // Socket functions
  gxsSocket_t Socket();
  gxsSocket_t InitSocket(gxsSocket_t st, int port, char *hostname = 0);
  gxsSocket_t InitSocket(gxsAddressFamily af, gxsSocket_t st, 
			 gxsProtocolFamily pf, int port, char *hostname = 0);
  void Close();
  void Close(gxsSocket_t &s);
  void CloseSocket();
  void CloseRemoteSocket();
  int Bind();
  int Connect();
  gxsSocket_t Accept();
  int Listen(int max_connections = SOMAXCONN);
  int Recv(void *buf, int bytes, int flags = 0);
  int Recv(gxsSocket_t s, void *buf, int bytes, int flags = 0);
  int Recv(void *buf, int bytes, int seconds, int useconds, int flags = 0);
  int Recv(gxsSocket_t s, void *buf, int bytes, int seconds, int useconds, 
	   int flags = 0);
  int Send(const void *buf, int bytes, int flags = 0);
  int Send(gxsSocket_t s, const void *buf, int bytes, int flags = 0);
  int RemoteRecv(void *buf, int bytes, int seconds, int useconds, 
		 int flags = 0);
  int RemoteRecv(void *buf, int bytes, int flags = 0);
  int RemoteSend(const void *buf, int bytes, int flags = 0);
  int RawRead(void *buf, int bytes, int flags = 0);
  int RawRead(gxsSocket_t s, void *buf, int bytes, int flags = 0);
  int RawRemoteRead(void *buf, int bytes, int flags = 0);
  int RawWrite(const void *buf, int bytes, int flags = 0);
  int RawWrite(gxsSocket_t s, const void *buf, int bytes, int flags = 0);
  int RawRemoteWrite(const void *buf, int bytes, int flags = 0);
  void ResetRead() { bytes_read = 0; }
  void ResetWrite() { bytes_moved = 0; } 
  void ShutDown(int how = 0);
  void ShutDown(gxsSocket_t &s, int how = 0);
  void ShutDownSocket(int how = 0);
  void ShutDownRemoteSocket(int how = 0);
  int GetPeerName(gxsSocket_t s, gxsSocketAddress *sa);
  int GetPeerName();
  int GetSockName(gxsSocket_t s, gxsSocketAddress *sa);
  int GetSockName();
  int GetSockOpt(gxsSocket_t s, int level, int optName, 
		 void *optVal, unsigned *optLen);
  int GetSockOpt(int level, int optName, void *optVal, unsigned *optLen);
  int SetSockOpt(gxsSocket_t s, int level, int optName, 
		 const void *optVal, unsigned optLen);
  int SetSockOpt(int level, int optName, const void *optVal, unsigned optLen);
  int GetServByName(char *name, char *protocol = 0);
  int GetServByPort(int port, char *protocol = 0); 
  gxsServent *GetServiceInformation(char *name, char *protocol = 0);
  gxsServent *GetServiceInformation(int port, char *protocol = 0);
  int GetPortNumber(); 
  int GetRemotePortNumber();
  int GetHostName(char *sbuf);
  int GetIPAddress(char *sbuf);
  int GetDomainName(char *sbuf);
  int GetBoundIPAddress(char *sbuf);
  int GetRemoteHostName(char *sbuf);
  gxsHostNameInfo *GetHostInformation(char *hostname);
  void GetClientInfo(char *client_name, int &r_port);
  gxsAddressFamily GetAddressFamily();
  gxsAddressFamily GetRemoteAddressFamily();
  
  // Process control functions
  int ReadSelect(gxsSocket_t s, int seconds, int useconds); 
  int BytesRead() { return bytes_read; }
  int BytesMoved() { return bytes_moved; }
  int SetBytesRead(int bytes = 0) { return bytes_read = bytes; }
  int SetBytesMoved(int bytes = 0) { return bytes_moved = bytes; }
  int *GetBytesRead() { return &bytes_read; }
  int *GetBytesMoved() { return &bytes_moved; }
  int IsConnected() { return is_connected == 1; }
  int IsBound() { return is_bound == 1; }
  gxsSocket_t SetSocket(gxsSocket_t s) { return gxsocket = s; }
  gxsSocket_t SetRemoteSocket(gxsSocket_t s) { return remote_socket = s; }
  void ReleaseSocket() { gxsocket = (gxsSocket_t)-1; }
  void ReleaseRemoteSocket() { remote_socket = (gxsSocket_t)-1; }

  // Datagram functions
  int RecvFrom(gxsSocket_t s, gxsSocketAddress *sa, void *buf,
	       int bytes, int seconds, int useconds, int flags = 0);
  int RecvFrom(gxsSocket_t s, gxsSocketAddress *sa, void *buf,
	       int bytes, int flags = 0);
  int SendTo(gxsSocket_t s, gxsSocketAddress *sa, void *buf,
	     int bytes, int flags = 0);
  int RawReadFrom(gxsSocket_t s, gxsSocketAddress *sa, void *buf,
		  int bytes, int flags = 0);
  int RawWriteTo(gxsSocket_t s, gxsSocketAddress *sa, void *buf,
		 int bytes, int flags = 0);
  int RecvFrom(void *buf, int bytes, int flags = 0);
  int RecvFrom(void *buf, int bytes, int seconds, int useconds, int flags = 0);
  int SendTo(void *buf, int bytes, int flags = 0);
  int RawReadFrom(void *buf, int bytes, int flags = 0);
  int RawWriteTo(void *buf, int bytes, int flags = 0);

  // Exception handling functions
  gxSocketError GetSocketError() { return socket_error; }
  gxSocketError GetSocketError() const { return socket_error; }
  gxSocketError SetSocketError(gxSocketError err) {
    return socket_error = err;
  }
  gxSocketError ResetSocketError() {
    return socket_error = gxSOCKET_NO_ERROR;
  }
  gxSocketError ResetError() {
    return socket_error = gxSOCKET_NO_ERROR;
  }
  const char *SocketExceptionMessage();
  
  // Platform specific initialization functions
  int InitSocketLibrary();
  int ReleaseSocketLibrary();

public: // Overloaded operators
  int operator!() const { return socket_error != gxSOCKET_NO_ERROR; }
  int operator!() { return socket_error != gxSOCKET_NO_ERROR; }
  operator const int () const { return socket_error == gxSOCKET_NO_ERROR; }
  operator int () { return socket_error == gxSOCKET_NO_ERROR; }

protected: // Socket variables 
  gxsAddressFamily address_family;   // Object's address family
  gxsProtocolFamily protocol_family; // Object's protocol family
  gxsSocket_t socket_type;           // Object's socket type
  gxsPort_t port_number;             // Object's port number
  gxsSocket_t gxsocket;              // Socket this object is bound to
  gxsSocket_t remote_socket;         // Socket used for remote connections
  gxSocketError socket_error;       // The last reported socket error

protected: // Process control variables
  int bytes_read;   // Number of bytes read following a read operation
  int bytes_moved;  // Number of bytes written following a write operation
  int is_connected; // True if the socket is connected
  int is_bound;     // True if the socket is bound
  
public: // Data structures used to set the internet domain and addresses
  gxsSocketAddress sin;        // Sock Internet address
  gxsSocketAddress remote_sin; // Remote socket Internet address

public:  // Platform specfic library extensions
  gxsSocketLibraryVersion socket_version; 

#if defined (__WIN32__)
  WSADATA socket_data; 
#endif
};

#endif // __GX_SOCKET_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
