// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: logfile.h
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 11/17/1995 
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The LogFile class is used to log program events.
*/
// ----------------------------------------------------------- //   
#ifndef __GX_LOGFILE_HPP__
#define __GX_LOGFILE_HPP__

#include <time.h>
#include <fstream.h>
#include "ostrbase.h"

// Class used to log program events. 
class LogFile : public OutputStreamB
{
public:
  LogFile() { is_open = 0; }
  ~LogFile() { if(is_open) Close(); }

public:
  int Open(char *fname);
  int Open(const char *fname);
  int OverWrite(char *fname);
  int OverWrite(const char *fname);
  void Close();
  void Flush();
  
public:
  void WriteSysTime();
  void GetSystemTime(char *s, int full_month_name = 0);
  
private:
  ofstream out_file;
  int is_open;
};

#endif // __GX_LOGFILE_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
