/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin.impl.kde2;

import com.l2fprod.gui.plaf.skin.DefaultButton;
import com.l2fprod.gui.plaf.skin.impl.AbstractSkinScrollbar;
import com.l2fprod.gui.plaf.skin.impl.kde2.Kde2Utils;
import com.l2fprod.util.IniFile;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.SwingConstants;

class Kde2Scrollbar
extends AbstractSkinScrollbar
implements SwingConstants {
    DefaultButton h_track;
    DefaultButton v_track;
    DefaultButton h_thumb;
    DefaultButton v_thumb;
    DefaultButton h_handle;
    DefaultButton v_handle;
    DefaultButton up;
    DefaultButton down;
    DefaultButton left;
    DefaultButton right;

    public Dimension getPreferredSize(JScrollBar scrollbar) {
        return scrollbar.getOrientation() == 1 ? new Dimension(Math.max(10, Math.min(this.up.getWidth(), this.v_thumb.getWidth())), 48) : new Dimension(48, Math.max(10, Math.min(this.left.getHeight(), this.h_thumb.getHeight())));
    }

    public Dimension getArrowPreferredSize(int direction) {
        switch (direction) {
            case 1: {
                return this.up.getPreferredSize();
            }
            case 5: {
                return this.down.getPreferredSize();
            }
            case 7: {
                return this.left.getPreferredSize();
            }
            case 3: {
                return this.right.getPreferredSize();
            }
        }
        throw new Error("Invalid direction " + direction);
    }

    public boolean status() {
        return true;
    }

    public boolean installSkin(JComponent c) {
        return true;
    }

    public boolean paintArrow(Graphics g, AbstractButton b, int direction) {
        switch (direction) {
            case 1: {
                this.up.paint(g, b);
                break;
            }
            case 5: {
                this.down.paint(g, b);
                break;
            }
            case 7: {
                this.left.paint(g, b);
                break;
            }
            case 3: {
                this.right.paint(g, b);
            }
        }
        return true;
    }

    public boolean paintTrack(Graphics g, JScrollBar scrollbar, Rectangle trackBounds) {
        if (this.h_track != null) {
            if (scrollbar.getOrientation() == 0) {
                this.h_track.paint(g, 0, 0, trackBounds.width, trackBounds.height, scrollbar);
            } else {
                this.v_track.paint(g, 0, 0, trackBounds.width, trackBounds.height, scrollbar);
            }
            return true;
        }
        return false;
    }

    public boolean paintThumb(Graphics g, JScrollBar scrollbar, Rectangle thumbBounds) {
        if (this.h_thumb != null) {
            if (scrollbar.getOrientation() == 0) {
                this.h_thumb.paint(g, 0, 0, thumbBounds.width, thumbBounds.height, scrollbar);
                if (this.h_handle != null) {
                    this.h_handle.paint(g, Math.max(0, (thumbBounds.width - this.h_handle.getWidth()) / 2), (thumbBounds.height - this.h_handle.getHeight()) / 2, Math.min(thumbBounds.width, this.h_handle.getWidth()), this.h_handle.getHeight(), scrollbar);
                }
            } else {
                this.v_thumb.paint(g, 0, 0, thumbBounds.width, thumbBounds.height, scrollbar);
                if (this.v_handle != null) {
                    this.v_handle.paint(g, (thumbBounds.width - this.v_handle.getWidth()) / 2, Math.max(0, (thumbBounds.height - this.v_handle.getHeight()) / 2), this.v_handle.getWidth(), Math.min(thumbBounds.height, this.v_handle.getHeight()), scrollbar);
                }
            }
            return true;
        }
        return false;
    }

    public Kde2Scrollbar(IniFile ini, URL skinURL) throws Exception {
        this.h_thumb = Kde2Utils.newButton(ini, skinURL, "HSBarSlider");
        this.v_thumb = Kde2Utils.newButton(ini, skinURL, "VSBarSlider");
        this.h_track = Kde2Utils.newButton(ini, skinURL, "HScrollGroove");
        this.v_track = Kde2Utils.newButton(ini, skinURL, "VScrollGroove");
        this.up = Kde2Utils.newButton(ini, skinURL, "ArrowUp");
        this.down = Kde2Utils.newButton(ini, skinURL, "ArrowDown");
        this.left = Kde2Utils.newButton(ini, skinURL, "ArrowLeft");
        this.right = Kde2Utils.newButton(ini, skinURL, "ArrowRight");
    }
}

