use perlchartdir;


sub ticks
{
	my ($denseticks, $filename) = @_;

	#data for the chart
	my $data = [100, 125, 265, 147, 67, 105];

	#create a XYChart object of size 250 x 250
	my $c = new XYChart(250, 250);

	#set the plot area at (25, 25) and of size 200 x 200
	$c->setPlotArea(25, 25, 200, 200);

	if ($denseticks) {
		#high tick density, uses 10 pixels as tick spacing
		$c->addTitle("Tick Density = 10 pixels");
		$c->yAxis()->setTickDensity(10);
	}
	else {
		#normal tick density, just use the default setting
		$c->addTitle("Default Tick Density");
	}

	#add a bar layer to the chart using the given data
	$c->addBarLayer($data, 0x00ff00);
	
	#output the chart
	$c->makeChart($filename);
}


ticks(0, "normalticks.png");
ticks(1, "denseticks.png");
