/*****************************************************************************/
/*
    CSTNWIN.H: Defines CSTNWIN.DLL resp. CSTNWN32.DLL application interface.
    This interface can be included by C or C++ code

    Copyright (C) Juergen Mueller (J.M.) 1988-1999
    All rights reserved.

    You are expressly prohibited from selling this software in any form,
    distributing it with another product, or removing this notice.

    This software and documentation is the confidential and proprietary 
    information of Juergen Mueller ("Confidential Information").  
    You shall not disclose such Confidential Information and shall use 
    it only in accordance with the terms of the license agreement you 
    entered into with Juergen Mueller.

    THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
    EITHER EXPRESS OR IMPLIED, INCLUDING, WITHOUT LIMITATION, THE
    IMPLIED WARRANTIES OF MERCHANTIBILITY, FITNESS FOR A PARTICULAR
    PURPOSE, OR NON-INFRINGEMENT. THE AUTHOR SHALL NOT BE LIABLE FOR
    ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
    OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES. THE ENTIRE RISK
    AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM AND DOCUMENTATION
    IS WITH YOU.

    written by: Juergen Mueller, Eastleighstrasse 14, 70806 Kornwestheim,
                GERMANY

    FILE       : CSTNWIN.C
    REVISION   : 01-Jun-1999
                 19:36:56
 */
/*****************************************************************************/

/* work-arounds due to the different DLL EXPORT syntax in WIN16 and WIN32 */

#if defined(_X86_) || defined(_WIN32)                       /***** WIN32 *****/
 #ifdef DLLBUILD                        /* only for DLL compilation */
  #define SXTNDLLAPI    __declspec(dllexport) LONG WINAPI   /** exporting **/
 #else                                  /* DLL-API for applications */
  #define SXTNDLLAPI    __declspec(dllimport) LONG WINAPI   /** importing **/
 #endif
#else                                   /***** WIN16 *****/
 #define SXTNDLLAPI     LONG WINAPI _export                 /** both **/
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* GENERAL OVERVIEW:                                                */
/* the user has to declare all string arrays in his application,    */
/* and pass pointers to them as function parameters                 */
/* the resulting output values require a string with 300 characters */
/* return value 101 means succesful, all others no success          */
/* LPSTR dbfname: pointer to string with database name              */

/* get location (file line) for 'name', result is in 'location' */
SXTNDLLAPI cstnGetLocation(LPSTR dbfname,               /* IN */
                           LPSTR name,                  /* IN */
                           LPSTR location               /* OUT [300] */
                          );

/* get first name from database, result is in 'name', */
/* called once before GetNextName                     */
SXTNDLLAPI cstnGetFirstName(LPSTR dbfname,              /* IN */
                            LPSTR name                  /* OUT [400]*/
                           );

/* get next name from database, result is in 'name', */
/* called after GetFirstName                         */
SXTNDLLAPI cstnGetNextName(LPSTR dbfname,               /* IN */
                           LPSTR name                   /* OUT [400]*/
                          );

/* get first defined name from database, result is in 'name', */
/* called once before GetNextDefName                          */
SXTNDLLAPI cstnGetFirstDefName(LPSTR dbfname,           /* IN */
                               LPSTR name               /* OUT [400]*/
                              );

/* get next name defined from database, result is in 'name', */
/* called after GetFirstDefName                              */
SXTNDLLAPI cstnGetNextDefName(LPSTR dbfname,            /* IN */
                              LPSTR name                /* OUT [400]*/
                             );

/* get first called item from database, result is in 'calleditem', */
/* called once before GetNextCalledItem                            */
SXTNDLLAPI cstnGetFirstCalledItem(LPSTR dbfname,        /* IN */
                                  LPSTR caller,         /* IN */
                                  LPSTR calleditem,     /* OUT [400]*/
                                  LPSTR location        /* OUT [300]*/
                                 );

/* get next called item from database, result is in 'calleditem', */
/* called after GetFirstCalledItem                                */
SXTNDLLAPI cstnGetNextCalledItem(LPSTR dbfname,         /* IN */
                                 LPSTR caller,          /* IN */
                                 LPSTR calleditem,      /* OUT [400]*/
                                 LPSTR location         /* OUT [300]*/
                                );

/* get first calling item from database, result is in 'callingitem', */
/* called once before GetNextCallingItem                             */
SXTNDLLAPI cstnGetFirstCallingItem(LPSTR dbfname,        /* IN */
                                   LPSTR caller,         /* IN */
                                   LPSTR callingitem     /* OUT [400]*/
                                  );

/* get next calling item from database, result is in 'callingitem', */
/* called after GetFirstCallingItem                                 */
SXTNDLLAPI cstnGetNextCallingItem(LPSTR dbfname,         /* IN */
                                  LPSTR caller,          /* IN */
                                  LPSTR callingitem      /* OUT [400]*/
                                 );

/* get first filename from database, result is in 'name', */
/* called once before GetNextFile                         */
SXTNDLLAPI cstnGetFirstFile(LPSTR dbfname,              /* IN */
                            LPSTR filename              /* OUT [300]*/
                           );

/* get next filename from database, result is in 'name', */
/* called after GetFirstFile                             */
SXTNDLLAPI cstnGetNextFile(LPSTR dbfname,               /* IN */
                           LPSTR filename               /* OUT [300] */
                          );

#ifdef __cplusplus
}
#endif

