/* 
   Copyright 2001-2003 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.  

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222

**********************************************************************

LSFRAME.C holds the code for the sizebars

**********************************************************************

*/
#include <windows.h>
#include <commctrl.h>
#include <stdio.h>
#include "lsctrl.h"

static char *szFrameWindClassName = "ladSoftFrameWindow" ;
static HCURSOR hcurs,vcurs ;

#define FRAMEBODY 2

static void DrawFrame (HDC dc, RECT *r,int vertical)
{
   HBRUSH brush, oldbrush;
   HPEN pen1,pen2,oldpen  ;
         pen1 = CreatePen(PS_SOLID,2,0xffffff) ;
         pen2 = CreatePen(PS_SOLID,1,0) ;
         brush = CreateSolidBrush(GetSysColor(COLOR_INACTIVEBORDER)) ;
         oldbrush = SelectObject(dc,brush) ;
         FillRect(dc,r,brush) ;

         oldpen = SelectObject(dc,pen1) ;
         MoveToEx(dc,r->left,r->top,0 );
         LineTo(dc,r->right,r->top) ;
//         MoveToEx(dc,r->left,r->top+1,0 );
//         LineTo(dc,r->right,r->top+1) ;

         SelectObject(dc,pen2) ;

         if (vertical) {
//            MoveToEx(dc,r->left,r->top,0 );
//            LineTo(dc,r->right,r->top) ;
         } else {

//           MoveToEx(dc,r->left,r->bottom-1,0 );
 //          LineTo(dc,r->right,r->bottom-1) ;
//           MoveToEx(dc,r->left,r->bottom-2,0 );
 //          LineTo(dc,r->right,r->bottom-2) ;
         }

         if (vertical) {
           SelectObject(dc,pen1) ;
           MoveToEx(dc,r->left,r->top+1,0 );
           LineTo(dc,r->left,r->bottom-2) ;
//           MoveToEx(dc,r->left+1,r->top,0 );
//           LineTo(dc,r->left+1,r->bottom-1) ;

           SelectObject(dc,pen2) ;
//           MoveToEx(dc,r->left,r->top,0 );
//           LineTo(dc,r->left,r->bottom-1) ;
           MoveToEx(dc,r->right-1,r->top,0 );
           LineTo(dc,r->right-1,r->bottom-1) ;
         }
         SelectObject(dc,oldpen) ;
         SelectObject(dc,oldbrush) ;
         DeleteObject(pen1) ;
         DeleteObject(pen2) ;
         DeleteObject(brush) ;
}
static LRESULT  CALLBACK _export FrameWindWndProc( HWND hwnd, UINT iMessage, WPARAM wParam,
                                                         LPARAM lParam )
{
   RECT r, *pr ;
   PAINTSTRUCT ps ;
   HDC dc ;
   CFW_params *ptr ;
   static int skip ;
   static int dragging,oncursor,sizing ;
   static RECT moverect ;
   static HCURSOR oldCursor ;
   POINT temppt, movept ;
   int temp ;
   switch(iMessage) {
      case WM_NOTIFY:
         break ;
      case WM_COMMAND:
         break ;
      case WM_LBUTTONDOWN:
         ptr = (CFW_params *)GetWindowLong(hwnd,0) ;
         dragging = TRUE ;
         dmgrSizeBarStartMove(ptr,lParam) ;
         SetCapture(hwnd) ;
         break ;
      case WM_LBUTTONUP:
         ptr = (CFW_params *)GetWindowLong(hwnd,0) ;
         dmgrSizeBarEndMove(ptr) ;
         dragging = FALSE ;
         ReleaseCapture() ;
         break ;
      case WM_MOUSEMOVE:
         ptr = (CFW_params *)GetWindowLong(hwnd,0) ;
         SetCursor(ptr->vertical ? hcurs : vcurs) ;
         if (dragging)
            dmgrSizeBarMove(ptr, lParam) ;
         break ;
      case WM_ERASEBKGND:
         return 0 ;
      case WM_PAINT:
         ptr = (CFW_params *)GetWindowLong(hwnd,0) ;
         dc = BeginPaint(hwnd, &ps) ;
         GetClientRect(hwnd,&r) ;
         DrawFrame(dc,&r,ptr->vertical) ;
         EndPaint(hwnd, &ps) ;         
         return 0 ;
		case WM_CREATE :
         ptr = HeapAlloc(GetProcessHeap(),HEAP_ZERO_MEMORY,sizeof(CFW_params)) ;
         SetWindowLong(hwnd,0,(DWORD)ptr) ;
         *ptr = *(CFW_params *)(((LPCREATESTRUCT)lParam)->lpCreateParams) ;
         ptr->self = hwnd ;
         dmgrAddFrame(ptr) ;
			return 0 ;
		case WM_DESTROY:
         ptr = (CFW_params *)GetWindowLong(hwnd,0) ;
          HeapFree(GetProcessHeap(),0,ptr) ;
         break ;
		case WM_CLOSE:

         return 0 ;
      case WM_SIZE :
         return 0 ;
      case WM_MOVE :
         return 0 ;
	}
   return DefWindowProc(hwnd, iMessage, wParam, lParam) ;
}

void RegisterFrameWindow(HINSTANCE hInstance)
{
		WNDCLASS wc ;
      memset(&wc,0,sizeof(wc)) ;
      wc.style = 0;
      wc.lpfnWndProc = &FrameWindWndProc ;
		wc.cbClsExtra = 0;
      wc.cbWndExtra = sizeof(LPVOID);
		wc.hInstance = hInstance ;
		wc.hIcon = LoadIcon(0,IDI_APPLICATION) ;
      wc.hCursor = 0;
      wc.hbrBackground = 0 ; // GetStockObject(WHITE_BRUSH) ;
		wc.lpszMenuName = 0 ;
      wc.lpszClassName = szFrameWindClassName ;
		RegisterClass(&wc) ;
         hcurs = LoadCursor(hInstance,"ID_SIZEHCUR") ;
         vcurs = LoadCursor(hInstance,"ID_SIZEVCUR") ;

}
HWND CreateFrameWindow(HWND parent, RECT *r, int vertical)
{
   CFW_params p ;
   HWND hwnd ;
   memset(&p,0,sizeof(p)) ;
   p.vertical = vertical ;
   p.position = *r ;
   hwnd = CreateWindow(szFrameWindClassName, "",
            WS_CLIPSIBLINGS | WS_CLIPCHILDREN |WS_VISIBLE | WS_CHILD,
            r->left,r->top,r->right-r->left,r->bottom-r->top, 
            parent, (HMENU)0 ,(HINSTANCE)GetWindowLong(parent,GWL_HINSTANCE), &p) ;

   return hwnd ;   
}