/* 
   Copyright 2001-2003 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.  

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
**********************************************************************

SourceTab.C holds the functionality for the several tabs on the SourceTab 
window.  These tabs let you index directly to open files.

**********************************************************************
*/
#define STRICT 
#include <windows.h>
#include <commctrl.h>
#include <commdlg.h>
#include <richedit.h>
#include <stdio.h>
#include "header.h"

extern HANDLE hInstance;
extern HWND hwndWatch , hwndClient, hwndFrame,hwndTab ;
extern int numberofdrawwindows ;
extern HANDLE children[MAX_CHILDREN] ;

HWND hwndSourceTab ;
static char szSourceTabClassName[] = "xccSourceTabClass" ;
static WNDPROC oldproc ;
static HWND hwndCtrl, hwndTabCtrl ;
static char *nameTags[MAX_CHILDREN] ;
static LOGFONT Boldfontdata = {
   14,0,0,0,FW_BOLD,FALSE,FALSE,FALSE,ANSI_CHARSET,OUT_DEFAULT_PRECIS,
   CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, FF_MODERN | FF_DONTCARE,
   "Arial"
} ;
static LOGFONT Normalfontdata = {
   14,0,0,0,FW_NORMAL,FALSE,FALSE,FALSE,ANSI_CHARSET,OUT_DEFAULT_PRECIS,
   CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, FF_MODERN | FF_DONTCARE,
   "Arial"
} ;
static HFONT tabBoldFont, tabNormalFont ;
void SelectWindow(index)
{
   BringWindowToTop(children[index]) ;
   SendMessage(children[index],WM_SETFOCUS,0,0) ;
}
void SetTabs(HWND hwnd)
{
   int width = 0 ;
   SIZE size ;
   int i ;
   TC_ITEM tie ;
   HDC dc = GetDC(hwnd) ;
   HFONT of = SelectObject(dc,tabBoldFont) ;
   TabCtrl_DeleteAllItems(hwnd) ;
   for (i=0; i < numberofdrawwindows; i++)
      if (nameTags[i])
         free(nameTags[i]) ;
   memset(nameTags,0,sizeof(nameTags)) ;
   for (i=0; i < numberofdrawwindows; i++)
   {
      if (IsWindow(children[i])) {
         DWINFO *p = (DWINFO *)GetWindowLong(children[i],0) ;
         nameTags[i] = malloc(256) ;
         if (nameTags[i]) {
            DWINFO *p = (DWINFO *)GetWindowLong(children[i],0) ;
            strcpy(nameTags[i],p->dwTitle) ;
            tie.mask = TCIF_TEXT ;
            tie.iImage = -1 ;
            tie.pszText  = nameTags[i] ;
            TabCtrl_InsertItem(hwnd,0, &tie) ;
            GetTextExtentPoint32(dc,nameTags[i],strlen(nameTags[i]),&size) ;
            if (size.cx > width)
               width = size.cx ;

         }
      }
   }
   width += 16 ;
   i = TabCtrl_SetItemSize(hwnd,width,10) ;
   TabCtrl_SetItemSize(hwnd,width,HIWORD(i)) ;
   SelectObject(dc,of) ;
   ReleaseDC(hwnd,dc) ;
}
LRESULT  CALLBACK _export SourceTabProc( HWND hwnd, UINT iMessage, WPARAM wParam,
																		LPARAM lParam)
{
   static int index ;
   static HFONT tabBoldFont, tabNormalFont ;
   static int height ;
   TC_ITEM tie ;
   NMHDR *h ;
   DRAWITEMSTRUCT *dr ;
   HFONT font ;
   RECT r,r1, *pr ;
   LPTOOLTIPTEXT lpt ;
   DWINFO *p ;
	switch(iMessage) {
		case WM_SYSCOMMAND :
         if (wParam == SC_CLOSE) {
				SendMessage(hwnd,WM_CLOSE,0,0) ;
         }
			break ;
      case WM_GETHEIGHT:
         return height ;
		case WM_NOTIFY:
         h = (NMHDR *)lParam ;
         switch(h->code) {
            case TTN_NEEDTEXT:
               lpt = (LPTOOLTIPTEXT)lParam ;
               if (IsWindow(children[lpt->hdr.idFrom])) {
                  p = (DWINFO *)GetWindowLong(children[lpt->hdr.idFrom],0) ;
                  lpt->lpszText = p->dwName ;
               }
               break ;
            case TCN_SELCHANGE:
               index = TabCtrl_GetCurSel(hwndTabCtrl) ;
               SelectWindow(index) ;
               break ;
         }
			break ;
		case WM_COMMAND:
//			switch(LOWORD(wParam)) {
//			}
			break ;
      case WM_DRAWITEM:
         dr = (DRAWITEMSTRUCT *)lParam ;
         if (dr->itemState & ODS_SELECTED)
            font = tabBoldFont ;
         else
            font = tabNormalFont ;
         if (nameTags[dr->itemID]) {
            font = SelectObject(dr->hDC,font) ;
            TextOut(dr->hDC,dr->rcItem.left+4,dr->rcItem.top,nameTags[dr->itemID],strlen(nameTags[dr->itemID])) ;
            font = SelectObject(dr->hDC,font) ;
         }
         break ;
		case WM_SETFOCUS:
			break ;
		case WM_CREATE:
         hwndSourceTab = hwnd ;
			GetClientRect(hwnd,&r) ;
         tabBoldFont = CreateFontIndirect(&Boldfontdata) ;
         tabNormalFont = CreateFontIndirect(&Normalfontdata) ;
#ifndef TCS_BOTTOM
#define TCS_BOTTOM 2
#endif
         hwndTabCtrl = CreateWindow(WC_TABCONTROL, 0,
            WS_CHILD + WS_CLIPSIBLINGS + WS_VISIBLE + WS_DLGFRAME + TCS_OWNERDRAWFIXED + TCS_FOCUSNEVER + TCS_FIXEDWIDTH + TCS_TOOLTIPS, 
            r.left,r.top,r.right-r.left,r.bottom-r.top,
            hwnd, 0 ,hInstance,0)  ;
         // fall through
      case WM_RESETTABS :
         SetTabs(hwndTabCtrl) ;
         r.left = 0 ; 
         r.top = 0 ;
         r.right = 400 ;
         r.bottom = 400 ;
         TabCtrl_AdjustRect(hwndTabCtrl,FALSE,&r) ;
         height = r.top ;
         if (height < 10)
            height = 0 ;
         CalculateLayout(-1,FALSE) ;
			return 0 ;
      case WM_SETACTIVETAB:
         TabCtrl_SetCurSel(hwndTabCtrl,lParam) ;
         break ;
		case WM_CLOSE:
			return 0 ;
		case WM_DESTROY:
         dmgrRemoveClient((CCW_params *)GetWindowLong(hwndCtrl,0)) ;
         DestroyWindow(hwndTabCtrl) ;
         DestroyWindow(hwndCtrl) ;
			break ;

		case WM_SIZE:       
         MoveWindow(hwndCtrl,0,0,LOWORD(lParam),HIWORD(lParam),TRUE) ;
         r.left = 0 ;
         r.right = LOWORD(lParam) ;
         r.top = 0 ;
         r.bottom = HIWORD(lParam) ;
         SendMessage(hwndCtrl,LCF_ADJUSTRECT,0,(LPARAM)&r) ;
         MoveWindow(hwndTabCtrl,r.left,r.top,r.right-r.left,r.bottom-r.top,TRUE) ;
			break ;
		default: 
			break ;
	}
	return DefMDIChildProc(hwnd,iMessage,wParam,lParam) ;
}
void RegisterSourceTabWindow(void)
{
		WNDCLASS wc ;
      memset(&wc,0,sizeof(wc)) ;
      wc.style = 0;
      wc.lpfnWndProc = &SourceTabProc ;
		wc.cbClsExtra = 0;
		wc.cbWndExtra = 0;
		wc.hInstance = hInstance ;
		wc.hIcon = LoadIcon(0,IDI_APPLICATION) ;
		wc.hCursor = LoadCursor(0,IDC_ARROW) ;
		wc.hbrBackground = GetStockObject(WHITE_BRUSH) ;
		wc.lpszMenuName = 0 ;
      wc.lpszClassName = szSourceTabClassName ;
		RegisterClass(&wc) ;

}
void CreateSourceTabWindow(void)
{
      MDICREATESTRUCT mc ;
		RECT r ;
      if (hwndSourceTab)
         return ;
      hwndSourceTab = CreateWindow(szSourceTabClassName,"",WS_CHILD ,
         CW_USEDEFAULT,CW_USEDEFAULT, 200,200, hwndFrame, 0, hInstance,0) ;
}